/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.BackJob;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.BOSSchedulerService;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.JobDefCategoryCollection;
import com.kingdee.eas.base.job.JobDefCategoryFactory;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimeTask;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimer;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class BackJobUtile {
    public static final String NUM_SYN_PUNCHCARD = "3002";
    public static final String NUM_AUTO_SCHEDULE = "3003";
    public static final String NUM_CARD_RULE = "3004";
    public static final String NUM_HOLIDAY = "302";
    public static final String NUM_AUTO_LIMIT = "3005";
    public static final String NUM_ATT = "301";
    public static final String NUM_ATT_CAL = "3001";
    public static final String NUM_ATT_CAL_BATCH = "30001";
    public static final String NUM_ATT_CAL_TRIP = "30002";
    public static final String NUM_ATT_CAL_LEAVE = "30003";
    public static final String NUM_ATT_CAL_CANCEL_LEAVE = "30004";
    public static final String NUM_ATT_CAL_OVERTIME = "30005";
    public static final String NUM_ATT_CAL_SIGNCARD = "30006";
    public static final String NUM_ATT_SIGN_AUDIT = "30007";
    public static final String NUM_ATT_CAL_SCHEDULE_EDIT = "30008";
    public static final String NUM_ATT_CAL_SCHEDULE_IMPORT = "30009";
    public static final String NUM_ATT_CAL_OVERTIME_REAUDIT = "30010";
    public static final String NUM_ATT_CAL_TRIP_REAUDIT = "30011";
    public static final String NUM_ATT_CAL_SIGNCARD_REAUDIT = "30012";
    public static final String NUM_ATT_CAL_LEAVE_REAUDIT = "30013";
    public static final String NUM_ATT_CAL_CANCEL_LEAVE_REAUDIT = "30014";
    public static final String NUM_ATT_CAL_CANTRIP_AUDIT = "30015";
    public static final String NUM_ATT_CAL_CANTRIP_REAUDIT = "30016";
    public static final String TYPE_I = "INTEGER";
    public static final String TYPE_FLOAT = "FLOAT";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_BOID = "BOID";
    public static final String TYPE_PK = "PK";
    public static final String TYPE_OBJECTVALUE = "OBJECTVALUE";
    public static final String TYPE_DATETIME = "DATETIME";
    public static final String TYPE_STRING = "STRING";
    public static final String PACKAGE_DEFAULT = "com.kingdee.eas.hr.ats.app";
    public static final String FACADE_AFFAIRBASE = "com.kingdee.eas.hr.ats.app.AtsAffairBaseFacade";
    public static final String FACADE_SCHEDULE = "com.kingdee.eas.hr.ats.ScheduleShiftFunction";
    public static final String FACADE_OTCBIZ = "com.kingdee.eas.hr.atsContrl.app.OTCLBizFacade";
    public static final String OPERATION_SYN_PUNCHCARD = "transmitPunchCardRecordByWebService";
    public static final String OPERATION_AUTO_SCHEDULE = "autoSchedule";
    public static final String OPERATION_MATCH_SCHEDULE = "matchSchedule";
    public static final String OPERATION_OTC_GEN_PER = "generatePersonOTLimit";
    public static final String OPERATION_OTC_GEN_DEP = "generateDepartmentOTLimit";
    public static final String JOB_INST_TITLE = "title";
    public static final String JOB_INST_EXCPETION = "exception";
    public static final String JOB_INST_ID = "jobInstId";
    public static final String JOB_INST_STATE = "state";
    public static final String ATS_DELAY_TIME = "delayTime";
    private static final Pattern PATTERN_PARAM_TYPE = Pattern.compile(" type='(\\w+)' ");

    public static FacadeInfo getFacade(Context ctx, String fullName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        MetaDataPK currenFacadePK = MetaDataPK.create((String)fullName);
        return loader.getFacade((IMetaDataPK)currenFacadePK);
    }

    public static FunctionObjectInfo getFunction(Context ctx, String fullName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        MetaDataPK currenFacadePK = MetaDataPK.create((String)fullName);
        return loader.getFunction((IMetaDataPK)currenFacadePK);
    }

    public static MethodInfo getMethod(FunctionObjectInfo function, String operationName) {
        if (function == null) {
            return null;
        }
        OperationCollection operations = function.getOperation();
        OperationInfo operation = null;
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)operations)) {
            int length = operations.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)operations.get(i).getName(), (String)operationName)) continue;
                if (operation == null) {
                    operation = operations.get(i);
                    continue;
                }
                return null;
            }
        }
        if (operation != null) {
            return operation.getEntityMethodRef();
        }
        return null;
    }

    public static MethodInfo getMethod(Context ctx, String fullName, String methodName) {
        FacadeInfo facade = BackJobUtile.getFacade(ctx, fullName);
        if (facade.getType() != null) {
            return BackJobUtile.getMethod(facade, methodName);
        }
        FunctionObjectInfo function = BackJobUtile.getFunction(ctx, fullName);
        return BackJobUtile.getMethod(function, methodName);
    }

    public static MethodInfo getMethod(FacadeInfo facade, String methodName) {
        if (facade == null) {
            return null;
        }
        MethodCollection medthods = facade.getAllMethodsRuntime();
        MethodInfo method = null;
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)medthods)) {
            int length = medthods.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)medthods.get(i).getName(), (String)methodName)) continue;
                if (method == null) {
                    method = medthods.get(i);
                    continue;
                }
                return null;
            }
        }
        return method;
    }

    public static ParameterCollection getParameters(Context ctx, String fullName, String methodName) {
        MethodInfo method = BackJobUtile.getMethod(ctx, fullName, methodName);
        return BackJobUtile.getParameters(method);
    }

    public static ParameterCollection getParameters(MethodInfo method) {
        if (method == null) {
            return null;
        }
        return method.getParameters();
    }

    public static JobDefCategoryCollection getJobDefCategory(Context ctx, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return BackJobUtile.getJobDefCategory(ctx);
        }
        StringBuffer sql = new StringBuffer("select * where number='").append(number).append("' or longnumber='").append(number).append("'");
        JobDefCategoryCollection colls = null;
        try {
            colls = JobDefCategoryFactory.getLocalInstance((Context)ctx).getJobDefCategoryCollection(sql.toString());
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)e);
        }
        return colls;
    }

    public static JobDefCategoryCollection getJobDefCategory(Context ctx) {
        JobDefCategoryCollection colls = null;
        try {
            colls = JobDefCategoryFactory.getLocalInstance((Context)ctx).getJobDefCategoryCollection();
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)e);
        }
        return colls;
    }

    @Deprecated
    public static boolean hasRunningJobByTitle(Context ctx, String title) {
        if (StringUtils.isEmpty((String)title)) {
            return false;
        }
        String date = AtsCommonUtile.timeAddStr(Calendar.getInstance().getTime(), 6, -2);
        StringBuffer sql = new StringBuffer(" select * from T_JOB_INST").append(" where ftitle like '%").append(title).append("%' ").append(" and fstate = 'Running'").append(" and fcreatedTime > { ts '").append(date).append("'}");
        String jobInstId = AtsCommonUtile.getFromCtx(ctx, (Object)JOB_INST_ID, String.class);
        if (jobInstId != null) {
            sql.append(" and fjobinstid <> '").append(jobInstId).append("'");
        }
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return rowSet.next();
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)e);
            return true;
        }
    }

    public static StringBuffer getSimpleHandWrap(String functionOrFacadName, String methodName) {
        if (StringUtils.isBlank((String)functionOrFacadName) || StringUtils.isBlank((String)methodName)) {
            return new StringBuffer();
        }
        StringBuffer backJobName = new StringBuffer("function:");
        if (!functionOrFacadName.contains(".")) {
            backJobName.append(PACKAGE_DEFAULT).append(".");
        }
        backJobName.append(functionOrFacadName).append("-").append(methodName).append(";<doc>");
        return backJobName;
    }

    public static boolean hasRunningJobById(Context ctx) {
        return BackJobUtile.hasRunningJobById(ctx, BackJobUtile.getJobId(ctx));
    }

    public static boolean hasRunningJobById(Context ctx, String jobInstId) {
        int docInd;
        if (StringUtils.isBlank((String)jobInstId)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select def.fhandlerwrapper,inst.flocalExplain from T_JOB_INST inst ");
        sql.append(" left join T_JOB_DEF def on inst.fjobdefid=def.fjobdefid ");
        sql.append(" where inst.fjobinstid='").append(jobInstId).append("'");
        String simpleHandWrap = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                simpleHandWrap = StringUtils.isBlank((String)rowSet.getString(1)) ? rowSet.getString(2) : rowSet.getString(1);
            }
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)e);
        }
        if (StringUtils.isBlank(simpleHandWrap)) {
            return false;
        }
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = PATTERN_PARAM_TYPE.matcher(simpleHandWrap);
        while (matcher.find()) {
            params.add(matcher.group(1));
        }
        int n = docInd = StringUtils.isBlank((String)simpleHandWrap) ? -1 : simpleHandWrap.indexOf(";<doc>");
        if (docInd == -1) {
            return false;
        }
        return BackJobUtile.hasRunningJob(ctx, simpleHandWrap.substring(0, docInd + 6), params.toArray(new String[params.size()]));
    }

    public static boolean hasRunningJob(Context ctx, String functionOrFacadName, String methodName) {
        return BackJobUtile.hasRunningJob(ctx, functionOrFacadName, methodName, null);
    }

    public static boolean hasRunningJob(Context ctx, String functionOrFacadName, String methodName, String[] paramTypes) {
        StringBuffer simpleHandWrap = BackJobUtile.getSimpleHandWrap(functionOrFacadName, methodName);
        return BackJobUtile.hasRunningJob(ctx, simpleHandWrap.toString(), paramTypes);
    }

    public static boolean hasRunningJob(Context ctx, String simpleHandWrap, String[] paramTypes) {
        if (StringUtils.isBlank((String)simpleHandWrap)) {
            return false;
        }
        String date = AtsCommonUtile.timeAddStr(Calendar.getInstance().getTime(), 6, -2);
        StringBuffer sql = new StringBuffer();
        sql.append(" select def.fhandlerwrapper,inst.flocalExplain from T_JOB_INST inst ");
        sql.append(" left join T_JOB_DEF def on inst.fjobdefid=def.fjobdefid ");
        sql.append(" where (def.fhandlerwrapper like '").append(simpleHandWrap).append("%' ");
        sql.append(" or inst.flocalExplain like '").append(simpleHandWrap).append("%') ");
        String jobInstId = AtsCommonUtile.getFromCtx(ctx, (Object)JOB_INST_ID, String.class);
        if (jobInstId != null) {
            sql.append(" and fjobinstid <> '").append(jobInstId).append("'");
        }
        sql.append(" and inst.fcreatedTime > { ts '").append(date).append("'}");
        sql.append(" and inst.fstate = 'Running'");
        IRowSet rowSet = null;
        ArrayList<String> handlerwrappers = new ArrayList<String>();
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                handlerwrappers.add(StringUtils.isBlank((String)rowSet.getString(1)) ? rowSet.getString(2) : rowSet.getString(1));
            }
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)e);
        }
        if (handlerwrappers.size() == 0) {
            return false;
        }
        if (paramTypes == null || paramTypes.length == 0) {
            return true;
        }
        for (String handlerwrapper : handlerwrappers) {
            int curInd = 0;
            boolean matched = true;
            Matcher matcher = PATTERN_PARAM_TYPE.matcher(handlerwrapper);
            while (matcher.find()) {
                if (curInd < paramTypes.length && !matcher.group(1).equalsIgnoreCase(paramTypes[curInd])) {
                    matched = false;
                    break;
                }
                ++curInd;
            }
            if (!matched || curInd != paramTypes.length) continue;
            return true;
        }
        return false;
    }

    public static synchronized String inserRunningJob(Context ctx, String title, String functionOrFacadName, String methodName) {
        return BackJobUtile.inserRunningJob(ctx, title, functionOrFacadName, methodName, null);
    }

    public static synchronized String inserRunningJob(Context ctx, String title, String functionOrFacadName, String methodName, String[] paramTypes) {
        if (StringUtils.isNotEmpty((String)title) && BackJobUtile.hasRunningJob(ctx, functionOrFacadName, methodName, paramTypes)) {
            throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.REPEATTASK)));
        }
        title = title + AtsCommonUtile.formateDateNum();
        String id = BOSUuid.create((String)"BGJOBINS").toString();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_job_inst(fcreatedTime,fscheduledtime,fstartedtime,fjobInstId,Fstate,ftitle,flocalExplain,fuserid,fholderid,fclientip)");
        sql.append("values(Now(),Now(),Now(), '");
        sql.append(id).append("','");
        sql.append("Running").append("','");
        sql.append(title).append("','");
        sql.append(BackJobUtile.getSimpleHandWrap(functionOrFacadName, methodName));
        if (paramTypes != null) {
            for (String paramType : paramTypes) {
                sql.append(" type=").append("''").append(paramType).append("''").append(" ");
            }
        }
        sql.append("','").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(",'").append(Configuration.serviceInstanceIdGenerator().getInstanceId()).append("'");
        sql.append(",'").append(ctx.getClientHostIP());
        sql.append("')");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.OPERATEERROR)));
        }
        return id;
    }

    public static void updateJobInfo(Context ctx, final JSONObject jobParam) {
        long delayTime = jobParam.getLongValue(ATS_DELAY_TIME);
        AtsTimer.getInstance().schedule((TimerTask)new AtsTimeTask<String>(ctx, null){

            @Override
            protected void process() throws BOSException {
                String[] needUpdateInfo;
                String jobInstId = jobParam.getString(BackJobUtile.JOB_INST_ID);
                String jobTitle = jobParam.getString(BackJobUtile.JOB_INST_TITLE);
                if (StringUtils.isEmpty((String)jobInstId) && StringUtils.isEmpty((String)jobTitle)) {
                    return;
                }
                ArrayList<String> paramsList = new ArrayList<String>();
                StringBuffer sql = new StringBuffer("update t_job_inst set");
                for (String field : needUpdateInfo = new String[]{BackJobUtile.JOB_INST_TITLE, BackJobUtile.JOB_INST_EXCPETION}) {
                    String value = jobParam.getString(field);
                    if (value == null) continue;
                    paramsList.add(value);
                    sql.append(" f").append(field).append("= ? ,");
                }
                JobStateEnum state = (JobStateEnum)jobParam.getObject(BackJobUtile.JOB_INST_STATE, JobStateEnum.class);
                if (state != null) {
                    paramsList.add(state.getValue());
                    sql.append(" fstate= ? ,");
                }
                sql.append(" fstateChangedTime = Now() where");
                if (paramsList.size() > 0) {
                    if (StringUtils.isNotEmpty((String)jobInstId)) {
                        paramsList.add(jobInstId);
                        sql.append(" fjobinstid = ?");
                    } else if (StringUtils.isNotEmpty((String)jobTitle)) {
                        sql.append(" ftitle like '%").append(jobTitle).append("%'");
                    }
                    DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])paramsList.toArray());
                }
            }
        }, delayTime);
    }

    public static String getJobId(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return (String)ctx.get((Object)JOB_INST_ID);
    }

    public static String getJobTitle(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return (String)ctx.get((Object)JOB_INST_TITLE);
    }

    public static JSONObject getJobParam(Context ctx) {
        JSONObject jobParam = AtsCollectionUtile.emptyJsonObj();
        for (String field : new String[]{JOB_INST_TITLE, JOB_INST_EXCPETION, JOB_INST_ID, JOB_INST_STATE, ATS_DELAY_TIME}) {
            if (ctx.get((Object)field) == null) continue;
            jobParam.put(field, ctx.get((Object)field));
        }
        return jobParam;
    }

    public static JSONObject getJobParam(String jobInstId) {
        return AtsCollectionUtile.sigleTon(JOB_INST_ID, jobInstId);
    }

    public static void completeJob(Context ctx, JSONObject jobParam) {
        jobParam.put(JOB_INST_STATE, (Object)JobStateEnum.COMPLETE);
        BackJobUtile.changeJobState(ctx, jobParam);
    }

    public static void abortJob(Context ctx, JSONObject jobParam) {
        jobParam.put(JOB_INST_STATE, (Object)JobStateEnum.ABORTED);
        BackJobUtile.changeJobState(ctx, jobParam);
    }

    public static void faillingJob(Context ctx, JSONObject jobParam) {
        jobParam.put(JOB_INST_STATE, (Object)JobStateEnum.FAILED);
        BackJobUtile.changeJobState(ctx, jobParam);
    }

    public static void changeJobState(Context ctx, JSONObject jobParam) {
        if (jobParam.getLong(ATS_DELAY_TIME) == null) {
            jobParam.put(ATS_DELAY_TIME, (Object)2000);
        }
        BackJobUtile.updateJobInfo(ctx, jobParam);
    }

    public static void reStartJob(Context ctx, JSONObject jobParam, long delayTime) {
        jobParam.put(JOB_INST_STATE, (Object)JobStateEnum.SUSPENDED);
        BackJobUtile.changeJobState(ctx, jobParam);
        AtsTimer.getInstance().schedule((TimerTask)new AtsTimeTask<String>(ctx, jobParam.getString(JOB_INST_ID)){

            @Override
            protected void process() throws BOSException {
                IJobService jobService = JobServiceFactory.getLocalInstance((Context)this.ctx);
                Job job = jobService.getJobInstance((String)this.dataObj);
                if (job != null && ReadyJobs.in((Job)job) && !BOSSchedulerService.isRunning() && Configuration.isEnable()) {
                    BOSSchedulerService.init();
                    BOSSchedulerService.startWorkerThread();
                }
            }
        }, delayTime);
    }

    public static void reStartJob(Context ctx, long delayTime) {
        Object jobInstId = ctx.get((Object)JOB_INST_ID);
        if (jobInstId != null) {
            BackJobUtile.reStartJob(ctx, BackJobUtile.getJobParam(jobInstId.toString()), delayTime);
        }
    }
}

