/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class LicenseUtile {
    private static Boolean licenseContainAtt;

    public static boolean requestAttLicense() {
        if (licenseContainAtt == null) {
            LicenseException exception = null;
            for (int i = 0; i < 1000; ++i) {
                try {
                    licenseContainAtt = LicenseUtile.requestLicense("sHR_SCHE");
                    break;
                }
                catch (LicenseException e) {
                    exception = e;
                    continue;
                }
            }
            if (exception != null) {
                licenseContainAtt = false;
                exception.printStackTrace();
            }
        }
        return licenseContainAtt;
    }

    public static boolean requestLicense(String moduleName) throws LicenseException {
        if (StringUtils.isBlank((CharSequence)moduleName)) {
            return false;
        }
        ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
        ModuleLicenseInfo[] list = iLicenseSrvAgent.getModuleLicenseInfo();
        Calendar curDate = Calendar.getInstance();
        for (ModuleLicenseInfo li : list) {
            if ((!curDate.before(li.getExpireDate()) || !moduleName.equals(li.getModuleName())) && !li.containModule(moduleName)) continue;
            return true;
        }
        return false;
    }

    public static String requestLicenseAlias(String moduleName) {
        return LicenseClientUtil.getModularAliasNameByModularName((String)moduleName);
    }

    public static Set<String> findModule(String moduleAlias) throws LicenseException {
        ModuleLicenseInfo[] list;
        HashSet<String> modules = new HashSet<String>();
        ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
        for (ModuleLicenseInfo li : list = iLicenseSrvAgent.getModuleLicenseInfo()) {
            String alias;
            String allAlias = alias = LicenseUtile.requestLicenseAlias(li.getModuleName());
            if (alias != null && alias.contains(moduleAlias)) {
                modules.add(allAlias + ":" + li.getModuleName());
            }
            if (li.getSubModules() == null) continue;
            for (String subModule : li.getSubModules()) {
                alias = LicenseUtile.requestLicenseAlias(subModule);
                if (alias == null || !alias.contains(moduleAlias)) continue;
                modules.add(allAlias + "!!" + alias + ":" + subModule);
            }
        }
        return modules;
    }
}

