/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common.ml;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.eas.base.param.INantionalServiceFacade;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.NationalPlanFactory;
import com.kingdee.eas.base.param.NationalPlanInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ObjectUtils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class UserNationaPlan {
    private Context ctx;
    private UserInfo userInfo;
    private boolean isRemoveSeconds;
    private boolean isRemoveDay;
    private RoundingMode numberRoundingMode;
    private int decimalPrecision = Integer.MIN_VALUE;
    private Map<String, Object> planMap = new HashMap<String, Object>(2);

    private void init() {
        String userId;
        if (!this.planMap.isEmpty()) {
            return;
        }
        if (this.userInfo == null || StringUtils.isBlank((String)this.userInfo.getString("id"))) {
            this.userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        }
        String string = userId = this.userInfo == null ? null : this.userInfo.getString("id");
        if (StringUtils.isBlank((String)userId)) {
            return;
        }
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)this.ctx);
        String orgId = orgUnitInfo == null ? null : orgUnitInfo.getString("id");
        Locale local = this.ctx.getLocale();
        String localStr = local == null ? null : local.getDisplayName();
        localStr = localStr == null ? null : localStr.toUpperCase();
        try {
            INantionalServiceFacade iNantionalServiceFacade = NantionalServiceFacadeFactory.getLocalInstance((Context)this.ctx);
            this.planMap = iNantionalServiceFacade.getNationalConfig(userId, orgId, localStr);
            this.planMap = (Map)ObjectUtils.createCopy(this.planMap);
            this.dateTimeFormatProcess();
            this.numberFormatProcess("numberFormat");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private void numberFormatProcess(String fieldName) {
        DecimalFormat format;
        DecimalFormat decimalFormat = format = this.planMap == null ? null : (DecimalFormat)this.planMap.get(fieldName);
        if (format == null) {
            return;
        }
        if (this.numberRoundingMode != null) {
            format.setRoundingMode(this.numberRoundingMode);
        }
        if (this.decimalPrecision != Integer.MIN_VALUE) {
            format.setMaximumFractionDigits(this.decimalPrecision);
            format.setMinimumFractionDigits(this.decimalPrecision);
        }
        this.planMap.put(fieldName, format);
    }

    private void dateTimeFormatProcess() {
        if (this.planMap == null) {
            return;
        }
        this.removeDayProcess("dateTimeFormat");
        this.removeDayProcess("dateFormat");
        this.removeSecondProcess("dateTimeFormat");
        this.removeSecondProcess("timeFormat");
    }

    private void removeDayProcess(String fieldName) {
        SimpleDateFormat format = (SimpleDateFormat)this.planMap.get(fieldName);
        if (!this.isRemoveDay || format == null) {
            return;
        }
        String format0 = format.toPattern();
        String tempFormat = format0.toLowerCase();
        int ddIndex = tempFormat.indexOf("dd");
        if (ddIndex == 0) {
            format0 = format0.substring(ddIndex + 3);
        } else if (ddIndex > 0) {
            String pre = format0.substring(0, ddIndex - 1);
            String after = format0.substring(ddIndex + 2);
            format0 = pre;
            if (!StringUtils.isEmpty((String)after)) {
                format0 = MessageFormat.format("{0}{1}", pre, after);
            }
        }
        TimeZone timeZone = format.getTimeZone();
        format = new SimpleDateFormat(format0);
        format.setTimeZone(timeZone);
        this.planMap.put(fieldName, format);
    }

    private void removeSecondProcess(String fieldName) {
        SimpleDateFormat format = (SimpleDateFormat)this.planMap.get(fieldName);
        if (!this.isRemoveSeconds || format == null) {
            return;
        }
        String format0 = format.toPattern();
        String tempFormat = format0.toLowerCase();
        format0 = tempFormat.indexOf("ss") > -1 ? format0.substring(0, tempFormat.indexOf("ss") - 1) : format0;
        TimeZone timeZone = format.getTimeZone();
        format = new SimpleDateFormat(format0);
        format.setTimeZone(timeZone);
        this.planMap.put(fieldName, format);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public UserNationaPlan setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public UserNationaPlan setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    public boolean isRemoveSeconds() {
        return this.isRemoveSeconds;
    }

    public UserNationaPlan setRemoveSeconds(boolean isRemoveSeconds) {
        this.isRemoveSeconds = isRemoveSeconds;
        return this;
    }

    public boolean isRemoveDay() {
        return this.isRemoveDay;
    }

    public UserNationaPlan setRemoveDay(boolean isRemoveDay) {
        this.isRemoveDay = isRemoveDay;
        return this;
    }

    public RoundingMode getNumberRoundingMode() {
        return this.numberRoundingMode;
    }

    public UserNationaPlan setNumberRoundingMode(RoundingMode numberRoundingMode) {
        this.numberRoundingMode = numberRoundingMode;
        return this;
    }

    public int getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public UserNationaPlan setDecimalPrecision(int decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
        return this;
    }

    public DecimalFormat getNumberFormat() {
        return (DecimalFormat)this.get("numberFormat");
    }

    public DecimalFormat getCurrencyFormat() {
        return (DecimalFormat)this.get("currencyFormat");
    }

    public SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)this.get("dateFormat");
    }

    public SimpleDateFormat getDateTimeFormat() {
        return (SimpleDateFormat)this.get("dateTimeFormat");
    }

    public SimpleDateFormat getTimeFormat() {
        return (SimpleDateFormat)this.get("timeFormat");
    }

    public DecimalFormatEx getEx1Format() {
        return (DecimalFormatEx)this.get("ex1");
    }

    public TimeZoneInfo getTimeZone() {
        return (TimeZoneInfo)this.get("timezoneInfo");
    }

    public TimeZoneInfo getServerTimeZone() {
        return (TimeZoneInfo)this.get("serverTimeZoneInfo");
    }

    public String formateTime(Object time) {
        return this.formatByTextFormat(Date.getTime(time), this.getTimeFormat());
    }

    public String formateDate(Object date) {
        return this.formatByTextFormat(Date.getTime(date), this.getDateFormat());
    }

    public String formateDateTime(Object dateTime) {
        return this.formatByTextFormat(Date.getTime(dateTime), this.getDateTimeFormat());
    }

    public String formatCurrency(Object currenty) {
        return this.formatByTextFormat(currenty, this.getCurrencyFormat());
    }

    public String formatNumber(Object number) {
        return this.formatByTextFormat(number, this.getNumberFormat());
    }

    public String formatByTextFormat(Object originalVal, Format format) {
        if (originalVal == null) {
            return "";
        }
        return format == null ? originalVal.toString() : format.format(originalVal);
    }

    public Date parseTime(String originalVal) {
        return Date.getTime(this.parseByTextFormat(originalVal, this.getTimeFormat()));
    }

    public Date parseDate(String originalVal) {
        return Date.getTime(this.parseByTextFormat(originalVal, this.getDateFormat()));
    }

    public Date parseDateTime(String originalVal) {
        return Date.getTime(this.parseByTextFormat(originalVal, this.getDateTimeFormat()));
    }

    public Integer parseInt(String originalVal) {
        Number number = this.parseNumber(originalVal);
        return number == null ? null : Integer.valueOf(number.intValue());
    }

    public Double parseDouble(String originalVal) {
        Number number = this.parseNumber(originalVal);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    public Double parseCurrency(String originalVal) {
        Number number = (Number)this.parseByTextFormat(originalVal, this.getCurrencyFormat());
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    public Number parseNumber(String originalVal) {
        return (Number)this.parseByTextFormat(originalVal, this.getNumberFormat());
    }

    public Object parseByTextFormat(String originalVal, Format format) {
        if (StringUtils.isBlank((String)originalVal) || format == null) {
            return null;
        }
        try {
            return format.parseObject(originalVal);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object get(Object key) {
        this.init();
        Object value = this.planMap.get(key);
        if (value == null && "serverTimeZoneInfo".equals(key)) {
            try {
                NationalPlanInfo sysPlanInfo = NationalPlanFactory.getLocalInstance((Context)this.ctx).getSysDefaultPlan();
                value = sysPlanInfo.getTimeZoneID();
                this.planMap.put("serverTimeZoneInfo", value);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return value;
    }
}

