/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.util.Precision.PrecisionHelper;
import com.kingdee.eas.hr.ats.util.common.AtsBillAssist;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BillHelper {
    private static Logger logger = Logger.getLogger(BillHelper.class);
    protected Context ctx;

    public BillHelper() {
    }

    public BillHelper(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public BillHelper setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T billInfo) throws BOSException, EASBizException {
        AtsBillAssist.setDefault2Bill(ctx, billInfo);
        return billInfo;
    }

    public BigDecimal getBillLength(Context ctx, AtsAffairEntryBaseInfo entryInfo) {
        try {
            Object len = AtsCommonUtile.callOsfDispatcherService(ctx, entryInfo, "getBillLength", null);
            PrecisionHelper precisionHelper = new PrecisionHelper();
            precisionHelper.setCtx(ctx).setRoundingMode(RoundingMode.UP);
            return precisionHelper.precisionProcess(new BigDecimal((String)len));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void uptBillSourceTypeWithBack(Context ctx, String billId) {
        try {
            String billTableName = AtsEntityUtile.getTableNameByBillId(ctx, billId);
            if (StringUtils.isEmpty((CharSequence)billTableName)) {
                return;
            }
            StringBuilder updBillSourceSb = new StringBuilder();
            updBillSourceSb.append(" update ");
            updBillSourceSb.append(billTableName);
            updBillSourceSb.append(" set fbillSourceType = '' ");
            updBillSourceSb.append(" where fid = '");
            updBillSourceSb.append(billId);
            updBillSourceSb.append("' ");
            DbUtil.execute((Context)ctx, (String)updBillSourceSb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String deleteWithTips(Context ctx, String billId) throws EASBizException {
        if (StringUtils.isEmpty((CharSequence)billId)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "id_is_empty", ctx)});
        }
        String[] ids = billId.split(",");
        int sucess = 0;
        int failure = 0;
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        HashSet<String> sucessIds = new HashSet<String>();
        for (String id : ids) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            if (sucessIds.contains(id)) continue;
            sucessIds.add(id);
            try {
                this.runDelete(ctx, id);
                this.deleteAttachment(id);
                ++sucess;
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                body.setMuitTipsMessage(MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_success", ctx) + "!");
            }
            catch (EASBizException e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail", ctx) + ": " + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                if (e instanceof ObjectNotFoundException) {
                    body.setMuitTipsMessage(MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_delete", ctx));
                } else if (e instanceof ObjectReferedException) {
                    String errorMessage = ExceptionMessageUtility.getMessage((Throwable)e);
                    body.setMuitTipsMessage(errorMessage);
                } else if (e instanceof HRCommonException) {
                    body.setMuitTipsMessage(e.getMessage());
                } else {
                    body.setMuitTipsMessage(MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "operate_fail", ctx) + "!" + MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "contact_admin", ctx));
                }
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            batchMessageTipsHeader.addResult(body);
        }
        batchMessageTipsHeader.setBillId(billId);
        batchMessageTipsHeader.setFailureCount(failure);
        batchMessageTipsHeader.setSuccessCount(sucess);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)batchMessageTipsHeader);
    }

    public static void processMuitTipsMessage(BatchMessageTipsHeader batchMessageTipsHeader, String msg, boolean muitTipsState) throws HRCommonException {
        if (batchMessageTipsHeader == null) {
            if (!muitTipsState) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
            }
            return;
        }
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        batchMessageTipsHeader.addResult(body);
        body.setMuitTipsState(muitTipsState);
        body.setMuitTipsMessage(msg);
    }

    public String delete(Context ctx, String billId) throws EASBizException {
        String[] ids = billId.split(",");
        HashSet<String> sucessIds = new HashSet<String>();
        for (int nIndex = 0; nIndex < ids.length; ++nIndex) {
            if (sucessIds.contains(ids[nIndex])) continue;
            try {
                this.runDelete(ctx, ids[nIndex]);
                this.deleteAttachment(ids[nIndex]);
                sucessIds.add(ids[nIndex]);
                continue;
            }
            catch (EASBizException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (ObjectNotFoundException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "data_delete", ctx)});
            }
            catch (ObjectReferedException e) {
                BizReference ref = (BizReference)e.getReferingObject();
                if (ref != null) {
                    throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{MLUtile.getRes("com.kingdee.eas.common.CommonResource", "isReferedError", ctx, ref.getRefEntityAlias(ctx.getLocale()))});
                }
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (BOSException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return null;
    }

    protected void runDelete(Context ctx, String id) throws BOSException, EASBizException {
        ICoreBase iCoreBase = AtsEntityUtile.getBizInterface(ctx, id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (iCoreBase == null || !iCoreBase.exists((IObjectPK)pk)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_delete", ctx)});
        }
        EnactmentServiceFactory.createEnactService((Context)ctx).abortProcessByHoldedObjectId(id);
        iCoreBase.delete((IObjectPK)pk);
        BoAttchAssoFactory.getRemoteInstance().deleteAllAssociationsByBoID(id);
    }

    protected void deleteAttachment(String boId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)boId));
        SHRAttachmentExtFactory.getRemoteInstance().delete(filter);
        BoAttchAssoFactory.getRemoteInstance().deleteAllAssociationsByBoID(boId);
    }
}

