/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.AbstractAtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAcrossStoreSopportInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BaseValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BillValidator<T extends AtsAffairBaseInfo>
extends BaseValidator<T> {
    @Override
    protected void beforeValidate() throws Exception {
        super.beforeValidate();
    }

    @Override
    protected void initConvertSelectFields() {
        super.initConvertSelectFields();
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            this.getValidateCtx().addConvertSelectField("creator");
            this.getValidateCtx().addConvertSelectField("entries.person");
        } else {
            this.getValidateCtx().addConvertSelectField("hrOrgUnit");
            this.getValidateCtx().addConvertSelectField("entries.isDefaultManage");
            this.getValidateCtx().addConvertSelectField("entries.adminOrgUnit");
            this.getValidateCtx().addConvertSelectField("entries.attAdminOrgUnit");
        }
    }

    @Override
    protected String doValidate(T target) throws Exception {
        String errorMsg = super.doValidate(target);
        return StringUtils.isBlank((CharSequence)errorMsg) ? this.validateField(target, "entries") : errorMsg;
    }

    @Override
    public String validateDAC(T target) throws Exception {
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            return this.isCurrentPerson(((AbstractAtsAffairBaseInfo)target).getProposer()) || this.isCurrentPerson(target.getCreator()) ? null : MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
        }
        if (PlateformType.isTeam(this.getValidateCtx().getPlateformType()) && !this.getValidateCtx().isUpdateMethod()) {
            return null;
        }
        Set<String> hrOrgRange = this.getValidateCtx().getHrOrgRange();
        if (target.getHrOrgUnit() != null && hrOrgRange.contains(target.getHrOrgUnit().getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM_HRO", this.getValidateCtx().getBosCtx());
    }

    @Override
    protected boolean isDefaultManage(Object target) throws Exception {
        return target instanceof AtsAffairEntryBaseInfo ? ((AtsAffairEntryBaseInfo)target).getBoolean("isDefaultManage") : true;
    }

    @Override
    protected String validateFieldDAC(String field, Object subTarget, T target) throws Exception {
        if (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)this.getEntryField(target)) && subTarget instanceof AtsAffairEntryBaseInfo) {
            return this.validateEntryDAC(field, (AtsAffairEntryBaseInfo)subTarget, target);
        }
        return null;
    }

    @Override
    protected String validateFieldBiz(String field, Object subTarget, T target) throws Exception {
        if (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)this.getEntryField(target)) && subTarget instanceof AtsAffairEntryBaseInfo) {
            return this.validateEntryBiz(field, (AtsAffairEntryBaseInfo)subTarget, target);
        }
        return null;
    }

    protected String getEntryField(T target) throws Exception {
        return target instanceof AtsAcrossStoreSopportInfo ? "spts" : "entries";
    }

    @Override
    protected String afterValidateAllField(T target) {
        return this.afterValidateAllEntry(target);
    }

    protected String afterValidateAllEntry(T target) {
        return null;
    }

    protected String validateEntryBiz(String field, AtsAffairEntryBaseInfo entryBillInfo, T billInfo) throws Exception {
        return null;
    }

    protected String validateEntryDAC(String field, AtsAffairEntryBaseInfo entryBillInfo, T billInfo) throws Exception {
        boolean outManage;
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            return this.isCurrentPerson(entryBillInfo.getPerson()) ? null : MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
        }
        boolean bl = outManage = PlateformType.isPro(this.getValidateCtx().getPlateformType()) && !this.isDefaultManage(entryBillInfo);
        if (outManage) {
            return null;
        }
        Set<String> adminOrgRange = this.getValidateCtx().getAdminOrgRange();
        AdminOrgUnitInfo adminInfo = entryBillInfo.getAdminOrgUnit();
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        adminInfo = entryBillInfo.getAttAdminOrgUnit();
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM_ADMIN", this.getValidateCtx().getBosCtx());
    }
}

