/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryCollection;
import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsOffsiteInfo;
import com.kingdee.eas.hr.ats.AtsOrdinalCommonResEnum;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AtsTripBillCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.BillSourceTypeEnum;
import com.kingdee.eas.hr.ats.IAtsTripBill;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.TripbillCancelEnum;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import com.kingdee.eas.hr.ats.util.common.TimeZoneUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.validator.DateInterVal;
import com.kingdee.eas.hr.ats.validator.OffsiteHelper;
import com.kingdee.eas.hr.ats.validator.ValidateCtx;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.timezone.TimeZoneUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OffsiteBillHelper
extends BillHelper {
    public OffsiteBillHelper(Context ctx) {
        super(ctx);
    }

    public OffsiteBillHelper() {
    }

    public String validateIsFillTrip(Context ctx, AtsOffsiteInfo atsOffsiteInfo) throws EASBizException, BOSException {
        System.out.println("OffsiteBillHelper.validateIsFillTrip.start");
        String validateIsFillmsg = OffsiteHelper.getInstance().validateFill(ctx, atsOffsiteInfo);
        System.out.println("OffsiteBillHelper.validateIsFillTrip.end " + validateIsFillmsg);
        return validateIsFillmsg;
    }

    public String doDateInterleaveVerify(AtsOffsiteEntryCollection offsiteEntryColl) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)offsiteEntryColl)) {
            return null;
        }
        int size = offsiteEntryColl.size();
        String[] rowNum = new String[size];
        String[] personID = new String[size];
        String[] offsiteStartTime = new String[size];
        String[] offsiteEndTime = new String[size];
        for (int i = 0; i < size; ++i) {
            rowNum[i] = String.valueOf(i + 1);
            personID[i] = CoreBaseUtile.getId(offsiteEntryColl.get(i).getPerson());
            offsiteStartTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealStartTime());
            offsiteEndTime[i] = HRTimeWebUtils.timestampToString(offsiteEntryColl.get(i).getRealEndTime());
        }
        return this.doDateInterleaveVerify(rowNum, personID, offsiteStartTime, offsiteEndTime);
    }

    public String doDateInterleaveVerify(String[] rowNum, String[] personID, String[] offsiteStartTime, String[] offsiteEndTime) {
        int len = personID.length;
        HashMap<String, String> dateMap = new HashMap<String, String>();
        StringBuffer errorSb = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            if (dateMap.containsKey(personID[i])) {
                String tempData = (String)dateMap.get(personID[i]);
                String interleaveList = this.dateInterleaveVerifyCore(i, tempData, offsiteStartTime, offsiteEndTime);
                if (!interleaveList.equals("")) {
                    String[] interleaveListArray = interleaveList.split(",");
                    StringBuffer tmpsb = new StringBuffer("");
                    for (int j = 0; j < interleaveListArray.length; ++j) {
                        if (interleaveListArray[j].equals("")) continue;
                        tmpsb.append(rowNum[Integer.parseInt(interleaveListArray[j])]).append(" ");
                    }
                    errorSb.append(MLUtile.getRes((ResourceEnum)AtsOrdinalCommonResEnum.ConflictTripTimeRow, this.getCtx(), rowNum[i], tmpsb.toString()));
                }
                dateMap.put(personID[i], (String)dateMap.get(personID[i]) + "," + i);
                continue;
            }
            dateMap.put(personID[i], String.valueOf(i));
        }
        return errorSb.toString();
    }

    public String dateInterleaveVerifyCore(int rowNum, String arrayNum, String[] offsiteStartTime, String[] offsiteEndTime) {
        String interleaveList = "";
        String[] arrayNums = arrayNum.split(",");
        Timestamp startTimeStA = HRTimeWebUtils.stringToTimestamp(offsiteStartTime[rowNum].substring(0, 16) + ":00");
        Timestamp endTimeStA = HRTimeWebUtils.stringToTimestamp(offsiteEndTime[rowNum].substring(0, 16) + ":00");
        for (int i = 0; i < arrayNums.length; ++i) {
            Timestamp endTimeStB;
            int tempArrayNum = Integer.parseInt(arrayNums[i]);
            Timestamp startTimeStB = HRTimeWebUtils.stringToTimestamp(offsiteStartTime[tempArrayNum].substring(0, 16) + ":00");
            if (!this.isInterleaving(startTimeStA, endTimeStA, startTimeStB, endTimeStB = HRTimeWebUtils.stringToTimestamp(offsiteEndTime[tempArrayNum].substring(0, 16) + ":00"))) continue;
            interleaveList = interleaveList + tempArrayNum + ",";
        }
        return interleaveList;
    }

    private boolean isInterleaving(Timestamp startTimeA, Timestamp endTimeA, Timestamp startTimeB, Timestamp endTimeB) {
        return startTimeA.before(endTimeB) && startTimeB.before(endTimeA);
    }

    public void getDateOverlappingData(AtsOffsiteInfo AtsOffsiteInfo2) throws BOSException, SQLException, EASBizException {
        Context ctx = this.getCtx();
        String billId = CoreBaseUtile.getId(AtsOffsiteInfo2);
        if (AtsOffsiteInfo2 == null || AtsCollectionUtile.isEmpty((IObjectCollection)AtsOffsiteInfo2.getEntries())) {
            return;
        }
        StringBuffer selectSql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>(4);
        String unionAllFlag = " union all ";
        for (int i = 0; i < AtsOffsiteInfo2.getEntries().size(); ++i) {
            AtsOffsiteEntryInfo atsOffsiteEntryInfo = AtsOffsiteInfo2.getEntries().get(i);
            String personId = CoreBaseUtile.getId(atsOffsiteEntryInfo.getPerson());
            Date beginTime = Date.getTime(atsOffsiteEntryInfo.getRealStartTime());
            Date endTime = Date.getTime(atsOffsiteEntryInfo.getRealEndTime());
            sqlParam.addAll(Arrays.asList(personId, endTime, beginTime));
            selectSql.append(" select bill.fnumber,entry.FRealStartTime,entry.FRealEndTime,entry.fpersonid");
            selectSql.append(" from  T_ATS_AtsOffsite  bill left join  T_ATS_AtsOffsiteEntry entry on  bill.fid = entry.fbillid ");
            selectSql.append(" where entry.fpersonid=? and bill.fbillstate not in( 0,4) and entry.FRealStartTime<? and entry.FRealEndTime>? and entry.FRealStartTime <> entry.FRealEndTime ");
            if (BOSUuid.isValid((String)billId, (boolean)true)) {
                selectSql.append("and bill.fid !=?");
                sqlParam.add(billId);
            }
            selectSql.append(unionAllFlag);
        }
        selectSql.setLength(selectSql.length() - unionAllFlag.length());
        selectSql.append(") temp");
        selectSql.insert(0, "select top 1 * from (");
        System.out.println("OffsiteBillHelper.getDateOverlappingData.sql " + selectSql.toString());
        System.out.println("OffsiteBillHelper.getDateOverlappingData.param " + sqlParam);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])sqlParam.toArray());
        if (row.next()) {
            System.out.println("OffsiteBillHelper.getDateOverlappingData.reault.has");
            java.util.Date dbBeginTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealStartTime"));
            java.util.Date dbEndTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealEndTime"));
            String personid = row.getString("fpersonid");
            PersonPositionInfo positionInfo = SHRBillUtil.getAdminOrgUnit(personid, ctx);
            String msg = MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "TRIP_OVER", this.getCtx(), row.getString("FNumber"), positionInfo != null && positionInfo.getPerson() != null ? positionInfo.getPerson().getName() : "", HRTimeWebUtils.dateLongToString(dbBeginTime), HRTimeWebUtils.dateLongToString(dbEndTime));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
        System.out.println("OffsiteBillHelper.getDateOverlappingData.notReault.has");
    }

    public static boolean hasIntersection(java.util.Date beginTime, java.util.Date lateTime, java.util.Date startTime, java.util.Date endTime) {
        if (startTime == null || endTime == null || startTime.getTime() >= endTime.getTime()) {
            return false;
        }
        if (beginTime == null || lateTime == null || beginTime.getTime() >= lateTime.getTime()) {
            return false;
        }
        return beginTime.getTime() < endTime.getTime() && startTime.getTime() < lateTime.getTime();
    }

    private static DateInterVal getStartAndEndTimeByScheduleShiftInfo(ScheduleShiftInfo info) {
        Timestamp preTime = null;
        Timestamp nextTime = null;
        for (int sta = 0; sta < info.getItems().size(); ++sta) {
            int segmentValue = Integer.parseInt(info.getItems().get(sta).getSegment().getValue());
            if (segmentValue == 1) {
                preTime = info.getItems().get(sta).getPreDateTime();
            }
            if (segmentValue != info.getItems().size()) continue;
            nextTime = info.getItems().get(sta).getNextDateTime();
        }
        DateInterVal dateInterVal = new DateInterVal();
        dateInterVal.setBeginDate(preTime);
        dateInterVal.setEndDate(nextTime);
        return dateInterVal;
    }

    public static AttendanceFileHISInfo getAttendanceFileHisInfo(Context ctx, Timestamp beginTime, String proposerId) throws BOSException {
        AttendanceFileHISCollection attendanceFilehisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select *,attencePolicy.* where proposer.id='" + proposerId + "' order by effdt desc");
        AttendanceFileHISInfo attendanceFileHisInfo = null;
        if (attendanceFilehisColl != null && attendanceFilehisColl.size() > 0) {
            for (int i = 0; i < attendanceFilehisColl.size(); ++i) {
                AttendanceFileHISInfo hisInfo = attendanceFilehisColl.get(i);
                java.util.Date effdt = hisInfo.getEFFDT();
                String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
                leffdtStr = leffdtStr + " 23:59:59";
                java.util.Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
                if (beginTime.getTime() < effdt.getTime() || beginTime.getTime() > leffdt.getTime()) continue;
                attendanceFileHisInfo = hisInfo;
                break;
            }
        }
        return attendanceFileHisInfo;
    }

    public String getCrossTimezoneMsg(AtsTripBillInfo billInfo) throws BOSException, EASBizException {
        boolean needValidate = billInfo != null && !AtsCollectionUtile.isEmpty((IObjectCollection)billInfo.getEntries());
        Context ctx = this.getCtx();
        StringBuffer crossMsg = new StringBuffer();
        if (needValidate && Boolean.parseBoolean(ParamUtile.getParamVal(ctx, "ShowTimeZoneForCtrl"))) {
            Map<Object, String> map = TimeZoneUtile.calTripCrossTimeZone(ctx, billInfo.getEntries(), true);
            map = AtsCollectionUtile.trim(map);
            for (String msg : map.values()) {
                crossMsg.append("\r\n").append(msg);
            }
            if (crossMsg.length() > 0) {
                crossMsg.insert(0, MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "CROSS_TIMEZOME", ctx));
            }
        }
        return crossMsg.toString();
    }

    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T billInfo) throws BOSException, EASBizException {
        super.storefields(ctx, billInfo);
        PersonInfo curPerson = SHRBillUtil.getCurrPersonInfoNew(ctx);
        if (billInfo.getAdminOrg() == null) {
            PersonPositionInfo curPersonPosition = SHRBillUtil.getAdminOrgUnit(CoreBaseUtile.getId(curPerson), ctx);
            billInfo.setAdminOrg(curPersonPosition.getPersonDep());
        }
        if (billInfo.get("billSourceType") == null) {
            billInfo.put("billSourceType", (Object)BillSourceTypeEnum.empSelfService);
        }
        this.setCtx(ctx);
        AtsTripBillEntryCollection atsTripBillEntryCollection = ((AtsTripBillInfo)billInfo).getEntries();
        this.storeEntryfields(atsTripBillEntryCollection, CoreBaseUtile.getId(billInfo.getHrOrgUnit()));
        return billInfo;
    }

    protected void storeEntryfields(AtsTripBillEntryCollection entries, String hrOrgUnitId) throws EASBizException, BOSException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        hrOrgUnitId = null;
        int entrySize = entries.size();
        for (int i = 0; i < entrySize; ++i) {
            Timestamp endTime;
            AtsTripBillEntryInfo atsBillEntryInfo = entries.get(i);
            Timestamp beginTime = atsBillEntryInfo.getTripStartTime();
            AttendanceFileHISInfo fileHisInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(this.ctx, beginTime, endTime = atsBillEntryInfo.getTripEndTime(), CoreBaseUtile.getId(atsBillEntryInfo.getPerson()));
            if (fileHisInfo == null) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{new AtsFileBizException(AtsFileBizException.NOTEXISTFILEHIS).getMessage()});
            }
            String string = hrOrgUnitId = hrOrgUnitId == null ? CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()) : hrOrgUnitId;
            if (!StringUtils.equals((CharSequence)hrOrgUnitId, (CharSequence)CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()))) {
                throw new BOSException(new AtsBillBizException(AtsBillBizException.COMMITCROSSHRORG).getMessage());
            }
            atsBillEntryInfo.setAdminOrgUnit(fileHisInfo.getAdminOrgUnit());
            atsBillEntryInfo.setAttAdminOrgUnit(fileHisInfo.getAttAdminOrgUnit());
            atsBillEntryInfo.setPosition(fileHisInfo.getPosition());
            atsBillEntryInfo.setIsDefaultManage(fileHisInfo.isIsDefaultManage());
            if (!atsBillEntryInfo.containsKey("isCancelTrip")) {
                atsBillEntryInfo.setIsCancelTrip(TripbillCancelEnum.notconfirm);
            }
            if (atsBillEntryInfo.isIsDefaultManage() || !atsBillEntryInfo.containsKey("isCalOt")) {
                atsBillEntryInfo.setIsCalOt(false);
            }
            Timestamp tripStartTime = atsBillEntryInfo.getTripStartTime();
            Timestamp tripEndTime = atsBillEntryInfo.getTripEndTime();
            BigDecimal tripDays = atsBillEntryInfo.getTripDays();
            atsBillEntryInfo.setRealTripStartTime(tripStartTime);
            atsBillEntryInfo.setRealTripEndTime(tripEndTime);
            atsBillEntryInfo.setRealTripDays(tripDays);
            atsBillEntryInfo.setIsInitAllDay(atsBillEntryInfo.isIsAllDay());
            atsBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsBillEntryInfo.setLastUpdateTime(now);
            if (atsBillEntryInfo.getTripDays() == null) {
                BigDecimal len = atsBillEntryInfo.getRealTripDays();
                atsBillEntryInfo.setTripDays(len == null ? this.getBillLength(this.ctx, atsBillEntryInfo) : len);
            }
            if (atsBillEntryInfo.getRealTripDays() == null) {
                atsBillEntryInfo.setRealTripDays(atsBillEntryInfo.getTripDays());
            }
            if (atsBillEntryInfo.getTimeZone() != null) continue;
            TimeZoneInfo timeZone = TimeZoneUtil.getUserTimeZone((Context)this.ctx);
            atsBillEntryInfo.setTimeZone(timeZone);
        }
    }

    public String[] doAbortBill(Context ctx, String billIdParam) throws BOSException, EASBizException {
        String billIds = billIdParam.replaceAll(",", "','");
        String[] billIdArr = billIdParam.split(",");
        HashSet atsInfoIds = new HashSet();
        ArrayList<String> noSubmitBilList = new ArrayList<String>();
        ArrayList<String> approveBilList = new ArrayList<String>();
        String oql = " select number,billstate,id,entries.person where id in ( '" + billIds + "' )";
        IAtsTripBill iAtsTripBill = AtsTripBillFactory.getLocalInstance(ctx);
        AtsTripBillCollection atsTripBillCol = iAtsTripBill.getAtsTripBillCollection(oql);
        ValidateCtx validateCtx = ValidateUtile.getValidateCtx(ctx, billIdParam);
        for (int i = 0; i < atsTripBillCol.size(); ++i) {
            HRBillStateEnum billState = atsTripBillCol.get(i).getBillState();
            String billId = atsTripBillCol.get(i).getId().toString();
            if (HRBillStateEnum.SAVED.equals((Object)billState)) {
                noSubmitBilList.add(billId);
                continue;
            }
            if (!HRBillStateEnum.AUDITED.equals((Object)billState)) continue;
            approveBilList.add(billId);
        }
        if (noSubmitBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        if (approveBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        for (int j = 0; j < billIdArr.length; ++j) {
            String billId = billIdArr[j];
            try {
                ValidateUtile.setValidatorCtx(ctx, validateCtx, billId);
                iAtsTripBill.abortBizBill(billId);
                OffsiteBillHelper.uptBillSourceTypeWithBack(ctx, billId);
                if (atsInfoIds.contains(billId)) continue;
                DataLogsRecordUtil.processListObjectsLog((CoreBaseInfo)AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo(" select *,entries.* where id = ( '" + billId + "' )"), OperActionEnum.abort, ctx);
                continue;
            }
            catch (EASBizException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return billIdArr;
    }
}

