/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

import com.kingdee.eas.hr.ats.util.common.AtsLog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MsgDisplayer {
    private int msgCount;
    private boolean forWebDisplay;
    private boolean useCollectionModel;
    private Logger logger = AtsLog.getLog();
    private Map<String, Msg> msgContainer = new HashMap<String, Msg>();

    public MsgDisplayer addInfo(String msg) {
        return this.addInfo(msg, null);
    }

    public MsgDisplayer addError(String msg) {
        return this.addError(msg, null);
    }

    public MsgDisplayer addInfo(String contentKey, Object ... msgParam) {
        return this.insertMsg(true, contentKey, null, msgParam);
    }

    public MsgDisplayer addError(String contentKey, Object ... msgParam) {
        return this.insertMsg(false, contentKey, null, msgParam);
    }

    public MsgDisplayer insertInfo(String msg, int sortNum) {
        return this.insertInfo(msg, sortNum, null);
    }

    public MsgDisplayer insertInfo(String contentKey, Integer sortNum, Object ... msgParam) {
        return this.insertMsg(true, contentKey, sortNum, msgParam);
    }

    public MsgDisplayer insertError(String msg, int sortNum) {
        return this.insertError(msg, sortNum, null);
    }

    public MsgDisplayer insertError(String contentKey, Integer sortNum, Object ... msgParam) {
        return this.insertMsg(false, contentKey, sortNum, msgParam);
    }

    protected MsgDisplayer insertMsg(boolean isInfoLevel, String contentKey, Integer sortNum, Object ... msgParam) {
        List<Object[]> params;
        if (StringUtils.isBlank((String)contentKey)) {
            return this;
        }
        if (isInfoLevel) {
            this.logger.info((Object)MessageFormat.format(contentKey, msgParam));
        } else {
            this.logger.error((Object)MessageFormat.format(contentKey, msgParam));
        }
        Msg msgObj = this.msgContainer.get(contentKey);
        if (msgObj == null) {
            msgObj = new Msg(contentKey, ++this.msgCount);
            this.msgContainer.put(contentKey, msgObj);
        }
        if (sortNum != null) {
            msgObj.setSortNum(sortNum);
        }
        if ((params = msgObj.getContentParams()) == null) {
            params = new ArrayList<Object[]>(4);
            msgObj.setContentParams(params);
        }
        if (msgParam != null && msgParam.length > 0) {
            params.add(msgParam);
        }
        return this;
    }

    public MsgDisplayer addMsg(MsgDisplayer msgContainer) {
        return this.addMsgInner(this, msgContainer);
    }

    public MsgDisplayer insertMsg(MsgDisplayer msgContainer) {
        return this.addMsgInner(msgContainer, this);
    }

    public MsgDisplayer addMsgInner(MsgDisplayer baseMsgDisplayer, MsgDisplayer addedMsgDisplayer) {
        Map<String, Msg> base = baseMsgDisplayer.getMsgContainer();
        Map<String, Msg> added = baseMsgDisplayer.getMsgContainer();
        for (String key : added.keySet()) {
            if (base.containsKey(key)) {
                base.get(key).getContentParams().addAll(added.get(key).getContentParams());
                continue;
            }
            base.put(key, added.get(key).setSortNum(++this.msgCount));
        }
        return this;
    }

    protected String getNextLineSign() {
        return this.forWebDisplay ? "<br/>" : "\r\n";
    }

    public String toString() {
        StringBuffer showMsg = new StringBuffer();
        ArrayList<Msg> values = new ArrayList<Msg>(this.msgContainer.values());
        Collections.sort(values);
        for (Msg msg : values) {
            showMsg.append(msg);
        }
        return showMsg.toString();
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public MsgDisplayer setMsgCount(int msgCount) {
        this.msgCount = msgCount;
        return this;
    }

    public boolean isForWebDisplay() {
        return this.forWebDisplay;
    }

    public MsgDisplayer setForWebDisplay(boolean forWebDisplay) {
        this.forWebDisplay = forWebDisplay;
        return this;
    }

    public boolean isUseCollectionModel() {
        return this.useCollectionModel;
    }

    public MsgDisplayer setUseCollectionModel(boolean useCollectionModel) {
        this.useCollectionModel = useCollectionModel;
        return this;
    }

    public Map<String, Msg> getMsgContainer() {
        return this.msgContainer;
    }

    public MsgDisplayer setMsgContainer(Map<String, Msg> msgContainer) {
        this.msgContainer = msgContainer;
        return this;
    }

    class Msg
    implements Comparable<Msg> {
        private boolean title;
        private String contentKey;
        private List<Object[]> contentParams;
        private int sortNum;
        private Msg parent;

        public Msg(String contentKey, int sortNum, Msg parent) {
            this.contentKey = contentKey;
            this.sortNum = sortNum;
            this.parent = parent;
        }

        public Msg(String contentKey) {
            this.contentKey = contentKey;
        }

        public Msg(String contentKey, int sortNum) {
            this.contentKey = contentKey;
            this.sortNum = sortNum;
        }

        public boolean isTitle() {
            return this.title;
        }

        public Msg setTitle(boolean title) {
            this.title = title;
            return this;
        }

        public String getContentKey() {
            return this.contentKey;
        }

        public Msg setContentKey(String contentKey) {
            this.contentKey = contentKey;
            return this;
        }

        public List<Object[]> getContentParams() {
            return this.contentParams;
        }

        public Msg setContentParams(List<Object[]> contentParams) {
            this.contentParams = contentParams;
            return this;
        }

        public int getSortNum() {
            return this.sortNum;
        }

        public Msg setSortNum(int sortNum) {
            this.sortNum = sortNum;
            return this;
        }

        public Msg getParent() {
            return this.parent;
        }

        public Msg setParent(Msg parent) {
            this.parent = parent;
            return this;
        }

        public String toString() {
            int i;
            StringBuffer showMsg = new StringBuffer();
            if (this.contentParams == null || this.contentParams.size() == 0 || !this.contentKey.contains("{") || !this.contentKey.contains("}")) {
                return showMsg.append(this.contentKey).append(MsgDisplayer.this.getNextLineSign()).toString();
            }
            int paramLen = this.contentParams.get(0).length;
            if (this.contentParams.size() == 1 || !MsgDisplayer.this.useCollectionModel && paramLen != 1) {
                for (Object[] o : this.contentParams) {
                    showMsg.append(MessageFormat.format(this.contentKey, o)).append(MsgDisplayer.this.getNextLineSign());
                }
                return showMsg.toString();
            }
            if (paramLen == 1) {
                StringBuffer sb = new StringBuffer("[");
                for (Object[] o : this.contentParams) {
                    sb.append(o[0]).append(",");
                }
                return showMsg.append(MessageFormat.format(this.contentKey, sb.replace(sb.length() - 1, sb.length(), "]"))).append(MsgDisplayer.this.getNextLineSign()).toString();
            }
            HashMap<Integer, LinkedHashSet<Object>> indexMap = new HashMap<Integer, LinkedHashSet<Object>>(paramLen);
            for (Object[] o : this.contentParams) {
                for (i = 0; i < paramLen; ++i) {
                    LinkedHashSet<Object> temp = (LinkedHashSet<Object>)indexMap.get(i);
                    if (temp == null) {
                        temp = new LinkedHashSet<Object>(paramLen);
                        indexMap.put(i, temp);
                    }
                    temp.add(o[i]);
                }
            }
            Object[] msgArr = new Object[paramLen];
            Iterator iterator = indexMap.keySet().iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                msgArr[i] = "[" + StringUtils.join(((Set)indexMap.get(i)).iterator(), (String)",") + "]";
            }
            return showMsg.append(MessageFormat.format(this.contentKey, msgArr)).append(MsgDisplayer.this.getNextLineSign()).toString();
        }

        @Override
        public int compareTo(Msg o) {
            if (o == null) {
                return -1;
            }
            return this.getSortNum() - o.getSortNum();
        }
    }
}

