/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

import com.kingdee.eas.hr.ats.vo.common.RangeVo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RangeMap<K, V> {
    private Map<RangeVo<K>, V> dataContainer;

    public RangeMap() {
        this.dataContainer = new HashMap<RangeVo<K>, V>();
    }

    public RangeMap(int size) {
        this.dataContainer = new HashMap<RangeVo<K>, V>(size);
    }

    public V get(K key) {
        for (RangeVo<K> v : this.dataContainer.keySet()) {
            if (!v.include(key)) continue;
            return this.dataContainer.get(v);
        }
        return null;
    }

    public V get(RangeVo<K> key) {
        return this.dataContainer.get(key);
    }

    public boolean containKey(K key) {
        for (RangeVo<K> v : this.dataContainer.keySet()) {
            if (!v.include(key)) continue;
            return true;
        }
        return false;
    }

    public V getFirstEle() {
        Iterator<V> iterator = this.values().iterator();
        if (iterator.hasNext()) {
            V ele = iterator.next();
            return ele;
        }
        return null;
    }

    public Collection<V> values() {
        return this.dataContainer.values();
    }

    public Iterator<V> valueIterator() {
        return this.dataContainer.values().iterator();
    }

    public boolean contains(Object key) {
        if (key instanceof RangeVo) {
            return this.containKey((RangeVo)key);
        }
        try {
            Object empKey = key;
            return this.containKey(empKey);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containValue(V value) {
        return this.dataContainer.containsValue(value);
    }

    public boolean containKey(RangeVo<K> key) {
        return this.dataContainer.containsKey(key);
    }

    public void put(RangeVo<K> key, V value) {
        if (key == null) {
            return;
        }
        this.dataContainer.put(key, value);
    }

    public Set<Map.Entry<RangeVo<K>, V>> entrySet() {
        return this.dataContainer.entrySet();
    }

    public void remove(RangeVo<K> key) {
        this.dataContainer.remove(key);
    }

    public void removeByValue(V value) {
        Iterator<Map.Entry<RangeVo<K>, V>> it = this.dataContainer.entrySet().iterator();
        while (it.hasNext()) {
            V temp = it.next().getValue();
            if (temp != value && (temp == null || !temp.equals(value))) continue;
            it.remove();
        }
    }

    public String toString() {
        return "RangeMap [dataContainer=" + this.dataContainer + "]";
    }
}

