/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

public abstract class RangeVo<T> {
    T upBound;
    T lowBound;

    public RangeVo() {
    }

    protected void changeUpAndLow() {
        T temp = this.upBound;
        this.upBound = this.lowBound;
        this.lowBound = temp;
    }

    public RangeVo(T lowBound, T upBound) {
        this.upBound = upBound;
        this.lowBound = lowBound;
        this.valid();
    }

    public RangeVo(RangeVo<T> rangeVo) {
        if (rangeVo != null) {
            this.upBound = rangeVo.upBound;
            this.lowBound = rangeVo.lowBound;
            this.valid();
        }
    }

    public boolean include(T t) {
        return this.indexOf(t) >= 0;
    }

    public int indexOf(T t) {
        if (!(this.upBound instanceof Comparable) || !this.isValid()) {
            return -1;
        }
        Comparable lowCompare = (Comparable)this.lowBound;
        Comparable upCompare = (Comparable)this.upBound;
        return ((Comparable)t).compareTo(this.lowBound) >= 0 && ((Comparable)t).compareTo(this.upBound) <= 0 ? 0 : -1;
    }

    public T getUpBound() {
        return this.upBound;
    }

    public void setUpBound(T upBound) {
        this.upBound = upBound;
    }

    public T getLowBound() {
        return this.lowBound;
    }

    public void setLowBound(T lowBound) {
        this.lowBound = lowBound;
    }

    public boolean isValid() {
        return this.lowBound != null && this.upBound != null;
    }

    public RangeVo<T> valid() {
        if (this.isValid() && this.upBound instanceof Comparable && ((Comparable)this.upBound).compareTo(this.lowBound) < 0) {
            this.changeUpAndLow();
        }
        return this;
    }

    public long width() {
        return this.widthLeft(this.getUpBound());
    }

    public long widthLeft(T compareObj) {
        return 0L;
    }

    public long widthRight(T compareObj) {
        return 0L;
    }

    public String toString() {
        return "RangeVo [lowBound=" + this.lowBound + ", upBound=" + this.upBound + "]";
    }
}

