/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.IScheduleShift;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkShiftUtile {
    public static Collection<LinkedHashMap<String, Object>> assembleNoShiftData(Context ctx, Collection<LinkedHashMap<String, Object>> noShiftPersonInfo, String beginDate, String endDate) {
        List<String> personNums = AtsCollectionUtile.map(noShiftPersonInfo, new AtsMapFn<LinkedHashMap<String, Object>, String>(){

            @Override
            public String map(LinkedHashMap<String, Object> t) {
                return (String)t.get("personNum");
            }
        });
        List<JSONObject> scheduleData = WorkShiftUtile.getScheduleShiftList(ctx, personNums, beginDate, endDate);
        block0: for (LinkedHashMap<String, Object> personAndSchedule : noShiftPersonInfo) {
            if (scheduleData == null) continue;
            for (int i = 0; i < scheduleData.size(); ++i) {
                if (!personAndSchedule.get("personNum").equals(scheduleData.get(i).get((Object)"personNum"))) continue;
                personAndSchedule.put("scheduleData", scheduleData.get(i).get((Object)"scheduleData"));
                continue block0;
            }
        }
        return noShiftPersonInfo;
    }

    public static void combineMultiAttAdminFields(IObjectCollection scheduleShiftInfos) {
        if (AtsCollectionUtile.isEmpty(scheduleShiftInfos)) {
            WorkShiftUtile.combineMultiAttAdminFields((ScheduleShiftInfo)scheduleShiftInfos);
            return;
        }
        int size = scheduleShiftInfos.size();
        for (int i = 0; i < size; ++i) {
            if (!(scheduleShiftInfos.getObject(i) instanceof ScheduleShiftInfo)) continue;
            WorkShiftUtile.combineMultiAttAdminFields((ScheduleShiftInfo)scheduleShiftInfos.getObject(i));
        }
    }

    public static void combineMultiAttAdminFields(ScheduleShiftInfo scheduleShiftInfo) {
        if (scheduleShiftInfo == null || AtsCollectionUtile.isEmpty((IObjectCollection)scheduleShiftInfo.getItems())) {
            return;
        }
        AtsShiftInfo shiftInfo = scheduleShiftInfo.getDefaultShift();
        Iterator it = scheduleShiftInfo.getItems().iterator();
        while (it.hasNext()) {
            ScheduleShiftItemInfo itemInfo = (ScheduleShiftItemInfo)it.next();
            if (itemInfo.getAttAdminOrgUnit() != null) continue;
            itemInfo.setAttAdminOrgUnit(scheduleShiftInfo.getAdminOrgUnit());
        }
    }

    public static List<JSONObject> getScheduleShiftList(Context ctx, Collection<String> personNums, String beginDate, String endDate) {
        String sql = "select person.fnumber personNum,person.fname" + MLUtile.getMlFlag(ctx) + " personName,schedule.fattenddate attendDate, shift.fname" + MLUtile.getMlFlag(ctx) + " shiftName, schedule.fdaytype dayType,schedule.FAtsTurnShift turnShiftId,schedule.fshiftByTurnSegment segment from t_bd_person  person left join t_hr_ats_scheduleshift schedule on person.fid = schedule.fproposerid and schedule.fattenddate >= {ts '" + beginDate + "'} and schedule.fattenddate <= {ts '" + endDate + "'} left join t_hr_ats_shift shift on schedule.fdefaultshiftid = shift.fid where person.fnumber in (?) ORDER by personNum";
        HashMap<String, JSONObject> results = new HashMap<String, JSONObject>(personNums.size());
        List<List<String>> groupedPersonNum = AtsCollectionUtile.group(personNums, AtsConstants.SIZE_COMMON_BATCH);
        JSONArray scheduleData = null;
        JSONObject personDateSchedule = null;
        for (List<String> personNumsL : groupedPersonNum) {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.replaceAll("\\?", AtsCollectionUtile.joinForSql(personNumsL)));
                while (rowSet.next()) {
                    String personNum = rowSet.getString("personNum");
                    JSONObject personSchedules = (JSONObject)results.get(personNum);
                    if (personSchedules == null) {
                        personSchedules = new JSONObject(4);
                        personSchedules.put("rowNum", (Object)(results.size() + 1));
                        personSchedules.put("personName", (Object)rowSet.getString("personName"));
                        personSchedules.put("personNum", (Object)personNum);
                        scheduleData = new JSONArray();
                        personSchedules.put("scheduleData", (Object)scheduleData);
                        results.put(personNum, personSchedules);
                    }
                    if (rowSet.getDate("attendDate") == null) continue;
                    scheduleData = personSchedules.getJSONArray("scheduleData");
                    personDateSchedule = new JSONObject(5);
                    personDateSchedule.put("dayType", (Object)rowSet.getInt("dayType"));
                    if (StringUtils.isNotEmpty((String)rowSet.getString("turnShiftId"))) {
                        personDateSchedule.put("turnShiftId", (Object)rowSet.getString("turnShiftId"));
                    }
                    if (rowSet.getInt("segment") != 0) {
                        personDateSchedule.put("segment", (Object)rowSet.getInt("segment"));
                    }
                    if (StringUtils.isNotEmpty((String)rowSet.getString("shiftName"))) {
                        personDateSchedule.put("shiftName", (Object)rowSet.getString("shiftName"));
                    }
                    personDateSchedule.put("attendDate", (Object)AtsCommonUtile.getDateFormat().format(rowSet.getDate("attendDate")));
                    scheduleData.add((Object)personDateSchedule);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<JSONObject> returnData = new ArrayList<JSONObject>(results.values());
        Collections.sort(returnData, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o1.getIntValue("rowNum") - o2.getIntValue("rowNum");
            }
        });
        return returnData;
    }

    public static List<JSONObject> getScheduleShiftListUseBizInterface(Context ctx, Collection<String> personNums, String beginDate, String endDate) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"proposer.number", "proposer.name", "attendDate", "defaultshift.name", "dayType", "AtsTurnShift", "shiftByTurnSegment"});
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo personFilter = new FilterItemInfo("proposer.number", (Object)Collections.EMPTY_SET, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(new FilterItemInfo("attendDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("attendDate", (Object)endDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(personFilter);
        evi.getSelector().add("proposer.number");
        HashMap<String, JSONObject> results = new HashMap<String, JSONObject>(personNums.size());
        List<List<String>> groupedPersonNum = AtsCollectionUtile.group(personNums, AtsConstants.SIZE_COMMON_BATCH);
        JSONArray scheduleData = null;
        JSONObject personDateSchedule = null;
        ArrayList<JSONObject> returnData = new ArrayList<JSONObject>(results.values());
        try {
            IScheduleShift iScheduleShift = ScheduleShiftFactory.getLocalInstance(ctx);
            for (List<String> personNumsL : groupedPersonNum) {
                personFilter.setCompareValue(new HashSet<String>(personNumsL));
                ScheduleShiftCollection scheduleColls = iScheduleShift.getScheduleShiftCollection(evi);
                if (AtsCollectionUtile.isEmpty((IObjectCollection)scheduleColls)) continue;
                int size = scheduleColls.size();
                for (int i = 0; i < size; ++i) {
                    ScheduleShiftInfo scheduleInfo = scheduleColls.get(i);
                    String personNum = (String)CoreBaseUtile.getfield((CoreBaseInfo)scheduleInfo, "proposer.number");
                    JSONObject personSchedules = (JSONObject)results.get(personNum);
                    if (personSchedules == null) {
                        personSchedules = new JSONObject(4);
                        personSchedules.put("rowNum", (Object)(results.size() + 1));
                        personSchedules.put("personName", (Object)((String)CoreBaseUtile.getfield((CoreBaseInfo)scheduleInfo, "proposer.name")));
                        personSchedules.put("personNum", (Object)personNum);
                        scheduleData = new JSONArray();
                        personSchedules.put("scheduleData", (Object)scheduleData);
                        results.put(personNum, personSchedules);
                    }
                    if (scheduleInfo.getAttendDate() == null) continue;
                    scheduleData = personSchedules.getJSONArray("scheduleData");
                    personDateSchedule = new JSONObject(8);
                    personDateSchedule.put("dayType", (Object)scheduleInfo.getDayType().getValue());
                    if (scheduleInfo.getAtsTurnShift() != null) {
                        personDateSchedule.put("turnShiftId", (Object)scheduleInfo.getAtsTurnShift().getString("id"));
                    }
                    if (scheduleInfo.getShiftByTurnSegment() != 0) {
                        personDateSchedule.put("segment", (Object)scheduleInfo.getShiftByTurnSegment());
                    }
                    personDateSchedule.put("shiftName", CoreBaseUtile.getfield((CoreBaseInfo)scheduleInfo, "defaultshift.name"));
                    personDateSchedule.put("attendDate", (Object)AtsCommonUtile.getDateFormat().format(scheduleInfo.getAttendDate()));
                    personDateSchedule.put("items", (Object)scheduleInfo.getItems());
                    scheduleData.add((Object)personDateSchedule);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Collections.sort(returnData, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o1.getIntValue("rowNum") - o2.getIntValue("rowNum");
            }
        });
        return returnData;
    }

    public static java.util.Date buildShiftPreTime(AtsShiftInfo shift, java.util.Date baseDate) {
        if (shift == null || AtsCollectionUtile.isEmpty((IObjectCollection)shift.getItems())) {
            return null;
        }
        shift.getItems().sort("");
        return WorkShiftUtile.buildShiftItemPreTime(shift.getItems().get(0), baseDate);
    }

    public static java.util.Date buildShiftNextTime(AtsShiftInfo shift, java.util.Date baseDate) {
        if (shift == null || AtsCollectionUtile.isEmpty((IObjectCollection)shift.getItems())) {
            return null;
        }
        AtsShiftItemInfo lastItem = shift.getItems().get(shift.getItems().size() - 1);
        return WorkShiftUtile.buildShiftItemNextTime(lastItem, baseDate);
    }

    public static java.util.Date buildShiftItemPreTime(AtsShiftItemInfo shiftItem, java.util.Date baseDate) {
        if (shiftItem == null || StringUtils.isEmpty((String)shiftItem.getPreTime())) {
            return null;
        }
        Calendar base = Calendar.getInstance();
        if (baseDate != null) {
            base.setTime(baseDate);
        }
        String preTime = AtsCommonUtile.formateDate(base.getTime()) + " " + shiftItem.getPreTime() + ":00";
        return Date.getTime(preTime).nextDay(shiftItem.getPreTimeDayType().getValue() - 1);
    }

    public static java.util.Date buildShiftItemNextTime(AtsShiftItemInfo shiftItem, java.util.Date baseDate) {
        if (shiftItem == null || StringUtils.isEmpty((String)shiftItem.getNextTime())) {
            return null;
        }
        Calendar base = Calendar.getInstance();
        if (baseDate != null) {
            base.setTime(baseDate);
        }
        String nextTime = AtsCommonUtile.formateDate(base.getTime()) + " " + shiftItem.getNextTime() + ":00";
        return Date.getTime(nextTime).nextDay(shiftItem.getNextTimeDayType().getValue() - 1);
    }

    public static java.util.Date buildShiftItemRestPreTime(AtsShiftItemInfo shiftItem, java.util.Date baseDate) {
        java.util.Date itemPreTime = WorkShiftUtile.buildShiftItemPreTime(shiftItem, baseDate);
        if (shiftItem == null || itemPreTime == null || StringUtils.isEmpty((String)shiftItem.getRestPreTime())) {
            return null;
        }
        Calendar base = Calendar.getInstance();
        if (baseDate != null) {
            base.setTime(baseDate);
        }
        String restPreTimeStr = AtsCommonUtile.formateDate(base.getTime()) + " " + shiftItem.getRestPreTime() + ":00";
        java.util.Date restPreTime = AtsCommonUtile.getTime(restPreTimeStr);
        return Date.getTime(restPreTime).nextDay(restPreTime.after(itemPreTime) ? 0 : 1);
    }

    public static java.util.Date buildShiftItemRestNextTime(AtsShiftItemInfo shiftItem, java.util.Date baseDate) {
        java.util.Date itemPreTime = WorkShiftUtile.buildShiftItemPreTime(shiftItem, baseDate);
        if (shiftItem == null || itemPreTime == null || StringUtils.isEmpty((String)shiftItem.getRestNextTime())) {
            return null;
        }
        Calendar base = Calendar.getInstance();
        if (baseDate != null) {
            base.setTime(baseDate);
        }
        String restNexTimeStr = AtsCommonUtile.formateDate(base.getTime()) + " " + shiftItem.getRestNextTime() + ":00";
        java.util.Date restNexTime = AtsCommonUtile.getTime(restNexTimeStr);
        return Date.getTime(restNexTime).nextDay(restNexTime.after(itemPreTime) ? 0 : 1);
    }

    public static void buildShiftStandardHour(AtsShiftInfo shift) {
        if (shift == null || AtsCollectionUtile.isEmpty((IObjectCollection)shift.getItems())) {
            return;
        }
        java.util.Date base = Calendar.getInstance().getTime();
        double standardHour = 0.0;
        for (int i = 0; i < shift.getItems().size(); ++i) {
            AtsShiftItemInfo itemInfo = shift.getItems().get(i);
            if (itemInfo.getAttendanceType() != AttendanceTypeEnum.normalAttance && itemInfo.getAttendanceType() != AttendanceTypeEnum.normalAttanceExcludExcep) continue;
            standardHour += (double)((Date)WorkShiftUtile.buildShiftItemNextTime(itemInfo, base)).diff(WorkShiftUtile.buildShiftItemPreTime(itemInfo, base), 12) - itemInfo.getSegmentInRest().doubleValue();
        }
        shift.setStandardHour(BigDecimal.valueOf(standardHour));
    }

    public static BigDecimal buildItemTime(ScheduleShiftItemInfo itemInfo, int calendarField, boolean includeResrTime) {
        if (itemInfo == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal segmentInRest = itemInfo.getSegmentInRest();
        if (segmentInRest == null || includeResrTime) {
            segmentInRest = BigDecimal.ZERO;
        }
        BigDecimal param = new BigDecimal(calendarField == 12 ? 60000 : (calendarField == 10 ? 3600000 : 86400000));
        BigDecimal res = new BigDecimal(itemInfo.getNextDateTime().getTime() - itemInfo.getPreDateTime().getTime()).subtract(segmentInRest.multiply(new BigDecimal(60000))).divide(param, RoundingMode.HALF_UP);
        return res;
    }

    public static List<AtsShiftInfo> getAtsShift(Context ctx, Collection<String> atsShiftIds) {
        ArrayList<AtsShiftInfo> shifts = new ArrayList<AtsShiftInfo>();
        if (AtsCollectionUtile.isEmpty(atsShiftIds)) {
            System.out.println(WorkShiftUtile.class.getName() + "getAtsShift params is null" + atsShiftIds);
            return shifts;
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"*", "cardRule.segAftFirtakeCardType", "cardRule.segAftFirEndNum", "elasticValue", "items.*"});
        AtsViewUtile.getViewByFilter("state", 1, CompareType.EQUALS, evi);
        AtsViewUtile.getViewByFilter("id", new HashSet<String>(atsShiftIds), CompareType.INCLUDE, evi);
        AtsViewUtile.addSorter("number", SortType.ASCEND, evi);
        AtsViewUtile.addSorter("items.segment", SortType.ASCEND, evi);
        AtsShiftCollection colls = null;
        try {
            colls = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)colls)) {
            for (int i = 0; i < colls.size(); ++i) {
                shifts.add(colls.get(i));
            }
        }
        return shifts;
    }

    public static void updateShiftItems(Context ctx, ScheduleShiftCollection scheduleShiftCollection, Collection<String> shiftIds) {
        int i;
        AtsShiftInfo shift;
        if (shiftIds == null) {
            shiftIds = new HashSet<String>();
            for (int i2 = 0; i2 < scheduleShiftCollection.size(); ++i2) {
                shift = scheduleShiftCollection.get(i2).getDefaultShift();
                if (shift != null) {
                    shiftIds.add(shift.getId().toString());
                }
                if ((shift = scheduleShiftCollection.get(i2).getMatchShift()) == null) continue;
                shiftIds.add(shift.getId().toString());
            }
        }
        AtsShiftCollection shifts = null;
        try {
            shifts = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("select id,items.* where id in " + AtsCollectionUtile.joinForSqlWithBrackets(shiftIds));
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        if (AtsCollectionUtile.isEmpty(shifts)) {
            return;
        }
        HashMap<String, AtsShiftItemCollection> mapItems = new HashMap<String, AtsShiftItemCollection>(shiftIds.size());
        for (i = 0; i < shifts.size(); ++i) {
            mapItems.put(shifts.get(i).getId().toString(), shifts.get(i).getItems());
        }
        for (i = 0; i < scheduleShiftCollection.size(); ++i) {
            shift = scheduleShiftCollection.get(i).getDefaultShift();
            if (shift != null) {
                shift.getItems().addCollection((AtsShiftItemCollection)((Object)mapItems.get(shift.getId().toString())));
            }
            if ((shift = scheduleShiftCollection.get(i).getMatchShift()) == null) continue;
            shift.getItems().addCollection((AtsShiftItemCollection)((Object)mapItems.get(shift.getId().toString())));
        }
    }

    public static void updateShiftItems(Context ctx, Collection<ScheduleShiftInfo> scheduleShiftCollection, Collection<String> shiftIds) {
        AtsShiftInfo shift;
        if (shiftIds == null) {
            shiftIds = new HashSet<String>();
            Iterator<ScheduleShiftInfo> it = scheduleShiftCollection.iterator();
            while (it.hasNext()) {
                shift = it.next().getDefaultShift();
                if (shift == null) continue;
                shiftIds.add(shift.getId().toString());
            }
        }
        AtsShiftCollection shifts = null;
        try {
            shifts = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection("select id,items.* where id in " + AtsCollectionUtile.joinForSqlWithBrackets(shiftIds));
        }
        catch (BOSException e) {
            AtsLog.getWSLog().error((Object)"", (Throwable)e);
        }
        if (AtsCollectionUtile.isEmpty(shifts)) {
            return;
        }
        HashMap<String, AtsShiftItemCollection> mapItems = new HashMap<String, AtsShiftItemCollection>(shiftIds.size());
        for (int i = 0; i < shifts.size(); ++i) {
            mapItems.put(shifts.get(i).getId().toString(), shifts.get(i).getItems());
        }
        Iterator<ScheduleShiftInfo> it = scheduleShiftCollection.iterator();
        while (it.hasNext()) {
            shift = it.next().getDefaultShift();
            if (shift == null) continue;
            shift.getItems().addCollection((AtsShiftItemCollection)((Object)mapItems.get(shift.getId().toString())));
        }
    }

    public static void generateScheduleItem(ScheduleShiftInfo scheduleShiftInfo) {
        if (scheduleShiftInfo == null || scheduleShiftInfo.getDefaultShift() == null) {
            return;
        }
        AtsShiftItemCollection atsShiftItemCollection = scheduleShiftInfo.getDefaultShift().getItems();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)atsShiftItemCollection)) {
            return;
        }
        java.util.Date attenDate = scheduleShiftInfo.getAttendDate();
        for (int j = 0; j < atsShiftItemCollection.size(); ++j) {
            ScheduleShiftItemInfo itemInfo = new ScheduleShiftItemInfo();
            AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(j);
            itemInfo.setGroup(scheduleShiftInfo);
            itemInfo.setShiftItem(atsShiftItemInfo);
            itemInfo.setPreDateTime(AtsCommonUtile.getTimeStamp(WorkShiftUtile.buildShiftItemPreTime(atsShiftItemInfo, attenDate)));
            itemInfo.setNextDateTime(AtsCommonUtile.getTimeStamp(WorkShiftUtile.buildShiftItemNextTime(atsShiftItemInfo, attenDate)));
            if (atsShiftItemCollection.size() == 1) {
                itemInfo.setRestPreDateTime(AtsCommonUtile.getTimeStamp(WorkShiftUtile.buildShiftItemRestPreTime(atsShiftItemInfo, attenDate)));
                itemInfo.setRestNextDateTime(AtsCommonUtile.getTimeStamp(WorkShiftUtile.buildShiftItemRestNextTime(atsShiftItemInfo, attenDate)));
            }
            for (String shiftItemField : WorkShiftUtile.getshiftItemRealte()) {
                itemInfo.put(shiftItemField, atsShiftItemInfo.get(shiftItemField));
            }
            scheduleShiftInfo.getItems().add(itemInfo);
        }
        WorkShiftUtile.combineMultiAttAdminFields(scheduleShiftInfo);
    }

    public static String[] getshiftItemRealte() {
        return new String[]{"attendanceType", "nextFloatAdjusted", "nextIsPunchCard", "nextTime", "nextTimeDayType", "nextUnit", "preFloatAdjusted", "preIsPunchCard", "preTime", "preTimeDayType", "preUnit", "restNextTime", "restPreTime", "segment", "segmentInRest"};
    }

    public static List<String> getShiftRelateFields() {
        return new ArrayList<String>(Arrays.asList("isHalfDay", "cardRule", "standardHour", "otCompens", "shiftType", "isElastic", "elasticType", "elasticDirection", "elasticValue"));
    }
}

