/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.autoSchedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsSchedulePlanCollection;
import com.kingdee.eas.hr.ats.AtsSchedulePlanInfo;
import com.kingdee.eas.hr.ats.AtsSchedulePlanSetInfo;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.EHolidayProcessWay;
import com.kingdee.eas.hr.ats.HolidayArrange;
import com.kingdee.eas.hr.ats.RestdayArrange;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.OneFieldProcessor;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByUserDefined;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftManager;
import com.kingdee.eas.hr.ats.workShift.plan.BasePlanManager;
import com.kingdee.eas.hr.ats.workShift.plan.RangeSettingAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.AutoScheduleAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.AutoScheduleUtile;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.ScheduleParamAnalysor;
import com.kingdee.eas.hr.ats.workShift.plan.util.AttendanceLogUtil;
import com.kingdee.eas.hr.ats.workShift.save.BaseSaveShift;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AutoScheduleManager
extends BasePlanManager {
    private boolean ignoreExecuteDate = false;
    private static ThreadLocal<AttendanceLogInfo> ThreadLocalAttendanceLogInfo = new ThreadLocal();

    public AutoScheduleManager() {
    }

    public AutoScheduleManager(Context ctx, boolean ignoreExecuteDate) {
        this.ctx = ctx;
        this.ignoreExecuteDate = ignoreExecuteDate;
    }

    @Override
    public void execPlaneInner(String idOrNumberColls) throws Exception {
        super.execPlaneInner(idOrNumberColls);
        StringBuffer sql = new StringBuffer();
        sql.append(" select entry.fid fid from T_ATS_AtsSchedulePlanSet planeSet ");
        sql.append(" inner join T_ATS_AtsSchedulePlan entry on planeSet.fid = entry.FAtsSchedulePlanSetID");
        sql.append(" where 1=1");
        if (StringUtils.isNotEmpty((String)idOrNumberColls)) {
            String appointedSet = AtsCollectionUtile.joinForSqlWithBrackets(Arrays.asList(idOrNumberColls.split(",|\uff0c")));
            sql.append(" and ( planeSet.fid in ").append(appointedSet);
            sql.append(" or planeSet.fnumber in ").append(appointedSet).append(")");
        } else {
            sql.append(" and planeSet.fautomatic = 1 and planeSet.fstate = 1");
        }
        sql.append(" order by planeSet.fnumber , entry.fschedulePriority");
        String jobId = (String)this.ctx.get((Object)"jobInstId");
        AttendanceLogInfo attendanceLog = AttendanceLogUtil.initAttendanceLogInfo(this.ctx, jobId);
        ThreadLocalAttendanceLogInfo.set(attendanceLog);
        long startTime = System.currentTimeMillis();
        new OneFieldProcessor<String>(sql.toString(), this.ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<String> rows) {
                AutoScheduleManager.this.doSchedulePlane(AutoScheduleUtile.getPlanes(ctx, rows, true));
            }
        }.process();
        String updateSql = "update T_HR_ATS_AttendanceLog set FCostSumTime=? ,FCostTime=? , FRemainTime=? ,fcalstatus=?  where FJobid = ? ";
        Object[] params = new Object[]{BigDecimal.valueOf(System.currentTimeMillis() - startTime), BigDecimal.valueOf(System.currentTimeMillis() - startTime), BigDecimal.valueOf(0L), 2, jobId};
        DbUtil.execute((Context)this.ctx, (String)updateSql, (Object[])params);
        ThreadLocalAttendanceLogInfo.remove();
    }

    @Override
    protected void beforeExecPlane(String ids) throws Exception {
        super.beforeExecPlane(ids);
        if (BackJobUtile.hasRunningJob(this.ctx, "com.kingdee.eas.hr.ats.ScheduleShiftFunction", "autoSchedule")) {
            String msg = MLUtile.getRes(AtsNounCommonResEnum.WaitForRuningMission, this.ctx);
            this.ctx.put((Object)"exception", (Object)msg);
            BackJobUtile.reStartJob(this.ctx, 5000L);
            AtsLog.getWSLog().error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public Set<String> rangSettingCheck(Collection<String> ids) {
        AtsSchedulePlanCollection schedulePlanes = AutoScheduleUtile.getPlanes(this.ctx, ids, false);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)schedulePlanes)) {
            this.errorMsg.add(MLUtile.getRes(AtsAttenceResEnum.FileWithoutItem, this.ctx));
            AtsLog.getWSLog().info((Object)"no entry in plan!");
            return new LinkedHashSet<String>(this.errorMsg);
        }
        List<AtsSchedulePlanInfo> plans = AtsCollectionUtile.toList(schedulePlanes, AtsSchedulePlanInfo.class);
        return this.rangSettingCheck(plans, schedulePlanes.get(0).getAtsSchedulePlanSet());
    }

    protected void doSchedulePlane(AtsSchedulePlanCollection schedulePlanes) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)schedulePlanes)) {
            return;
        }
        Iterator it = schedulePlanes.iterator();
        while (it.hasNext()) {
            AtsSchedulePlanInfo entry = (AtsSchedulePlanInfo)it.next();
            AtsSchedulePlanSetInfo setInfo = entry.getAtsSchedulePlanSet();
            List<ScheduleParamAnalysor> scheduleParamAnalysors = this.createScheduleParamAnalysor(entry.getConfig());
            for (ScheduleParamAnalysor scheduleParamAnalysor : scheduleParamAnalysors) {
                AutoScheduleAnalysor analysor = new AutoScheduleAnalysor(this.ctx);
                RangeSettingAnalysor rangeSettingAnalysor = this.createRangeSettingAnalysor(entry, this.ctx);
                rangeSettingAnalysor.setHrOrgUnit(setInfo.getHrOrgUnit());
                analysor.setRangeSettingAnalysor(rangeSettingAnalysor);
                scheduleParamAnalysor.setFrontDay(setInfo.getFrontDate());
                analysor.setScheduleParamAnalysor(scheduleParamAnalysor);
                analysor.setHrOrgUnitId(setInfo.getHrOrgUnit().getId().toString());
                analysor.analyze();
                if (!analysor.isSatisfyScheduleCondition()) continue;
                analysor.getAnalyzeResults().setHolidayProcessWay(EHolidayProcessWay.getEnum(Integer.valueOf(entry.getPostpone().getValue())));
                analysor.getAnalyzeResults().setHolidayArrange(HolidayArrange.getEnum(entry.getHolidayArrange().getValue()));
                analysor.getAnalyzeResults().setRestdayArrange(RestdayArrange.getEnum(entry.getRestdayArrange().getValue()));
                this.doSchedulePlaneByPage(this.ctx, analysor);
            }
        }
    }

    protected List<ScheduleParamAnalysor> createScheduleParamAnalysor(String paramConfig) {
        Class<ScheduleParamAnalysor> analysorClass;
        ArrayList<ScheduleParamAnalysor> scheduleParamAnalysors = new ArrayList<ScheduleParamAnalysor>();
        ScheduleParamAnalysor scheduleParamAnalysor = null;
        String analyClassName = ScheduleParamAnalysor.class.getName();
        JSONObject scheduleParams = JSON.parseObject((String)paramConfig);
        ArrayList<JSONObject> scheduleParamList = new ArrayList<JSONObject>();
        if (scheduleParams.containsKey((Object)"conditionItem")) {
            scheduleParamList.addAll(JSON.parseArray((String)scheduleParams.getString("conditionItem"), JSONObject.class));
        } else {
            scheduleParamList.add(scheduleParams);
        }
        if (((JSONObject)scheduleParamList.get(0)).containsKey((Object)"scheduleParamAnalysorClass")) {
            analyClassName = ((JSONObject)scheduleParamList.get(0)).getString("scheduleParamAnalysorClass");
        }
        if ((analysorClass = AtsCommonUtile.getClass(analyClassName, ScheduleParamAnalysor.class)) != null) {
            for (JSONObject scheduleParam : scheduleParamList) {
                scheduleParamAnalysor = AtsCommonUtile.getInstance(analysorClass);
                if (scheduleParamAnalysor == null) continue;
                scheduleParamAnalysor.setCtx(this.ctx);
                scheduleParamAnalysor.setTaskStartTime(this.getTaskTruncateDateTime());
                scheduleParamAnalysor.setIgnoreExecuteDate(this.ignoreExecuteDate);
                scheduleParamAnalysor.setScheduleParams(scheduleParam);
                scheduleParamAnalysors.add(scheduleParamAnalysor);
            }
        }
        return scheduleParamAnalysors;
    }

    protected void doSchedulePlaneByPage(Context ctx, AutoScheduleAnalysor analysor) {
        new OneFieldProcessor<String>(analysor.getScheduleTargetSql(), ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<String> rows) {
                ArrangeShiftManager arrangeShiftManager;
                AutoScheduleAnalysor analysor = (AutoScheduleAnalysor)this.outData;
                String arrangeManagerName = ArrangeShiftManager.class.getName();
                if (ArrangeShiftByUserDefined.class.isAssignableFrom(analysor.getAnalyzeResults().getClass())) {
                    arrangeManagerName = analysor.getScheduleParamAnalysor().getScheduleParams().getString("arrangeManageClass");
                }
                if ((arrangeShiftManager = AtsCommonUtile.getInstance(arrangeManagerName, ArrangeShiftManager.class)) != null) {
                    arrangeShiftManager.setCtx(ctx);
                    analysor.getAnalyzeResults().setAttenceGroups(analysor.getRangeSettingAnalysor().getAttenceGroups());
                    try {
                        arrangeShiftManager.arangeShift(rows, analysor.getAnalyzeResults());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AttendanceLogUtil.generateAttendanceLogInfo((AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get(), rows.size());
                    HashMap<String, PersonInfo> personMap = AttendanceLogUtil.generatePersonMap(ctx, rows);
                    BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
                    baseSaveShift.setHrOrgUnitId(analysor.getHrOrgUnitId());
                    baseSaveShift.setAttendanceLogInfo((AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get());
                    baseSaveShift.save(arrangeShiftManager.getArrangeResult());
                    ThreadLocalAttendanceLogInfo.set(baseSaveShift.getAttendanceLogInfo());
                    CoreBaseCollection attendanceLogEntryCollection = AttendanceLogUtil.generateAttendanceLogInfoEntry(ctx, (AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get(), personMap, baseSaveShift.inffectFileMap, baseSaveShift.scheduleOrderMap);
                    AttendanceLogUtil.updateAttendanceLogAndEntry(ctx, (AttendanceLogInfo)ThreadLocalAttendanceLogInfo.get(), attendanceLogEntryCollection);
                }
            }
        }.setOutData(analysor).setLength(200).process();
    }

    public boolean isIgnoreExecuteDate() {
        return this.ignoreExecuteDate;
    }

    public void setIgnoreExecuteDate(boolean ignoreExecuteDate) {
        this.ignoreExecuteDate = ignoreExecuteDate;
    }
}

