/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.autoSchedule;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByCopy;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByShift;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftByTurns;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.BaseScheduleParamAnalysor;
import java.util.Calendar;
import java.util.Date;

public class ScheduleParamAnalysor
extends BaseScheduleParamAnalysor {
    public ScheduleParamAnalysor() {
    }

    public ScheduleParamAnalysor(JSONObject scheduleParams, Calendar taskStartTime, boolean ignoreExecuteDate, int frontDay) {
        super(scheduleParams, taskStartTime, ignoreExecuteDate, frontDay);
    }

    @Override
    protected void completeShiftParam() {
        super.completeShiftParam();
        ArrangeShiftByShift arrangeShiftByShift = (ArrangeShiftByShift)this.getAnalyzeResults();
        arrangeShiftByShift.setAtsShiftId(this.scheduleParams.getString("atsShiftId"));
    }

    @Override
    protected void completeTurnShiftParam() {
        super.completeCopyParam();
        Date calStartDate = this.scheduleParams.getDate("calStartDate");
        ArrangeShiftByTurns arrangeShitByTurns = (ArrangeShiftByTurns)this.getAnalyzeResults();
        int dateDiff = AtsCommonUtile.dateDiff(calStartDate, arrangeShitByTurns.getBeginDate(), 6);
        arrangeShitByTurns.setTurnShiftId(this.scheduleParams.getString("turnShiftId"));
        int totalSegment = 0;
        if (this.scheduleParams.containsKey((Object)"totalSegment")) {
            totalSegment = this.scheduleParams.getIntValue("totalSegment");
        } else if (this.scheduleParams.containsKey((Object)"turnShiftId")) {
            totalSegment = AtsSqlUtile.getTotalCount(this.getCtx(), "select fid from T_HR_ATS_TurnShiftEntry where fgroupid='" + this.scheduleParams.getString("turnShiftId") + "'");
        }
        if (totalSegment != 0) {
            arrangeShitByTurns.setStartSegment(this.scheduleParams.getIntValue("startSegmnet") + dateDiff % totalSegment);
        } else {
            AtsLog.getWSLog().error((Object)("segment not satisfiy turnShift\uff0cscheduleParams=" + this.scheduleParams));
            this.setSatisfyScheduleCondition(false);
        }
    }

    @Override
    protected void completeCopyParam() {
        super.completeCopyParam();
        ArrangeShiftByCopy arrangeShiftByCopy = (ArrangeShiftByCopy)this.getAnalyzeResults();
        arrangeShiftByCopy.setSourceBeginDate(AtsCommonUtile.analyzeStartDate(this.taskStartTime.getTime(), this.scheduleParams.getString("copySourceDate")));
        arrangeShiftByCopy.setSourceEndDate(AtsCommonUtile.analyzeEndDate(this.taskStartTime.getTime(), this.scheduleParams.getString("copySourceDate")));
    }

    @Override
    public String toString() {
        return "ScheduleParamAnalysor [scheduleParams=" + this.scheduleParams + ", taskStartTime=" + this.taskStartTime + ", arrangeShiftClass=" + this.arrangeShiftClass + ", satisfyScheduleCondition=" + this.satisfyScheduleCondition + ", analyzeResults=" + this.analyzeResults + ", ignoreExecuteDate=" + this.ignoreExecuteDate + ", frontDay=" + this.frontDay + ", ctx=" + this.ctx + "]";
    }
}

