/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.matchSchedule;

import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.workShift.WorkShiftUtile;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.BaseMatchRuleAnalysor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OverTimeBillMatchRuleAnalysor
extends BaseMatchRuleAnalysor {
    protected boolean restRelateAtsShift;
    protected boolean holidayRelateAtsShift;
    protected boolean removeShifts = true;

    public OverTimeBillMatchRuleAnalysor() {
    }

    public OverTimeBillMatchRuleAnalysor(BaseMatchRuleAnalysor nextAnalysor) {
        super(nextAnalysor);
    }

    @Override
    public void doAnalyze() {
        super.doAnalyze();
        List<AtsOverTimeBillEntryInfo> billRecords = this.matchShiftEnv.getOTBillEntries();
        if (!AtsCollectionUtile.isEmpty(billRecords)) {
            this.matchShiftEnv.setOTBillEntries(new ArrayList<AtsOverTimeBillEntryInfo>(billRecords));
            billRecords = this.matchShiftEnv.getOTBillEntries();
            List<AtsShiftInfo> curAtsShifts = this.matchShiftEnv.getCurAtsShifts();
            for (int i = 0; i < billRecords.size(); ++i) {
                AtsOverTimeBillEntryInfo billInfo = billRecords.get(i);
                if (new RangeDate(billInfo.getStartTime(), billInfo.getEndTime()).retainAll(this.matchShiftEnv.getAttendRange()).isValid()) {
                    if (!this.removeShifts) continue;
                    this.removeShiftByBill(billRecords.get(i), curAtsShifts);
                    continue;
                }
                billRecords.remove(i);
                --i;
            }
            String attenDate = AtsCommonUtile.formateDate((Date)this.matchShiftEnv.getAttendRange().getLowBound());
            for (AtsOverTimeBillEntryInfo bill : billRecords) {
                if (!attenDate.equals(AtsCommonUtile.formateDate(bill.getOtDate()))) continue;
                this.updateDayType(bill.getOtType());
                break;
            }
        }
        if (!this.restRelateAtsShift && this.matchShiftEnv.getDayType() == DayTypeEnum.restDay) {
            this.matchShiftEnv.setRelateAtsShift(false);
        }
        if (!this.holidayRelateAtsShift && this.matchShiftEnv.getDayType() == DayTypeEnum.legalHoliday) {
            this.matchShiftEnv.setRelateAtsShift(false);
        }
    }

    private void removeShiftByBill(AtsOverTimeBillEntryInfo billInfo, List<AtsShiftInfo> curAtsShifts) {
        RangeDate billRange = new RangeDate(billInfo.getStartTime(), billInfo.getEndTime());
        Date attendDate = (Date)this.matchShiftEnv.getAttendRange().getLowBound();
        for (int i = 0; i < curAtsShifts.size(); ++i) {
            Date nextTime;
            Date preTime = WorkShiftUtile.buildShiftPreTime(curAtsShifts.get(i), attendDate);
            if (!billRange.retainAll(preTime, nextTime = WorkShiftUtile.buildShiftNextTime(curAtsShifts.get(i), attendDate)).isValid()) continue;
            curAtsShifts.remove(i);
            --i;
        }
    }

    private void updateDayType(OverTimeTypeInfo otType) {
        if (StringUtils.contains((String)otType.getName(), (String)MLUtile.getRes(AtsCommonResEnum.Workday, this.ctx))) {
            this.matchShiftEnv.setDayType(DayTypeEnum.workDay);
        }
        if (StringUtils.contains((String)otType.getName(), (String)MLUtile.getRes(AtsCommonResEnum.Holiday, this.ctx))) {
            this.matchShiftEnv.setDayType(DayTypeEnum.restDay);
        }
        if (StringUtils.contains((String)otType.getName(), (String)MLUtile.getRes(AtsNounCommonResEnum.Legal, this.ctx))) {
            this.matchShiftEnv.setDayType(DayTypeEnum.legalHoliday);
        }
    }

    public boolean isRestRelateAtsShift() {
        return this.restRelateAtsShift;
    }

    public void setRestRelateAtsShift(boolean restRelateAtsShift) {
        this.restRelateAtsShift = restRelateAtsShift;
    }

    public boolean isHolidayRelateAtsShift() {
        return this.holidayRelateAtsShift;
    }

    public void setHolidayRelateAtsShift(boolean holidayRelateAtsShift) {
        this.holidayRelateAtsShift = holidayRelateAtsShift;
    }

    public boolean isRemoveShifts() {
        return this.removeShifts;
    }

    public void setRemoveShifts(boolean removeShifts) {
        this.removeShifts = removeShifts;
    }

    public String toString() {
        return "OverTimeBillMatchRuleAnalysor [restRelateAtsShift=" + this.restRelateAtsShift + ", holidayRelateAtsShift=" + this.holidayRelateAtsShift + ", removeShifts=" + this.removeShifts + "]";
    }
}

