/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.arrange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsTurnShiftEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.AbstractArrangeShiftManager;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShiftByCopy;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShitByTurns;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.BaseArrangeShift;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.EArrangeWay;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.IArrangeShift;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ArrangeShiftManager
implements AbstractArrangeShiftManager {
    private Context ctx;
    private List<BaseArrangeShift> allScheduleShift = new ArrayList<BaseArrangeShift>();
    private Set<String> errorMsg = new HashSet<String>();

    public ArrangeShiftManager() {
    }

    public ArrangeShiftManager(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void completeScheduleShift(AttendanceGroupShiftCollection ScheduleShifts) {
    }

    @Override
    public void saveArrangeResult(AttendanceGroupShiftCollection arrangeResult) {
    }

    @Override
    public void arangeShift(Collection<String> personNums, IArrangeShift iArrangeShift) throws CloneNotSupportedException {
        if (AtsCollectionUtile.isEmpty(personNums)) {
            this.errorMsg.add(MLUtile.getRes(AtsFileResEnum.NotChooseEmployee, this.ctx));
            return;
        }
        List<List<String>> batchPersonNums = AtsCollectionUtile.group(personNums, AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> batchPersonIterator = batchPersonNums.iterator();
        block5: while (batchPersonIterator.hasNext()) {
            switch (iArrangeShift.getArrangeWay()) {
                case COPY: {
                    this.arrangShiftByCopy((Collection<String>)batchPersonIterator.next(), (ArrangeShiftByCopy)iArrangeShift);
                    continue block5;
                }
                case TURNS: {
                    this.arrangeByTurns((Collection<String>)batchPersonIterator.next(), (ArrangeShitByTurns)iArrangeShift);
                    continue block5;
                }
                case TURNS_POSTPINE: {
                    this.arrangeByPostoneTurns((Collection<String>)batchPersonIterator.next(), (ArrangeShitByTurns)iArrangeShift);
                    continue block5;
                }
            }
        }
        this.doArrange();
    }

    public void doArrange() {
        if (this.allScheduleShift.size() > 0) {
            Map<String, Map<String, Integer>> holidayMap = this.getRelateHoliday();
            for (BaseArrangeShift o : this.allScheduleShift) {
                ArrangeShiftByCopy copy;
                o.setHolidayMap(holidayMap.get(o.getPersonInfo().getNumber()));
                if (o.getClass() == ArrangeShiftByCopy.class && (copy = (ArrangeShiftByCopy)o).getSource() != null && copy.getSource().getNumber() != null) {
                    copy.setSourceHolidayMap(holidayMap.get(copy.getSource().getNumber()));
                }
                o.arrangeShift();
                this.errorMsg.addAll(o.getErrorMsg());
            }
        }
    }

    private Map<String, Map<String, Integer>> getRelateHoliday() {
        HashSet<String> personNums = new HashSet<String>();
        Date minDate = null;
        Date maxDate = null;
        String WorkCalendar2 = "";
        for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
            personNums.add(arrangeShift.getPersonInfo().getNumber());
            WorkCalendar2 = arrangeShift.getWorkCalendarId();
            if (minDate == null) {
                minDate = arrangeShift.getBeginDate();
                maxDate = arrangeShift.getEndDate();
            }
            if (minDate != null && minDate.after(arrangeShift.getBeginDate())) {
                minDate = arrangeShift.getBeginDate();
            }
            if (maxDate != null && maxDate.before(arrangeShift.getEndDate())) {
                maxDate = arrangeShift.getEndDate();
            }
            if (arrangeShift.getArrangeWay() != EArrangeWay.COPY) continue;
            ArrangeShiftByCopy copy = (ArrangeShiftByCopy)arrangeShift;
            if (minDate != null && minDate.after(copy.getSourceBeginDate())) {
                minDate = copy.getSourceBeginDate();
            }
            if (maxDate != null && maxDate.before(copy.getSourceEndDate())) {
                maxDate = copy.getSourceEndDate();
            }
            if (copy.getSource() == null || copy.getSource().getNumber() == null) continue;
            personNums.add(copy.getSource().getNumber());
        }
        return ArrangeShiftUtile.getPersonHoliday(this.ctx, WorkCalendar2, personNums, AtsCommonUtile.getDateFormat().format(minDate), AtsCommonUtile.getDateFormat().format(maxDate));
    }

    @Override
    public List<JSONObject> showShiftResult() {
        HashMap<String, JSONArray> shiftResult = new HashMap<String, JSONArray>(this.allScheduleShift.size());
        int noPersonNumCount = 1;
        if (this.allScheduleShift.size() > 0) {
            for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
                String personNum;
                String string = personNum = arrangeShift.getPersonInfo() != null ? arrangeShift.getPersonInfo().getNumber() : "";
                if (StringUtils.isNotEmpty((String)personNum)) {
                    if (shiftResult.get(personNum) != null) {
                        ((JSONArray)shiftResult.get(personNum)).addAll((Collection)arrangeShift.showArrangeResult());
                        continue;
                    }
                    shiftResult.put(personNum, arrangeShift.showArrangeResult());
                    continue;
                }
                shiftResult.put("noNumS" + noPersonNumCount, arrangeShift.showArrangeResult());
                ++noPersonNumCount;
            }
        }
        ArrayList<JSONObject> results = new ArrayList<JSONObject>(shiftResult.size());
        for (String person : shiftResult.keySet()) {
            JSONObject personSchedule = new JSONObject(2);
            personSchedule.put("personNum", (Object)person);
            personSchedule.put("scheduleData", shiftResult.get(person));
            results.add(personSchedule);
        }
        return results;
    }

    public AttendanceGroupShiftCollection getArrangeResult() {
        AttendanceGroupShiftCollection returnData = new AttendanceGroupShiftCollection();
        if (this.allScheduleShift.size() > 0) {
            for (BaseArrangeShift arrangeShift : this.allScheduleShift) {
                returnData.addCollection(arrangeShift.getArrangeResult());
            }
        }
        return returnData;
    }

    public void arrangeByTurns(Collection<String> personNums, ArrangeShitByTurns arrangeShitByTurns) throws CloneNotSupportedException {
        Map<Integer, AtsTurnShiftEntryInfo> turnShiftEntry = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, arrangeShitByTurns.getTurnShiftId());
        for (String personNum : personNums) {
            ArrangeShitByTurns temp = (ArrangeShitByTurns)arrangeShitByTurns.clone();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setNumber(personNum);
            temp.setPersonInfo((DataBaseInfo)personInfo);
            temp.setTurnShiftId(arrangeShitByTurns.getTurnShiftId());
            temp.setTurnShiftEntrys(turnShiftEntry);
            temp.setWorkCalendarId(arrangeShitByTurns.getWorkCalendarId());
            this.allScheduleShift.add(temp);
        }
    }

    public void arrangeByPostoneTurns(Collection<String> personNums, ArrangeShitByTurns arrangeShitByTurns) throws CloneNotSupportedException {
        Map<String, JSONObject> personNumToLatestSheduleTurn = ArrangeShiftUtile.getshiftTurnFromSchedule(this.ctx, personNums, arrangeShitByTurns.getEndDate());
        HashSet<String> turnShiftIds = new HashSet<String>();
        for (JSONObject segmentAndTurnId : personNumToLatestSheduleTurn.values()) {
            if (!StringUtils.isNotEmpty((String)segmentAndTurnId.getString("turnShiftId"))) continue;
            turnShiftIds.add(segmentAndTurnId.getString("turnShiftId"));
        }
        if (AtsCollectionUtile.isEmpty(personNumToLatestSheduleTurn)) {
            this.errorMsg.add(MLUtile.getRes(AtsScheduleShiftResEnum.ForbidShiftLateForDate, this.ctx));
            return;
        }
        Map<String, Map<Integer, AtsTurnShiftEntryInfo>> turnShiftEntrys = ArrangeShiftUtile.getTurnShiftEntrys(this.ctx, turnShiftIds);
        for (String personNum : personNums) {
            if (personNumToLatestSheduleTurn.get(personNum) == null) continue;
            String turnShiftId = personNumToLatestSheduleTurn.get(personNum).getString("turnShiftId");
            if (StringUtils.isNotEmpty((String)personNum) && turnShiftEntrys.get(turnShiftId) != null) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                ArrangeShitByTurns copy = (ArrangeShitByTurns)arrangeShitByTurns.clone();
                copy.setPersonInfo((DataBaseInfo)personInfo);
                Date beignDate = personNumToLatestSheduleTurn.get(personNum).getDate("attendDate");
                copy.setBeginDate(AtsDateUtils.getNextDay(beignDate));
                copy.setTurnShiftEntrys(turnShiftEntrys.get(turnShiftId));
                copy.setTurnShiftId(turnShiftId);
                copy.setStartSegment(personNumToLatestSheduleTurn.get(personNum).getIntValue("currentSegment") + 1);
                this.allScheduleShift.add(copy);
                continue;
            }
            this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.ScheduleShiftOrder6, this.ctx, personNum));
        }
    }

    public void arrangShiftByCopy(Collection<String> personNums, ArrangeShiftByCopy arrangeShiftByCopy) throws CloneNotSupportedException {
        boolean isCopySpecificMan = arrangeShiftByCopy.getSource() != null && !StringUtils.isEmpty((String)arrangeShiftByCopy.getSource().getId().toString());
        Set<String> source = Collections.singleton(arrangeShiftByCopy.getSource().getNumber());
        this.updateCopySourceEndDate(arrangeShiftByCopy);
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"defaultShift.*", "defaultShift.items.*"});
        Map<String, Map<String, AttendanceGroupShiftInfo>> scheduleShifts = ArrangeShiftUtile.getScheduleShifts(this.ctx, source, AtsCommonUtile.getDateFormat().format(arrangeShiftByCopy.getSourceBeginDate()), AtsCommonUtile.getDateFormat().format(arrangeShiftByCopy.getSourceEndDate()), AtsViewUtile.getViewByFilter("hrOrgUnit.id", (Object)arrangeShiftByCopy.getHrOrgUnitIdD(), evi));
        if (AtsCollectionUtile.isEmpty(scheduleShifts)) {
            this.errorMsg.add(MLUtile.getRes(AtsShiftResEnum.NoShiftFromCopySource, this.ctx));
            return;
        }
        HashSet<String> needSearchPre7DayPerson = this.updateLatestSourceSchedule(scheduleShifts, arrangeShiftByCopy);
        needSearchPre7DayPerson = needSearchPre7DayPerson.size() == 0 ? null : (isCopySpecificMan ? new HashSet<String>(personNums) : needSearchPre7DayPerson);
        Map<Object, Object> latest7daySchedule = new HashMap();
        if (!AtsCollectionUtile.isEmpty(needSearchPre7DayPerson)) {
            latest7daySchedule = this.getAheadSchedule(arrangeShiftByCopy, needSearchPre7DayPerson);
        }
        for (String personNum : personNums) {
            Map<String, AttendanceGroupShiftInfo> sourceSchedule = scheduleShifts.get(isCopySpecificMan ? arrangeShiftByCopy.getSource().getNumber() : personNum);
            if (sourceSchedule != null) {
                ArrangeShiftByCopy arrangeShifTemp = (ArrangeShiftByCopy)arrangeShiftByCopy.clone();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                arrangeShifTemp.setPersonInfo((DataBaseInfo)personInfo);
                arrangeShifTemp.setSourceScheduleShifts(sourceSchedule);
                if (latest7daySchedule.get(personNum) != null) {
                    arrangeShifTemp.setLatestSchedule((AttendanceGroupShiftInfo)latest7daySchedule.get(personNum));
                }
                this.allScheduleShift.add(arrangeShifTemp);
                continue;
            }
            this.errorMsg.add(MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.CopyShiftFailWithoutShift, this.ctx, personNum));
        }
    }

    private boolean updateSourcePersonInfo(ArrangeShiftByCopy arrangeShiftByCopy) {
        try {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)this.ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(arrangeShiftByCopy.getSource().getId().toString()));
            if (personInfo == null || StringUtils.isEmpty((String)personInfo.getNumber())) {
                this.errorMsg.add(MLUtile.getRes(AtsHolidayResEnum.NoEmployeeAndCheck, this.ctx));
                return false;
            }
            arrangeShiftByCopy.setSource(personInfo);
        }
        catch (Exception e) {
            this.errorMsg.add(MLUtile.getRes(AtsCommonResEnum.ServerError, this.ctx));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateCopySourceEndDate(ArrangeShiftByCopy arrangeShiftByCopy) {
        Calendar calendar;
        long scheduleInterval = arrangeShiftByCopy.getEndDate().getTime() - arrangeShiftByCopy.getBeginDate().getTime();
        long sourceScheduleInterval = arrangeShiftByCopy.getSourceEndDate().getTime() - arrangeShiftByCopy.getSourceBeginDate().getTime();
        long absoutDiff = Math.abs(sourceScheduleInterval - scheduleInterval);
        if (scheduleInterval < sourceScheduleInterval) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(arrangeShiftByCopy.getSourceEndDate().getTime() - absoutDiff);
            arrangeShiftByCopy.setSourceEndDate(calendar.getTime());
        }
        if (scheduleInterval > sourceScheduleInterval) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(arrangeShiftByCopy.getEndDate().getTime() - absoutDiff);
            arrangeShiftByCopy.setEndDate(calendar.getTime());
        }
    }

    private Set<String> updateLatestSourceSchedule(Map<String, Map<String, AttendanceGroupShiftInfo>> scheduleShifts, ArrangeShiftByCopy arrangeShiftByCopy) {
        if (!arrangeShiftByCopy.isHolidayWithWorkDayUnshift()) {
            return new HashSet<String>(0);
        }
        HashSet<String> personNums = new HashSet<String>();
        for (String personNum : scheduleShifts.keySet()) {
            boolean hasShift = false;
            boolean hasHolidayNoShift = false;
            for (AttendanceGroupShiftInfo currentSchedule : scheduleShifts.get(personNum).values()) {
                if (currentSchedule.getDefaultShift() != null) {
                    hasShift = true;
                }
                if (currentSchedule.getDayType() != DayTypeEnum.legalHoliday || currentSchedule.getDefaultShift() != null) continue;
                hasHolidayNoShift = true;
            }
            if (!hasHolidayNoShift || hasShift) continue;
            personNums.add(personNum);
        }
        return personNums;
    }

    private Map<String, AttendanceGroupShiftInfo> getAheadSchedule(ArrangeShiftByCopy arrangeShiftByCopy, Set<String> personNums) {
        String endDate = AtsCommonUtile.getPreDayStr(arrangeShiftByCopy.getBeginDate());
        String beginDate = AtsCommonUtile.dateAddStr(endDate, 5, -7);
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"defaultShift.*"});
        AtsViewUtile.getViewByFilter("hrOrgUnit", (Object)arrangeShiftByCopy.getHrOrgUnitIdD(), evi);
        AtsViewUtile.getViewByFilter("defaultShift", null, CompareType.NOTEQUALS, evi);
        Map<String, Map<String, AttendanceGroupShiftInfo>> latest7daySchedule = ArrangeShiftUtile.getScheduleShifts(this.ctx, personNums, beginDate, endDate, evi);
        HashMap<String, AttendanceGroupShiftInfo> personLatestSchedule = new HashMap<String, AttendanceGroupShiftInfo>(latest7daySchedule.size());
        AttendanceGroupShiftInfo currentSchedule = null;
        Iterator<String> it = latest7daySchedule.keySet().iterator();
        while (it.hasNext()) {
            currentSchedule = null;
            String personNum = it.next();
            for (AttendanceGroupShiftInfo tempSchedule : latest7daySchedule.get(personNum).values()) {
                if (currentSchedule != null && !tempSchedule.getAttendDate().after(currentSchedule.getAttendDate())) continue;
                currentSchedule = tempSchedule;
            }
            personLatestSchedule.put(personNum, currentSchedule);
        }
        return personLatestSchedule;
    }

    public List<BaseArrangeShift> getAllScheduleShift() {
        return this.allScheduleShift;
    }

    public void setAllScheduleShift(List<BaseArrangeShift> allScheduleShift) {
        this.allScheduleShift = allScheduleShift;
    }

    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }
}

