/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.save;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsTurnShiftInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftFactory;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.IScheduleShift;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShiftGroup.save.BaseSaveShift;
import com.kingdee.eas.hr.ats.workShiftGroup.save.ISaveShift;
import com.kingdee.eas.hr.ats.workShiftGroup.save.SaveShiftUtile;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class GroupBaseSaveShift
implements ISaveShift {
    private Context ctx;
    IScheduleShift iScheduleShift;
    private String userInfo;
    private String CtrlUnitInfo;
    private String hrOrgUnitId;
    private Date minDate;
    private Date maxDate;
    private int defaultAdvcValue = 1;
    private SchlShiftSrcTypeEnum defaultScheduleSrcType = SchlShiftSrcTypeEnum.sysSchlShift;
    private AttendanceGroupShiftCollection toBeSavedShift;
    private Map<String, AttendanceGroupShiftInfo> existsSchedules;
    private RangeMap<Date, AttendanceGroupShiftInfo> scheduleShiftFromAttHis;
    CoreBaseCollection insertColl = new CoreBaseCollection();
    CoreBaseCollection updateColl = new CoreBaseCollection();
    List<Object[]> updateShiftParams = new ArrayList<Object[]>();
    List<Object[]> updateShiftItemParams = new ArrayList<Object[]>();
    List<Object[]> deleteShiftItemParams = new ArrayList<Object[]>();

    public GroupBaseSaveShift() {
    }

    public GroupBaseSaveShift(Context ctx) {
        this.ctx = ctx;
        try {
            this.iScheduleShift = ScheduleShiftFactory.getLocalInstance(this.ctx);
            UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
            this.userInfo = currentUserInfo != null && currentUserInfo.getId() != null ? currentUserInfo.getId().toString() : "";
            CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
            this.CtrlUnitInfo = cu != null && cu.getId() != null ? cu.getId().toString() : "";
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static BaseSaveShift getManualInstance() {
        BaseSaveShift baseSaveShift = new BaseSaveShift();
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        return baseSaveShift;
    }

    public static BaseSaveShift getManualInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setDefaultAdvcValue(2);
        baseSaveShift.setDefaultScheduleSrcType(SchlShiftSrcTypeEnum.manSchlShift);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        return baseSaveShift;
    }

    public static BaseSaveShift getAutoInstance() {
        return new BaseSaveShift();
    }

    public static BaseSaveShift getAutoInstance(Context ctx, String hrOrgUnitId) {
        BaseSaveShift baseSaveShift = new BaseSaveShift(ctx);
        baseSaveShift.setHrOrgUnitId(hrOrgUnitId);
        return baseSaveShift;
    }

    protected void initDate(AttendanceGroupShiftCollection toBeSavedShift) {
        this.minDate = this.maxDate = toBeSavedShift.get(0).getAttendDate();
        for (int i = 0; i < toBeSavedShift.size(); ++i) {
            if (toBeSavedShift.get(i).getAttendDate().before(this.minDate)) {
                this.minDate = toBeSavedShift.get(i).getAttendDate();
            }
            if (!toBeSavedShift.get(i).getAttendDate().after(this.maxDate)) continue;
            this.maxDate = toBeSavedShift.get(i).getAttendDate();
        }
    }

    public void save(Map<String, List<JSONObject>> schedules) {
        List<List<String>> groupedPersonNums = AtsCollectionUtile.group(schedules.keySet(), AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> personNumIterator = groupedPersonNums.iterator();
        this.toBeSavedShift = new AttendanceGroupShiftCollection();
        while (personNumIterator.hasNext()) {
            ArrayList<JSONObject> relateSchedules = new ArrayList<JSONObject>();
            List<String> personNums = personNumIterator.next();
            for (String personNum : personNums) {
                relateSchedules.addAll((Collection<JSONObject>)schedules.get(personNum));
            }
            List<String> realteShiftName = SaveShiftUtile.getShiftNameFromJson(relateSchedules);
            Map<String, AtsShiftInfo> atsShifts = SaveShiftUtile.getAtsShiftByNames(this.ctx, new HashSet<String>(realteShiftName));
            for (String personNum : personNums) {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setNumber(personNum);
                this.toBeSavedShift.addCollection(GroupBaseSaveShift.resolveToScheduleShift(personInfo, schedules.get(personNum), atsShifts));
            }
        }
        this.save(this.toBeSavedShift);
    }

    public static AttendanceGroupShiftCollection resolveToScheduleShift(PersonInfo personInfo, List<JSONObject> schedules, Map<String, AtsShiftInfo> atsShifts) {
        if (AtsCollectionUtile.isEmpty(schedules)) {
            return null;
        }
        AttendanceGroupShiftCollection scheduleResult = new AttendanceGroupShiftCollection();
        for (JSONObject schedule : schedules) {
            AttendanceGroupShiftInfo scheduleShift = new AttendanceGroupShiftInfo();
            scheduleShift.setProposer(personInfo);
            scheduleShift.setAdvcValue(2);
            if (!schedule.containsKey((Object)"attendDate")) continue;
            scheduleShift.setAttendDate(schedule.getDate("attendDate"));
            if (!schedule.containsKey((Object)"dayType")) continue;
            scheduleShift.setDayType(DayTypeEnum.getEnum(schedule.getIntValue("dayType")));
            if (schedule.containsKey((Object)"shiftName") && StringUtils.isNotEmpty((String)schedule.getString("shiftName"))) {
                scheduleShift.setDefaultShift(atsShifts.get(schedule.getString("shiftName")));
            }
            if (schedule.containsKey((Object)"segment")) {
                scheduleShift.setShiftByTurnSegment(schedule.getIntValue("segment"));
            }
            if (schedule.containsKey((Object)"turnShiftId") && StringUtils.isNotEmpty((String)schedule.getString("turnShiftId"))) {
                AtsTurnShiftInfo turnShiftInfo = new AtsTurnShiftInfo();
                turnShiftInfo.setId(BOSUuid.read((String)schedule.getString("turnShiftId")));
                scheduleShift.setTurnShift(turnShiftInfo);
            }
            scheduleResult.add(scheduleShift);
        }
        return scheduleResult;
    }

    public void save(AttendanceGroupShiftCollection toBeSavedShift) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)toBeSavedShift)) {
            return;
        }
        this.toBeSavedShift = toBeSavedShift;
        this.initDate(toBeSavedShift);
        List<List<Object>> scheduleGroup = AtsCollectionUtile.group((IObjectCollection)toBeSavedShift, AtsConstants.SIZE_COMMON_BATCH);
        for (List<Object> groupTemp : scheduleGroup) {
            ArrayList<AttendanceGroupShiftInfo> groupedSchedule = new ArrayList<AttendanceGroupShiftInfo>(groupTemp.size());
            for (Object o : groupTemp) {
                groupedSchedule.add((AttendanceGroupShiftInfo)o);
            }
            this.doSave(groupedSchedule);
        }
    }

    public static Map<String, AttendanceGroupShiftInfo> getExistsSchedule(Context ctx, Set<String> personNums, Date begin, Date end) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "attenceGroup.id", "attendDate"});
        AtsViewUtile.getViewByFilter("attenceGroup.id", personNums, CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("attendDate", end, CompareType.LESS_EQUALS, evi);
        AtsViewUtile.getViewByFilter("attendDate", begin, CompareType.GREATER_EQUALS, evi);
        AttendanceGroupShiftCollection shiftCollection = null;
        try {
            shiftCollection = AttendanceGroupShiftFactory.getLocalInstance(ctx).getAttendanceGroupShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)shiftCollection)) {
            return new HashMap<String, AttendanceGroupShiftInfo>();
        }
        HashMap<String, AttendanceGroupShiftInfo> existSchedule = new HashMap<String, AttendanceGroupShiftInfo>();
        AttendanceGroupShiftInfo shiftTemp = null;
        for (int i = 0; i < shiftCollection.size(); ++i) {
            shiftTemp = shiftCollection.get(i);
            String number = shiftTemp.getProposer().getNumber();
            existSchedule.put(number + "_" + AtsCommonUtile.getDateFormat().format(shiftTemp.getAttendDate()), shiftTemp);
        }
        return existSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(List<AttendanceGroupShiftInfo> schedules) {
        HashSet<String> personNums = new HashSet<String>(AtsCollectionUtile.map(schedules, new AtsMapFn<AttendanceGroupShiftInfo, String>(){

            @Override
            public String map(AttendanceGroupShiftInfo t) {
                return t.getAttenceGroup().getId().toString();
            }
        }));
        this.existsSchedules = GroupBaseSaveShift.getExistsSchedule(this.ctx, personNums, this.minDate, this.maxDate);
        this.completeScheduleShift(schedules);
        try {
            this.saveOrUpdateEntity();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            this.resetSaveOrUpdateCollection();
        }
    }

    protected void resetSaveOrUpdateCollection() {
        this.insertColl.clear();
        this.updateColl.clear();
        this.updateShiftParams.clear();
        this.updateShiftItemParams.clear();
        this.deleteShiftItemParams.clear();
    }

    protected void save() {
    }

    protected void completeScheduleShift(List<AttendanceGroupShiftInfo> schedules) {
        for (int i = 0; i < schedules.size(); ++i) {
            AttendanceGroupShiftInfo schedule = schedules.get(i);
            AttendanceGroupShiftInfo defaultSchedle = this.scheduleShiftFromAttHis.get(schedule.getAttendDate());
            String personNum = schedule.getProposer().getNumber();
            AttendanceGroupShiftInfo existsSchedule = this.existsSchedules.get(personNum + "_" + AtsCommonUtile.getDateFormat().format(schedule.getAttendDate()));
            if (existsSchedule != null) {
                schedule.setId(existsSchedule.getId());
                schedule.setProposer(existsSchedule.getProposer());
                schedule.setAdminOrgUnit(defaultSchedle.getAdminOrgUnit());
                schedule.setHrOrgUnit(defaultSchedle.getHrOrgUnit());
                schedule.setPosition(defaultSchedle.getPosition());
                schedule.setOtCompens(defaultSchedle.getOtCompens());
                this.updateColl.add((CoreBaseInfo)schedule);
            } else {
                BeanUtils.copyProperties((Object)defaultSchedle, (Object)schedule, (String[])new String[]{"attendDate", "dayType", "defaultShift", "shiftByTurnSegment", "atsTurnShift", "advcValue", "srcType"});
                this.insertColl.add((CoreBaseInfo)schedule);
            }
            if (schedule.getAdvcValue() == 0) {
                schedule.setAdvcValue(this.defaultAdvcValue);
            }
            if (schedule.getSrcType() == null) {
                schedule.setSrcType(this.defaultScheduleSrcType);
            }
            schedule.getItems().clear();
            this.setShiftRealteParam(schedule, defaultSchedle);
            if (existsSchedule == null) continue;
            this.buildUpdateParam(schedule);
        }
    }

    protected void buildUpdateParam(AttendanceGroupShiftInfo schedule) {
        Object[] updateShiftParamsArr = GroupBaseSaveShift.getScheduleShiftParams(schedule, this.userInfo, this.CtrlUnitInfo);
        this.updateShiftParams.add(updateShiftParamsArr);
        if (schedule.getDefaultShift() != null && !AtsCollectionUtile.isEmpty((IObjectCollection)schedule.getDefaultShift().getItems())) {
            List<Object[]> updateShiftItemParamsArr = GroupBaseSaveShift.getScheduleShiftItemParams(schedule);
            Object[] deleteShiftItemParamsArr = new Object[]{schedule.getId().toString()};
            this.updateShiftItemParams.addAll(updateShiftItemParamsArr);
            this.deleteShiftItemParams.add(deleteShiftItemParamsArr);
        }
    }

    public static String correctId(DataBaseInfo dataBaseInfo) {
        if (dataBaseInfo == null || dataBaseInfo.getId() == null) {
            return "";
        }
        return dataBaseInfo.getId().toString();
    }

    public static Object[] getScheduleShiftParams(AttendanceGroupShiftInfo AttendanceGroupShiftInfo2, String currentUserInfo, String cu) {
        Object[] objArr = new Object[22];
        if (AttendanceGroupShiftInfo2 != null) {
            objArr[0] = AttendanceGroupShiftInfo2.getDayType() != null ? Integer.valueOf(AttendanceGroupShiftInfo2.getDayType().getValue()) : null;
            objArr[1] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getDefaultShift());
            objArr[4] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getCardRule());
            objArr[5] = AttendanceGroupShiftInfo2.getSrcType() != null ? AttendanceGroupShiftInfo2.getSrcType().getValue() : null;
            objArr[6] = AttendanceGroupShiftInfo2.getAdvcValue();
            objArr[7] = AttendanceGroupShiftInfo2.getStandardHour() != null ? AttendanceGroupShiftInfo2.getStandardHour() : Integer.valueOf(0);
            objArr[8] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getProposer());
            objArr[9] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getPosition());
            objArr[10] = currentUserInfo;
            objArr[12] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getAdminOrgUnit());
            objArr[14] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getShiftType());
            objArr[15] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getOtCompens());
            objArr[16] = AttendanceGroupShiftInfo2.getAttendDate();
            objArr[17] = cu;
            objArr[18] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getHrOrgUnit());
            objArr[19] = AttendanceGroupShiftInfo2.getShiftByTurnSegment() == 0 ? "" : Integer.valueOf(AttendanceGroupShiftInfo2.getShiftByTurnSegment());
            objArr[20] = GroupBaseSaveShift.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getTurnShift());
            objArr[21] = GroupBaseSaveShift.correctId(AttendanceGroupShiftInfo2);
        }
        return objArr;
    }

    protected void setShiftRealteParam(AttendanceGroupShiftInfo schedule, AttendanceGroupShiftInfo defaultSchedle) {
        AtsShiftInfo shift = schedule.getDefaultShift();
        if (shift == null) {
            schedule.setShiftType(null);
            schedule.setStandardHour(defaultSchedle.getStandardHour());
            schedule.setCardRule(defaultSchedle.getCardRule());
            return;
        }
        schedule.setCardRule(shift.getCardRule());
        schedule.setStandardHour(shift.getStandardHour());
        schedule.setOtCompens(shift.getOtCompens());
        schedule.setShiftType(shift.getShiftType());
        schedule.setIsElastic(shift.isIsElastic());
        schedule.setElasticType(shift.getElasticType());
        schedule.setElasticDirection(shift.getElasticDirection());
        schedule.setElasticValue(shift.getElasticValue());
    }

    public void saveOrUpdateEntity() throws BOSException, EASBizException {
        if (!this.insertColl.isEmpty()) {
            this.iScheduleShift.addnew(this.insertColl);
        }
        if (!this.updateColl.isEmpty()) {
            StringBuffer deleteShiftItemSql = new StringBuffer("");
            deleteShiftItemSql.append(" delete from t_hr_ats_scheduleshiftItem where fgroupId = ?");
            DbUtil.executeBatch((Context)this.ctx, (String)deleteShiftItemSql.toString(), this.deleteShiftItemParams);
            StringBuffer updateShiftSql = new StringBuffer("");
            updateShiftSql.append(" update T_ATS_AttendanceGroupShift set fdayType = ?,FDefaultShiftID = ?,FAttendFileID = ?,FAttendPolicyID = ?,\n");
            updateShiftSql.append(" FCardRuleID = ?,FSrcType = ?,FAdvcValue = ?,FStandardHour = ?,FProposerId = ?,FPositionId = ?,");
            updateShiftSql.append(" FCreatorId = ?,FCreateTime = Now(),FLastUpdateUserId = ?,FLastUpdateTime = Now(),FAdminOrgUnitId = ?,FHldPlcSetID = ?,");
            updateShiftSql.append(" FShiftTypeID = ?,FOtCompensID = ?,FAttendDate = ?,FControlUnitID = ?,FHrOrgUnitID = ?,FshiftByTurnSegment = ?,FatsTurnShift = ? where Fid = ?");
            DbUtil.executeBatch((Context)this.ctx, (String)updateShiftSql.toString(), this.updateShiftParams);
        }
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        List<Object> updateParamList = new ArrayList();
        if (this.insertColl != null && this.insertColl.size() > 0) {
            AttendanceGroupShiftInfo schedule2 = null;
            AtsShiftInfo atsShiftInfo = null;
            for (AttendanceGroupShiftInfo schedule2 : this.insertColl) {
                atsShiftInfo = schedule2.getDefaultShift();
                if (atsShiftInfo == null || AtsCollectionUtile.isEmpty((IObjectCollection)atsShiftInfo.getItems())) continue;
                insertParamList.addAll(GroupBaseSaveShift.getScheduleShiftItemParams(schedule2));
            }
        }
        if (this.updateColl != null && this.updateColl.size() > 0) {
            updateParamList = this.updateShiftItemParams;
        }
        StringBuffer insertShiftItemSql = new StringBuffer("");
        insertShiftItemSql.append(" insert into T_ATS_AttendanceGroupShiftItem(Fid,FShiftItemID,FSegment, FPreTime,FPreFloatAdjusted,FPreUnit,FPreIsPunchCard, FNextTime, FNextFloatAdjusted, FNextUnit, FNextIsPunchCard, FSegmentInRest, FAttendanceType,");
        insertShiftItemSql.append(" FPreTimeDayType, FNextTimeDayType, FPreDateTime, FNextDateTime, FRestPreTime, FRestNextTime, FRestPreDateTime, FRestNextDateTime,FGroupID)");
        insertShiftItemSql.append(" values(newbosid('4ECBA044'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (insertParamList != null && insertParamList.size() > 0) {
            DbUtil.executeBatch((Context)this.ctx, (String)insertShiftItemSql.toString(), insertParamList);
        }
        if (updateParamList != null && updateParamList.size() > 0) {
            DbUtil.executeBatch((Context)this.ctx, (String)insertShiftItemSql.toString(), updateParamList);
        }
    }

    public static List<Object[]> getScheduleShiftItemParams(AttendanceGroupShiftInfo AttendanceGroupShiftInfo2) {
        ArrayList<Object[]> shiftItemList = new ArrayList<Object[]>();
        AtsShiftItemCollection atsShiftItemCollection = AttendanceGroupShiftInfo2.getDefaultShift().getItems();
        Date atdt = AttendanceGroupShiftInfo2.getAttendDate();
        String atdtString = AtsDateUtils.dateShortToString(atdt);
        Calendar atdtNextDayCal = Calendar.getInstance();
        atdtNextDayCal.setTimeInMillis(atdt.getTime() + 86400000L);
        String atdtNextDayString = GroupBaseSaveShift.dateShortToString(atdtNextDayCal.getTime());
        Calendar atdtPreDayCal = Calendar.getInstance();
        atdtPreDayCal.setTimeInMillis(atdt.getTime() - 86400000L);
        String atdtPreDayString = GroupBaseSaveShift.dateShortToString(atdtPreDayCal.getTime());
        String preTimeStr = "";
        String preDateTimeStr = "";
        String nextTimeStr = "";
        String nextDateTimeStr = "";
        String restPreTime = "";
        for (int j = 0; j < atsShiftItemCollection.size(); ++j) {
            Object[] insertShiftItemObjArr = new Object[21];
            AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(j);
            preTimeStr = atsShiftItemInfo.getPreTime();
            int preTimeValue = atsShiftItemInfo.getPreTimeDayType().getValue();
            preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString, preTimeStr);
            int nextTimeValue = atsShiftItemInfo.getNextTimeDayType().getValue();
            nextTimeStr = atsShiftItemInfo.getNextTime();
            nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, atdtString, atdtPreDayString, atdtNextDayString, nextTimeStr);
            restPreTime = atsShiftItemInfo.getRestPreTime();
            String restNextTime = atsShiftItemInfo.getRestNextTime();
            String restPreDateTimeStr = "";
            String restNextDateTimeStr = "";
            if (!StringUtils.isEmpty((String)restPreTime) && !StringUtils.isEmpty((String)restNextTime)) {
                restPreDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restPreTime");
                restNextDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restNextTime");
            }
            insertShiftItemObjArr[0] = atsShiftItemInfo != null && atsShiftItemInfo.getId() != null ? atsShiftItemInfo.getId().toString() : "";
            insertShiftItemObjArr[1] = atsShiftItemInfo.getSegment() == null ? "" : atsShiftItemInfo.getSegment().getValue();
            insertShiftItemObjArr[2] = atsShiftItemInfo.getPreTime() == null ? "" : atsShiftItemInfo.getPreTime();
            insertShiftItemObjArr[3] = atsShiftItemInfo.getPreFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getPreFloatAdjusted().floatValue();
            insertShiftItemObjArr[4] = atsShiftItemInfo.getPreUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getPreUnit().getValue());
            insertShiftItemObjArr[5] = atsShiftItemInfo.getPreIsPunchCard() == null ? "" : atsShiftItemInfo.getPreIsPunchCard().getValue();
            insertShiftItemObjArr[6] = atsShiftItemInfo.getNextTime() == null ? "" : atsShiftItemInfo.getNextTime();
            insertShiftItemObjArr[7] = atsShiftItemInfo.getNextFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getNextFloatAdjusted().floatValue();
            insertShiftItemObjArr[8] = atsShiftItemInfo.getNextUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getNextUnit().getValue());
            insertShiftItemObjArr[9] = atsShiftItemInfo.getNextIsPunchCard() == null ? "" : atsShiftItemInfo.getNextIsPunchCard().getValue();
            insertShiftItemObjArr[10] = atsShiftItemInfo.getSegmentInRest() == null ? Integer.valueOf(0) : atsShiftItemInfo.getSegmentInRest();
            insertShiftItemObjArr[11] = atsShiftItemInfo.getAttendanceType() == null ? "" : atsShiftItemInfo.getAttendanceType().getValue();
            insertShiftItemObjArr[12] = atsShiftItemInfo.getPreTimeDayType().getValue();
            insertShiftItemObjArr[13] = atsShiftItemInfo.getNextTimeDayType().getValue();
            insertShiftItemObjArr[14] = StringUtils.isNotEmpty((String)preDateTimeStr) ? GroupBaseSaveShift.stringToTimestamp(preDateTimeStr) : null;
            insertShiftItemObjArr[15] = StringUtils.isNotEmpty((String)nextDateTimeStr) ? GroupBaseSaveShift.stringToTimestamp(nextDateTimeStr) : null;
            insertShiftItemObjArr[16] = restPreTime == null ? "" : restPreTime;
            insertShiftItemObjArr[17] = restNextTime == null ? "" : restNextTime;
            insertShiftItemObjArr[18] = StringUtils.isNotEmpty((String)restPreDateTimeStr) ? GroupBaseSaveShift.stringToTimestamp(restPreDateTimeStr) : null;
            insertShiftItemObjArr[19] = StringUtils.isNotEmpty((String)restNextDateTimeStr) ? GroupBaseSaveShift.stringToTimestamp(restNextDateTimeStr) : null;
            insertShiftItemObjArr[20] = AttendanceGroupShiftInfo2 != null && AttendanceGroupShiftInfo2.getId() != null ? AttendanceGroupShiftInfo2.getId().toString() : "";
            shiftItemList.add(insertShiftItemObjArr);
        }
        return shiftItemList;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getCtrlUnitInfo() {
        return this.CtrlUnitInfo;
    }

    public void setCtrlUnitInfo(String ctrlUnitInfo) {
        this.CtrlUnitInfo = ctrlUnitInfo;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getHrOrgUnitId() {
        return this.hrOrgUnitId;
    }

    public void setHrOrgUnitId(String hrOrgUnitId) {
        this.hrOrgUnitId = hrOrgUnitId;
    }

    public int getDefaultAdvcValue() {
        return this.defaultAdvcValue;
    }

    public void setDefaultAdvcValue(int defaultAdvcValue) {
        this.defaultAdvcValue = defaultAdvcValue;
    }

    public SchlShiftSrcTypeEnum getDefaultScheduleSrcType() {
        return this.defaultScheduleSrcType;
    }

    public void setDefaultScheduleSrcType(SchlShiftSrcTypeEnum defaultScheduleSrcType) {
        this.defaultScheduleSrcType = defaultScheduleSrcType;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }
}

