/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.service.api.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.ShrSqlEnum;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.SqlGenerateUtils;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.ISHRSqlBuilder;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractSHRSqlBuilder
implements ISHRSqlBuilder {
    private static Logger logger = Logger.getLogger(AbstractSHRSqlBuilder.class);
    protected Context ctx;
    protected SqlParam param;
    protected Map<String, String> historyReplayColumn;
    protected Map<String, String> permissFields;

    private void init(Context ctx, SqlParam param) throws EASBizException, BOSException {
        HashMap<String, String> infoCtr = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : param.getInfoCtr().entrySet()) {
            infoCtr.put(entry.getKey().toString().toUpperCase(), entry.getValue());
        }
        param.setInfoCtr((Map<String, String>)infoCtr);
        this.ctx = ctx;
        this.param = param;
        this.historyReplayColumn = new HashMap<String, String>();
        this.permissFields = new HashMap<String, String>();
        this.initExt(ctx, param);
    }

    protected void initExt(Context ctx, SqlParam param) {
    }

    @Override
    public String getSql(Context ctx, SqlParam param) throws EASBizException, BOSException {
        long begin = System.currentTimeMillis();
        this.init(ctx, param);
        String sql = this.generateSQL(ctx, param);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSql cost:" + (end - begin) + ", sql:" + sql));
        }
        return sql;
    }

    @Override
    public Map<String, String> getSqlMap(Context ctx, SqlParam param) throws EASBizException, BOSException {
        this.init(ctx, param);
        return this.generateSQLMap(ctx, param);
    }

    @Override
    public List<Map<String, Object>> pupolate(Context ctx, SqlParam param, IRowSet rowSet) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.param = param;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, String> reverseMap = new HashMap<String, String>();
        HashMap<String, String> originMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : param.getSelectMapping().entrySet()) {
            reverseMap.put(entry.getValue().toString().toUpperCase(), entry.getKey());
            originMap.put(entry.getValue().toString().toUpperCase(), entry.getValue());
        }
        try {
            ResultSetMetaData RSMD = rowSet.getMetaData();
            int colCount = RSMD.getColumnCount();
            int[] datetypes = new int[colCount];
            String[] columns = new String[colCount];
            PropertyInfo[] props = new PropertyInfo[colCount];
            HashMap<String, Integer> dataTypeValueMap = new HashMap<String, Integer>();
            HashMap<String, Object> cnSn = new HashMap<String, Object>();
            HashMap<String, String> labCostTypeNumberFieldMap = new HashMap<String, String>();
            this.pupolateCnSnOSFHandler(cnSn, dataTypeValueMap, labCostTypeNumberFieldMap);
            for (int k = 1; k <= colCount; ++k) {
                String key = RSMD.getColumnName(k);
                String reallyColumn = (String)reverseMap.get(key.toUpperCase());
                if (param.isNeedGropBy() && key.toString().equalsIgnoreCase("count")) {
                    OwnPropertyInfo own = new OwnPropertyInfo();
                    own.setDataType(DataType.DECIMAL);
                    props[k - 1] = own;
                    columns[k - 1] = "count";
                    datetypes[k - 1] = 3;
                    continue;
                }
                if (this.pupolateColumnAndDateTypesFhandler(k, key, reallyColumn, props, columns, datetypes, labCostTypeNumberFieldMap)) continue;
                String fieldStr = reallyColumn;
                String[] split = reallyColumn.split("\\.");
                if (split.length > 1) {
                    fieldStr = split[split.length - 1];
                }
                if (this.pupolateColumnAndDateTypesFhandler0(k, key, fieldStr, props, columns, datetypes, dataTypeValueMap, originMap)) continue;
                if (split.length > 2) {
                    reallyColumn = split[split.length - 2] + "." + split[split.length - 1];
                }
                StructureConfigInfo configInfo = null;
                try {
                    configInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)ctx, (String)reallyColumn, (String)param.getScheme());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (null == configInfo) {
                    columns[k - 1] = reallyColumn;
                    continue;
                }
                PropertyInfo propInfo = null;
                try {
                    propInfo = this.getPropertyInfoFullPath(configInfo, reallyColumn);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (null == propInfo) {
                    columns[k - 1] = reallyColumn;
                    continue;
                }
                props[k - 1] = propInfo;
                columns[k - 1] = (String)originMap.get(key.toUpperCase().toString());
                datetypes[k - 1] = propInfo.getMappingField().getSQLType();
            }
            while (rowSet.next()) {
                HashMap<String, Object> each = new HashMap<String, Object>();
                for (int k = 1; k <= colCount; ++k) {
                    PropertyInfo fld = props[k - 1];
                    if (null == fld) {
                        each.put(columns[k - 1], rowSet.getObject(k));
                        continue;
                    }
                    Object data = ImplUtils.getDataFromDr((int)datetypes[k - 1], (ResultSet)rowSet, (int)k);
                    if (fld instanceof OwnPropertyInfo) {
                        DataType dataType = ((OwnPropertyInfo)fld).getDataType();
                        if (DataType.BOSUUID.equals((Object)dataType)) {
                            if (data != null && !StringUtils.isEmpty((String)((String)data))) {
                                try {
                                    data = BOSUuid.read((String)data.toString());
                                }
                                catch (Exception e) {
                                    throw new BOSException("Invalid BOSUuid.  colName:" + columns[k - 1] + ", value:" + data, (Throwable)e);
                                }
                            }
                        } else {
                            Object _data_;
                            data = DataType.ENUM.equals((Object)dataType) ? (null != (_data_ = rowSet.getObject(k)) ? SqlGenerateUtils.convertSQLTypeData2Java((DataType)dataType, (Object)data, (OwnPropertyInfo)((OwnPropertyInfo)fld), (SqlParam)param) : null) : SqlGenerateUtils.convertSQLTypeData2Java((DataType)dataType, (Object)data, (OwnPropertyInfo)((OwnPropertyInfo)fld), (SqlParam)param);
                        }
                    }
                    if (data == null) {
                        data = "";
                    }
                    each.put(columns[k - 1], data);
                }
                result.add(each);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected abstract void pupolateCnSnOSFHandler(Map<String, Object> var1, Map<String, Integer> var2, Map<String, String> var3) throws EASBizException, BOSException;

    protected abstract boolean pupolateColumnAndDateTypesFhandler(int var1, String var2, String var3, PropertyInfo[] var4, String[] var5, int[] var6, Map<String, String> var7);

    protected abstract boolean pupolateColumnAndDateTypesFhandler0(int var1, String var2, String var3, PropertyInfo[] var4, String[] var5, int[] var6, Map<String, Integer> var7, Map<String, String> var8);

    private String generateSQL(Context ctx, SqlParam param) throws EASBizException, BOSException {
        if (param.getGroupType() != null) {
            return this.generateSQL2(ctx, param, Boolean.FALSE);
        }
        String fromSql = this.assembleSQLFrom();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.assembleSQLSelect());
        sql.append(" FROM ");
        sql.append(fromSql);
        String whereSql = this.assembleSQLWhereWithOrderAndGroup();
        if (!StringUtils.isEmpty((String)whereSql)) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        return sql.toString();
    }

    private String generateSQL2(Context ctx, SqlParam param, boolean needInit) throws EASBizException, BOSException {
        String orderSql;
        String customWhere;
        if (needInit) {
            this.init(ctx, param);
        }
        StringBuffer sql = new StringBuffer();
        String fromSql = this.assembleSQLFrom();
        String outerSelectSql = this.assembleOuterSQLSelect();
        sql.append("SELECT ");
        sql.append(outerSelectSql);
        sql.append(" FROM ").append("(");
        sql.append("SELECT ");
        if (param.isNeedDistinct()) {
            sql.append("DISTINCT ");
        }
        String selectSql = this.assembleSQLSelect();
        sql.append(selectSql);
        sql.append(" FROM ");
        sql.append(fromSql);
        String whereSql = this.assembleSQLWhere();
        if (!StringUtils.isEmpty((String)whereSql)) {
            sql.append(" WHERE ");
            sql.append(whereSql);
        }
        if (!StringUtils.isEmpty((String)(customWhere = this.assembleCustomSQLWhere()))) {
            if (StringUtils.isEmpty((String)whereSql)) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            sql.append(customWhere);
        }
        if (!StringUtils.isEmpty((String)(orderSql = this.assembleSQLOrderby()))) {
            sql.append(" ORDER BY ").append(orderSql);
        }
        sql.append(")").append(" ").append("tempTT ");
        String outGroupbySql = this.assembleOutSQLGroupby();
        if (!StringUtils.isEmpty((String)outGroupbySql)) {
            sql.append(" GROUP BY ").append(outGroupbySql);
        }
        sql.append(" ");
        return sql.toString();
    }

    private Map<String, String> generateSQLMap(Context ctx, SqlParam param) throws EASBizException, BOSException {
        if (param.getGroupType() != null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SELECT ".trim(), this.assembleSQLSelect());
        map.put(" FROM ".trim(), this.assembleSQLFrom());
        map.put(" WHERE ".trim(), this.assembleSQLWhere());
        return map;
    }

    protected abstract String assembleSQLFrom() throws EASBizException, BOSException;

    protected abstract String assembleSQLSelect() throws EASBizException, BOSException;

    protected String assembleSQLWhereWithOrderAndGroup() throws EASBizException, BOSException {
        String groupbySql;
        StringBuffer sql = new StringBuffer();
        String whereSql = this.assembleSQLWhere();
        sql.append(whereSql);
        String orderSql = this.assembleSQLOrderby();
        if (!StringUtils.isEmpty((String)orderSql)) {
            sql.append(" ORDER BY ").append(orderSql);
        }
        if (this.param.isNeedGropBy() && !StringUtils.isEmpty((String)(groupbySql = this.assembleSQLGroupby()))) {
            sql.append(" GROUP BY ").append(groupbySql);
        }
        sql.append(" ");
        return sql.toString();
    }

    protected abstract String assembleSQLWhere() throws EASBizException, BOSException;

    protected abstract String assembleSQLOrderby() throws EASBizException, BOSException;

    protected abstract String assembleSQLGroupby() throws EASBizException, BOSException;

    protected abstract String assembleOuterSQLSelect() throws EASBizException, BOSException;

    protected abstract String assembleOutSQLGroupby() throws EASBizException, BOSException;

    protected String assembleCustomSQLWhere() throws EASBizException, BOSException {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendClouse(StringBuffer filter, Object value, CompareType type, FilterItemInfo filterItemInfo, PropertyInfo propInfo) {
        String tmp;
        if (value != null && value instanceof String && (tmp = value.toString()).startsWith("~9^Nz")) {
            value = tmp.substring(tmp.lastIndexOf("~9^Nz") + 5);
        }
        if (value == null) {
            if (CompareType.EQUALS.equals((Object)type) || CompareType.IS.equals((Object)type)) {
                filter.append(" is null");
                return;
            } else {
                if (!CompareType.NOTEQUALS.equals((Object)type) && !CompareType.ISNOT.equals((Object)type)) throw new IllegalArgumentException("can't compare with null, comparetype = " + type);
                filter.append(" is not null");
            }
            return;
        } else if (CompareType.LIKE.equals((Object)type)) {
            filter.append(" like ").append(this.getValueString(value));
            filter.deleteCharAt(filter.length() - 1);
            return;
        } else if (CompareType.NOTLIKE.equals((Object)type)) {
            filter.append(" not like ").append(this.getValueString(value));
            filter.deleteCharAt(filter.length() - 1);
            return;
        } else if (CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type)) {
            if (value != null && value instanceof Set && ((Set)value).size() == 0) {
                ((Set)value).add("");
            }
            filter.append(this.appendIn(filterItemInfo, propInfo, CompareType.INCLUDE.equals((Object)type)));
            return;
        } else if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type)) {
            if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'inner' or 'notinner' as compare type, the compare value must be string");
            filter.append(type == CompareType.INNER ? " in " : " not in ");
            filter.append("(");
            filter.append(value.toString());
            filter.append(")");
            return;
        } else if (CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
            if (value == null || !(value instanceof String)) throw new IllegalArgumentException("when use 'exists' or 'notexists' as compare type, the compare value must be string");
            filter.append(type == CompareType.EXISTS ? " exists " : " not exists ");
            filter.append("(");
            filter.append(value.toString());
            filter.append(")");
            return;
        } else if (CompareType.IS.equals((Object)type) || CompareType.ISNOT.equals((Object)type)) {
            filter.append(" ").append(filterItemInfo.getCompareExpression());
            filter.append(" ").append(" null ");
            return;
        } else {
            filter.append(filterItemInfo.getCompareExpression());
            filter.append(" ").append(this.getValueString(value));
            filter.deleteCharAt(filter.length() - 1);
        }
    }

    protected void appendCommonJoinOnCondition(String contract, StringBuffer sql, String leftTableAlias, String leftTableField, String compareValue, String rightTableAlias, String rightTableFieldOrValue) {
        if (!StringUtils.isEmpty((String)contract)) {
            sql.append(contract);
        }
        sql.append(leftTableAlias).append(".").append(leftTableField).append(compareValue);
        if (!StringUtils.isEmpty((String)rightTableAlias)) {
            sql.append(rightTableAlias).append(".");
        }
        sql.append(rightTableFieldOrValue);
    }

    protected final void appendAliasQueAndFiledQue(StringBuffer sql, String tableAlias, String tableField) {
        this.appendAliasQue(sql, tableAlias);
        sql.append(".").append(this.appendQuo(tableField));
    }

    protected final void appendAliasQueAndFiled(StringBuffer sql, String tableAlias, String tableField) {
        this.appendAliasQue(sql, tableAlias);
        sql.append(".").append(tableField);
    }

    protected final void appendAliasQue(StringBuffer sql, String tableAlias) {
        sql.append(this.appendQuo(tableAlias));
    }

    protected final void appendLeftJoin(StringBuffer sql, StringBuffer tableNameAndAlias, StringBuffer joinCondition) {
        sql.append("\n").append(" LEFT JOIN ").append(tableNameAndAlias).append(" ON ").append(joinCondition);
    }

    protected final void appendInnerJoin(StringBuffer sql, StringBuffer tableNameAndAlias, StringBuffer joinCondition) {
        sql.append("\n").append(" INNER JOIN ").append(tableNameAndAlias).append(" ON ").append(joinCondition);
    }

    protected final void appendFuntionQue(StringBuffer sql, String functionName, String filedName) {
        String realName = this.appendQuo(filedName);
        sql.append(functionName).append("(").append(realName).append(")").append(" AS ").append(realName);
    }

    protected final String appendQuo(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"").append(name).append("\"");
        return sb.toString();
    }

    protected final void appendCount(StringBuffer sql) {
        sql.append(",").append("\n").append("COUNT(*)").append(" AS ").append("COUNT");
    }

    protected final void appendQueAdminHis(StringBuffer sql, StructureConfigInfo configInfo, String split, String field, String alias) {
        sql.append(" ").append("\"").append(this.getTableAlias(configInfo)).append(split).append("\"").append(".").append(field);
        if (!StringUtils.isEmpty((String)alias)) {
            sql.append(" AS ").append(this.appendQuo(alias)).append(" ");
        }
    }

    protected final EntityObjectInfo getEntityObject(String entityName) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    protected String generatePermissionRangeFilter() throws EASBizException, BOSException {
        StringBuffer rangeSql = new StringBuffer();
        if (ShrSqlEnum.DYNAMIC.equals((Object)this.param.getShrSqlEnum())) {
            return rangeSql.toString();
        }
        String pHr = this.generatePHr();
        String pAdmin = this.generatePAdmin();
        String hrRange = this.generateHrRange();
        String adminRange = this.generatePAdminRange();
        String defaultManage = this.generateDefaultManage();
        if (StringUtils.isEmpty((String)defaultManage) && StringUtils.isEmpty((String)this.permissFields.get("hr")) && StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            return rangeSql.toString();
        }
        if (StringUtils.isEmpty((String)defaultManage) && StringUtils.isEmpty((String)this.permissFields.get("hr")) && !StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            rangeSql.append(this.appendAdminOrgUnitSql(pAdmin, adminRange));
            return rangeSql.toString();
        }
        if (StringUtils.isEmpty((String)defaultManage) && !StringUtils.isEmpty((String)this.permissFields.get("hr")) && StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            rangeSql.append(this.appendHrOrgUnitSql(pHr, hrRange));
            return rangeSql.toString();
        }
        if (StringUtils.isEmpty((String)defaultManage) && !StringUtils.isEmpty((String)this.permissFields.get("hr")) && !StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            rangeSql.append(this.appendHrOrgUnitSql(pHr, hrRange)).append(" AND ").append(this.appendAdminOrgUnitSql(pAdmin, adminRange));
            return rangeSql.toString();
        }
        if (!StringUtils.isEmpty((String)defaultManage) && StringUtils.isEmpty((String)this.permissFields.get("hr")) && !StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            return rangeSql.toString();
        }
        if (!(StringUtils.isEmpty((String)defaultManage) || StringUtils.isEmpty((String)this.permissFields.get("hr")) || StringUtils.isEmpty((String)this.permissFields.get("admin")))) {
            if (StringUtils.isEmpty((String)pHr) && StringUtils.isEmpty((String)pAdmin)) {
                rangeSql.append("(").append(hrRange).append(" AND ").append("(").append(adminRange).append(" OR ").append(defaultManage).append(")").append(")");
                return rangeSql.toString();
            }
            if (StringUtils.isEmpty((String)pHr) && !StringUtils.isEmpty((String)pAdmin)) {
                rangeSql.append("(").append(hrRange).append(" AND ").append(pAdmin).append(" AND ").append(adminRange).append(")");
                return rangeSql.toString();
            }
            if (!StringUtils.isEmpty((String)pHr) && StringUtils.isEmpty((String)pAdmin)) {
                rangeSql.append("(").append(pHr).append(" AND ").append("(").append(adminRange).append(" OR ").append(defaultManage).append(")").append(")");
                return rangeSql.toString();
            }
            if (!StringUtils.isEmpty((String)pHr) && !StringUtils.isEmpty((String)pAdmin)) {
                rangeSql.append("(").append(pHr).append(" AND ").append(pAdmin).append(" AND ").append(adminRange).append(")");
                return rangeSql.toString();
            }
        } else if (!StringUtils.isEmpty((String)defaultManage) && !StringUtils.isEmpty((String)this.permissFields.get("hr")) && StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            if (!StringUtils.isEmpty((String)pHr)) {
                rangeSql.append("(").append(pHr).append(")");
            } else {
                rangeSql.append("(").append(hrRange).append(")");
            }
            return rangeSql.toString();
        }
        return rangeSql.toString();
    }

    protected final String appendHrOrgUnitSql(String pHr, String hrRange) {
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        if (!StringUtils.isEmpty((String)pHr)) {
            sql.append(pHr);
        } else {
            sql.append(hrRange);
        }
        sql.append(")");
        return sql.toString();
    }

    protected final String appendAdminOrgUnitSql(String pAdmin, String adminRange) {
        StringBuffer sql = new StringBuffer();
        sql.append("(").append(adminRange);
        if (!StringUtils.isEmpty((String)pAdmin)) {
            sql.append(" AND ").append(pAdmin);
        }
        sql.append(")");
        return sql.toString();
    }

    protected final String generatePHr() {
        if (StringUtils.isEmpty((String)this.permissFields.get("hr"))) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.param.getPHr())) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.permissFields.get("hr")).append(" in ").append("(");
        sql.append("@customHrOrg");
        sql.append(")");
        return sql.toString();
    }

    protected final String generateSqlStringIn(String[] values, String type) {
        StringBuffer sql = new StringBuffer();
        int j = 0;
        int total = values.length;
        for (int i = 0; i < total; ++i) {
            if (!"hr".equals(type) && !"admin".equals(type)) continue;
            if (j > 0) {
                sql.append(",");
            }
            sql.append("'").append(values[i]).append("'");
            ++j;
        }
        return sql.toString();
    }

    protected final String generateHrRange() {
        if (StringUtils.isEmpty((String)this.permissFields.get("hr"))) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.permissFields.get("hr")).append(" in ").append("(").append("@customHrOrg").append(")");
        return sql.toString();
    }

    private String getIdsInSql(String value, String fieldName, String type) {
        StringBuffer sql = new StringBuffer();
        String[] values = value.split(",");
        if (values.length == 1) {
            if (!"hr".equals(type) && !"admin".equals(type)) {
                return null;
            }
            sql.append(fieldName).append(" = ").append("'").append(values[0]).append("'");
            return sql.toString();
        }
        String mutilSql = this.generateSqlStringIn(values, type);
        if (!StringUtils.isEmpty((String)mutilSql)) {
            sql.append(fieldName).append(" in ").append("(").append(mutilSql).append(")");
            return sql.toString();
        }
        return null;
    }

    protected final String generatePAdmin() {
        if (StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            return null;
        }
        if ("FID".equals(this.param.getPAdminType())) {
            if (StringUtils.isEmpty((String)this.param.getPAdmin())) {
                return null;
            }
            return this.getIdsInSql(this.param.getPAdmin(), this.permissFields.get("admin"), "admin");
        }
        if ("FLongNumber".equals(this.param.getPAdminType())) {
            if (StringUtils.isEmpty((String)this.param.getPAdminLongNumber())) {
                return null;
            }
            return this.generateLongNumberFilter(this.permissFields.get("admin"), this.param.getPAdminLongNumber());
        }
        if ("FDisplayName".equals(this.param.getPAdminType())) {
            if (StringUtils.isEmpty((String)this.param.getpAdminDisplayName())) {
                return null;
            }
            return this.generateDisplayL2Filter(this.permissFields.get("admin"), this.param.getPAdminLongNumber());
        }
        return null;
    }

    private String generateLongNumberFilter(String fieldName, String value) {
        StringBuffer sql = new StringBuffer();
        sql.append(fieldName).append(" in ").append("(").append("SELECT FID FROM T_ORG_ADMIN where (FLONGNUMBER = '").append("@customAdminOrg").append("' OR FLONGNUMBER like '").append("@customAdminOrg").append("!%')").append(")");
        return sql.toString();
    }

    private String generateDisplayL2Filter(String fieldName, String value) {
        StringBuffer sql = new StringBuffer();
        sql.append(fieldName).append(" in ").append("(").append("SELECT FID FROM T_ORG_ADMIN where (FDisplayName_").append("@customLocaleLan").append(" = '").append(value).append("' OR FDisplayName_").append("@customLocaleLan").append(" like '").append(value).append("!%')").append(")");
        return sql.toString();
    }

    protected final String generatePAdminRange() {
        if (StringUtils.isEmpty((String)this.permissFields.get("admin"))) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.permissFields.get("admin")).append(" in ").append("(").append("@customAdminOrgRange").append(")");
        return sql.toString();
    }

    protected final String generateDefaultManage() {
        if (StringUtils.isEmpty((String)this.permissFields.get("defaultManage"))) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.permissFields.get("defaultManage")).append(" = ").append(0);
        return sql.toString();
    }

    protected final String getUserId() {
        return HRFilterUtils.getCurrentUserId((Context)this.ctx);
    }

    protected final Set<String> getHrOrgUnitPermissionRangeSet() {
        return SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)this.ctx, (String)this.getUserId(), (String)this.param.getPermItemId());
    }

    protected final boolean hasHrOrgUnitPermission(String hrOrgUnitId) {
        return SHRUserOrgPermissionApi.containsHROrgRange((Context)this.ctx, (String)this.getUserId(), (String)this.param.getPermItemId(), (String)hrOrgUnitId);
    }

    protected final String getAdminOrgUnitPermissionRangeSql() {
        return SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)this.ctx, (String)this.getUserId(), (String)this.param.getPermItemId());
    }

    protected final Set<String> getAdminOrgUnitPermissionRangeSet() {
        return SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)this.ctx, (String)this.getUserId(), (String)this.param.getPermItemId());
    }

    protected final boolean hasAdminOrgUnitPermission(String AdminOrgUnitId) {
        return SHRUserOrgPermissionApi.containsAdminOrgRange((Context)this.ctx, (String)this.getUserId(), (String)this.param.getPermItemId(), (String)AdminOrgUnitId);
    }

    @Override
    public FilterInfo getDataSourceCustomFilter(Context ctx, String scheme, Map configParam) throws EASBizException, BOSException {
        this.ctx = ctx;
        String effdtStr = null;
        if (configParam.get("effdt") != null) {
            effdtStr = (String)configParam.get("effdt");
        }
        Date effdt = null;
        try {
            effdt = effdtStr != null && !"".equals(effdtStr) ? DateTimeUtils.parseDate((String)effdtStr, (String)"yyyy-MM-dd") : DateTimeUtils.truncateDate((Date)new Date());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return this.privateDataSourceCustomFilter(scheme, configParam, effdtStr, effdt);
    }

    protected abstract FilterInfo privateDataSourceCustomFilter(String var1, Map var2, String var3, Date var4) throws EASBizException, BOSException;

    protected final String getTableAlias(StructureConfigInfo configInfo) {
        return configInfo.getClientNumber().toUpperCase();
    }

    protected final String getQuoTableAlias(StructureConfigInfo configInfo) {
        return this.appendQuo(this.getTableAlias(configInfo));
    }

    protected final HistoryGeneratorParam getHisParam(StructureConfigInfo configInfo) {
        HistoryGeneratorParam hisParam = new HistoryGeneratorParam();
        EntityObjectInfo bo = this.getEntityObject(configInfo.getEntityName());
        hisParam.setRelateColumn(bo.getBusinessHistoryColumn());
        hisParam.setRelateTalbe(this.getTableAlias(configInfo));
        return hisParam;
    }

    protected final String getTableName(StructureConfigInfo configInfo, boolean historyMode) throws EASBizException, BOSException {
        String tableName = null;
        EntityObjectInfo clientEntity = this.getEntityObject(configInfo.getEntityName());
        if (clientEntity.isNeedHistory() && historyMode) {
            clientEntity = this.getEntityObject(clientEntity.getHisEntity());
        }
        if (!StringUtils.isEmpty((String)clientEntity.getExtendedProperty("shrHisEntity")) && historyMode) {
            clientEntity = this.getEntityObject(clientEntity.getExtendedProperty("shrHisEntity"));
        }
        if (null == clientEntity.getType() || null == clientEntity.getTable()) {
            throw new BaseConfigException(BaseConfigException.METADATA_ENTITY_NOT_EXIST, new Object[]{clientEntity.getFullName()});
        }
        tableName = clientEntity.getTable().getName();
        return tableName.toUpperCase();
    }

    protected final String getColumnName(StructureConfigInfo tableConfigInfo, String propertyName) throws EASBizException, BOSException {
        String sourceColumnName = null;
        if (StringUtils.isEmpty((String)propertyName) && StringUtils.isEmpty((String)tableConfigInfo.getEntityName())) {
            throw new BaseConfigException(BaseConfigException.TABLENAMEANDCOLUMNNAMENULL);
        }
        PropertyInfo prop = this.getPropertyInfo(tableConfigInfo, propertyName);
        sourceColumnName = this.getFieldClause(prop);
        StringBuffer columnString = new StringBuffer();
        columnString.append(this.getQuoTableAlias(tableConfigInfo)).append(".");
        columnString.append(sourceColumnName);
        return columnString.toString();
    }

    protected final String getFieldClause(PropertyInfo prop) throws EASBizException {
        if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual()) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                return MessageFormat.format("{0}{1}{2}", prop.getMappingField().getName(), "_", "@customLocaleLan");
            }
            return MessageFormat.format("{0}{1}{2}", prop.getMappingField().getName(), "_", this.ctx.getLocale().getDisplayName());
        }
        return prop.getMappingField().getName();
    }

    protected boolean isHistoryEntity(EntityObjectInfo entityInfo) {
        Boolean result = entityInfo.isNeedHistory();
        if (result.booleanValue()) {
            return result;
        }
        if (!StringUtils.isEmpty((String)entityInfo.getExtendedProperty("shrHisEntity"))) {
            return Boolean.TRUE;
        }
        return result;
    }

    protected PropertyInfo getRealPropertyInfo(EntityObjectInfo entityInfo, String propertyName) {
        PropertyInfo prop = entityInfo.getPropertyByNameRuntime(propertyName);
        if (this.isHistoryEntity(entityInfo)) {
            String hisEntity = entityInfo.getHisEntity();
            if (StringUtils.isEmpty((String)hisEntity)) {
                hisEntity = entityInfo.getExtendedProperty("shrHisEntity");
            }
            if (!StringUtils.isEmpty((String)hisEntity)) {
                EntityObjectInfo hisEntityInfo = this.getEntityObject(hisEntity);
                prop = hisEntityInfo.getPropertyByNameRuntime(propertyName);
            }
        }
        return prop;
    }

    private EntityObjectInfo getHisEntityInfo(EntityObjectInfo entityInfo) {
        String hisEntity = entityInfo.getHisEntity();
        if (StringUtils.isEmpty((String)hisEntity)) {
            hisEntity = entityInfo.getExtendedProperty("shrHisEntity");
        }
        if (!StringUtils.isEmpty((String)hisEntity)) {
            return this.getEntityObject(hisEntity);
        }
        return null;
    }

    protected PropertyInfo getPropertyInfo(StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        EntityObjectInfo entityInfo = this.getEntityObject(clientInfo.getEntityName());
        PropertyInfo prop = this.getRealPropertyInfo(entityInfo, propertyName);
        if (prop == null) {
            prop = this.getCmpPropertyInfo(clientInfo, propertyName);
        }
        if (prop == null) {
            prop = this.getAtsPropertyInfo(clientInfo, propertyName);
        }
        if (prop == null) {
            EntityObjectInfo hisEntityObjectInfo = this.getHisEntityInfo(entityInfo);
            if (null != hisEntityObjectInfo) {
                throw new BaseConfigException(BaseConfigException.ENTITYPROPTYNOTVALID, new Object[]{hisEntityObjectInfo.getAlias(), hisEntityObjectInfo.getFullName(), propertyName});
            }
            throw new BaseConfigException(BaseConfigException.ENTITYPROPTYNOTVALID, new Object[]{entityInfo.getAlias(), entityInfo.getFullName(), propertyName});
        }
        if (prop.getMappingField() == null) {
            throw new BaseConfigException(BaseConfigException.ENITTYPROPTYNOTTABLEMAPPING, new Object[]{entityInfo.getAlias(), propertyName});
        }
        return prop;
    }

    protected abstract OwnPropertyInfo getCmpPropertyInfo(StructureConfigInfo var1, String var2) throws EASBizException, BOSException;

    protected abstract OwnPropertyInfo getAtsPropertyInfo(StructureConfigInfo var1, String var2) throws EASBizException, BOSException;

    protected String getColumnName(Map<String, String> historyColumn, StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        if (propertyName.startsWith("UPPER(")) {
            String pName = propertyName.substring(propertyName.indexOf("(") + 1, propertyName.length() - 1);
            String[] keys = pName.split("\\.");
            String ColumnName = "UPPER(" + this.getColumnNameCurrentEntity(historyColumn, clientInfo, keys[1]) + ")";
            return ColumnName;
        }
        String[] keys = propertyName.split("\\.");
        return this.getColumnNameCurrentEntity(historyColumn, clientInfo, keys[1]);
    }

    private String getColumnNameCurrentEntity(Map<String, String> historyColumn, StructureConfigInfo clientInfo, String key) throws EASBizException, BOSException {
        PropertyInfo prop = this.getPropertyInfo(clientInfo, key);
        StringBuffer column = new StringBuffer();
        column.append(this.getQuoTableAlias(clientInfo)).append(".").append(this.getFieldClause(prop));
        return this.getColumnHisotryName(historyColumn, column.toString());
    }

    protected String getColumnHisotryName(Map<String, String> historyColumn, String currentName) {
        if (historyColumn.containsKey(currentName.toUpperCase())) {
            return historyColumn.get(currentName.toUpperCase());
        }
        return currentName;
    }

    protected String getRelationFieldTableColumn(EntityObjectInfo entityInfo, String relationField, String relationFieldAlais) throws EASBizException {
        PropertyInfo prop = entityInfo.getPropertyByNameRuntime(relationField);
        if (StringUtils.isEmpty((String)relationFieldAlais)) {
            relationFieldAlais = "";
        }
        if (null == prop) {
            throw new BaseConfigException(BaseConfigException.REL_ATTR_ENTITY_NOT_EXIST, new Object[]{relationFieldAlais, relationField, entityInfo.getAlias(), entityInfo.getFullName()});
        }
        if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual()) {
            if (ShrSqlEnum.REPORT.equals((Object)this.param.getShrSqlEnum())) {
                return MessageFormat.format("{0}{1}{2}", prop.getMappingField().getName(), "_", "@customLocaleLan");
            }
            return MessageFormat.format("{0}{1}{2}", prop.getMappingField().getName(), "_", this.ctx.getLocale().getDisplayName());
        }
        if (null == prop.getMappingField()) {
            throw new BaseConfigException(BaseConfigException.REL_ATTR_DATA_FIELD_ISNULL, new Object[]{prop.getAlias(), prop.getName()});
        }
        return prop.getMappingField().getName();
    }

    protected PropertyInfo getPropertyInfoFullPath(StructureConfigInfo clientInfo, String fullPath) throws EASBizException, BOSException {
        if (fullPath.startsWith("UPPER(")) {
            String pName = fullPath.substring(fullPath.indexOf("(") + 1, fullPath.length() - 1);
            String[] keys = pName.split("\\.");
            return this.getPropertyInfo(clientInfo, keys[1]);
        }
        String[] keys = fullPath.split("\\.");
        return this.getPropertyInfo(clientInfo, keys[1]);
    }

    protected CoreBaseInfo getInfoFromCollByKey(IObjectCollection coreBaseColl, String key) {
        if (StringUtils.isEmpty((String)key) || coreBaseColl.size() == 0) {
            return null;
        }
        int total = coreBaseColl.size();
        for (int i = 0; i < total; ++i) {
            if (!key.equals(((CoreBaseInfo)coreBaseColl.getObject(i)).getId().toString())) continue;
            return (CoreBaseInfo)coreBaseColl.getObject(i);
        }
        return null;
    }

    protected String getValueString(Object value) {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getValueStringOnly(value)).append(",");
        return sql.toString();
    }

    protected String getValueStringOnly(Object value) {
        StringBuffer sql = new StringBuffer();
        if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            sql.append(value.toString()).append("");
        } else if (value instanceof Boolean) {
            sql.append(value.toString().equalsIgnoreCase("true") ? "1" : "0");
        } else if (value instanceof Timestamp || value instanceof Date || value instanceof Time || value instanceof Date) {
            String val = null;
            if (value instanceof Timestamp) {
                val = DateTimeUtils.format((Date)((Timestamp)value), (String)"yyyy-MM-dd HH:mm:ss");
                sql.append("{ts ").append(this.appendQuotedConst(val)).append("}");
            } else if (value instanceof Time) {
                val = DateTimeUtils.format((Date)((Time)value), (String)"HH:mm:ss");
                sql.append("{ts ").append(this.appendQuotedConst(val)).append("}");
            } else if (value instanceof Date) {
                val = DateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                sql.append("{ts ").append(this.appendQuotedConst(val)).append("}");
            }
        } else {
            sql.append(this.appendQuotedConst(this.escapedSingleQuotation(value.toString().replace("'", "''")))).append("");
        }
        return sql.toString();
    }

    protected String appendQuotedConst(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("'").append(name).append("'");
        return sb.toString();
    }

    protected String appendIn(FilterItemInfo fp, PropertyInfo prop, boolean isInclude) {
        StringBuffer sql = new StringBuffer();
        sql.append(isInclude ? " in " : " not in ");
        if (fp.getCompareValue() instanceof Set) {
            HashSet set = (HashSet)fp.getCompareValue();
            if (set.size() > 0) {
                assert (set.size() < 1024) : "set size must less 1024";
                sql.append("(");
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    if (prop instanceof OwnPropertyInfo) {
                        Object obj;
                        DataType type = ((OwnPropertyInfo)prop).getDataType();
                        if (type.equals((Object)DataType.STRING) || type.equals((Object)DataType.DATE) || type.equals((Object)DataType.BOSUUID)) {
                            obj = it.next();
                            if (obj != null && obj.toString() != null) {
                                sql.append(this.appendQuotedConst(obj.toString().replaceAll("'", "''"))).append(",");
                                continue;
                            }
                            sql.append(this.appendQuotedConst("")).append(",");
                            continue;
                        }
                        if (type.equals((Object)DataType.BOOLEAN)) {
                            String val = it.next().toString();
                            if (val.equalsIgnoreCase("true")) {
                                sql.append("1,");
                                continue;
                            }
                            if (!val.equalsIgnoreCase("false")) continue;
                            sql.append("0,");
                            continue;
                        }
                        obj = it.next();
                        if (obj != null && obj.toString() != null) {
                            sql.append(obj.toString()).append(",");
                            continue;
                        }
                        sql.append(this.appendQuotedConst("")).append(",");
                        continue;
                    }
                    sql.append(this.getValueString(it.next()));
                }
                if (sql.toString().lastIndexOf(",") == sql.toString().length() - 1) {
                    sql.deleteCharAt(sql.toString().length() - 1);
                }
                sql.append(")");
            }
        } else {
            sql.append(prop.toString());
        }
        return sql.toString();
    }

    protected void afterGetAllTableInfoForReport(StructureConfigCollection tableCollection) {
    }

    private String escapedSingleQuotation(String sourceStr) {
        if (StringUtils.isEmpty((String)sourceStr)) {
            return sourceStr;
        }
        if (sourceStr.contains("'")) {
            sourceStr = sourceStr.replaceAll("'", "'");
        }
        return sourceStr;
    }
}

