/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage.log;

import com.kingdee.util.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public abstract class BizManageLoggerUtil {
    public static Logger getLogger(String logName) {
        if (StringUtils.isEmpty((String)logName)) {
            logName = "bizmessage";
        }
        Logger logger = Logger.getLogger((String)logName);
        logger.removeAllAppenders();
        logger.setLevel(Level.INFO);
        logger.setAdditivity(true);
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayout layout = new PatternLayout();
        String conversionPattern = "[%d %p %t]%m%n";
        layout.setConversionPattern(conversionPattern);
        appender.setLayout((Layout)layout);
        String sysPath = System.getProperty("EAS_HOME") + "/server/profiles/" + System.getProperty("EAS_INSTANCE_NAME");
        appender.setFile(sysPath + "/logs/shrbizmanage/" + logName + ".log");
        appender.setEncoding("UTF-8");
        appender.setAppend(true);
        appender.activateOptions();
        logger.addAppender((Appender)appender);
        return logger;
    }

    public static Logger getLogger() {
        String logName = "bizmessage";
        Logger logger = Logger.getLogger((String)logName);
        logger.removeAllAppenders();
        logger.setLevel(Level.INFO);
        logger.setAdditivity(true);
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayout layout = new PatternLayout();
        String conversionPattern = "%n[%d{MMdd HH:mm:ss} %p %t %F %M %L]%m";
        layout.setConversionPattern(conversionPattern);
        appender.setLayout((Layout)layout);
        String sysPath = System.getProperty("EAS_HOME") + "/server/profiles/" + System.getProperty("EAS_INSTANCE_NAME");
        appender.setFile(sysPath + "/logs/shrbizmanage/" + logName + ".log");
        appender.setEncoding("UTF-8");
        appender.setMaxBackupIndex(10);
        appender.setMaxFileSize("10MB");
        appender.setAppend(true);
        appender.activateOptions();
        logger.addAppender((Appender)appender);
        return logger;
    }
}

