/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.bizmanage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.bizmanage.BizManageTypeInfo;
import com.kingdee.shr.base.bizmanage.BizmanageBizException;
import com.kingdee.shr.base.bizmanage.ISHRBizManageMsgManage;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class SHRBizManageMsgManageFactory {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.bizmanage.SHRBizManageMsgManageFactory");

    private SHRBizManageMsgManageFactory() {
    }

    public static ISHRBizManageMsgManage getInstance(Context ctx, String bizManageTypeId, int type) throws EASBizException, BOSException {
        BizManageTypeInfo info = new BizManageTypeInfo();
        if (type == 0) {
            info = SHRBizManageCommonTool.getPersonBizManageTypeInfo(ctx, bizManageTypeId);
        } else if (type == 1) {
            info = SHRBizManageCommonTool.getOrgBizManageTypeInfo(ctx, bizManageTypeId);
        }
        if (info == null) {
            logger.error((Object)("---------SHRBizManageMsgManageFactory.getInstance()------->BizManageTypeInfo is null :" + bizManageTypeId + " type:" + type + "<-------------------"));
            return null;
        }
        String className = info.getCnBizClassFullName();
        if (StringUtils.isEmpty((String)className)) {
            logger.error((Object)("---------SHRBizManageMsgManageFactory.getInstance()------->CnBizClassFullName is null :" + bizManageTypeId + " type:" + type + "<------------------"));
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className.trim());
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (ISHRBizManageMsgManage)constructor.newInstance(bizManageTypeId);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BizmanageBizException(BizmanageBizException.NOT_FIND_CLASS, new Object[]{className.trim()})));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BizmanageBizException(BizmanageBizException.NOT_FIND_CONTRACT_MET)));
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }
}

