/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.certificationservice.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificationSHRSqlBuilder
extends CommonSHRSqlBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CertificationSHRSqlBuilder.class);
    public static final String SELECTOR_KEY = "selector";

    protected void addSingleCondition(StructureConfigInfo clientInfo, StringBuffer sql) throws EASBizException, BOSException {
        String filterCond = clientInfo.getSingleCondition();
        if (StringUtils.isEmpty((String)filterCond)) {
            return;
        }
        sql.append(" and " + filterCond);
    }

    protected String generateOneColumn(String column, String alias) throws EASBizException, BOSException {
        String scheme = this.param.getScheme();
        String[] keys = column.split("\\.");
        StringBuffer selectColumnString = new StringBuffer();
        StructureConfigInfo configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)keys[0], (String)scheme);
        if (configInfo == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)keys[1]) && StringUtils.isEmpty((String)configInfo.getEntityName())) {
            throw new BaseConfigException(BaseConfigException.TABLENAMEANDCOLUMNNAMENULL);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("structureConfig.id", (Object)configInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)keys[1]));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("extendOptions"));
        coll.add(new SelectorItemInfo("structureConfig.id"));
        coll.add(new SelectorItemInfo("structureConfig.clientNumber"));
        view.setFilter(filter);
        view.setSelector(coll);
        StructureConfigColumnsCollection columnsCollection = StructureConfigColumnsFactory.getLocalInstance((Context)this.ctx).getStructureConfigColumnsCollection(view);
        if (columnsCollection == null || columnsCollection.size() == 0) {
            return super.generateOneColumn(column, alias);
        }
        StructureConfigColumnsInfo columnsInfo = columnsCollection.get(0);
        String extendOptions = columnsInfo.getExtendOptions();
        if (StringUtils.isEmpty((String)extendOptions)) {
            return super.generateOneColumn(column, alias);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)extendOptions);
            String SELECTOR = jsonObject.getString(SELECTOR_KEY);
            if (StringUtils.isEmpty((String)SELECTOR)) {
                return super.generateOneColumn(column, alias);
            }
            selectColumnString.append(SELECTOR).append(" ");
            selectColumnString.append(" AS ").append(this.appendQuo(alias)).append(" ");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return super.generateOneColumn(column, alias);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            return super.generateOneColumn(column, alias);
        }
        return selectColumnString.toString();
    }

    public String getSql(Context ctx, SqlParam param) throws EASBizException, BOSException {
        String sql = super.getSql(ctx, param);
        logger.error("CertificationSHRSqlBuilder getSql sql : " + sql);
        return sql;
    }
}

