/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.dto.v2;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import shaded.org.apache.parquet.Strings;

public class AdjustSalaryItemDTO {
    private static Logger logger = Logger.getLogger(AdjustSalaryItemDTO.class);

    public static Set<String> getSubmitItemPresetIds(Context ctx) {
        HashSet<String> idSet = new HashSet<String>();
        String sql = " SELECT FID FROM T_HR_AdjustSalaryItem where FIsSysPreset=1 ";
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    idSet.add(iRowSet.getString("FID"));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }

    public static Set<String> getSubmitItemIdsByState(Context ctx, BaseItemStateEnum stateEnum) {
        HashSet<String> idSet = new HashSet<String>();
        String sql = " SELECT FID FROM T_HR_AdjustSalaryItem where FState=" + stateEnum.getValue();
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    idSet.add(iRowSet.getString("FID"));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }

    public static Map<String, Object> getReferenceItemInfo(String billIdWithComm, Context ctx) {
        String billInSql = CmpStrUtil.buildInSql((String)billIdWithComm);
        String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        StringBuffer checkSqlBuf = new StringBuffer();
        checkSqlBuf.append(" SELECT css.FAdjustSalaryItemID as ITEMID, ssi.Fname_").append(l).append(" as ITEMNAME, ss.Fname_").append(l).append(" as SBNAME ");
        checkSqlBuf.append(" FROM T_HR_SBatchAdjustRuleItem css ");
        checkSqlBuf.append(" inner join T_HR_ScalsubmitScheme ss on ss.Fid=css.FCalSubmitSchemeID ");
        checkSqlBuf.append(" inner join T_HR_AdjustSalaryItem ssi on ssi.fid=css.FAdjustSalaryItemID ");
        checkSqlBuf.append(" where css.FAdjustSalaryItemID in ");
        checkSqlBuf.append(billInSql);
        checkSqlBuf.append(" order by  css.FAdjustSalaryItemID,css.FCalSubmitSchemeID ");
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)checkSqlBuf.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        HashMap<String, String> itemInfoMap = null;
        if (iRowSet != null) {
            try {
                while (iRowSet.next()) {
                    String itemId = iRowSet.getString("ITEMID");
                    String itemName = iRowSet.getString("ITEMNAME");
                    String sbName = iRowSet.getString("SBNAME");
                    itemInfoMap = (HashMap<String, String>)itemMap.get(itemId);
                    if (itemInfoMap == null) {
                        itemInfoMap = new HashMap<String, String>();
                        itemInfoMap.put("ITEMNAME", itemName);
                        itemInfoMap.put("SCHEMENAME", sbName);
                        itemMap.put(itemId, itemInfoMap);
                        continue;
                    }
                    String schemeNames = (String)itemInfoMap.get("SCHEMENAME");
                    itemInfoMap.put("SCHEMENAME", schemeNames + "\u3001" + sbName);
                    itemMap.put(itemId, itemInfoMap);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return itemMap;
    }

    public static ArrayList<String> checkIsRefSameCmpItem(String cmpItemID, String adjustSalaryItemID, Context ctx) {
        StringBuffer checkSqlBuf = new StringBuffer();
        ArrayList<String> schemeNameList = new ArrayList<String>();
        checkSqlBuf.append(" select count(ruleItem.FCalSubmitSchemeID) ,ruleItem.FCalSubmitSchemeID schemeId from T_HR_SBatchAdjustRuleItem ruleItem  ");
        checkSqlBuf.append(" inner join T_HR_AdjustSalaryItem adj on ruleItem.FAdjustSalaryItemID = adj.fid   ");
        checkSqlBuf.append("where adj.FCmpItemID='").append(cmpItemID).append("' and adj.fid !='").append(adjustSalaryItemID).append("' ");
        checkSqlBuf.append(" and ruleItem.FCalSubmitSchemeID in ( ");
        checkSqlBuf.append(" select ruleItem.FCalSubmitSchemeID from T_HR_SBatchAdjustRuleItem ruleItem  ");
        checkSqlBuf.append(" inner join T_HR_AdjustSalaryItem adj on ruleItem.FAdjustSalaryItemID = adj.fid  ");
        checkSqlBuf.append("  where  adj.fid='").append(adjustSalaryItemID).append("'  ) ");
        checkSqlBuf.append(" group by ruleItem.FCalSubmitSchemeID  having count(1) > 0 ");
        HashSet<String> schemeIdSet = new HashSet<String>();
        try {
            CalSubmitSchemeCollection schemeCollection;
            IRowSet iRowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)checkSqlBuf.toString());
            while (iRowSet.next()) {
                schemeIdSet.add(iRowSet.getString("schemeId"));
            }
            if (!schemeIdSet.isEmpty() && (schemeCollection = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeCollection("select name,id where id in ('" + Strings.join(schemeIdSet, (String)"','") + "')")) != null && schemeCollection.size() > 0) {
                int size = schemeCollection.size();
                for (int i = 0; i < size; ++i) {
                    schemeNameList.add(schemeCollection.get(i).getName());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return schemeNameList;
    }

    public static boolean hasApplyingItem(String adjustSalaryItemID, Context ctx) {
        String sql = "select adj.fid from T_HR_AdjustSalaryItem adj \n inner join T_HR_SBatchAdjustRuleItem ruleItem on ruleItem.FAdjustSalaryItemID = adj.fid \n inner join T_HR_SAdjustSalaryApply applyBill on ruleItem.FCalSubmitSchemeID = applyBill.FAdjustSalaryRuleID \n where adj.fid = ? and applyBill.FBillState in (0,1,2)";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{adjustSalaryItemID});
            if (iRowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean hasOnlyOneItemInCalSubmitScheme(String adjustSalaryItemID, Context ctx) {
        String sql = "SELECT ruleItem.FCalSubmitSchemeID,count(ruleItem.FAdjustSalaryItemID) FROM T_HR_SBatchAdjustRuleItem ruleItem inner join T_HR_AdjustSalaryItem salaryItem        on salaryItem.fid =ruleItem.FAdjustSalaryItemID  inner join T_HR_SCalSubmitScheme scheme        on scheme.fid =ruleItem.FCalSubmitSchemeID and scheme.Fstate =1 where ruleItem.FCalSubmitSchemeID in (         SELECT            tt.FCalSubmitSchemeID              FROM              T_HR_SBatchAdjustRuleItem tt           where              exists (                 select                     1                  from                      T_HR_AdjustSalaryItem t                    where                     t.FCmpItemID is not null                      and tt.FAdjustSalaryItemID = t.fid                        and t.fid =?              )           )         and salaryItem.FCmpItemID is not null     group by        ruleItem.FCalSubmitSchemeID      having count(1) = 1 ";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{adjustSalaryItemID});
            if (iRowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

