/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.cmpdesign.CobAdjustPersonPermCollection;
import com.kingdee.shr.cmpdesign.CobAdjustPersonPermFactory;
import com.kingdee.shr.cmpdesign.CobAdjustPersonPermInfo;
import com.kingdee.shr.cmpdesign.CobCmpStdDataPermFactory;
import com.kingdee.shr.cmpdesign.CobFixAdjustDataPermCollection;
import com.kingdee.shr.cmpdesign.CobFixAdjustDataPermFactory;
import com.kingdee.shr.cmpdesign.CobFixAdjustDataPermInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class AdjustPermFilter {
    public static FilterInfo getOrgRange(Context ctx, String permItemId, String adminKey, String hrKey) {
        FilterInfo filter = null;
        String adminOrgSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String hrOrgSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        StringBuilder str = new StringBuilder();
        str.append(adminKey).append(" in (").append(adminOrgSql).append(") ");
        str.append(" and ").append(hrKey).append(" in (").append(hrOrgSql).append(") ");
        String innerSql = str.toString();
        try {
            filter = new FilterInfo(innerSql);
        }
        catch (ParserException e) {
            e.printStackTrace();
            filter = new FilterInfo();
        }
        String outerSql = hrKey + " in (" + hrOrgSql + ") and useDefault = 0 ";
        try {
            filter.mergeFilter(new FilterInfo(outerSql), "OR");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filter;
    }

    public static Set<String> getAdjustPersonPermSet(Context ctx, String permItemId) throws EASBizException {
        HashSet<String> personHrSet = new HashSet<String>();
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        StringBuilder str = new StringBuilder();
        str.append(" SELECT FPERSONID, FHRORGUNITID ");
        str.append(" FROM T_HR_SAdjustPersonRecord ");
        str.append(" WHERE FHRORGUNITID IN (").append(hrRange).append(") ");
        String permFilter = AdjustPermFilter.getAdjustPersonPermFilter(ctx, permItemId, "FHRORGUNITID", "FPERSONID", true);
        if (!StringUtils.isEmpty((String)permFilter)) {
            str.append(" AND " + permFilter);
        }
        try {
            IRowSet r = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (r.next()) {
                personHrSet.add(r.getString("FPERSONID") + "_" + r.getString("FHRORGUNITID"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personHrSet;
    }

    public static String getAdjustPersonPermFilter(Context ctx, String permItemId, String hrOrgKey, String personKey, boolean historyMode) throws EASBizException {
        String sql = null;
        String scheme = "001";
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (StringUtils.isEmpty((String)personid)) {
            return null;
        }
        String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and hrOrgUnit.id in (" + hrOrgUnitRangeSQL + ")";
        CobAdjustPersonPermCollection adjustPermCollection = new CobAdjustPersonPermCollection();
        try {
            adjustPermCollection = CobAdjustPersonPermFactory.getLocalInstance(ctx).getCobAdjustPersonPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder hrOrgSb = new StringBuilder();
        if (adjustPermCollection.size() > 0) {
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("person.id", "person.id");
            sb.append("(");
            int size = adjustPermCollection.size();
            for (int i = 0; i < size; ++i) {
                CobAdjustPersonPermInfo adjustPermInfo = adjustPermCollection.get(i);
                String filterStr = adjustPermInfo.getFilter();
                if (CmpStrUtil.isEmpty((String)filterStr)) continue;
                String hrOrgId = adjustPermInfo.getHrOrgUnit().getId().toString();
                FilterInfo filterInfo = null;
                try {
                    filterInfo = new FilterInfo(filterStr);
                    hrOrgSb.append("'").append(hrOrgId).append("', ");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                sqlParam.setSelectMapping(selectMapping);
                sqlParam.setFilterInfo(filterInfo);
                sqlParam.setScheme(scheme);
                sqlParam.setNewSearch(true);
                sqlParam.setHistoryMode(historyMode);
                try {
                    sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i != 0) {
                    sb.append(" or  ");
                }
                sb.append("(").append(personKey).append(" in (").append(sql).append(") and ").append(hrOrgKey).append("='").append(hrOrgId).append("')");
                if (i != size - 1) continue;
                String hrOrgStr = hrOrgSb.substring(0, hrOrgSb.lastIndexOf(","));
                sb.append(" or  ");
                sb.append(hrOrgKey).append(" not in (").append(hrOrgStr).append(")");
            }
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getAdjustPersonPermFilterByOrg(Context ctx, String permItemId, String hrOrgId, String personKey, boolean historyMode) throws EASBizException {
        String sql = null;
        String scheme = "001";
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (StringUtils.isEmpty((String)personid)) {
            return null;
        }
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and hrOrgUnit.id in ('" + hrOrgId + "')";
        CobAdjustPersonPermCollection adjustPermCollection = new CobAdjustPersonPermCollection();
        try {
            adjustPermCollection = CobAdjustPersonPermFactory.getLocalInstance(ctx).getCobAdjustPersonPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        if (adjustPermCollection.size() > 0) {
            CobAdjustPersonPermInfo adjustPermInfo = adjustPermCollection.get(0);
            String filterStr = adjustPermInfo.getFilter();
            if (CmpStrUtil.isEmpty((String)filterStr)) {
                return null;
            }
            FilterInfo filterInfo = null;
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("person.id", "person.id");
            try {
                filterInfo = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filterInfo);
            sqlParam.setScheme(scheme);
            sqlParam.setNewSearch(true);
            sqlParam.setHistoryMode(historyMode);
            try {
                sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sb.append("(" + personKey + " in (" + sql + "))");
        }
        return sb.toString();
    }

    public static String getCmpStdPermUsableSql(Context ctx, String permItemId, boolean isDisatribute) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        StringBuilder cmpStdUsable = new StringBuilder();
        StringBuilder cmpStdPerm = new StringBuilder();
        String hroRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id in (" + hroRangeSql + ") and isCmpStdPerm = 1";
        try {
            cmpStdUsable.append(" select FID from T_HR_SCmpStandard where (FAdminOrgUnitID is null or FAdminOrgUnitID in (").append(adminRangeSql).append(")) and ");
            cmpStdPerm.append("select FBaseInfoId from T_HR_SCmpStandardRelHR where ");
            if (isDisatribute) {
                cmpStdPerm.append(" FState=100 and ");
            }
            cmpStdPerm.append(" (FHrOrgUseId in (").append(hroRangeSql).append(")");
            if (StringUtils.isEmpty((String)personId)) {
                cmpStdUsable.append("FID in (").append((CharSequence)cmpStdPerm).append("))");
                return cmpStdUsable.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CobFixAdjustDataPermCollection permColletion = CobFixAdjustDataPermFactory.getLocalInstance(ctx).getCobFixAdjustDataPermCollection(permOql);
                if (permColletion != null && permColletion.size() > 0) {
                    for (int i = 0; i < permColletion.size(); ++i) {
                        CobFixAdjustDataPermInfo adjDataPermInfo = permColletion.get(i);
                        hrBuf.append(",'").append(adjDataPermInfo.getHrOrgUnit().getId().toString()).append("'");
                    }
                }
                String permHrOrg = hrBuf.substring(1);
                cmpStdPerm.append(" and FHrOrgUseId not in (").append(permHrOrg).append(") or  FBaseInfoId in (");
                cmpStdPerm.append(" select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='");
                cmpStdPerm.append(personId).append("' and FHrOrgUnitId in (").append(permHrOrg).append(")) ");
            }
            cmpStdUsable.append("FID in (").append((CharSequence)cmpStdPerm).append("))");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdUsable.toString();
    }

    public static String getCmpStdForImportSql(Context ctx, String permItemId, boolean isDisatribute) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        StringBuilder cmpStdPerm = new StringBuilder();
        String hroRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id in (" + hroRangeSql + ") and isCmpStdPerm = 1";
        try {
            cmpStdPerm.append("select cmpStdRel.FBaseInfoId as cmpStdId,cmpStdRel.FHrOrgUseId as hrOrgId from T_HR_SCmpStandardRelHR cmpStdRel ");
            cmpStdPerm.append("left join T_HR_SCmpStandard cmpStd on cmpStd.FID=cmpStdRel.FBaseInfoId where ");
            if (isDisatribute) {
                cmpStdPerm.append(" cmpStdRel.FState=100 and ");
            }
            cmpStdPerm.append(" (cmpStdRel.FHrOrgUseId in (").append(hroRangeSql).append(")");
            if (StringUtils.isEmpty((String)personId)) {
                cmpStdPerm.append(")");
                return cmpStdPerm.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CobFixAdjustDataPermCollection permColletion = CobFixAdjustDataPermFactory.getLocalInstance(ctx).getCobFixAdjustDataPermCollection(permOql);
                if (permColletion != null && permColletion.size() > 0) {
                    for (int i = 0; i < permColletion.size(); ++i) {
                        CobFixAdjustDataPermInfo adjDataPermInfo = permColletion.get(i);
                        hrBuf.append(",'").append(adjDataPermInfo.getHrOrgUnit().getId().toString()).append("'");
                    }
                }
                String permHrOrg = hrBuf.substring(1);
                cmpStdPerm.append(" and cmpStdRel.FHrOrgUseId not in (").append(permHrOrg).append(") or  cmpStdRel.FBaseInfoId in (");
                cmpStdPerm.append(" select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='");
                cmpStdPerm.append(personId).append("' and FHrOrgUnitId in (").append(permHrOrg).append(")) ");
            }
            cmpStdPerm.append(") and (cmpStd.FAdminOrgUnitID is null or cmpStd.FAdminOrgUnitID in (").append(adminRangeSql).append("))");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdPerm.toString();
    }

    public static String getCmpStdUsableByHRO(Context ctx, String hrOrgId, boolean isDisatribute) {
        StringBuilder cmpStdPerm = new StringBuilder();
        cmpStdPerm.append("select FBaseInfoId from T_HR_SCmpStandardRelHR where FHrOrgUseId ='");
        cmpStdPerm.append(hrOrgId).append("'");
        if (isDisatribute) {
            cmpStdPerm.append(" and FState=100 ");
        }
        return "select FID from T_HR_SCmpStandard where  FID in (" + cmpStdPerm + ")";
    }

    public static String getCmpStdUsableByHRO(Context ctx, String hrOrgId, String permItemId, boolean isDisatribute) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        StringBuilder cmpStdUsable = new StringBuilder();
        cmpStdUsable.append("select FID from T_HR_SCmpStandard where ");
        StringBuilder cmpStdPerm = new StringBuilder();
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id = '" + hrOrgId + "' and isCmpStdPerm = 1";
        try {
            cmpStdPerm.append("select FBaseInfoId from T_HR_SCmpStandardRelHR where FHrOrgUseId ='");
            cmpStdPerm.append(hrOrgId).append("'");
            if (isDisatribute) {
                cmpStdPerm.append(" and FState=100 ");
            }
            if (StringUtils.isEmpty((String)personId)) {
                cmpStdUsable.append(" FID in (").append((CharSequence)cmpStdPerm).append(")");
                return cmpStdUsable.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                cmpStdPerm.append(" and FBaseInfoId in ( ");
                cmpStdPerm.append(" select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='").append(personId).append("' and FHrOrgUnitId ='").append(hrOrgId).append("')");
            }
            String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
            cmpStdUsable.append(" (FAdminOrgUnitID is null or FAdminOrgUnitID in (").append(adminRangeSql).append(")) and ");
            cmpStdUsable.append(" FID in (").append((CharSequence)cmpStdPerm).append(")");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdUsable.toString();
    }

    public static String getCmpStdPermUsableFilter(Context ctx, String permItemId, boolean isDisatribute) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        StringBuilder cmpStdPerm = new StringBuilder();
        String hroRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id in (" + hroRangeSql + ") and isCmpStdPerm = 1";
        cmpStdPerm.append(" (AdminOrg.id is null or AdminOrg.id in (").append(adminRangeSql).append(")) ");
        try {
            if (StringUtils.isEmpty((String)personId)) {
                return cmpStdPerm.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CobFixAdjustDataPermCollection permColletion = CobFixAdjustDataPermFactory.getLocalInstance(ctx).getCobFixAdjustDataPermCollection(permOql);
                if (permColletion != null && permColletion.size() > 0) {
                    cmpStdPerm.append(" and (");
                    for (int i = 0; i < permColletion.size(); ++i) {
                        CobFixAdjustDataPermInfo adjDataPermInfo = permColletion.get(i);
                        String hrOrgId = adjDataPermInfo.getHrOrgUnit().getId().toString();
                        hrBuf.append(",'").append(hrOrgId).append("'");
                        cmpStdPerm.append(" BaseInfo.id in (select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='").append(personId);
                        cmpStdPerm.append("' and FHrOrgUnitId ='").append(hrOrgId).append("') and hrOrgUse.id ='").append(hrOrgId).append("' or ");
                    }
                    String permHrOrg = hrBuf.substring(1);
                    cmpStdPerm.append(" hrOrgUse.id not in(").append(permHrOrg).append("))");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdPerm.toString();
    }

    public static String getCmpStdPermUsableFilterByHRO(Context ctx, String permItemId) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        StringBuilder cmpStdPerm = new StringBuilder();
        String hroRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id in (" + hroRangeSql + ") and isCmpStdPerm = 1";
        cmpStdPerm.append(" (AdminOrg.id is null or AdminOrg.id in (").append(adminRangeSql).append(")) ");
        try {
            if (StringUtils.isEmpty((String)personId)) {
                return cmpStdPerm.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CobFixAdjustDataPermCollection permColletion = CobFixAdjustDataPermFactory.getLocalInstance(ctx).getCobFixAdjustDataPermCollection(permOql);
                if (permColletion != null && permColletion.size() > 0) {
                    cmpStdPerm.append(" and (");
                    for (int i = 0; i < permColletion.size(); ++i) {
                        CobFixAdjustDataPermInfo adjDataPermInfo = permColletion.get(i);
                        String hrOrgId = adjDataPermInfo.getHrOrgUnit().getId().toString();
                        hrBuf.append(",'").append(hrOrgId).append("'");
                        cmpStdPerm.append(" BaseInfo.id in (select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='").append(personId);
                        cmpStdPerm.append("' and FHrOrgUnitId ='").append(hrOrgId).append("') and hrOrgUse.id ='").append(hrOrgId).append("' ");
                        if (i == permColletion.size() - 1) continue;
                        cmpStdPerm.append(" or ");
                    }
                    cmpStdPerm.append(" )");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdPerm.toString();
    }

    public static String getCmpStdPermPreventFilter(Context ctx, String permItemId) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuilder cmpStdPerm = new StringBuilder();
        if (StringUtils.isEmpty((String)personId)) {
            return cmpStdPerm.toString();
        }
        String hroRangeSql = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String adminRangeSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String permOql = "select hrOrgUnit.id where person.id='" + personId + "' and hrOrgUnit.id in (" + hroRangeSql + ") and isCmpStdPerm = 1";
        try {
            if (StringUtils.isEmpty((String)personId)) {
                return cmpStdPerm.toString();
            }
            boolean isDataPerm = CobFixAdjustDataPermFactory.getLocalInstance(ctx).exists(permOql);
            if (isDataPerm) {
                StringBuilder hrBuf = new StringBuilder();
                CobFixAdjustDataPermCollection permColletion = CobFixAdjustDataPermFactory.getLocalInstance(ctx).getCobFixAdjustDataPermCollection(permOql);
                if (permColletion != null && permColletion.size() > 0) {
                    for (int i = 0; i < permColletion.size(); ++i) {
                        CobFixAdjustDataPermInfo adjDataPermInfo = permColletion.get(i);
                        String hrOrgId = adjDataPermInfo.getHrOrgUnit().getId().toString();
                        hrBuf.append(",'").append(hrOrgId).append("'");
                        cmpStdPerm.append(" hrOrgUnit.id = '").append(hrOrgId).append("' and ");
                        cmpStdPerm.append(" (id in (select FCmpStandardId from T_HR_SCobCmpStdDataPerm where FPersonId='").append(personId).append("'");
                        cmpStdPerm.append(" and FIsEdit=1 and FHrOrgUnitId  ='").append(hrOrgId).append("') ");
                        cmpStdPerm.append(" or (creator='").append(userId).append("' and hrOrgUnit.id in (").append(hroRangeSql).append(")");
                        cmpStdPerm.append(" and (adminOrgUnit.id is null or adminOrgUnit.id in (").append(adminRangeSql).append(")))) or ");
                    }
                }
                String permHrOrg = hrBuf.substring(1);
                cmpStdPerm.append(" hrOrgUnit.id not in(").append(permHrOrg).append(") and ");
                cmpStdPerm.append(" (adminOrgUnit.id is null or adminOrgUnit.id in (").append(adminRangeSql).append("))");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return cmpStdPerm.toString();
    }

    public static boolean isCmpStdDataPerm(Context ctx, String hrOrgRange) {
        boolean isDataPerm = false;
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String permOql = "select * where person.id='" + personId + "' and hrOrgUnit.id in (" + hrOrgRange + ")";
        try {
            if (StringUtils.isEmpty((String)personId)) {
                return isDataPerm;
            }
            isDataPerm = CobCmpStdDataPermFactory.getLocalInstance(ctx).exists(permOql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return isDataPerm;
    }

    public static String getFixAdjustPermQueryFilter(Context ctx, String personId, String hrOrgId) {
        String queryFilter = "";
        String permOql = "select * where person.id = '" + personId + "' and hrOrgUnit.id='" + hrOrgId + "'";
        try {
            if (StringUtils.isEmpty((String)personId)) {
                return queryFilter;
            }
            CobAdjustPersonPermCollection cobAdjustPersonPermCol = CobAdjustPersonPermFactory.getLocalInstance(ctx).getCobAdjustPersonPermCollection(permOql);
            if (cobAdjustPersonPermCol != null && cobAdjustPersonPermCol.size() > 0) {
                CobAdjustPersonPermInfo fixAdjustPermInfo = cobAdjustPersonPermCol.get(0);
                queryFilter = fixAdjustPermInfo.getQueryfilter();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return queryFilter;
    }
}

