/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryFactory;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustFacadeFactory;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.IBudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetadjustEntryValidateHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetAdjustEntryHelper {
    private static Logger logger = Logger.getLogger(BudgetAdjustEntryHelper.class);
    private IBudgetAdjustService service = new BudgetAdjustService();
    private Context ctx = null;
    private String billId = null;
    private List<String> budgetItemFields = null;
    private List<String> budgetItemFieldSn = null;
    private List<String> budgetPeriodColNames = null;
    private List<String> budgetPeriodFields = null;
    private Map<String, Integer> dataTypeMap = null;
    private CmpBudgetSchemeInfo budgetScheme = null;
    private BudgetadjustEntryValidateHelper validateHelper = null;
    private BudgetItemMapInfo itemMap = null;
    private BudgetPeriodMapInfo subItemMap = null;
    private Map<String, String> uniqueEntryMap = new HashMap<String, String>();
    private Set<String> entryIdSet = null;
    private Set<String> subEntryIdSet = null;
    private Map<String, Object> entryMap = null;
    private Map<String, Object> newEntryIdMap = new HashMap<String, Object>();

    public void initEntryMap(Context ctx, String billId) throws BOSException {
        this.entryMap = new HashMap<String, Object>();
        BudgetAdjustEntryCollection entryCol = BudgetAdjustEntryFactory.getLocalInstance((Context)ctx).getBudgetAdjustEntryCollection("select id, adminOrgUnit.id, costType.id where bill.id= '" + billId + "'");
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            String entryId = entryInfo.getId().toString();
            String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entryInfo);
            this.entryMap.put(entryKey, entryId);
        }
    }

    public void initEntryIdsAndSubEntryIds(Context ctx, String billId) throws BOSException, SQLException {
        String queryEntrySql = "select fid from T_HR_SBudgetAdjustEntry where FBillId = ?";
        this.entryIdSet = new HashSet<String>();
        IRowSet entryRs = DbUtil.executeQuery((Context)ctx, (String)queryEntrySql, (Object[])new Object[]{billId});
        while (entryRs.next()) {
            this.entryIdSet.add(entryRs.getString("fid"));
        }
        String querySubEntrySql = "select fid from T_HR_SSubBudgetAdjustEntry where FBillId = ?";
        this.subEntryIdSet = new HashSet<String>();
        IRowSet subEntryRs = DbUtil.executeQuery((Context)ctx, (String)querySubEntrySql, (Object[])new Object[]{billId});
        while (subEntryRs.next()) {
            this.subEntryIdSet.add(subEntryRs.getString("fid"));
        }
    }

    public BudgetAdjustEntryHelper(Context ctx, String billId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.billId = billId;
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        this.budgetScheme = billInfo.getBudgetScheme();
        String budgetSchemeId = this.budgetScheme.getId().toString();
        BudgetItemMapInfo itemMap = this.service.getItemMapByScheme(ctx, budgetSchemeId);
        this.budgetItemFields = itemMap.getColNameAllList();
        if (this.service.hasSubEntry(this.budgetScheme)) {
            BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, this.budgetScheme);
            this.budgetPeriodColNames = subItemMap.getColNameList();
            this.budgetPeriodFields = subItemMap.getFieldNameList();
        }
        this.initEntryMap(ctx, billId);
        this.validateHelper = new BudgetadjustEntryValidateHelper(ctx, this.budgetScheme);
    }

    public BudgetAdjustEntryHelper(Context ctx, String billId, boolean notValid) throws EASBizException, BOSException, SQLException {
        this.ctx = ctx;
        this.billId = billId;
        BudgetAdjustBillInfo billInfo = this.service.getBillInfo(ctx, billId);
        this.budgetScheme = billInfo.getBudgetScheme();
        String budgetSchemeId = this.budgetScheme.getId().toString();
        BudgetItemMapInfo itemMap = this.service.getItemMapByScheme(ctx, budgetSchemeId);
        this.budgetItemFields = itemMap.getColNameAllList();
        if (this.service.hasSubEntry(this.budgetScheme)) {
            BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, this.budgetScheme);
            this.budgetPeriodColNames = subItemMap.getColNameList();
            this.budgetPeriodFields = subItemMap.getFieldNameList();
        }
        this.initEntryMap(ctx, billId);
        if (!notValid) {
            this.validateHelper = new BudgetadjustEntryValidateHelper(ctx, this.budgetScheme, billId);
        }
    }

    public BudgetAdjustEntryHelper(Context ctx, String billId, BudgetItemMapInfo itemMap, BudgetPeriodMapInfo subItemMap) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.billId = billId;
        if (itemMap != null) {
            this.budgetItemFields = itemMap.getColNameAllList();
        }
        if (subItemMap != null) {
            this.budgetPeriodColNames = subItemMap.getColNameList();
            this.budgetPeriodFields = subItemMap.getFieldNameList();
        }
        this.initEntryMap(ctx, billId);
    }

    public BudgetAdjustEntryHelper(Context ctx, String billId, CmpBudgetSchemeInfo budgetScheme, BudgetadjustEntryValidateHelper validateHelper) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.billId = billId;
        this.budgetScheme = budgetScheme;
        if (this.budgetScheme == null || budgetScheme.getId() == null) {
            return;
        }
        String budgetSchemeId = budgetScheme.getId().toString();
        BudgetItemMapInfo itemMap = this.service.getItemMapByScheme(ctx, budgetSchemeId);
        this.budgetItemFields = itemMap.getColNameAllList();
        if (this.service.hasSubEntry(budgetScheme)) {
            BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, budgetScheme);
            this.budgetPeriodColNames = subItemMap.getColNameList();
            this.budgetPeriodFields = subItemMap.getFieldNameList();
        }
        this.initEntryMap(ctx, billId);
        this.validateHelper = validateHelper;
    }

    public BudgetAdjustEntryHelper(Context ctx, String billId, CmpBudgetSchemeInfo budgetScheme) throws BOSException {
        this.ctx = ctx;
        this.billId = billId;
        if (budgetScheme == null || budgetScheme.getId() == null) {
            return;
        }
        this.itemMap = this.service.getItemMapByScheme(ctx, budgetScheme.getId().toString());
        this.budgetItemFieldSn = this.itemMap.getFieldSnList();
        this.dataTypeMap = this.itemMap.getItemDataTypeMap();
        if (this.service.hasSubEntry(budgetScheme)) {
            this.subItemMap = this.service.getSubItemMapByScheme(ctx, budgetScheme);
            this.budgetPeriodColNames = this.subItemMap.getColNameList();
            this.budgetPeriodFields = this.subItemMap.getFieldNameList();
        }
        this.initEntryMap(ctx, billId);
    }

    public BudgetadjustEntryValidateHelper getValidateHelper() {
        return this.validateHelper;
    }

    public void setValidateHelper(BudgetadjustEntryValidateHelper validateHelper) {
        this.validateHelper = validateHelper;
    }

    public BudgetItemMapInfo getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(BudgetItemMapInfo itemMap) {
        this.itemMap = itemMap;
    }

    public BudgetPeriodMapInfo getSubItemMap() {
        return this.subItemMap;
    }

    public void setSubItemMap(BudgetPeriodMapInfo subItemMap) {
        this.subItemMap = subItemMap;
    }

    public void saveData(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol) throws BOSException, EASBizException {
        if (this.validateHelper != null) {
            this.validateHelper.saveEntryValid(entryCol, subEntryCol, this.budgetPeriodColNames);
            this.uniqueEntryMap = this.validateHelper.assembleUniqueEntryMap();
        }
        try {
            this.initEntryIdsAndSubEntryIds(this.ctx, this.billId);
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        this.saveEntryData(entryCol);
        if (this.service.hasSubEntry(this.budgetScheme)) {
            this.saveSubEntryData(subEntryCol);
        }
    }

    public void deleteEntryAndsaveData(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol) throws BOSException, EASBizException {
        if (this.validateHelper != null) {
            this.validateHelper.saveEntryValid(entryCol, subEntryCol, this.budgetPeriodColNames);
            this.uniqueEntryMap = this.validateHelper.assembleUniqueEntryMap();
        }
        this.deleteEntryAndSubEntryData(this.billId, entryCol);
        try {
            this.initEntryIdsAndSubEntryIds(this.ctx, this.billId);
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        this.saveEntryData(entryCol);
        if (this.service.hasSubEntry(this.budgetScheme)) {
            this.saveSubEntryData(subEntryCol);
        }
    }

    public void deleteEntryAndSubEntryData(String billId, BudgetAdjustEntryCollection entryCol) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)billId) || entryCol == null) {
            return;
        }
        HashSet<String> entrySet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entryCol.get(i));
            entrySet.add(entryKey);
        }
        ArrayList<String> delEntryIds = new ArrayList<String>();
        if (this.entryMap != null) {
            for (Map.Entry entry : this.entryMap.entrySet()) {
                if (entrySet.contains(entry.getKey())) continue;
                delEntryIds.add(entry.getValue().toString());
            }
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("entryIds", StringUtils.join(delEntryIds, (String)","));
        BudgetAdjustFacadeFactory.getLocalInstance((Context)this.ctx).deleteEntryAndSubEntryData(billId, param);
    }

    public String saveEntryData(BudgetAdjustEntryCollection entryCol) throws BOSException, BudgetEASBizException, EASBizException {
        return this.saveEntryData(entryCol, this.budgetItemFields);
    }

    public String saveEntryData(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields) throws BOSException, BudgetEASBizException, EASBizException {
        Object entryId;
        Object costTypeId;
        Object adminOrgId;
        if (entryCol == null || entryCol.isEmpty() || budgetItemFields == null) {
            return null;
        }
        ArrayList<Object[]> batchInsertEntryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> batchUpdateEntryParams = new ArrayList<Object[]>();
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entry = entryCol.get(i);
            String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entry);
            if (StringUtils.isEmpty((CharSequence)entryKey)) continue;
            this.handleMultiFields(entry);
            if (this.validateHelper != null) {
                if (this.uniqueEntryMap.containsKey(entryKey)) {
                    String entryId2 = this.uniqueEntryMap.get(entryKey);
                    if (StringUtils.isEmpty((CharSequence)entryId2)) continue;
                    entry.setId(BOSUuid.read((String)entryId2));
                    batchUpdateEntryParams.add(BudgetAdjustSqlUtils.assembleUpdateEntryParam(this.billId, entry, budgetItemFields).toArray());
                    continue;
                }
                this.uniqueEntryMap.put(entryKey, null);
                batchInsertEntryParams.add(BudgetAdjustSqlUtils.assembleInsertEntryParam(this.billId, entry, budgetItemFields).toArray());
                continue;
            }
            if (entry.getId() != null && (this.entryIdSet == null || this.entryIdSet.contains(entry.getId().toString()))) {
                batchUpdateEntryParams.add(BudgetAdjustSqlUtils.assembleUpdateEntryParam(this.billId, entry, budgetItemFields).toArray());
                continue;
            }
            batchInsertEntryParams.add(BudgetAdjustSqlUtils.assembleInsertEntryParam(this.billId, entry, budgetItemFields).toArray());
        }
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleInsertEntrySql(budgetItemFields), batchInsertEntryParams);
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleUpdateEntrySql(budgetItemFields), batchUpdateEntryParams);
        if (!batchInsertEntryParams.isEmpty()) {
            for (Object[] params : batchInsertEntryParams) {
                adminOrgId = params[3];
                costTypeId = params[4];
                if (adminOrgId == null || costTypeId == null) continue;
                entryId = params[0];
                this.newEntryIdMap.put(adminOrgId + "_" + costTypeId, entryId);
            }
        }
        if (!batchUpdateEntryParams.isEmpty()) {
            for (Object[] params : batchUpdateEntryParams) {
                adminOrgId = params[0];
                costTypeId = params[1];
                if (adminOrgId == null || costTypeId == null) continue;
                entryId = params[params.length - 1];
                this.newEntryIdMap.put(adminOrgId.toString() + "_" + costTypeId.toString(), entryId);
            }
        }
        return null;
    }

    public void handleMultiFields(BudgetAdjustEntryInfo entry) {
        if (StringUtils.isEmpty((CharSequence)entry.getDescription(LocaleUtils.locale_l1))) {
            entry.setDescription(entry.getDescription(LocaleUtils.locale_l2), LocaleUtils.locale_l1);
        }
    }

    public String updateEntryData(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields) throws BOSException {
        if (entryCol == null || entryCol.isEmpty() || budgetItemFields == null) {
            return null;
        }
        ArrayList<Object[]> batchUpdateEntryParams = new ArrayList<Object[]>();
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entry = entryCol.get(i);
            if (entry.getId() == null) continue;
            batchUpdateEntryParams.add(BudgetAdjustSqlUtils.assembleUpdateEntryParamFromManage(this.billId, entry, budgetItemFields).toArray());
        }
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleUpdateEntrySqlFromManage(budgetItemFields), batchUpdateEntryParams);
        return null;
    }

    public String saveSubEntryData(SubBudgetAdjustEntryCollection subEntryCol, List<String> budgetPeriodColNames, List<String> budgetPeriodFields) throws BOSException, EASBizException {
        if (subEntryCol == null || subEntryCol.isEmpty() || budgetPeriodColNames == null) {
            return null;
        }
        ArrayList<Object[]> batchInsertSubEntryParams = new ArrayList<Object[]>();
        ArrayList<Object[]> batchUpdateSubEntryParams = new ArrayList<Object[]>();
        for (int i = 0; i < subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entry = subEntryCol.get(i);
            if (entry.getId() != null && (this.subEntryIdSet == null || this.subEntryIdSet.contains(entry.getId().toString()))) {
                batchUpdateSubEntryParams.add(BudgetAdjustSqlUtils.assembleUpdateSubEntryParam(entry, budgetPeriodColNames).toArray());
                continue;
            }
            if (entry.getYearBudgetEntry() != null) {
                batchInsertSubEntryParams.add(BudgetAdjustSqlUtils.assembleInsertSubEntryParam(this.billId, entry, budgetPeriodColNames).toArray());
                continue;
            }
            batchInsertSubEntryParams.add(BudgetAdjustSqlUtils.assembleInsertSubEntryParam(this.billId, entry, this.newEntryIdMap, budgetPeriodColNames).toArray());
        }
        this.deleteSubEntryBeforeInsertData(batchInsertSubEntryParams);
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleInsertSubEntrySql(budgetPeriodFields), batchInsertSubEntryParams);
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleUpdateSubEntrySql(budgetPeriodFields), batchUpdateSubEntryParams);
        return null;
    }

    public String updateSubEntryData(SubBudgetAdjustEntryCollection subEntryCol, List<String> budgetPeriodColNames, List<String> budgetPeriodFields) throws BOSException, EASBizException {
        if (subEntryCol == null || subEntryCol.isEmpty() || budgetPeriodColNames == null) {
            return null;
        }
        ArrayList<Object[]> batchUpdateSubEntryParams = new ArrayList<Object[]>();
        for (int i = 0; i < subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entry = subEntryCol.get(i);
            if (entry.getId() == null) continue;
            batchUpdateSubEntryParams.add(BudgetAdjustSqlUtils.assembleUpdateSubEntryParamFromSubManage(entry, budgetPeriodColNames).toArray());
        }
        this.executeBatchSql(this.ctx, BudgetAdjustSqlUtils.assembleUpdateSubEntrySqlFromSubManage(budgetPeriodFields), batchUpdateSubEntryParams);
        return null;
    }

    public void deleteSubEntryBeforeInsertData(List<Object[]> insertParam) throws BOSException {
        if (insertParam == null || insertParam.isEmpty()) {
            return;
        }
        HashSet<String> entryIds = new HashSet<String>();
        for (int i = 0; i < insertParam.size(); ++i) {
            Object entryId = insertParam.get(i)[7];
            if (entryId == null) continue;
            entryIds.add(entryId.toString());
        }
        this.service.deleteSubEntryByEntryIds(this.ctx, entryIds);
    }

    public String saveSubEntryData(SubBudgetAdjustEntryCollection subEntryCol) throws BOSException, EASBizException {
        return this.saveSubEntryData(subEntryCol, this.budgetPeriodColNames, this.budgetPeriodFields);
    }

    public void executeBatchSql(Context ctx, String executeSql, List<Object[]> executeParams) throws BOSException {
        if (!executeParams.isEmpty() && !StringUtils.isEmpty((CharSequence)executeSql)) {
            CmpSQLUtil.executeBatch(ctx, executeSql, executeParams);
        }
    }

    public BudgetAdjustEntryCollection assembleEntryCol() throws BOSException, SQLException {
        if (this.budgetItemFieldSn == null || this.budgetItemFieldSn.isEmpty() || this.dataTypeMap == null) {
            return null;
        }
        String queryEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustEntrySql(this.ctx, this.budgetItemFieldSn, " where FBillId = ?");
        IRowSet entryRs = DbUtil.executeQuery((Context)this.ctx, (String)queryEntrySql.toString(), (Object[])new Object[]{this.billId});
        BudgetAdjustEntryCollection entryCol = BudgetAdjustSqlUtils.assembleNewEntryColByBillId(this.ctx, this.budgetItemFieldSn, entryRs, this.dataTypeMap);
        return entryCol;
    }

    public SubBudgetAdjustEntryCollection assembleSubEntryCol(boolean updateHis) throws BOSException, SQLException {
        if (this.budgetPeriodFields == null || this.budgetPeriodFields.isEmpty() || this.budgetPeriodColNames == null || this.budgetPeriodColNames.isEmpty()) {
            return null;
        }
        SubBudgetAdjustEntryCollection subEntryCol = null;
        if (updateHis) {
            String querySubEntrySql = BudgetAdjustSqlUtils.queryBudgetAdjustSubEntryHisSql(this.budgetPeriodFields, this.budgetPeriodColNames, "where subentry.FbillId = ?");
            IRowSet subEntryRs = DbUtil.executeQuery((Context)this.ctx, (String)querySubEntrySql, (Object[])new Object[]{this.billId});
            subEntryCol = BudgetAdjustSqlUtils.assembleNewSubEntryColByBillId(this.budgetPeriodColNames, subEntryRs);
        } else {
            subEntryCol = BudgetAdjustSqlUtils.queryAndAssembleSubEntryColByBill(this.ctx, this.billId, this.budgetPeriodColNames, this.budgetPeriodFields, "where subentry.FBillId = ?");
        }
        return subEntryCol;
    }
}

