/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.combine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.calculate.combine.ICombineData;
import com.kingdee.shr.compensation.calculate.combine.calData.CmpQueryConfigEmunService;
import com.kingdee.shr.compensation.calculate.combine.calData.CmpQueryConfigService;
import com.kingdee.shr.compensation.calculate.combine.calData.EnumNameAndValueMap;
import com.kingdee.shr.compensation.calculate.model.ColumnAttribute;
import com.kingdee.shr.compensation.calculate.model.DataTable;
import com.kingdee.shr.compensation.calculate.model.ICell;
import com.kingdee.shr.compensation.calculate.model.IRow;
import com.kingdee.shr.compensation.calculate.model.ITable;
import com.kingdee.shr.compensation.calculate.model.StructureAttribute;
import com.kingdee.shr.compensation.calculate.thread.CalInitData;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.util.StringUtils;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AbstractCombineData
implements ICombineData {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.calculate.combine.AbstractCombineData");
    protected Map<String, StructureAttribute> structureMap;
    protected Map<String, String> clientNumberAndTableMap;
    protected CalInitData initData;
    protected Map<String, EnumNameAndValueMap> enumMap;
    protected int calKeyIndex = 0;
    protected Map<String, Map<String, PropertyInfo>> propertysMap;

    public AbstractCombineData(CalInitData initData) {
        this.initData = initData;
    }

    @Override
    public ITable getInitData(List<CalFormulaInfo> formulaList) throws Exception {
        String sql = null;
        this.propertysMap = CmpQueryConfigService.getCalProperties(this.initData.getCtx());
        this.clientNumberAndTableMap = CmpQueryConfigService.getClientAndTableMap(this.initData.getCtx());
        this.enumMap = CmpQueryConfigEmunService.getEnumProperty(this.initData.getCtx());
        this.structureMap = this.combineTableItems(formulaList);
        try {
            sql = this.buildDataSetSql();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ITable dataTable = this.combineTableData(sql);
        return dataTable;
    }

    public String afterGetSql(String sql) throws BOSException {
        return sql;
    }

    protected Map<String, StructureAttribute> combineTableItems(List<CalFormulaInfo> formulaList) {
        String clientNumber;
        this.structureMap = new HashMap<String, StructureAttribute>();
        String[] item = null;
        String[] items = null;
        for (int i = 0; i < formulaList.size(); ++i) {
            String listItems = formulaList.get(i).getListItem();
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                String column = item[2].toUpperCase();
                String tableName = item[1].toUpperCase();
                clientNumber = "CMP_CTB";
                if (item.length > 3 && !this.propertysMap.containsKey(clientNumber = item[3].toUpperCase()) || !tableName.toUpperCase().equals("T_HR_SCMPCALTABLE") && clientNumber.equals("CMP_CTB")) continue;
                if (this.structureMap.containsKey(clientNumber)) {
                    this.structureMap.get(clientNumber).addColumn(column);
                    continue;
                }
                StructureAttribute structure = new StructureAttribute(tableName, clientNumber);
                structure.addColumn(column);
                this.structureMap.put(clientNumber, structure);
            }
        }
        if (!StringUtils.isEmpty((String)this.mustSelectColumns())) {
            String[] columnArr;
            for (String s : columnArr = this.mustSelectColumns().split(",")) {
                clientNumber = s.split("\\.")[0].toUpperCase();
                String field = s.split("\\.")[1].toUpperCase();
                if (this.structureMap.containsKey(clientNumber)) {
                    this.structureMap.get(clientNumber).addColumn(field);
                    continue;
                }
                StructureAttribute structure = new StructureAttribute(this.clientNumberAndTableMap.get(clientNumber), clientNumber);
                structure.addColumn(field);
                this.structureMap.put(clientNumber, structure);
            }
        }
        return this.structureMap;
    }

    protected String buildDataSetSql() throws Exception {
        FilterInfo filter = new FilterInfo(this.initData.getClientNumber() + ".id in (" + this.initData.getFilterSql() + ")");
        SqlParam sqlParam = new SqlParam();
        Map<String, String> selectMapping = this.buildSelector();
        if (selectMapping.size() < 1) {
            return null;
        }
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setScheme(this.initData.getScheme());
        sqlParam.setSortStr(this.initData.getClientNumber() + ".id");
        sqlParam.setFilterDate(this.initData.getSchemeInfo().getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)this.initData.getCtx(), (SqlParam)sqlParam);
        return sql;
    }

    protected Map<String, String> buildSelector() throws Exception {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        for (Map.Entry<String, StructureAttribute> entry : this.structureMap.entrySet()) {
            StructureAttribute structureAttr = entry.getValue();
            if (!structureAttr.isStructure()) continue;
            String strucNum = structureAttr.getClientNumber();
            List<String> clumnList = structureAttr.getColumns();
            for (int i = 0; i < clumnList.size(); ++i) {
                String dbColumn = clumnList.get(i);
                if (selectMapping.containsKey(strucNum + "." + dbColumn)) continue;
                String field = strucNum.equals("CMP_CTB") && null == this.propertysMap.get(strucNum).get(dbColumn) ? dbColumn : this.propertysMap.get(strucNum).get(dbColumn).getName();
                selectMapping.put(strucNum + "." + field, strucNum + "." + dbColumn);
            }
        }
        this.addColumnToSelectMapping(selectMapping);
        return selectMapping;
    }

    public void addColumnToSelectMapping(Map<String, String> selectMapping) {
    }

    protected ITable combineTableData(String sql) throws Exception {
        HashSet<String> personSet = new HashSet<String>();
        DataTable tableData = new DataTable();
        String personId = null;
        if (StringUtils.isEmpty((String)sql)) {
            return tableData;
        }
        List<IRowSet> rowSets = this.executeQueryPaging(this.initData.getCtx(), sql);
        ArrayList<ColumnAttribute> columnsList = this.generateColumns(rowSets.get(0).getMetaData());
        int count = 0;
        for (IRowSet rowSet : rowSets) {
            while (rowSet.next()) {
                IRow dataRow = tableData.createRow(count);
                for (int i = 0; i < columnsList.size(); ++i) {
                    ICell cell = dataRow.createCell(i);
                    ColumnAttribute columnAttribute = columnsList.get(i);
                    Object value = rowSet.getObject(i + 1);
                    String columnName = (columnAttribute.getTable().getClientNumber() + "_" + columnAttribute.getName().split("\\.")[1]).toUpperCase();
                    if (columnName.equalsIgnoreCase("CMP_PERSON_ID")) {
                        personId = value.toString();
                    }
                    if (columnAttribute.getDataType() == 40) {
                        cell.setCellValue(CmpDateUtil.toDate(value));
                        continue;
                    }
                    if (null != value && !StringUtils.isEmpty((String)value.toString()) && this.enumMap.containsKey(columnName)) {
                        value = this.enumMap.get(columnName).getValue(value.toString());
                    }
                    cell.setCellValue(value);
                    this.afterAddCellData(cell, columnName, value);
                }
                if (personSet.contains(personId)) continue;
                personSet.add(personId);
                this.afterAddStructureRow(dataRow);
                ++count;
                tableData.addRow(dataRow);
            }
        }
        tableData.setColumns(columnsList);
        return tableData;
    }

    public void afterAddStructureRow(IRow dataRow) {
    }

    public void afterAddCellData(ICell cell, String columnName, Object value) {
    }

    protected ArrayList<ColumnAttribute> generateColumns(ResultSetMetaData rsm) throws Exception {
        ArrayList<ColumnAttribute> result = new ArrayList<ColumnAttribute>();
        try {
            rsm.getColumnCount();
        }
        catch (Exception e) {
            throw new Exception("Get RowSet columns failed !");
        }
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            String aliasName = rsm.getColumnName(i + 1);
            if ("temprownumber".equalsIgnoreCase(aliasName) || "tempcolumn".equalsIgnoreCase(aliasName) || "RN".equalsIgnoreCase(aliasName)) continue;
            String clientNumber = aliasName.split("\\.")[0];
            ColumnAttribute column = new ColumnAttribute();
            column.setIndex(i);
            column.setName(aliasName);
            column.setDataType(rsm.getColumnType(i + 1));
            column.setScale(rsm.getScale(i + 1));
            column.setTable(this.structureMap.get(clientNumber.toUpperCase()));
            switch (column.getDataType()) {
                case 1: 
                case 12: {
                    column.setDataType(30);
                    break;
                }
                case 91: 
                case 93: {
                    column.setDataType(40);
                    break;
                }
                case 2: {
                    column.setDataType(20);
                    break;
                }
                case 2004: {
                    column.setDataType(70);
                    break;
                }
                default: {
                    column.setDataType(10);
                }
            }
            result.add(column);
        }
        return result;
    }

    public String mustSelectColumns() {
        return "CMP_CTB.ID,CMP_PERSON.ID,CMP_CTB.CALSTATE";
    }

    public List<IRowSet> executeQueryPaging(Context ctx, String sql) throws Exception {
        int columnSize;
        int exceptionNumber;
        int mod;
        ArrayList<IRowSet> result = new ArrayList<IRowSet>();
        IRowSet rs = null;
        String tempSql = "";
        if (sql.contains(" ")) {
            int orderIndex = 0;
            if (sql.contains("order by")) {
                orderIndex = sql.indexOf("order by");
            } else if (sql.contains("ORDER BY")) {
                orderIndex = sql.indexOf("ORDER BY");
            }
            tempSql = orderIndex > 0 ? sql.substring(0, orderIndex) : sql;
        }
        int pageSize = 0 == (mod = (exceptionNumber = JdbcRowSet.UPPER_CELLNUMBER_FOR_EXCEPTION) % (columnSize = (rs = DbUtil.executeQuery((Context)ctx, (String)("select TEMPTABLE.* from (" + tempSql + ") TEMPTABLE where 1<>1"))).getMetaData().getColumnCount())) ? exceptionNumber / columnSize + 1 : (exceptionNumber - mod) / columnSize;
        rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) counts from (" + tempSql + ")TEMPTABLE"));
        int rowTotalSize = 0;
        while (rs.next()) {
            rowTotalSize = rs.getInt("counts");
        }
        int totalPage = 1;
        if (rowTotalSize > pageSize) {
            totalPage = rowTotalSize / pageSize + 1;
        }
        int length = pageSize;
        PagingHelper pageHelper = new PagingHelper();
        String pagingSQL = "";
        for (int curPage = 1; curPage < totalPage + 1; ++curPage) {
            if (curPage * pageSize > rowTotalSize) {
                length = rowTotalSize - (curPage - 1) * pageSize;
            }
            pagingSQL = pageHelper.getPagingSqlNoOptmize(ctx, sql, (curPage - 1) * pageSize, length);
            logger.info((Object)("getDataForDataTable pagingSQL : " + pagingSQL));
            IRowSet rsn = SqlUtil.executeQuery(ctx, pagingSQL, pageHelper.getParamData());
            result.add(rsn);
        }
        return result;
    }
}

