/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.calculate.thread;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class RuntimeJVMonitor {
    private static NumberFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
    private static NumberFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));

    public static void getRuntimeMontitor() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        CompilationMXBean cm = ManagementFactory.getCompilationMXBean();
        System.out.printf("jvm.name (JVM\u540d\u79f0-\u7248\u672c\u53f7-\u4f9b\u5e94\u5546):%s | version: %s | vendor: %s  %n", runtime.getVmName(), runtime.getVmVersion(), runtime.getVmVendor());
        System.out.printf("jvm.spec.name (JVM\u89c4\u8303\u540d\u79f0-\u7248\u672c\u53f7-\u4f9b\u5e94\u5546):%s | version: %s | vendor: %s  %n", runtime.getSpecName(), runtime.getSpecVersion(), runtime.getSpecVendor());
        System.out.printf("jvm.java.version (JVM JAVA\u7248\u672c):%s%n", System.getProperty("java.version"));
        System.out.printf("jvm.start.time (Java\u865a\u62df\u673a\u7684\u542f\u52a8\u65f6\u95f4):%s%n", RuntimeJVMonitor.toDuration(runtime.getStartTime()));
        System.out.printf("jvm.uptime (Java\u865a\u62df\u673a\u7684\u6b63\u5e38\u8fd0\u884c\u65f6\u95f4):%s%n", RuntimeJVMonitor.toDuration(runtime.getUptime()));
        System.out.println("-----------------------------------------------\u7f16\u8bd1\u60c5\u51b5-------------------------------------------------------");
        System.out.printf("compilation.name(\u7f16\u8bd1\u5668\u540d\u79f0)\uff1a%s%n", cm.getName());
        System.out.printf("compilation.total.time(\u7f16\u8bd1\u5668\u8017\u65f6)\uff1a%d\u6beb\u79d2%n", cm.getTotalCompilationTime());
        boolean isSupport = cm.isCompilationTimeMonitoringSupported();
        if (isSupport) {
            System.out.println("\u652f\u6301\u5373\u65f6\u7f16\u8bd1\u5668\u7f16\u8bd1\u76d1\u63a7");
        } else {
            System.out.println("\u4e0d\u652f\u6301\u5373\u65f6\u7f16\u8bd1\u5668\u7f16\u8bd1\u76d1\u63a7");
        }
        System.out.printf("-------------------------------------------------\u7ebf\u7a0b\u60c5\u51b5-----------------------------------------------------", new Object[0]);
        System.out.printf("jvm.threads.total.count (\u603b\u7ebf\u7a0b\u6570(\u5b88\u62a4+\u975e\u5b88\u62a4)):%d%n", threads.getThreadCount());
        System.out.printf("jvm.threads.daemon.count (\u5b88\u62a4\u8fdb\u7a0b\u7ebf\u7a0b\u6570):%d%n", threads.getDaemonThreadCount());
        System.out.printf("jvm.threads.peak.count (\u5cf0\u503c\u7ebf\u7a0b\u6570):%d%n", threads.getPeakThreadCount());
        System.out.printf("jvm.threads.total.start.count(Java\u865a\u62df\u673a\u542f\u52a8\u540e\u521b\u5efa\u5e76\u542f\u52a8\u7684\u7ebf\u7a0b\u603b\u6570):%d%n", threads.getTotalStartedThreadCount());
        System.out.printf("", new Object[0]);
        System.out.println("--------------------------------------------------\u5806\u5185\u5b58\u60c5\u51b5----------------------------------------------------");
        System.out.printf("jvm.heap.init (\u521d\u59cb\u5316\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(heapMemoryUsage.getInit()));
        System.out.printf("jvm.heap.used (\u5df2\u4f7f\u7528\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(heapMemoryUsage.getUsed()));
        System.out.printf("jvm.heap.committed (\u53ef\u4f7f\u7528\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(heapMemoryUsage.getCommitted()));
        System.out.printf("jvm.heap.max (\u6700\u5927\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(heapMemoryUsage.getMax()));
        System.out.printf("", new Object[0]);
        System.out.println("---------------------------------------------------\u975e\u5806\u5185\u5b58\u4f7f\u7528\u60c5\u51b5---------------------------------------------------");
        System.out.printf("jvm.noheap.init (\u521d\u59cb\u5316\u975e\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(nonHeapMemoryUsage.getInit()));
        System.out.printf("jvm.noheap.used (\u5df2\u4f7f\u7528\u975e\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(nonHeapMemoryUsage.getUsed()));
        System.out.printf("jvm.noheap.committed (\u53ef\u4f7f\u7528\u975e\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(nonHeapMemoryUsage.getCommitted()));
        System.out.printf("jvm.noheap.max (\u6700\u5927\u975e\u5806\u5185\u5b58):%s %n", RuntimeJVMonitor.bytesToMB(nonHeapMemoryUsage.getMax()));
        System.out.printf("", new Object[0]);
        System.out.println("-----------------------------------------------------\u7cfb\u7edf\u6982\u51b5-------------------------------------------------");
        System.out.printf("os.name(\u64cd\u4f5c\u7cfb\u7edf\u540d\u79f0-\u7248\u672c\u53f7):%s %s %s %n", os.getName(), "version", os.getVersion());
        System.out.printf("os.arch(\u64cd\u4f5c\u7cfb\u7edf\u5185\u6838):%s%n", os.getArch());
        System.out.printf("os.cores(\u53ef\u7528\u7684\u5904\u7406\u5668\u6570\u91cf):%s %n", os.getAvailableProcessors());
        System.out.printf("os.loadAverage(\u7cfb\u7edf\u8d1f\u8f7d\u5e73\u5747\u503c):%s %n", os.getSystemLoadAverage());
        System.out.printf("", new Object[0]);
        System.out.println("-------------------------------------------------------\u7c7b\u52a0\u8f7d\u60c5\u51b5-----------------------------------------------");
        System.out.printf("class.current.load.count(\u5f53\u524d\u52a0\u8f7d\u7c7b\u6570\u91cf):%s %n", cl.getLoadedClassCount());
        System.out.printf("class.unload.count(\u672a\u52a0\u8f7d\u7c7b\u6570\u91cf):%s %n", cl.getUnloadedClassCount());
        System.out.printf("class.total.load.count(\u603b\u52a0\u8f7d\u7c7b\u6570\u91cf):%s %n", cl.getTotalLoadedClassCount());
        System.out.printf("", new Object[0]);
        System.out.println("------------------------------------------------------------------------------------------------------");
        for (MemoryPoolMXBean pool : pools) {
            String kind = pool.getType().name();
            MemoryUsage usage = pool.getUsage();
            System.out.println("\u5185\u5b58\u6a21\u578b\uff1a " + RuntimeJVMonitor.getKindName(kind) + ", \u5185\u5b58\u7a7a\u95f4\u540d\u79f0\uff1a " + RuntimeJVMonitor.getPoolName(pool.getName()) + ", jvm." + pool.getName() + ".init(\u521d\u59cb\u5316):" + RuntimeJVMonitor.bytesToMB(usage.getInit()));
            System.out.println("\u5185\u5b58\u6a21\u578b\uff1a " + RuntimeJVMonitor.getKindName(kind) + ", \u5185\u5b58\u7a7a\u95f4\u540d\u79f0\uff1a " + RuntimeJVMonitor.getPoolName(pool.getName()) + ", jvm." + pool.getName() + ".used(\u5df2\u4f7f\u7528): " + RuntimeJVMonitor.bytesToMB(usage.getUsed()));
            System.out.println("\u5185\u5b58\u6a21\u578b\uff1a " + RuntimeJVMonitor.getKindName(kind) + ", \u5185\u5b58\u7a7a\u95f4\u540d\u79f0\uff1a " + RuntimeJVMonitor.getPoolName(pool.getName()) + ", jvm." + pool.getName() + ".committed(\u53ef\u4f7f\u7528):" + RuntimeJVMonitor.bytesToMB(usage.getCommitted()));
            System.out.println("\u5185\u5b58\u6a21\u578b\uff1a " + RuntimeJVMonitor.getKindName(kind) + ", \u5185\u5b58\u7a7a\u95f4\u540d\u79f0\uff1a " + RuntimeJVMonitor.getPoolName(pool.getName()) + ", jvm." + pool.getName() + ".max(\u6700\u5927):" + RuntimeJVMonitor.bytesToMB(usage.getMax()));
            System.out.println("------------------------------------------------------------------------------------------------------");
        }
    }

    protected static String getKindName(String kind) {
        if ("NON_HEAP".equals(kind)) {
            return "NON_HEAP(\u975e\u5806\u5185\u5b58)";
        }
        return "HEAP(\u5806\u5185\u5b58)";
    }

    protected static String getPoolName(String poolName) {
        switch (poolName) {
            case "Code Cache": {
                return poolName + "(\u4ee3\u7801\u7f13\u5b58\u533a)";
            }
            case "Metaspace": {
                return poolName + "(\u5143\u7a7a\u95f4)";
            }
            case "Compressed Class Space": {
                return poolName + "(\u7c7b\u6307\u9488\u538b\u7f29\u7a7a\u95f4)";
            }
            case "PS Eden Space": {
                return poolName + "(\u4f0a\u7538\u56ed\u533a)";
            }
            case "PS Survivor Space": {
                return poolName + "(\u5e78\u5b58\u8005\u533a)";
            }
            case "PS Old Gen": {
                return poolName + "(\u8001\u5e74\u4ee3)";
            }
        }
        return poolName;
    }

    protected static String bytesToMB(long bytes) {
        return fmtI.format(bytes / 1024L / 1024L) + " MB";
    }

    protected static String printSizeInKb(double size) {
        return fmtI.format((long)(size / 1024.0)) + " kbytes";
    }

    protected static String toDuration(double uptime) {
        if ((uptime /= 1000.0) < 60.0) {
            return fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 24.0);
        String s = fmtI.format(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
        }
        return s;
    }
}

