/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cmpBudget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CostBearFacadeFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.DataStateEnum;
import com.kingdee.shr.compensation.app.budget.DeductConfigFacadeFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigInfo;
import com.kingdee.shr.compensation.app.cmpBudget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.cmpBudget.RollBackNodeEnum;
import com.kingdee.shr.compensation.service.budget.DeductionCmpCalUnit;
import com.kingdee.shr.compensation.service.budget.DeductionParam;
import com.kingdee.shr.compensation.service.budget.DeductionParamCmpCal;
import com.kingdee.shr.compensation.service.budget.DeductionResult;
import com.kingdee.shr.compensation.service.budget.impl.CmpCalPersonParam;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.budget.BudgetUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpBudgetFacadeService {
    private static final Logger logger = Logger.getLogger(CmpBudgetFacadeService.class);

    public void rollbackBudget(Context ctx, String calSchemeId, String calTabelFilter, RollBackNodeEnum rollBackNodeEnum, DeduNodeEnum deduNodeEnum) throws BOSException, EASBizException {
        String sql = "select FCmpCalTableID from T_HR_CalSchemeVeriResult where FCmpCalTableID in (" + calTabelFilter + ") and FExecuteStatus in (" + StringUtils.join((Object[])new Object[]{1, 2, 3}, (String)",") + ")";
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("com.kingdee.shr.compensation.cmpBudget.CmpBudgetFacadeService : rollbackBudgetSql" + sql));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            HashSet execList = Sets.newHashSet();
            while (rs.next()) {
                execList.add(rs.getString("FCmpCalTableID"));
            }
            if (execList.isEmpty()) {
                return;
            }
            CmpInSql inSql = CmpInSqlFactory.getInstance();
            String inSqlBaseOnFId = inSql.createInSqlBaseOnFId(ctx, execList);
            DeductionParamCmpCal cmpCalParam = new DeductionParamCmpCal();
            cmpCalParam.setCmpCalTableIds(inSqlBaseOnFId);
            cmpCalParam.setCmpRollbackNodeEnum(rollBackNodeEnum);
            cmpCalParam.setCalSchemeId(calSchemeId);
            cmpCalParam.setCmpDeductNodeEnum(deduNodeEnum);
            DeductConfigFacadeFactory.getLocalInstance((Context)ctx).dealWithRollback((DeductionParam)cmpCalParam, BudgetTemplateTypeEnum.SALARY_TYPE);
            if (rollBackNodeEnum == RollBackNodeEnum.OTHERS) {
                this.afterRollBack(ctx, inSqlBaseOnFId);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void afterRollBack(Context ctx, String inSqlBaseOnFId) throws Exception {
        String updateExecStateSql = "update T_HR_CalSchemeVeriResult set FExecuteStatus = 0 where FCmpCalTableID in " + inSqlBaseOnFId;
        DbUtil.execute((Context)ctx, (String)updateExecStateSql);
    }

    public DeductionResult budgetDeduction(Context ctx, Object outerData, String calSchemeId, Map<String, Sheet> calculateResultMap) throws BOSException, EASBizException {
        try {
            DeductionParamCmpCal cmpCalParam = this.assembleCmpCalParam(ctx, outerData, calSchemeId, calculateResultMap);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("com.kingdee.shr.compensation.cmpBudget.CmpBudgetFacadeService : budgetDeduction" + cmpCalParam));
            }
            return DeductConfigFacadeFactory.getLocalInstance((Context)ctx).dealSchemeDeductConfig((DeductionParam)cmpCalParam, BudgetTemplateTypeEnum.SALARY_TYPE);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public DeductionParamCmpCal assembleCmpCalParam(Context ctx, Object outerData, String calSchemeId, Map<String, Sheet> calculateResultMap) throws Exception {
        int deduNode = (Integer)outerData;
        Map<String, String> deduRes = this.getDeduConfigByScheme(ctx, deduNode, calSchemeId);
        DeductionParamCmpCal cmpCalParam = new DeductionParamCmpCal();
        ArrayList calUnitList = Lists.newArrayList();
        if (deduNode == 100) {
            cmpCalParam.setCmpDeductNodeEnum(DeduNodeEnum.EXECBUDGET);
        } else {
            cmpCalParam.setCmpDeductNodeEnum(DeduNodeEnum.APPROVE);
        }
        cmpCalParam.setCalSchemeId(calSchemeId);
        cmpCalParam.setDeductionDate(CmpDateUtil.parseDate(deduRes.get("deductionDate")));
        cmpCalParam.setCalCurrencyId(deduRes.get("currencyId"));
        for (String costTypeId : calculateResultMap.keySet()) {
            Sheet result = calculateResultMap.get(costTypeId);
            List changeDataList = result.getChangeDataList();
            if (changeDataList.isEmpty()) continue;
            Map<String, Integer> colIndex = this.assembleColumnIndex((Row)changeDataList.get(0));
            HashMap groupMap = Maps.newHashMap();
            for (Row row : changeDataList) {
                List cells = row.getCells();
                String costOrgId = ((Cell)cells.get(colIndex.get("CAL_COSTORG.ID"))).getValue();
                groupMap.putIfAbsent(costTypeId + "~" + costOrgId, Lists.newArrayList());
                List personParamList = (List)groupMap.get(costTypeId + "~" + costOrgId);
                personParamList.add(this.buildPersonParam(cells, colIndex, deduRes, costTypeId));
            }
            for (Map.Entry entry : groupMap.entrySet()) {
                DeductionCmpCalUnit cmpCalUnit = new DeductionCmpCalUnit();
                String[] keyArr = ((String)entry.getKey()).split("~");
                cmpCalUnit.setCostBearOrgId(keyArr[1]);
                cmpCalUnit.setCostTypeId(keyArr[0]);
                cmpCalUnit.setPersonList((List)entry.getValue());
                calUnitList.add(cmpCalUnit);
            }
            cmpCalParam.setUnits(calUnitList);
        }
        return cmpCalParam;
    }

    protected CmpCalPersonParam buildPersonParam(List<Cell> cells, Map<String, Integer> colIndex, Map<String, String> deduRes, String costTypeId) {
        CmpCalPersonParam personParam = new CmpCalPersonParam();
        personParam.setPersonId(cells.get(colIndex.get("FPERSONID")).getValue());
        personParam.setCalTableId(cells.get(colIndex.get("FCALID")).getValue());
        personParam.setPeriodYear(Integer.parseInt(deduRes.get("periodYear")));
        personParam.setPeriodMonth(Integer.parseInt(deduRes.get("periodMonth")));
        personParam.setCalTimes(Integer.parseInt(deduRes.get("calTime")));
        personParam.setDataState(DataStateEnum.DEDUCT);
        personParam.setCalCurrencyId(deduRes.get("currencyId"));
        personParam.setExchangeTableId(deduRes.get("exchangeTableId"));
        personParam.setAdminOrgUnitId(cells.get(colIndex.get("CAL_ADMINORG.ID")).getValue());
        personParam.setHrOrgUnitId(deduRes.get("hrOrgUnitId"));
        personParam.setCmpEmpORelationId(cells.get(colIndex.get("CAL_CMPEPOR.ID")).getValue());
        HashMap amountMap = Maps.newHashMap();
        deduRes.forEach((k, v) -> {
            String cmpStandingBookFieldSn;
            if (k.startsWith("T_HR_SCMPSTANDINGBOOK_S") && k.endsWith(costTypeId) && colIndex.containsKey(cmpStandingBookFieldSn = k.split("\\$")[0])) {
                int index = (Integer)colIndex.get(cmpStandingBookFieldSn);
                BigDecimal cellValue = new BigDecimal(((Cell)cells.get(index)).getValue());
                int scale = Math.min(cellValue.scale(), 10);
                amountMap.put(v, StringUtils.isEmpty((CharSequence)((Cell)cells.get(index)).getValue()) ? BigDecimal.ZERO : cellValue.setScale(scale, RoundingMode.HALF_UP));
            }
        });
        personParam.setAmountMap(amountMap);
        return personParam;
    }

    protected Map<String, Integer> assembleColumnIndex(Row row) {
        HashMap colIndex = Maps.newHashMap();
        List cells = row.getCells();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.get(i);
            String column = cell.getColumn();
            colIndex.put(column, i);
        }
        return colIndex;
    }

    public Map<String, String> getDeduConfigByScheme(Context ctx, int deduNode, String calSchemeId) throws BOSException {
        HashMap res = Maps.newHashMap();
        try {
            String oql = "select periodYear, periodMonth, calTime, hrOrgUnit.id, currency.id, exchangeTable.id, budgetOffset, beginDate, costType where id = '" + calSchemeId + "'";
            CalSchemeInfo calSchemeInfo = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo(oql);
            res.put("periodYear", String.valueOf(calSchemeInfo.getPeriodYear()));
            res.put("periodMonth", String.valueOf(calSchemeInfo.getPeriodMonth()));
            res.put("calTime", String.valueOf(calSchemeInfo.getCalTime()));
            res.put("hrOrgUnitId", calSchemeInfo.getHrOrgUnit().getId().toString());
            res.put("currencyId", calSchemeInfo.getCurrency().getId().toString());
            res.put("exchangeTableId", calSchemeInfo.getExchangeTable().getId().toString());
            Date beginDate = calSchemeInfo.getBeginDate();
            int budgetOffset = calSchemeInfo.getBudgetOffset();
            Calendar c = Calendar.getInstance();
            c.setTime(beginDate);
            c.add(2, budgetOffset);
            res.put("deductionDate", CmpDateUtil.getDateStr(BudgetUtil.getSchemeActualDate(ctx, calSchemeId)));
            String defaultCostType = calSchemeInfo.getCostType().getId().toString();
            oql = "select cmpBudgetItemRel.id, cmpBudgetItemRel.standingBookItem.fieldSn, costType where calScheme.id = '" + calSchemeId + "' and deduNode = " + deduNode;
            BudgetDeductionConfigCollection collection = BudgetDeductionConfigFactory.getLocalInstance((Context)ctx).getBudgetDeductionConfigCollection(oql);
            for (int i = 0; i < collection.size(); ++i) {
                BudgetDeductionConfigInfo configInfo = collection.get(i);
                if (configInfo.getCmpBudgetItemRel() == null || configInfo.getCmpBudgetItemRel().getStandingBookItem() == null) continue;
                String costType = configInfo.getCostType() != null ? configInfo.getCostType().getId().toString() : defaultCostType;
                String key = "T_HR_SCMPSTANDINGBOOK_S" + configInfo.getCmpBudgetItemRel().getStandingBookItem().getFieldSn() + "$" + costType;
                res.put(key, configInfo.getCmpBudgetItemRel().getId().toString());
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public void rollBackBudgetWhenStopCal(Context ctx, CalSchemeInfo calSchemeInfo, String calTabelFilter, boolean isDeleteExecState) throws BOSException, EASBizException {
        CostBearFacadeFactory.getLocalInstance(ctx).deleteCostBearData(calTabelFilter, calSchemeInfo);
        this.rollbackBudget(ctx, calSchemeInfo.getId().toString(), calTabelFilter, RollBackNodeEnum.OTHERS, DeduNodeEnum.EXECBUDGET);
        if (isDeleteExecState) {
            String deleteBudgetExecStateSql = "delete from T_HR_CalSchemeVeriResult where FCMPCALTABLEID in (" + calTabelFilter + ")";
            CmpSQLUtil.execute(ctx, deleteBudgetExecStateSql);
        }
    }

    public static void syncCalTableDataToVeriStatus(Context ctx, CalSchemeInfo calSchemeInfo, String filterSql) throws BOSException {
        String schemeId = calSchemeInfo.getId().toString();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        StringBuilder builder = new StringBuilder();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String sqlDate = CmpDateUtil.toKSqlDate(new Date());
        builder.append(" insert into T_HR_CalSchemeVeriResult(FCalSchemeID,FPeriodYear,FPeriodMonth,FCalTime,FCmpCalTableID, ");
        builder.append(" FExecuteStatus,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FID) ");
        builder.append(" SELECT '").append(schemeId).append("' ,").append(periodYear).append(",").append(periodMonth).append(",");
        builder.append(calTime).append(", Fid,").append(0);
        builder.append(", '").append(userId).append("',").append(sqlDate).append(",'").append(userId).append("',").append(sqlDate).append(",newbosid('9CB9D274')");
        builder.append(" FROM T_HR_SCmpCalTable where  FCALSCHEMEID = '").append(schemeId).append("' and FPERIODYEAR =");
        builder.append(periodYear).append(" and FPERIODMONTH = ").append(periodMonth).append(" and FCALTIME = ").append(calTime);
        builder.append(filterSql);
        DbUtil.execute((Context)ctx, (String)builder.toString());
    }
}

