/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.NumericalUnit;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateSTBItemFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigCollection;
import com.kingdee.shr.compensation.app.cmpBudget.BudgetDeductionConfigFactory;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.BudgetTools;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.DashBoardInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.InputParamInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.OrgUnitBudgetInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.AbstractCombineData;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.CalDashBoardForAnnual;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.CalDashBoardForPeriod;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.DashBoardForAnnual;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.DashBoardForPeriod;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.SubmitDashBoardForAnnual;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.SubmitDashboardForPeriod;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DashBoardManager {
    private static final BigDecimal THOUSAND = new BigDecimal(1000);
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);
    private static final BigDecimal MILLION = new BigDecimal(1000000);
    private static final BigDecimal BILLION = new BigDecimal(100000000);

    public static DashBoardInfo getAnnualInfo(Context ctx, String permItemId, String templateId, String adminOrgUnitId, int year) throws BOSException {
        DashBoardForAnnual cb = null;
        DashBoardInfo info = DashBoardManager.isEmptyBudgetScheme(ctx, templateId, year);
        if (info.isEmpty) {
            return info;
        }
        InputParamInfo paramInfo = new InputParamInfo(templateId, year);
        String longNumber = DashBoardManager.getAdminOrgUnitLongNumber(ctx, adminOrgUnitId);
        paramInfo.setAdminOrgUnitId(adminOrgUnitId);
        paramInfo.setLongNumber(longNumber);
        paramInfo.setPermId(permItemId);
        BudgetTemplateCollection coll = BudgetTemplateFactory.getLocalInstance((Context)ctx).getBudgetTemplateCollection("where id = '" + templateId + "'");
        BudgetTemplateInfo budgetInfo = coll.get(0);
        cb = 2 == budgetInfo.getTemplateType().getValue() ? new CalDashBoardForAnnual(ctx, paramInfo) : new SubmitDashBoardForAnnual(ctx, paramInfo);
        return DashBoardManager.getDashBoardInfo(ctx, templateId, cb, info);
    }

    public static DashBoardInfo getPeriodInfo(Context ctx, String permItemId, String templateId, String adminOrgUnitId, int year, Date currentDate) throws BOSException {
        DashBoardForPeriod cb = null;
        DashBoardInfo info = DashBoardManager.isEmptyBudgetScheme(ctx, templateId, year);
        if (info.isEmpty) {
            return info;
        }
        BudgetTemplateCollection coll = BudgetTemplateFactory.getLocalInstance((Context)ctx).getBudgetTemplateCollection("where id = '" + templateId + "'");
        BudgetTemplateInfo budgetInfo = coll.get(0);
        if (budgetInfo.getBudgetPeriod().equals((Object)BudgetPeriodEnum.YEAR)) {
            info.setEmpty(true);
            return info;
        }
        String period = BudgetTools.getCurrentPeriod(ctx, templateId, adminOrgUnitId, year, currentDate);
        InputParamInfo paramInfo = new InputParamInfo(templateId, year, period);
        String longNumber = DashBoardManager.getAdminOrgUnitLongNumber(ctx, adminOrgUnitId);
        paramInfo.setAdminOrgUnitId(adminOrgUnitId);
        paramInfo.setLongNumber(longNumber);
        paramInfo.setPermId(permItemId);
        cb = 2 == budgetInfo.getTemplateType().getValue() ? new CalDashBoardForPeriod(ctx, paramInfo) : new SubmitDashboardForPeriod(ctx, paramInfo);
        return DashBoardManager.getDashBoardInfo(ctx, templateId, cb, info);
    }

    public static DashBoardInfo isEmptyBudgetScheme(Context ctx, String templateId, int year) throws BOSException {
        String sql;
        DashBoardInfo info = new DashBoardInfo();
        info.isEmpty = true;
        BudgetTemplateCollection c0 = BudgetTemplateFactory.getLocalInstance((Context)ctx).getBudgetTemplateCollection("where id = '" + templateId + "'");
        if (c0.size() < 1) {
            return info;
        }
        BudgetTemplateInfo budgetTemplateInfo = c0.get(0);
        String oql = "select id where template.id = '" + templateId + "'";
        BudgetTemplateSTBItemCollection c1 = BudgetTemplateSTBItemFactory.getLocalInstance((Context)ctx).getBudgetTemplateSTBItemCollection(oql);
        if (c1.size() < 1) {
            return info;
        }
        if (budgetTemplateInfo.getTemplateType().equals((Object)BudgetTemplateTypeEnum.SALARY_TYPE)) {
            sql = " select id where calScheme.budgetTemplate.id = '" + templateId + "' ";
            BudgetDeductionConfigCollection c2 = BudgetDeductionConfigFactory.getLocalInstance((Context)ctx).getBudgetDeductionConfigCollection(sql);
            if (c2.size() < 1) {
                return info;
            }
        } else {
            sql = "select id where calSubmitScheme.budgetTemplate.id = '" + templateId + "'";
            SchemeDeduConfigCollection c3 = SchemeDeduConfigFactory.getLocalInstance((Context)ctx).getSchemeDeduConfigCollection(sql);
            if (c3.size() < 1) {
                return info;
            }
        }
        sql = " select man.fid  from T_HR_SBudgetManage man  inner join T_HR_SCmpBudgetScheme sch on man.FBudgetSchemeID = sch.fid  where sch.FTemplateID = ? and man.FBudgetYear = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId, year});
        if (rowSet.size() < 1) {
            return info;
        }
        info.setEmpty(false);
        return info;
    }

    public static Map<String, Object> combineResult(Context ctx, DashBoardInfo info, NumericalUnit unit) {
        String good = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpBashBoardResource", (String)"label0", (Locale)ctx.getLocale());
        String warning = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpBashBoardResource", (String)"label1", (Locale)ctx.getLocale());
        String excess = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpBashBoardResource", (String)"label2", (Locale)ctx.getLocale());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        int exceedNumber = 0;
        int unExceedNumber = 0;
        int goodNumber = 0;
        int warnNumber = 0;
        BigDecimal boundary = new BigDecimal(0.8);
        BigDecimal hundred = new BigDecimal(1);
        BigDecimal zero = new BigDecimal(0);
        if (info.isEmpty) {
            dataMap.put("used", null);
            dataMap.put("residue", null);
            dataMap.put("exceed", null);
            dataMap.put("max", null);
            dataMap.put("state", null);
            dataMap.put("percent", null);
            dataMap.put("exceedNumber", 0);
            dataMap.put("unExceedNumber", 0);
            dataMap.put("goodNumber", 0);
            dataMap.put("warnNumber", 0);
        } else {
            dataMap.put("used", DashBoardManager.numericalTrans(info.getUsed(), unit));
            dataMap.put("residue", DashBoardManager.numericalTrans(info.getResidue(), unit));
            dataMap.put("exceed", DashBoardManager.numericalTrans(info.getExceed(), unit));
            dataMap.put("max", DashBoardManager.numericalTrans(info.getMax(), unit));
            dataMap.put("state", info.isEmpty ? null : (info.getUsedPercent().compareTo(hundred) > 0 ? excess : (info.getUsedPercent().compareTo(boundary) > 0 ? warning : good)));
            dataMap.put("percent", info.isEmpty ? null : info.getUsedPercent().multiply(new BigDecimal(100)).intValue() + "%");
            dataMap.put("currency", unit.equals((Object)NumericalUnit.INDIVIDUAL) ? info.getCurrency() : unit.getAlias(ctx.getLocale()) + info.getCurrency());
            dataMap.put("numericalUnit", unit.equals((Object)NumericalUnit.INDIVIDUAL) ? "" : unit.getAlias(ctx.getLocale()));
            List<OrgUnitBudgetInfo> list = info.getOrgUnitBudgetInfo();
            for (OrgUnitBudgetInfo i : list) {
                if (i.isExcess()) {
                    ++exceedNumber;
                } else {
                    ++unExceedNumber;
                }
                if (null == i.getMax() || i.getMax().compareTo(zero) == 0 || i.getUsed().divide(i.getMax(), 2, 1).compareTo(boundary) < 0) {
                    ++goodNumber;
                    continue;
                }
                ++warnNumber;
            }
            dataMap.put("exceedNumber", exceedNumber);
            dataMap.put("unExceedNumber", unExceedNumber);
            dataMap.put("goodNumber", goodNumber);
            dataMap.put("warnNumber", warnNumber);
        }
        return dataMap;
    }

    private static BigDecimal numericalTrans(BigDecimal val, NumericalUnit unit) {
        BigDecimal temp = null;
        if (null == unit) {
            return val;
        }
        switch (unit.getValue()) {
            case 5: {
                temp = val;
                break;
            }
            case 10: {
                temp = val.divide(THOUSAND, 0, 4);
                break;
            }
            case 20: {
                temp = val.divide(TEN_THOUSAND, 0, 4);
                break;
            }
            case 30: {
                temp = val.divide(MILLION, 2, 4);
                break;
            }
            case 40: {
                temp = val.divide(BILLION, 2, 4);
            }
        }
        return temp;
    }

    private static String getAdminOrgUnitLongNumber(Context ctx, String adminOrgUnitId) throws BOSException {
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select longNumber where id = '" + adminOrgUnitId + "' ");
        if (coll.size() < 1) {
            return null;
        }
        return coll.get(0).getLongNumber();
    }

    private static DashBoardInfo getDashBoardInfo(Context ctx, String templateId, AbstractCombineData cb, DashBoardInfo info) throws BOSException {
        BigDecimal zero = new BigDecimal(0);
        BigDecimal residue = cb.getResidue(ctx);
        info.setMax(cb.getMax(ctx));
        info.setUsed(cb.getUsed(ctx));
        info.setOrgUnitBudgetInfo(cb.getOrgUnitBudgetInfo(ctx, false));
        info.setExceed(residue.compareTo(zero) > 0 ? zero : zero.subtract(residue));
        info.setResidue(residue.compareTo(zero) > 0 ? residue : zero);
        if (info.getUsed().add(residue).compareTo(zero) == 0) {
            info.setUsedPercent(zero);
        } else {
            info.setUsedPercent(info.getUsed().divide(info.getUsed().add(info.getResidue()).subtract(info.getExceed()), 2, 1));
        }
        String oql = "select currency.baseUnit  where template.id = '" + templateId + "' ";
        CmpBudgetSchemeCollection schemeColl = CmpBudgetSchemeFactory.getLocalInstance((Context)ctx).getCmpBudgetSchemeCollection(oql);
        if (schemeColl.size() < 1) {
            return info;
        }
        info.setCurrency(schemeColl.get(0).getCurrency().getBaseUnit());
        return info;
    }
}

