/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.InputParamInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.OrgUnitBudgetInfo;
import com.kingdee.shr.compensation.dataplatform.budget.bashboard.combine.CombineDataInter;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCombineData
implements CombineDataInter {
    private static final Logger logger = Logger.getLogger(AbstractCombineData.class);
    protected InputParamInfo paramInfo;
    protected String standingItems;
    protected String balanceItems;
    protected String budgetItems;
    protected BigDecimal externalUsed;
    protected Map<String, BigDecimal> orgExternalUsed;

    public AbstractCombineData(Context ctx, InputParamInfo paramInfo) {
        this.paramInfo = paramInfo;
        this.initData(ctx);
    }

    public void initData(Context ctx) {
        try {
            this.budgetItems = this.getBudgetItems(ctx);
            this.standingItems = this.getExpendItems(ctx);
            this.balanceItems = this.getBalanceItems(ctx);
            this.externalUsed = this.getExternalUsed(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public BigDecimal getExternalUsed(Context ctx) throws BOSException {
        this.orgExternalUsed = new HashMap<String, BigDecimal>();
        BigDecimal sum = new BigDecimal(0);
        BigDecimal zero = new BigDecimal(0);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (CmpStrUtil.isEmpty(this.budgetItems)) {
            return zero;
        }
        String fields = this.budgetItems.substring(0, this.budgetItems.length() - 1).replaceAll("T", "");
        String sql = " select sum(FAmount) amount, org.fid  from T_HR_SCmpPeriodUsedAmount am  inner join T_ORG_Admin org on am.FAdminOrgUnitID = org.fid  inner join T_HR_SubCmpStandingBook book on book.fid = am.FSubStandingBookId  inner join T_HR_SSubBudgetQuery qu on book.FSubBudgetQueryID = qu.fid  where am.FBudgetTemplateId = ? and am.FBudgetYear = ? and qu.FPeriod = ?  and (org.FLongNumber = '" + this.paramInfo.getLongNumber() + "'  or org.FLongNumber like '" + this.paramInfo.getLongNumber() + "!%')  and org.fid in (" + SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)this.paramInfo.getPermId()) + ")  and am.FCmpBudgetItemID in (select fid from T_HR_SCmpBudgetItem where FieldSn in (" + fields + ")) group by org.fid ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{this.paramInfo.getTemplateId(), this.paramInfo.getYear(), this.paramInfo.getPeriod()});
        try {
            while (rowSet.next()) {
                sum = sum.add(rowSet.getBigDecimal(1));
                this.orgExternalUsed.put(rowSet.getString(2), rowSet.getBigDecimal(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sum;
    }

    protected String getExpendItems(Context ctx) throws BOSException {
        String sql = " select t1.FieldSn  from T_HR_SBudgetTemplateSTBItem t0  inner join T_HR_SStandingBookItem t1 on t0.FStandingBookItemID = t1.fid  where t0.FTemplateID = ? ";
        return this.combineItems(ctx, false, sql, new Object[]{this.paramInfo.getTemplateId()});
    }

    protected String getBudgetItems(Context ctx) throws BOSException {
        String sql = " select distinct t2.FieldSn  from T_HR_SSchemeDeduConfig t0  inner join T_HR_SBudgetTemplateSTBItem t1 on t0.FTemplateStbItemId = t1.fid  inner join T_HR_SCmpBudgetItem t2 on t1.FCmpBudgetItemId = t2.fid  where t1.FTemplateID = ? ";
        return this.combineItems(ctx, true, sql, new Object[]{this.paramInfo.getTemplateId()});
    }

    protected String getBalanceItems(Context ctx) throws BOSException {
        String sql = "/*dialect*/ select distinct FieldSn from (select t.FieldSn, row_number() over(partition by t.FCmpBudgetItemId order by t.FDeduNode) rn from (select t2.FieldSn, t0.FDeduNode,t1.FCmpBudgetItemId from T_HR_SSchemeDeduConfig t0  inner join T_HR_SBudgetTemplateSTBItem t1 on t0.FTemplateStbItemId = t1.fid  inner join T_HR_SStandingBookItem t2 on t1.FBalanceLedgerItemID = t2.fid  where t1.FTemplateID = ?) t) tt  where tt.rn = 1 ";
        return this.combineItems(ctx, false, sql, new Object[]{this.paramInfo.getTemplateId()});
    }

    protected String combineItems(Context ctx, boolean isBudget, String sql, Object[] param) throws BOSException {
        StringBuilder str = new StringBuilder(",");
        String prefix = isBudget ? "T" : "S";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (rowSet.next()) {
                str.append(prefix).append(rowSet.getInt(1)).append(",");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return str.substring(1);
    }

    protected BigDecimal combineSummary(Context ctx, String bookItems, String alias, String fromSql, Object[] param) throws BOSException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        BigDecimal money = null;
        BigDecimal zero = new BigDecimal(0);
        String[] standingItemArr = bookItems.split(",");
        StringBuilder sb = new StringBuilder("sum(");
        for (String item : standingItemArr) {
            sb.append("+ isnull(").append(alias).append(".").append(item).append(",0)");
        }
        String sumItems = sb.toString().replaceFirst("\\+", "") + ") as item ";
        StringBuilder str = new StringBuilder();
        str.append(" select ").append(sumItems);
        str.append(fromSql);
        str.append(" and (").append("adminOrgUnit").append(".FLongNumber = '").append(this.paramInfo.getLongNumber()).append("' ");
        str.append(" or ").append("adminOrgUnit").append(".FLongNumber like '").append(this.paramInfo.getLongNumber()).append("%') ");
        str.append(" and ").append("adminOrgUnit").append(".Fid in (");
        str.append(SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)this.paramInfo.getPermId())).append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString(), (Object[])param);
        while (true) {
            try {
                while (rowSet.next()) {
                    money = rowSet.getBigDecimal(1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
        return null == money ? zero : money;
    }

    public List<OrgUnitBudgetInfo> getOrgUnitBudgetInfo(Context ctx, boolean isAll, String fromSql, Object[] param) throws BOSException {
        ArrayList<OrgUnitBudgetInfo> list = new ArrayList<OrgUnitBudgetInfo>();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String[] budgetArr = this.budgetItems.split(",");
        StringBuilder sb = new StringBuilder("sum(");
        for (String item : budgetArr) {
            sb.append("+ isnull(man.").append(item).append(",0)");
        }
        String item1 = sb.toString().replaceFirst("\\+", "") + ") as budgetItems ";
        String[] bookArr = this.standingItems.split(",");
        sb = new StringBuilder("sum(");
        for (String item : bookArr) {
            sb.append("+ isnull(book.").append(item).append(",0)");
        }
        String item2 = sb.toString().replaceFirst("\\+", "") + ") as standingItems ";
        sb = new StringBuilder();
        sb.append(" select ").append(item1).append(",").append(item2);
        sb.append(",").append("adminOrgUnit").append(".fid, ");
        sb.append("adminOrgUnit").append(".FNumber, ");
        sb.append("adminOrgUnit").append(".FName_").append(ctx.getLocale());
        sb.append(fromSql);
        if (isAll) {
            sb.append(" and ").append("adminOrgUnit").append(".FLongNumber like '").append(this.paramInfo.getLongNumber()).append("!%' ");
        } else {
            sb.append(" and ").append("adminOrgUnit").append(".FParentID = '").append(this.paramInfo.getAdminOrgUnitId()).append("' ");
        }
        sb.append(" and ").append("adminOrgUnit").append(".Fid in (");
        sb.append(SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)this.paramInfo.getPermId())).append(") ");
        sb.append(" group by ").append("adminOrgUnit").append(".fid, ");
        sb.append("adminOrgUnit").append(".FNumber, ");
        sb.append("adminOrgUnit").append(".FName_").append(ctx.getLocale());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                String orgId = rowSet.getString(3);
                OrgUnitBudgetInfo info = new OrgUnitBudgetInfo(orgId, rowSet.getString(4), rowSet.getString(5));
                info.setMax(rowSet.getBigDecimal(1));
                if (this.orgExternalUsed.containsKey(orgId)) {
                    info.setUsed(rowSet.getBigDecimal(2).add(this.orgExternalUsed.get(orgId)));
                } else {
                    info.setUsed(rowSet.getBigDecimal(2));
                }
                info.setExcess(info.getUsed().compareTo(info.getMax()) > 0);
                list.add(info);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return list;
    }
}

