/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.integrate.verify;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineCollection;
import com.kingdee.shr.compensation.exception.SubmitBillVerifyException;
import com.kingdee.shr.compensation.integrate.verify.AbstractSubmitBillVerify;
import com.kingdee.shr.compensation.integrate.verify.ISubmitBillVerifyInterface;
import com.kingdee.shr.compensation.integrate.verify.ISubmitBillWeakVerifyInterface;
import com.kingdee.shr.compensation.integrate.verify.VerifyDTO;
import com.kingdee.shr.compensation.integrate.verify.WeakVerifyDTO;
import com.kingdee.shr.compensation.util.db.CmpTempTable;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.compensation.util.integrate.SubmitBizKeyHelper;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CycleVerify
extends AbstractSubmitBillVerify
implements ISubmitBillWeakVerifyInterface {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.integrate.verify.CycleVerify");
    private final ISubmitBillVerifyInterface submitBillVerify;

    public CycleVerify(ISubmitBillVerifyInterface submitBillVerify) {
        this.submitBillVerify = submitBillVerify;
    }

    @Override
    public void verify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        this.weakVerify(ctx, model, otherParams);
    }

    @Override
    public WeakVerifyDTO weakVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        this.submitBillVerify.verify(ctx, model, otherParams);
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        return this.doVerifyCycle(ctx, info);
    }

    public WeakVerifyDTO doVerifyCycle(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        CalSubmitSchemeInfo submitScheme = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(info.getSubmitScheme().getId().toString()));
        if (!submitScheme.isIscycle() || info.getEntry() == null || info.getEntry().isEmpty()) {
            return new WeakVerifyDTO(WeakVerifyDTO.Result.SUCCESS);
        }
        this.verifyRepeatBizKeyInCycleScheme(ctx, info);
        this.verifyEffectDateAndLeffectDateLegality(ctx, info);
        return this.verifyCyclePeriod(ctx, submitScheme, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakVerifyDTO verifyCyclePeriod(Context ctx, CalSubmitSchemeInfo submitScheme, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        WeakVerifyDTO weakVerifyDTO;
        String billID = info.getId().toString();
        CalSubmitSchemeInfo calSubmitSchemeInfo = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(info.getSubmitScheme().getId().toString()));
        String dynamicEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, calSubmitSchemeInfo.getId().toString());
        BatchSubmitShemeBillEntryCollection entryCols = info.getEntry();
        HashSet<String> submitElementIdSet = calSubmitSchemeInfo.isIsEnableSubmitElement() ? SubmitBizKeyHelper.mapDistinctSubmitElementId(entryCols) : new HashSet<String>();
        CmpTempTable currentEntryTmpTable = SubmitBizKeyHelper.insertIntoTempTableForBizKeyInfo(ctx, dynamicEntryTable, entryCols);
        try {
            this.verifySameEffectDate(ctx, submitScheme, dynamicEntryTable, submitElementIdSet, currentEntryTmpTable, billID);
            weakVerifyDTO = this.verifyOverlapPeriodInCycleScheme(ctx, submitScheme, dynamicEntryTable, submitElementIdSet, currentEntryTmpTable, billID);
        }
        finally {
            currentEntryTmpTable.release(ctx);
        }
        return weakVerifyDTO;
    }

    public void verifySameEffectDate(Context ctx, CalSubmitSchemeInfo submitScheme, String dynamicEntryTable, Set<String> submitElementIdSet, CmpTempTable currentEntryTmpTable, String billId) throws BOSException, EASBizException {
        String cycleVerifyBaseSql = this.getCycleVerifyBaseSql(ctx, dynamicEntryTable, currentEntryTmpTable, billId);
        String baseExistsWhereSql = SubmitBizKeyHelper.getExistsWhereSql(ctx, submitScheme, submitElementIdSet, new ArrayList<String>(), "entry", "temp");
        String sameCycleWhereSql = baseExistsWhereSql + " AND entry.FEffectDate = temp.FEffectDate AND entry.FBillState <> " + 4;
        String sameCycleVerifySql = String.format(cycleVerifyBaseSql, sameCycleWhereSql);
        VerifyDTO verifyDTO = new VerifyDTO();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("verifySameEffectDate SQL:" + sameCycleVerifySql));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sameCycleVerifySql);
            while (rs.next() && !verifyDTO.isMaxErrCount()) {
                String errorPartMes = MessageFormat.format(this.getMultiLan(ctx, "label34"), rs.getString("name"), rs.getString("number"));
                String errorMes = MessageFormat.format(this.getMultiLan(ctx, "label39"), errorPartMes, sdf.format(rs.getDate("effectDate")));
                verifyDTO.addErrorPart(errorMes);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (verifyDTO.existError()) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION3, new Object[]{verifyDTO.getJoinedPartMes(ctx)});
        }
    }

    protected WeakVerifyDTO verifyOverlapPeriodInCycleScheme(Context ctx, CalSubmitSchemeInfo submitScheme, String dynamicEntryTable, Set<String> submitElementIdSet, CmpTempTable currentEntryTmpTable, String billId) throws EASBizException, BOSException {
        String cycleVerifyBaseSql = this.getCycleVerifyBaseSql(ctx, dynamicEntryTable, currentEntryTmpTable, billId);
        String baseExistsWhereSql = SubmitBizKeyHelper.getExistsWhereSql(ctx, submitScheme, submitElementIdSet, new ArrayList<String>(), "entry", "temp");
        String overlapCycleWhereSql = baseExistsWhereSql + " AND entry.FEffectDate > temp.FEffectDate AND entry.FEffectDate <= temp.FLEffectDate AND entry.FBillState <> " + 4;
        String overlapCycleSql = String.format(cycleVerifyBaseSql, overlapCycleWhereSql);
        overlapCycleSql = overlapCycleSql + "ORDER BY entry.FPersonId ASC,entry.FEffectDate ASC";
        VerifyDTO verifyDTO = new VerifyDTO();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("verifyOverlapPeriodInCycleScheme SQL:" + overlapCycleSql));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)overlapCycleSql);
            while (rs.next() && !verifyDTO.isMaxErrCount()) {
                String errorPartMes = MessageFormat.format(this.getMultiLan(ctx, "label34"), rs.getString("name"), rs.getString("number"));
                verifyDTO.addErrorPart(errorPartMes);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (verifyDTO.existError()) {
            return new WeakVerifyDTO(WeakVerifyDTO.Result.BIZ_EXCEPTION, MessageFormat.format(this.getMultiLan(ctx, "label40"), verifyDTO.getJoinedPartMes(ctx)));
        }
        return new WeakVerifyDTO(WeakVerifyDTO.Result.SUCCESS);
    }

    public void verifyRepeatBizKeyInCycleScheme(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
        BatchSubmitShemeBillEntryCollection entryCols = info.getEntry();
        HashSet bizKeySet = Sets.newHashSet();
        SchemeBizKeyDefineCollection schemeBizKeyDefineCols = SubmitBizKeyHelper.getSchemeBizKeyDefineCollectionBySchemeId(ctx, info.getSubmitScheme().getId().toString());
        VerifyDTO verifyDTO = new VerifyDTO();
        for (int i = 0; i < entryCols.size() && !verifyDTO.isMaxErrCount(); ++i) {
            BatchSubmitShemeBillEntryInfo entry = entryCols.get(i);
            if (bizKeySet.add(SubmitBizKeyHelper.getSchemeBizKey(schemeBizKeyDefineCols, entry))) continue;
            String errorMes = MessageFormat.format(this.getMultiLan(ctx, "label34"), entry.getPerson().getName(), this.getNumber(entry));
            verifyDTO.addErrorPart(errorMes);
        }
        if (verifyDTO.existError()) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION2, new Object[]{verifyDTO.getJoinedPartMes(ctx), ""});
        }
    }

    protected String getNumber(BatchSubmitShemeBillEntryInfo entry) {
        String number = (String)entry.get("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            number = entry.getPerson().getNumber();
        }
        return number;
    }

    public void verifyEffectDateAndLeffectDateLegality(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException {
        BatchSubmitShemeBillEntryCollection entryCols = info.getEntry();
        VerifyDTO verifyDTO = new VerifyDTO();
        for (int i = 0; i < entryCols.size() && !verifyDTO.isMaxErrCount(); ++i) {
            BatchSubmitShemeBillEntryInfo entry = entryCols.get(i);
            if (entry.getLeffectDate() == null || entry.getEffectDate().compareTo(entry.getLeffectDate()) <= 0) continue;
            String errorMes = MessageFormat.format(this.getMultiLan(ctx, "label34"), entry.getPerson().getName(), this.getNumber(entry));
            verifyDTO.addErrorPart(errorMes);
        }
        if (verifyDTO.existError()) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION8, new Object[]{verifyDTO.getJoinedPartMes(ctx), ""});
        }
    }

    protected String getCycleVerifyBaseSql(Context ctx, String dynamicEntryTable, CmpTempTable cmpTempTable, String billId) {
        return "SELECT person.FName_" + LocaleUtils.getShortCode((Locale)ctx.getLocale()) + " name,FNumber number,entry.FEffectDate effectDate FROM " + dynamicEntryTable + " entry LEFT JOIN T_BD_Person person ON entry.FPersonId = person.FId WHERE EXISTS(SELECT 1 FROM T_HR_SBatchSubmitShemeBill WHERE entry.FBillId = FID AND FID <> '" + billId + "') AND EXISTS (SELECT 1 FROM " + cmpTempTable.getTmpTableName() + " temp WHERE %s)";
    }
}

