/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.confirm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.intelligent.confirm.AbstractCmpIntelConfirm;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.record.factory.impl.SocRecordImpl;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.record.validator.SocRecordValidator;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SocPersonDecreaseConfirm
extends AbstractCmpIntelConfirm {
    private static Logger logger = Logger.getLogger(SocPersonDecreaseConfirm.class);

    @Override
    public Map<String, Object> confirm() throws EASBizException, BOSException {
        int loseSize = 0;
        String errorMsg = "";
        HashMap<String, Object> confirmMap = new HashMap<String, Object>();
        List<CmpIntelMatchDataInfo> matchDatas = this.getMatchDataInfos();
        Map<String, Object> loseDataMap = this.filterLoseData(matchDatas);
        Map validDataMap = (Map)loseDataMap.get("validDataMap");
        Map stopMap = (Map)loseDataMap.get("stopMap");
        Set successSet = (Set)loseDataMap.get("successSet");
        if (successSet != null) {
            loseSize = successSet.size();
            SocRecordImpl socRecordImpl = (SocRecordImpl)RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.SOC);
            socRecordImpl.loseRecords(this.ctx, validDataMap);
            this.stopPayStatus(stopMap);
            this.changeState(successSet);
        }
        errorMsg = (String)loseDataMap.get("errorMsg");
        confirmMap.put("successSize", loseSize);
        confirmMap.put("errorMsg", errorMsg);
        return confirmMap;
    }

    private Map<String, Object> filterLoseData(List<CmpIntelMatchDataInfo> loseList) {
        String matchDataId = "";
        String personId = "";
        String socCategoryId = "";
        String customParamStr = "";
        String socRecordId = "";
        String hrOrgId = "";
        java.util.Date handleDate = null;
        CmpIntelState state = null;
        StringBuffer recordIds = new StringBuffer();
        CmpIntelMatchDataInfo matchDataInfo = null;
        HashMap<String, java.util.Date> allLoseDateMap = new HashMap<String, java.util.Date>();
        Map customMap = new HashMap();
        List<RocordValidatorInfo> errorList = new ArrayList<RocordValidatorInfo>();
        Map<String, String> socRecordMap = this.getSocPersonRecordMap();
        HashMap<String, String> matchToSocRecord = new HashMap<String, String>();
        HashMap<String, String> socCategoryMap = new HashMap<String, String>();
        HashMap<String, String> temp = new HashMap<String, String>();
        String errorMsg = "";
        int size = loseList.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = loseList.get(i);
            state = matchDataInfo.getState();
            if (CmpIntelState.CONFIRMED.equals((Object)state)) continue;
            matchDataId = matchDataInfo.getId().toString();
            hrOrgId = matchDataInfo.getHrOrgUnit().getId().toString();
            personId = matchDataInfo.getPerson().getId().toString();
            if (!socRecordMap.containsKey(hrOrgId + "_" + personId)) {
                String label35;
                matchToSocRecord.put(matchDataId, null);
                errorMsg = label35 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"label56", (Locale)this.ctx.getLocale());
                logger.info((Object)("record is not exists:" + errorMsg));
                temp.put(matchDataId, label35);
                continue;
            }
            customParamStr = matchDataInfo.getCustomParam();
            customMap = CmpIntelligentUtil.getJsonObj(customParamStr, customMap);
            socCategoryId = (String)customMap.get("socCategory");
            socCategoryId = CmpIntelligentUtil.uriDecode(socCategoryId);
            socRecordId = socRecordMap.get(hrOrgId + "_" + personId);
            recordIds.append(socRecordId).append(",");
            handleDate = matchDataInfo.getHandleDate();
            handleDate = new Date(handleDate.getTime());
            allLoseDateMap.put(socRecordId, handleDate);
            socCategoryMap.put(matchDataId + "_" + socRecordId, socCategoryId);
            matchToSocRecord.put(matchDataId, socRecordId + "_" + hrOrgId + "_" + personId);
        }
        SocRecordValidator validator = (SocRecordValidator)RecordInstanceFactory.getRecordValidatorInstance(RecordInstanceFactory.CATEGORY.SOC);
        try {
            if (recordIds.length() > 0) {
                logger.info((Object)("error recordIds:" + recordIds));
                errorList = validator.loseRecord(this.ctx, recordIds.substring(0, recordIds.length() - 1), handleDate);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Map<Object, Object> result = new HashMap();
        if (recordIds.length() > 0) {
            Map<String, RocordValidatorInfo> validateErrorMap = this.buildRecordDataMap(errorList);
            result = this.getResult(matchToSocRecord, validateErrorMap, allLoseDateMap, socCategoryMap);
        }
        logger.info((Object)("result" + result));
        Map<String, String> errorMap = result.get("errorMap") == null ? new HashMap() : (Map)result.get("errorMap");
        errorMsg = result.get("errorMap") == null ? errorMsg : result.get("errorMsg").toString();
        errorMap.putAll(temp);
        result.put("errorMap", errorMap);
        result.put("errorMsg", errorMsg);
        return result;
    }

    private Map<String, Object> getResult(Map<String, String> matchToSocRecord, Map<String, RocordValidatorInfo> validateErrorMap, Map<String, java.util.Date> allLoseDateMap, Map<String, String> socCategoryMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, java.util.Date> validDataMap = new HashMap<String, java.util.Date>();
        HashSet<String> successSet = new HashSet<String>();
        HashMap<String, HashMap<String, Object>> stopMap = new HashMap<String, HashMap<String, Object>>();
        Set<Map.Entry<String, String>> entrySet = matchToSocRecord.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        String matchDataId = "";
        String value = "";
        String socRecordId = "";
        String msg = "";
        String errorMsg = "";
        String socCategoryId = "";
        String hrOrgId = "";
        String personId = "";
        String[] split = null;
        RocordValidatorInfo info = null;
        java.util.Date handleDate = null;
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            matchDataId = next.getKey();
            value = next.getValue();
            if (CmpStrUtil.isEmpty(value)) {
                String label35 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label35", (Locale)this.ctx.getLocale());
                errorMap.put(matchDataId, label35);
                continue;
            }
            split = value.split("_");
            socRecordId = split[0];
            if (validateErrorMap.containsKey(socRecordId)) {
                info = validateErrorMap.get(socRecordId);
                errorMsg = msg = info.getMsg();
                errorMap.put(matchDataId, msg);
                continue;
            }
            hrOrgId = split[1];
            personId = split[2];
            handleDate = allLoseDateMap.get(socRecordId);
            if (new java.util.Date().before(handleDate)) {
                msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label27", (Locale)this.ctx.getLocale());
                errorMap.put(matchDataId, msg);
                errorMsg = msg;
                continue;
            }
            validDataMap.put(socRecordId, handleDate);
            socCategoryId = socCategoryMap.get(matchDataId + "_" + socRecordId);
            map = new HashMap();
            map.put("stopDate", handleDate);
            map.put("socCategoryId", socCategoryId);
            map.put("hrOrgId", hrOrgId);
            map.put("personId", personId);
            stopMap.put(socRecordId, map);
            successSet.add(matchDataId);
        }
        result.put("validDataMap", validDataMap);
        result.put("errorMap", errorMap);
        result.put("stopMap", stopMap);
        result.put("successSet", successSet);
        result.put("errorMsg", errorMsg);
        return result;
    }

    private void stopPayStatus(Map<String, Map<String, Object>> stopMap) {
        Object[] param = new Object[]{};
        Set<Map.Entry<String, Map<String, Object>>> entrySet = stopMap.entrySet();
        Iterator<Map.Entry<String, Map<String, Object>>> it = entrySet.iterator();
        String socRecordId = "";
        String socCategoryId = "";
        String hrOrgId = "";
        String personId = "";
        String effectDate = "";
        Map<Object, Object> valueMap = new HashMap();
        java.util.Date stopDate = null;
        String updateSql = "update T_HR_SSocEmpPayStatus set fsocPayStatus=0, FEffectDate=? where FSocPersonRecordID=?  and fsocCategoryId in (?)";
        String insertSql = "insert into T_HR_SSocEmpPayStatus (fid, fsocPayStatus, fpersonid, fsocCategoryId, FEffectDate, FUpdateDate, FHrOrgUnitID, FSocPersonRecordID) values (newbosid('585E694A'), 0, ?, ?, ?, now(), ?, ?)";
        try {
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<String, Map<String, Object>> entry = it.next();
                socRecordId = entry.getKey();
                valueMap = entry.getValue();
                stopDate = (java.util.Date)valueMap.get("stopDate");
                effectDate = CmpDateUtil.toKSqlDate(stopDate);
                socCategoryId = (String)valueMap.get("socCategoryId");
                socCategoryId = CmpSQLUtil.createInSql(this.ctx, socCategoryId, "T_HR_SSocCategory", "fid");
                hrOrgId = (String)valueMap.get("hrOrgId");
                personId = (String)valueMap.get("personId");
                param = new Object[]{personId, socCategoryId, stopDate, hrOrgId, socRecordId};
                updateSql = "update T_HR_SSocEmpPayStatus set fsocPayStatus=0, FEffectDate=" + effectDate + " where FSocPersonRecordID='" + socRecordId + "'  and fsocCategoryId in (" + socCategoryId + ")";
                count = CmpSQLUtil.executeUpdate(this.ctx, updateSql);
                if (count != 0) continue;
                DbUtil.execute((Context)this.ctx, (String)insertSql, (Object[])param);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, RocordValidatorInfo> buildRecordDataMap(List<RocordValidatorInfo> errorList) {
        HashMap<String, RocordValidatorInfo> map = new HashMap<String, RocordValidatorInfo>();
        String recordId = "";
        RocordValidatorInfo info = null;
        int size = errorList.size();
        for (int i = 0; i < size; ++i) {
            info = errorList.get(i);
            recordId = info.getCode();
            map.put(recordId, info);
        }
        return map;
    }

    private Map<String, String> getSocPersonRecordMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fid, fpersonId, FHrOrgUnitID from T_HR_SSocPersonRecord";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            String personId = "";
            String personCmpId = "";
            String hrOrgId = "";
            while (rs.next()) {
                personCmpId = rs.getString("fid");
                personId = rs.getString("fpersonId");
                hrOrgId = rs.getString("FHrOrgUnitID");
                map.put(hrOrgId + "_" + personId, personCmpId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }
}

