/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelMatchData;
import com.kingdee.shr.compensation.intelligent.execution.CmpIntelCommonExecution;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.record.SocPBManageImpl;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SocPersonIncreaseExecution
extends CmpIntelCommonExecution {
    private static Logger logger = Logger.getLogger(SocPersonIncreaseExecution.class);
    protected String bizManageType = "CMP03";
    protected String detail = "";
    protected boolean hasDate = true;

    @Override
    public String getCustomParam(Map<String, Object> paramMap) {
        String socCategory = (String)paramMap.get("socCategory");
        String bfMonthStr = (String)paramMap.get("bfMonth");
        String afMonthStr = (String)paramMap.get("afMonth");
        int bfMonth = Integer.parseInt(bfMonthStr);
        int afMonth = Integer.parseInt(afMonthStr);
        String socCategorysStr = "";
        if (CmpStrUtil.isNotEmpty(socCategory)) {
            String socCategoryJsonStr = socCategory.substring(socCategory.indexOf("=") + 1, socCategory.length());
            socCategorysStr = socCategoryJsonStr.indexOf("[") > -1 ? CmpIntelligentUtil.getJsonArrayFieldFromStr(socCategoryJsonStr, "id") : socCategory.substring(socCategory.indexOf("=") + 1, socCategory.lastIndexOf("_"));
        }
        String result = "{socCategory:\"" + socCategorysStr + "\", bfMonth: " + bfMonth + ", afMonth:" + afMonth + "}";
        return result;
    }

    @Override
    protected java.util.Date getActualDate(java.util.Date changeDate, String dateJson, String customParam) {
        Calendar calendar = Calendar.getInstance();
        java.util.Date handleDate = super.getActualDate(changeDate, dateJson, customParam);
        Map customMap = new HashMap();
        customMap = CmpIntelligentUtil.getJsonObj(customParam, customMap);
        Map dateMap = new HashMap();
        dateMap = CmpIntelligentUtil.getJsonObj(dateJson, dateMap);
        Map dayMap = (Map)dateMap.get("day");
        Double dayType = (Double)dayMap.get("type");
        Double dayValue = (Double)dayMap.get("value");
        Double bfMonthStr = (Double)customMap.get("bfMonth");
        Double afMonthStr = (Double)customMap.get("afMonth");
        int bfMonth = bfMonthStr.intValue();
        int afMonth = afMonthStr.intValue();
        calendar.setTime(changeDate);
        int day = handleDate.getDate();
        if (changeDate.before(handleDate) || changeDate.equals(handleDate)) {
            calendar.add(2, bfMonth);
            int lastDay = calendar.getActualMaximum(5);
            if (1.0 == dayType) {
                Double symbol = (Double)dayMap.get("symbol");
                if (0.0 == symbol && dayValue == 1.0) {
                    calendar.set(5, lastDay);
                }
            } else if (dayValue.intValue() > lastDay) {
                calendar.set(5, lastDay);
            } else {
                calendar.set(5, dayValue.intValue());
            }
        } else {
            calendar.add(2, afMonth);
            int lastDay = calendar.getActualMaximum(5);
            if (1.0 == dayType) {
                Double symbol = (Double)dayMap.get("symbol");
                if (0.0 == symbol && dayValue == 1.0) {
                    calendar.set(5, lastDay);
                }
            } else if (dayValue.intValue() > lastDay) {
                calendar.set(5, lastDay);
            } else {
                calendar.set(5, dayValue.intValue());
            }
        }
        handleDate = calendar.getTime();
        return handleDate;
    }

    @Override
    protected void addPersonBizManager(List<PersonBURelationInfo> personBuList) throws BOSException, EASBizException {
        SocPBManageImpl personBiz = new SocPBManageImpl();
        personBiz.batchAddNewPersonBizManage(this.ctx, personBuList);
        super.addPersonBizManager(personBuList);
    }

    @Override
    protected void afterExecute(CoreBaseCollection coll) {
        ArrayList<String> buList = new ArrayList<String>();
        ArrayList<CmpIntelMatchDataInfo> matchDatas = new ArrayList<CmpIntelMatchDataInfo>();
        PersonBURelationInfo pbuRelation = null;
        CmpIntelMatchDataInfo matchDataInfo = null;
        SocPBManageImpl personBiz = new SocPBManageImpl();
        try {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                matchDataInfo = (CmpIntelMatchDataInfo)coll.get(i);
                if (buList.size() >= 400) {
                    personBiz.batchEnablePersonBizManage(this.ctx, buList);
                    buList.clear();
                }
                if ((pbuRelation = matchDataInfo.getPbuRelation()) == null) continue;
                buList.add(pbuRelation.getId().toString());
            }
            personBiz.batchEnablePersonBizManage(this.ctx, buList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        java.util.Date handleDate = null;
        java.util.Date socEffDate = null;
        String customParamStr = "";
        String socCategoryId = "";
        String hrOrgId = "";
        String personId = "";
        String newEmpPosId = "";
        Object[] addParam = null;
        Object[] updateParam = null;
        Map customMap = new HashMap();
        ArrayList<Object[]> addParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        Object[] socRecordParam = null;
        EmpPosOrgRelationInfo empPosOrgRelaInfo = null;
        Map empPosOrgReMap = (Map)this.cacheMap.get("empPosOrgReMap");
        ArrayList<Object[]> socRecordParamList = new ArrayList<Object[]>();
        PersonBURelaConfirmInfo confirmInfo = null;
        HROrgUnitInfo hrOrgInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = (CmpIntelMatchDataInfo)coll.get(i);
            customParamStr = matchDataInfo.getCustomParam();
            customMap = CmpIntelligentUtil.getJsonObj(customParamStr, customMap);
            socCategoryId = (String)customMap.get("socCategory");
            socCategoryId = CmpIntelligentUtil.uriDecode(socCategoryId);
            handleDate = matchDataInfo.getHandleDate();
            handleDate = new Date(handleDate.getTime());
            confirmInfo = matchDataInfo.getPbuConfirm();
            hrOrgInfo = confirmInfo.getNewHrOrgUnit() == null ? confirmInfo.getDefaultHrOrgUnit() : confirmInfo.getNewHrOrgUnit();
            hrOrgId = hrOrgInfo.getId().toString();
            personId = confirmInfo.getPerson().getId().toString();
            newEmpPosId = confirmInfo.getNewEmpOrgRelation().getId().toString();
            empPosOrgRelaInfo = (EmpPosOrgRelationInfo)empPosOrgReMap.get(newEmpPosId);
            if (empPosOrgRelaInfo == null) {
                try {
                    empPosOrgRelaInfo = EmpPosOrgRelationFactory.getLocalInstance((Context)this.ctx).getEmpPosOrgRelationInfo("where id = '" + newEmpPosId + "'");
                }
                catch (Exception e) {
                    logger.error((Object)("Compensation assembly business relationship error:" + confirmInfo.getId()), (Throwable)e);
                }
            }
            socEffDate = null == empPosOrgRelaInfo ? null : empPosOrgRelaInfo.getEFFDT();
            socRecordParam = new Object[]{socEffDate, hrOrgId, personId, socEffDate};
            if (StringUtils.isEmpty((CharSequence)socCategoryId)) continue;
            String[] socCategoryIdArr = socCategoryId.split(",");
            for (int j = 0; j < socCategoryIdArr.length; ++j) {
                addParam = new Object[]{1, personId, socCategoryIdArr[j], handleDate, hrOrgId, "tempRecord"};
                updateParam = new Object[]{1, handleDate, hrOrgId, socCategoryIdArr[j], personId};
                addParamList.add(addParam);
                updateParamList.add(updateParam);
            }
            socRecordParamList.add(socRecordParam);
            matchDatas.add(matchDataInfo);
        }
        this.updateSocEffectDate(socRecordParamList);
        this.updateSocPayStatus(addParamList, updateParamList);
        this.updateSocRecord();
        this.changeState(matchDatas);
    }

    protected void changeState(List<CmpIntelMatchDataInfo> list) {
        CmpIntelMatchDataInfo cmpIntelMatchDataInfo = null;
        CoreBaseCollection coll = new CoreBaseCollection();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            cmpIntelMatchDataInfo = list.get(i);
            cmpIntelMatchDataInfo.setState(CmpIntelState.CONFIRMED);
            coll.add((CoreBaseInfo)cmpIntelMatchDataInfo);
        }
        try {
            ICmpIntelMatchData cmpIntelMatchData = CmpIntelMatchDataFactory.getLocalInstance((Context)this.ctx);
            cmpIntelMatchData.update(coll);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateSocEffectDate(List<Object[]> paramList) {
        String sql = "update t_hr_ssocpersonrecord set FEffectDate=? where FHrOrgUnitID=? and fpersonid=? and FEffectDate>?";
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, paramList);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateSocPayStatus(List<Object[]> addPayStatusParamList, List<Object[]> updatePayStatusParamList) {
        String tempTable = SQLHandleUtil.createTempTableName(this.ctx);
        String creatTable = "select FHrOrgUnitID,FPersonID,FSocCategoryID  into " + tempTable + " from T_HR_SSocEmpPayStatus where 1<>1";
        String insertsql = "insert into " + tempTable + "(FHrOrgUnitID,FPersonID,FSocCategoryID) values (?,?,?)";
        ArrayList<Object[]> tempParam = new ArrayList<Object[]>();
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        ArrayList<Object[]> distinctAddPayStatusParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> distinctUpdatePayStatusParamList = new ArrayList<Object[]>();
        for (int i = 0; i < updatePayStatusParamList.size(); ++i) {
            Object[] objects = updatePayStatusParamList.get(i);
            String dateKey = objects[2] + "_" + objects[4] + "_" + objects[3];
            if (dateMap.containsKey(dateKey)) {
                if (objects[1] == null) continue;
                java.util.Date parseDate2 = (java.util.Date)objects[1];
                if (dateMap.get(dateKey) == null) {
                    dateMap.put(dateKey, parseDate2);
                    continue;
                }
                java.util.Date parseDate1 = (java.util.Date)dateMap.get(dateKey);
                if (parseDate1.compareTo(parseDate2) != 1) continue;
                dateMap.put(dateKey, parseDate2);
                continue;
            }
            dateMap.put(dateKey, objects[1]);
            tempParam.add(new Object[]{objects[2], objects[4], objects[3]});
            distinctAddPayStatusParamList.add(addPayStatusParamList.get(i));
            distinctUpdatePayStatusParamList.add(objects);
        }
        try {
            DbUtil.execute((Context)this.ctx, (String)creatTable);
            DbUtil.executeBatch((Context)this.ctx, (String)insertsql, tempParam);
            String queryExistSql = "select soc.FHrOrgUnitID,soc.FPersonID,soc.FSocCategoryID,soc.FSocPayStatus from T_HR_SSocEmpPayStatus soc inner join " + tempTable + " temp on soc.FHrOrgUnitID=temp.FHrOrgUnitID and soc.FPersonID=temp.FPersonID and soc.FSocCategoryID=temp.FSocCategoryID   union select soc2.FHrOrgUnitID,soc2.FPersonID,soc2.FSocCategoryID,soc2.FSocPayStatus from T_HR_SSocEmpPayStatus soc2 inner join  " + tempTable + " temp2 on soc2.FHrOrgUnitID<>temp2.FHrOrgUnitID and soc2.FPersonID = temp2.FPersonID and soc2.FSocCategoryID=temp2.FSocCategoryID and soc2.FSocPayStatus=1";
            IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)queryExistSql);
            HashMap<String, ArrayList<String>> hrOrgIdMap = new HashMap<String, ArrayList<String>>();
            HashMap<String, ArrayList<String>> statusMap = new HashMap<String, ArrayList<String>>();
            while (iRowSet.next()) {
                String mapKey = iRowSet.getString("FPersonID") + "_" + iRowSet.getString("FSocCategoryID");
                ArrayList<String> hrOrgIdArr = (ArrayList<String>)hrOrgIdMap.get(mapKey);
                if (hrOrgIdArr == null) {
                    hrOrgIdArr = new ArrayList<String>();
                    hrOrgIdMap.put(mapKey, hrOrgIdArr);
                }
                hrOrgIdArr.add(iRowSet.getString("FHrOrgUnitID"));
                ArrayList<String> statusArr = (ArrayList<String>)statusMap.get(mapKey);
                if (statusArr == null) {
                    statusArr = new ArrayList<String>();
                    statusMap.put(mapKey, statusArr);
                }
                statusArr.add(iRowSet.getString("FSocPayStatus"));
            }
            CmpSQLUtil.releaseTemptTable(this.ctx, tempTable);
            ArrayList<Object[]> realInsertParams = new ArrayList<Object[]>();
            ArrayList<Object[]> realUpdateParams = new ArrayList<Object[]>();
            int size = distinctAddPayStatusParamList.size();
            for (int i = 0; i < size; ++i) {
                ArrayList statusArr;
                Object[] updateParam = (Object[])distinctUpdatePayStatusParamList.get(i);
                Object[] addParam = (Object[])distinctAddPayStatusParamList.get(i);
                int status = (Integer)updateParam[0];
                String dateKey = updateParam[2] + "_" + updateParam[4] + "_" + updateParam[3];
                java.util.Date handleDate = (java.util.Date)dateMap.get(dateKey);
                String effectDate = CmpDateUtil.toKSqlDate(handleDate);
                String hrOrgId = (String)updateParam[2];
                String socCategoryId = (String)updateParam[3];
                String personId = (String)updateParam[4];
                String mapKey = personId + "_" + socCategoryId;
                ArrayList hrOrgIdArr = (ArrayList)hrOrgIdMap.get(mapKey);
                if (hrOrgIdArr == null) {
                    hrOrgIdArr = new ArrayList();
                }
                if ((statusArr = (ArrayList)statusMap.get(mapKey)) == null) {
                    statusArr = new ArrayList();
                }
                if (hrOrgIdArr.contains(hrOrgId) && !statusArr.contains("1")) {
                    realUpdateParams.add(new Object[]{status, effectDate, hrOrgId, socCategoryId, personId});
                    continue;
                }
                if (hrOrgIdArr.contains(hrOrgId)) continue;
                addParam[0] = statusArr.contains("1") ? 0 : 1;
                realInsertParams.add(addParam);
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
            String userId = "00000000-0000-0000-0000-00000000000013B7DE7F";
            if (userInfo != null && userInfo.getId() != null) {
                userId = userInfo.getId().toString();
            }
            String time = CmpDateUtil.toKSqlDate(new java.util.Date());
            String insertSql = "insert into T_HR_SSocEmpPayStatus (fid, fsocPayStatus, fpersonid, fsocCategoryId, FEffectDate, FHrOrgUnitID, FSocPersonRecordID,FCREATORID,FLASTUPDATEUSERID,FCREATETIME,FLASTUPDATETIME) values (newbosid('585E694A'), ?, ?, ?, ?, ?, ?,'" + userId + "','" + userId + "'," + time + "," + time + ")";
            String updateSql = "update T_HR_SSocEmpPayStatus set FSocPayStatus = ?, FEffectDate = ?, FUpdateDate=now(), FLastUpdateTime=now(),FLASTUPDATEUSERID = '" + userId + "' where FHrOrgUnitID=? and fsocCategoryId=? and FPersonID=? ";
            DbUtil.executeBatch((Context)this.ctx, (String)insertSql, realInsertParams);
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, realUpdateParams);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateSocRecord() {
        String updateSql = "update T_HR_SSocEmpPayStatus a set FSocPersonRecordID = (select fid from t_hr_ssocpersonrecord where fpersonid=a.fpersonid and FHrOrgUnitID=a.FHrOrgUnitID)";
        try {
            DbUtil.execute((Context)this.ctx, (String)updateSql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean needPbuRelation() {
        return true;
    }

    @Override
    public String getBizManageType() {
        return this.bizManageType;
    }

    @Override
    public List<String> getDetail(Map<String, Object> paramMap) {
        String condition = (String)paramMap.get("socCategory");
        String socCatName = "";
        if (CmpStrUtil.isNotEmpty(condition)) {
            if (condition.indexOf("[") > -1) {
                String socCatJsonArrStr = condition.substring(condition.indexOf("=") + 1, condition.length());
                socCatName = CmpIntelligentUtil.getJsonArrayFieldFromStr(socCatJsonArrStr, "name");
            } else {
                socCatName = condition.substring(condition.lastIndexOf("_") + 1, condition.length() - 1);
            }
        }
        ArrayList socCatName_l1 = new ArrayList();
        ArrayList socCatName_l2 = new ArrayList();
        ArrayList socCatName_l3 = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)socCatName)) {
            String[] socCatNameAr = socCatName.split(",");
            for (int i = 0; i < socCatNameAr.length; ++i) {
                List nameList = (List)this.mapSocCategory.get(socCatNameAr[i]);
                if (nameList == null) continue;
                socCatName_l1.add(nameList.get(0));
                socCatName_l2.add(nameList.get(1));
                socCatName_l3.add(nameList.get(2));
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"SOCPERSONADD_MSG", (Locale)LocaleUtils.locale_l1) + ", " + EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"class", (Locale)LocaleUtils.locale_l1) + " :" + StringUtils.join((Object[])socCatName_l1.toArray(), (String)", "));
        list.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"SOCPERSONADD_MSG", (Locale)LocaleUtils.locale_l2) + ", " + EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"class", (Locale)LocaleUtils.locale_l2) + " :" + StringUtils.join((Object[])socCatName_l2.toArray(), (String)", "));
        list.add(EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"SOCPERSONADD_MSG", (Locale)LocaleUtils.locale_l3) + ", " + EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"class", (Locale)LocaleUtils.locale_l3) + " :" + StringUtils.join((Object[])socCatName_l3.toArray(), (String)", "));
        return list;
    }

    @Override
    public boolean isHasDate() {
        return this.hasDate;
    }

    @Override
    protected String getCustomFilter() {
        String hrOrgId = this.cacheMap.get("hrOrgId").toString();
        return "confirmState=0 and (bizDefineType=10 and bizDefineEntrySeq=2 or bizDefineType!=10)";
    }
}

