/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.execution;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.app.intelligent.CmpSynTaxMatchLogFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpSynTaxMatchLogInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelSyncTaxUnitJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.CustomFilter;
import com.kingdee.shr.compensation.intelligent.dto.json.Scheme;
import com.kingdee.shr.compensation.intelligent.dto.json.SyncTaxUnit;
import com.kingdee.shr.compensation.intelligent.execution.AbstractCmpIntelExecution;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentFilterUtil;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class TaxUnitSyncPersonExecution
extends AbstractCmpIntelExecution {
    private static Logger logger = Logger.getLogger(TaxUnitSyncPersonExecution.class);

    @Override
    protected CoreBaseCollection buildMatchData() throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void execute() throws EASBizException, BOSException {
        Map<String, Object> res = this.getCmpSynTaxUnitConfig(this.ctx, this.ruleId, this.catalogId);
        List cmpSynTaxUnitConfig = (List)res.get("config");
        Map schemeMap = (Map)res.get("schemeMap");
        if (cmpSynTaxUnitConfig.size() == 0) {
            return;
        }
        for (CmpItelSyncTaxUnitJsonBean config : cmpSynTaxUnitConfig) {
            List<Scheme> scheme = config.getScheme();
            SyncTaxUnit syncTaxUnit = config.getSyncTaxUnit();
            CustomFilter customFilter = config.getPersonRange().getCustomFilter();
            HashSet<String> schemeIdSet = new HashSet<String>();
            for (Scheme sc : scheme) {
                if (!schemeMap.containsKey(sc.getId())) continue;
                schemeIdSet.add(sc.getId());
            }
            if (schemeIdSet.size() == 0) continue;
            String createInSql = CmpSQLUtil.createInSql(this.ctx, schemeIdSet, "t_hr_scalScheme", "fid");
            FilterInfo filter = null;
            try {
                filter = new FilterInfo("sync_calScheme.id in " + createInSql);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            String customCondition = CmpIntelligentFilterUtil.getSyncOrgPositionOtherFilter(this.ctx, customFilter, filter, null);
            for (String schemeId : schemeIdSet) {
                java.util.Date syncTaxUnitDate;
                CalSchemeInfo calSchemeInfo = (CalSchemeInfo)schemeMap.get(schemeId);
                if (calSchemeInfo == null || (syncTaxUnitDate = this.getSyncTaxUnitDate(this.ctx, calSchemeInfo, syncTaxUnit)) == null) continue;
                try {
                    this.doSyncTaxUnit(this.ctx, customCondition, syncTaxUnitDate, calSchemeInfo, syncTaxUnit);
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void doSyncTaxUnit(Context ctx, String customCondition, java.util.Date syncTaxUnitDate, CalSchemeInfo calSchemeInfo, SyncTaxUnit syncTaxUnit) throws BOSException, SQLException, EASBizException {
        String sql = this.getTaxSyncSql(ctx, customCondition, syncTaxUnitDate, calSchemeInfo);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String tempPersonId = "";
        int tempIndex = 0;
        Date tempDate = null;
        boolean jump = false;
        while (rs.next()) {
            String personId = rs.getString("personId");
            int index = rs.getInt("index");
            Date date = rs.getDate("judgeDate");
            String caltableId = rs.getString("caltableId");
            String cTaxUnitId = rs.getString("cTaxUnitId");
            String taxUnitId = rs.getString("taxUnitId");
            if (!tempPersonId.equals(personId)) {
                tempPersonId = personId;
                tempIndex = index;
                tempDate = date;
                jump = false;
                params.add(new Object[]{taxUnitId, cTaxUnitId, caltableId, personId});
                continue;
            }
            if (jump) continue;
            if (tempIndex == index && date.compareTo(tempDate) == 0) {
                params.remove(params.size() - 1);
            }
            jump = true;
        }
        this.doWithResult(ctx, params, calSchemeInfo, syncTaxUnit, syncTaxUnitDate);
    }

    private void doWithResult(Context ctx, List<Object[]> params, CalSchemeInfo calSchemeInfo, SyncTaxUnit syncTaxUnit, java.util.Date syncTaxUnitDate) throws EASBizException, BOSException {
        if (params == null || params.size() == 0) {
            return;
        }
        CoreBaseCollection coll = new CoreBaseCollection();
        CmpSynTaxMatchLogInfo baseLogInfo = new CmpSynTaxMatchLogInfo();
        baseLogInfo.setCalScheme(calSchemeInfo);
        baseLogInfo.setPeriodYear(calSchemeInfo.getPeriodYear());
        baseLogInfo.setPeriodMonth(calSchemeInfo.getPeriodMonth());
        baseLogInfo.setCalTime(calSchemeInfo.getCalTime());
        CmpIntelRuleInfo ruleInfo = new CmpIntelRuleInfo();
        ruleInfo.setId(BOSUuid.read((String)this.ruleId));
        baseLogInfo.setCmpIntelRule(ruleInfo);
        CmpIntelCatalogInfo catalogInfo = new CmpIntelCatalogInfo();
        catalogInfo.setId(BOSUuid.read((String)this.catalogId));
        baseLogInfo.setCmpIntelCatalog(catalogInfo);
        baseLogInfo.setState(CmpIntelState.CONFIRMED);
        baseLogInfo.setHandleDate(new java.util.Date());
        baseLogInfo.setHrOrgUnit(calSchemeInfo.getHrOrgUnit());
        baseLogInfo.setEffdt(new java.util.Date());
        String syncTaxUnitPeriod = syncTaxUnit.getSyncTaxUnitPeriod();
        String syncTaxUnitDay = syncTaxUnit.getSyncTaxUnitDay();
        String periodTag = CmpConstants.SYNC_LAST_PERIOD.equals(syncTaxUnitPeriod) ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label82", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label83", (Locale)ctx.getLocale());
        syncTaxUnitDay = "32".equals(syncTaxUnitDay) ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label84", (Locale)ctx.getLocale()) : syncTaxUnitDay + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label102", (Locale)ctx.getLocale());
        syncTaxUnitDay = syncTaxUnitDay + "(" + CmpStrUtil.toString(syncTaxUnitDate) + ")";
        baseLogInfo.setMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label85", (Locale)ctx.getLocale()), periodTag, syncTaxUnitDay));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < params.size(); ++i) {
            Object[] param = params.get(i);
            if (param[0] == null || param[0].equals(param[1])) continue;
            paramList.add(new Object[]{param[0], param[2]});
            CmpSynTaxMatchLogInfo tagLogInfo = new CmpSynTaxMatchLogInfo();
            BeanUtils.copyProperties((Object)baseLogInfo, (Object)tagLogInfo);
            TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
            taxUnitInfo.setId(BOSUuid.read((String)param[0].toString()));
            tagLogInfo.setNewTaxUnit(taxUnitInfo);
            if (param[1] != null) {
                taxUnitInfo = new TaxUnitInfo();
                taxUnitInfo.setId(BOSUuid.read((String)param[1].toString()));
                tagLogInfo.setOldTaxUnit(taxUnitInfo);
            }
            CmpCalTableInfo caltableInfo = new CmpCalTableInfo();
            caltableInfo.setId(BOSUuid.read((String)param[2].toString()));
            tagLogInfo.setCmpCalTable(caltableInfo);
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)param[3].toString()));
            tagLogInfo.setPerson(person);
            coll.add((CoreBaseInfo)tagLogInfo);
        }
        CmpSynTaxMatchLogFactory.getLocalInstance((Context)ctx).save(coll);
        DbUtil.executeBatch((Context)ctx, (String)"update t_hr_scmpcaltable set ftaxUnitId = ? where fid = ?", paramList);
    }

    private String getTaxSyncSql(Context ctx, String customCondition, java.util.Date syncTaxUnitDate, CalSchemeInfo calSchemeInfo) {
        String calTableFilter = "select fid from t_hr_scmpcaltable where fcalschemeId = '" + calSchemeInfo.getId() + "' and fperiodYear = " + calSchemeInfo.getPeriodYear() + " and fperiodMonth = " + calSchemeInfo.getPeriodMonth() + " and fcaltime = " + calSchemeInfo.getCalTime() + " and FCalTaxDataState = 0 and fcalstate <= 4 " + (CmpStrUtil.isEmpty(customCondition) ? "" : " and fid not in (" + customCondition + ")");
        calTableFilter = SQLHandleUtil.getTempTable(ctx, calTableFilter);
        String sqlStr = CmpDateUtil.toKSqlDate(syncTaxUnitDate);
        String sql = "select caltableId,personId,\"index\",judgeDate,cTaxUnitId,taxUnitId from ( select caltable.fid as caltableId,tpr.fpersonid as personId,cTaxUnit.fid as cTaxUnitId,tpre.FTaxUnitID as taxUnitId, 1 as \"index\",  tpre.FEmployedDate as judgeDate from T_HR_STaxPersonRecord tpr inner join  T_HR_STaxPersonRecordEntry tpre on tpr.fid = tpre.FBillID  inner join t_hr_scmpcaltable caltable on tpr.FPERSONID = caltable.FPERSONID  left join t_hr_taxUnit cTaxUnit on caltable.ftaxUnitId= cTaxUnit.fid  where caltable.fid in (" + calTableFilter + ") and tpre.FEmployedDate <=" + sqlStr + " and (tpre.FDepartureDate is null or tpre.FDepartureDate >=" + sqlStr + ") union all select caltable.fid as caltableId,ptu.FPersonId as personId,cTaxUnit.fid as cTaxUnitId,ptu.FTaxUnitId as taxUnitId,2 as \"index\", ptu.FEFFDT as judgeDate from T_HR_SPERSONTAXUNIT ptu  inner join t_hr_scmpcaltable caltable on ptu.FPERSONID = caltable.FPERSONID  left join t_hr_taxUnit cTaxUnit on caltable.ftaxUnitId= cTaxUnit.fid  where caltable.fid in (" + calTableFilter + ") and ptu.FEFFDT <=" + sqlStr + " and ptu.FLEFFDT >=" + sqlStr + " ) temp order by personId,\"index\",judgeDate desc";
        return sql;
    }

    private java.util.Date getSyncTaxUnitDate(Context ctx, CalSchemeInfo calSchemeInfo, SyncTaxUnit syncTaxUnit) {
        String syncTaxUnitPeriod = syncTaxUnit.getSyncTaxUnitPeriod();
        String syncTaxUnitDayStr = syncTaxUnit.getSyncTaxUnitDay();
        int syncTaxUnitDay = Integer.parseInt(syncTaxUnitDayStr);
        java.util.Date taxUnitActualDate = calSchemeInfo.getEndDate();
        Calendar taxUnitCal = Calendar.getInstance();
        taxUnitCal.setTime(taxUnitActualDate);
        CmpPeriodTypeEnum periodType = calSchemeInfo.getCmpPeriodType();
        int lastDay = taxUnitCal.get(5);
        if (periodType != CmpPeriodTypeEnum.halfmonth) {
            if (lastDay < syncTaxUnitDay) {
                syncTaxUnitDay = lastDay;
            }
            taxUnitCal.set(5, syncTaxUnitDay);
        }
        CalSchemeInfo taxUnitScheme = (CalSchemeInfo)calSchemeInfo.clone();
        if (CmpConstants.SYNC_LAST_PERIOD.equals(syncTaxUnitPeriod)) {
            if (periodType == CmpPeriodTypeEnum.month) {
                taxUnitCal.add(2, -1);
            } else if (periodType == CmpPeriodTypeEnum.quarter) {
                taxUnitCal.add(2, -3);
            } else if (periodType == CmpPeriodTypeEnum.half) {
                taxUnitCal.add(2, -6);
            } else if (periodType == CmpPeriodTypeEnum.yeay) {
                taxUnitCal.add(1, -1);
            } else if (periodType == CmpPeriodTypeEnum.halfmonth) {
                Calendar tmpCal = Calendar.getInstance();
                tmpCal.setTime(taxUnitScheme.getBeginDate());
                tmpCal.add(5, -1);
                java.util.Date lastEndate = tmpCal.getTime();
                tmpCal.setTime(taxUnitScheme.getEndDate());
                taxUnitScheme.setEndDate(lastEndate);
                tmpCal.add(2, -1);
                tmpCal.add(5, 1);
                taxUnitScheme.setBeginDate(tmpCal.getTime());
                taxUnitCal.setTime(taxUnitScheme.getEndDate());
            }
        }
        if (periodType == CmpPeriodTypeEnum.halfmonth) {
            if (syncTaxUnitDay == 32) {
                taxUnitCal.setTime(taxUnitScheme.getEndDate());
            } else if (taxUnitScheme.getEndDate().getDate() > taxUnitScheme.getBeginDate().getDate()) {
                taxUnitCal.set(5, syncTaxUnitDay);
                if (taxUnitCal.getTime().after(taxUnitScheme.getEndDate()) || taxUnitCal.getTime().before(taxUnitScheme.getBeginDate())) {
                    return null;
                }
            } else {
                if (syncTaxUnitDay > taxUnitScheme.getEndDate().getDate() && syncTaxUnitDay < taxUnitScheme.getBeginDate().getDate()) {
                    return null;
                }
                if (syncTaxUnitDay < taxUnitScheme.getEndDate().getDate()) {
                    taxUnitCal.set(5, syncTaxUnitDay);
                } else if (syncTaxUnitDay >= taxUnitScheme.getBeginDate().getDate()) {
                    taxUnitCal.setTime(taxUnitScheme.getBeginDate());
                    int maxNum = taxUnitCal.getActualMaximum(5);
                    if (syncTaxUnitDay > maxNum) {
                        syncTaxUnitDay = maxNum;
                    }
                    taxUnitCal.set(5, syncTaxUnitDay);
                }
            }
        }
        taxUnitActualDate = taxUnitCal.getTime();
        return taxUnitActualDate;
    }

    private Map<String, Object> getCmpSynTaxUnitConfig(Context ctx, String ruleId, String catalogId) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        HashMap<String, CalSchemeInfo> schemeMap = new HashMap<String, CalSchemeInfo>();
        HashSet<String> schemeIdSet = new HashSet<String>();
        ArrayList<CmpItelSyncTaxUnitJsonBean> configList = new ArrayList<CmpItelSyncTaxUnitJsonBean>();
        String oql = "select data where cmpIntelRule.id='" + ruleId + "' and cmpIntelCatalog.id='" + catalogId + "' order by index desc";
        CmpIntelEntryCollection coll = CmpIntelEntryFactory.getLocalInstance((Context)ctx).getCmpIntelEntryCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CmpIntelEntryInfo cmpIntelEntryInfo = coll.get(i);
            String entryJsonData = cmpIntelEntryInfo.getData();
            CmpItelSyncTaxUnitJsonBean synTaxUnitConfig = CmpIntelligentUtil.getJsonObj(entryJsonData, new CmpItelSyncTaxUnitJsonBean());
            configList.add(synTaxUnitConfig);
            for (Scheme sc : synTaxUnitConfig.getScheme()) {
                schemeIdSet.add(sc.getId());
            }
        }
        res.put("config", configList);
        String sql = "select id,periodYear,periodMonth,caltime,cmpPeriodType,endDate,beginDate,hrOrgUnit where id in " + CmpSQLUtil.createInSql(ctx, schemeIdSet, "t_hr_scalscheme", "id") + " and taxUnit.id is not null";
        CalSchemeCollection schemeCollection = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeCollection(sql);
        for (int i = 0; i < schemeCollection.size(); ++i) {
            CalSchemeInfo calSchemeInfo = schemeCollection.get(i);
            schemeMap.put(calSchemeInfo.getId().toString(), calSchemeInfo);
        }
        res.put("schemeMap", schemeMap);
        return res;
    }
}

