/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.assemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.RecordConstant;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AdjustRecordAssemble {
    public static Map<String, Object> getEnableData(Context ctx, List<String> pbuList) throws BOSException {
        RecordDataInfo recordDataInfo;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<RecordDataInfo> creRecordList = new ArrayList<RecordDataInfo>();
        ArrayList<RecordDataInfo> upCmpEmpList = new ArrayList<RecordDataInfo>();
        ArrayList<RecordDataInfo> creEmpList = new ArrayList<RecordDataInfo>();
        String enableDataSql = AdjustRecordSQL.getEnableDataSql(CmpStrUtil.convertListToString(pbuList));
        try {
            IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, enableDataSql);
            while (rowSet.next()) {
                String recordId = rowSet.getString("recFid");
                String empOrgRelationID = rowSet.getString("cmpEmpORelationId");
                recordDataInfo = RecordUtil.getRecordDataInfo(rowSet);
                if (CmpStrUtil.isEmpty(recordId)) {
                    creRecordList.add(recordDataInfo);
                    continue;
                }
                if (CmpStrUtil.isEmpty(empOrgRelationID)) {
                    recordDataInfo.setRecordId(rowSet.getString("recFid"));
                    recordDataInfo.setLeffdt(RecordConstant.LEFFECT);
                    creEmpList.add(recordDataInfo);
                    continue;
                }
                if (!CmpStrUtil.isNotEmpty(empOrgRelationID)) continue;
                recordDataInfo.setCmpEmpid(rowSet.getString("empFid"));
                recordDataInfo.setOldPersonBURelId(rowSet.getString("oldPersonBURelId"));
                upCmpEmpList.add(recordDataInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = creRecordList.size() - 1; i >= 0; --i) {
            recordDataInfo = (RecordDataInfo)creRecordList.get(i);
            String key = recordDataInfo.getPersonId() + "_" + recordDataInfo.getHrOrgUnitId();
            if (set.contains(key)) {
                creRecordList.remove(i);
                creEmpList.add(recordDataInfo);
                continue;
            }
            set.add(key);
        }
        returnMap.put("createRecord", creRecordList);
        returnMap.put("updateEmpRel", upCmpEmpList);
        returnMap.put("createEmpRel", creEmpList);
        return returnMap;
    }

    public static Map<String, List<String>> getDisablePBURelationData(Context ctx, List<String> pbuList, Date leffectDate) throws BOSException {
        String sqlStr = AdjustRecordSQL.getDisablePBURelationDataSql(CmpStrUtil.convertListToString(pbuList), leffectDate);
        Map<String, List<String>> map = RecordUtil.getClassifyPBUData(ctx, pbuList, sqlStr, "FPersonBURelId");
        return map;
    }

    public static Map<String, List<String>> getUndoPBURelationData(Context ctx, List<String> pbuList) throws BOSException {
        String sqlStr = AdjustRecordSQL.getUndoPBURelationDataSql(CmpStrUtil.convertListToString(pbuList));
        Map<String, List<String>> map = RecordUtil.getClassifyPBUData(ctx, pbuList, sqlStr, "FPersonBURelId");
        List<String> rightList = map.get("rightIds");
        String recoredSql = AdjustRecordSQL.getOnoToOneEmpWithRecordSql(CmpStrUtil.convertListToString(rightList));
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, recoredSql);
        ArrayList<String> recordList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                recordList.add(rowSet.getString("recFid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        map.put("recordIds", recordList);
        return map;
    }
}

