/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryRecordFacadeFactory;
import com.kingdee.shr.compensation.record.RecordConstant;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustRecordImpl
extends AbstractRecord {
    Logger logger = Logger.getLogger(AdjustRecordImpl.class);
    AbstractEmpOrgRelation empOrgRelation = RecordInstanceFactory.getRelationInstance(RecordInstanceFactory.CATEGORY.ADJ);

    @Override
    public List<String> createRecords(Context ctx, List<RecordDataInfo> recList) throws BOSException, EASBizException {
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String creRecordSql = SQLHandleUtil.getInsertSql(ctx, "T_HR_SAdjustPersonRecord", "fid,FPersonId,FHrOrgUnitID,FEffectDate,FLeffectDate");
        int size = recList.size();
        for (int i = 0; i < size; ++i) {
            Object[] batchParam = new Object[5];
            String recordId = BOSUuid.create((String)"BC605B57").toString();
            RecordDataInfo recordDataInfo = recList.get(i);
            recordDataInfo.setRecordId(recordId);
            batchParam[0] = recordId;
            batchParam[1] = recordDataInfo.getPersonId();
            batchParam[2] = recordDataInfo.getHrOrgUnitId();
            batchParam[3] = null == recordDataInfo.getEnterDate() ? recordDataInfo.getEffdt() : (recordDataInfo.getEffdt().before(recordDataInfo.getEnterDate()) ? recordDataInfo.getEnterDate() : recordDataInfo.getEffdt());
            batchParam[4] = RecordConstant.LEFFECT;
            paramsList.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, creRecordSql, paramsList);
        return this.empOrgRelation.createEmpOrgRelations(ctx, recList);
    }

    @Override
    public void updateRecords(Context ctx, List<RecordDataInfo> udpateLis) throws BOSException, EASBizException {
        StringBuilder recIdStr = new StringBuilder();
        for (RecordDataInfo recordDataInfo : udpateLis) {
            recIdStr.append("'").append(recordDataInfo.getRecordId()).append("',");
        }
        HashMap<String, Date> map = new HashMap<String, Date>();
        String recordEffectSql = AdjustRecordSQL.getRecordEffect(recIdStr.substring(0, recIdStr.lastIndexOf(",")));
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, recordEffectSql);
        try {
            while (rowSet.next()) {
                map.put(rowSet.getString("recordId"), rowSet.getDate("effectDate"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        String updateSql = SQLHandleUtil.getUpdateSql("T_HR_SAdjustPersonRecord", "FLeffectDate,FEffectDate", "fid", null);
        int size = udpateLis.size();
        for (int i = 0; i < size; ++i) {
            RecordDataInfo recordDataInfo = udpateLis.get(i);
            String recordId = recordDataInfo.getRecordId();
            java.util.Date effectDate = recordDataInfo.getEffdt();
            java.util.Date oldEffectDate = (java.util.Date)map.get(recordId);
            if (effectDate == null || oldEffectDate == null) continue;
            java.util.Date realEffdt = effectDate.compareTo(oldEffectDate) < 0 ? effectDate : oldEffectDate;
            Object[] batchParam = new Object[]{RecordConstant.LEFFECT, null == recordDataInfo.getEnterDate() ? realEffdt : (recordDataInfo.getEnterDate().after(realEffdt) ? recordDataInfo.getEnterDate() : realEffdt), recordId};
            paramsList.add(batchParam);
        }
        CmpSQLUtil.executeBatch(ctx, updateSql, paramsList);
    }

    @Override
    public void loseRecords(Context ctx, Map<String, java.util.Date> recordMap) throws BOSException, EASBizException {
        String leffdt = null;
        if (recordMap.size() < 1) {
            return;
        }
        String recordIds = CmpStrUtil.converMapToString(recordMap);
        LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
        for (Map.Entry<String, java.util.Date> entry : recordMap.entrySet()) {
            Object[] batchParam = new Object[]{CmpDateUtil.toSqlDate(entry.getValue()), entry.getKey()};
            paramsList.add(batchParam);
        }
        Iterator<Map.Entry<String, java.util.Date>> iterator = recordMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, java.util.Date> entry;
            entry = iterator.next();
            leffdt = CmpDateUtil.toKSqlDate(entry.getValue());
        }
        ArrayList<String> changeIdList = new ArrayList<String>();
        StringBuilder maxStr = new StringBuilder();
        maxStr.append(" select tt.fid from T_HR_SFixAdjustSalary tt ");
        maxStr.append(" inner join (");
        maxStr.append(" select max(tt.FEffectDay) effDt, tt.fpersonid, FPayHrOrgUnitID, FCmpItemId ");
        maxStr.append(" from T_HR_SFixAdjustSalary tt ");
        maxStr.append(" inner join T_HR_SAdjustPersonRecord pr on tt.FPersonId = pr.FPersonId and tt.FAdjHrOrgUnitID = pr.FHrOrgUnitID ");
        maxStr.append(" where pr.fid in (").append(recordIds).append(") ");
        maxStr.append(" group by tt.fpersonid, FPayHrOrgUnitID, FCmpItemId) t1 ");
        maxStr.append(" on tt.FPERSONID = t1.fpersonid and tt.FEffectDay = t1.effDt and tt.FCmpItemId = t1.FCmpItemId and (tt.FPayHrOrgUnitID = t1.FPayHrOrgUnitID or t1.FPayHrOrgUnitID is null and tt.FPayHrOrgUnitID is null)");
        maxStr.append(" where tt.FEffectDay <= ").append(leffdt).append(" and tt.FLeffectDay >= ").append(leffdt);
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, maxStr.toString());
        try {
            while (rs.next()) {
                changeIdList.add(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        FixAdjustSalaryCollection oldColl = null;
        String oql = null;
        if (!changeIdList.isEmpty()) {
            CmpInSql inSql = CmpInSqlFactory.getInstance();
            String inSqlBaseOnFId = inSql.createInSqlBaseOnFId(ctx, changeIdList);
            oql = " where id in " + inSqlBaseOnFId + " order by id ";
            oldColl = FixAdjustSalaryFactory.getLocalInstance(ctx).getFixAdjustSalaryCollection(oql);
            StringBuffer str = new StringBuffer();
            str.append(" update T_HR_SFixAdjustSalary set FLeffectDay = ").append(leffdt).append(" ,FLeffectSource='20' ");
            str.append(" where fid in ").append(inSqlBaseOnFId);
            CmpSQLUtil.execute(ctx, str.toString());
            str = new StringBuffer();
            str.append(" update T_HR_SFixAdjustPayHrRecord A01 set (FLEFFDT) = ( ");
            str.append(" select FLeffectDay from T_HR_SFixAdjustSalary A02 where A01.FSourceId = A02.fid ");
            str.append(" and A02.FPersonId in (select FPersonId from T_HR_SAdjustPersonRecord where fid in (" + recordIds + ")) ");
            str.append(" )");
            CmpSQLUtil.execute(ctx, str.toString());
        }
        HashMap<String, java.util.Date> pbuMap = new HashMap<String, java.util.Date>();
        String empSql = AdjustRecordSQL.getCmpEmpDatasByRecord(recordIds);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (rowSet.next()) {
                pbuMap.put(rowSet.getString("FPersonBURelId"), recordMap.get(rowSet.getString("recFid")));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        this.empOrgRelation.loseEmpRelations(ctx, pbuMap);
        String recordSql = SQLHandleUtil.getUpdateSql("T_HR_SAdjustPersonRecord", "FLeffectDate", "fid", null);
        CmpSQLUtil.executeBatch(ctx, recordSql, paramsList);
        if (!changeIdList.isEmpty()) {
            FixAdjustSalaryCollection coll = FixAdjustSalaryFactory.getLocalInstance(ctx).getFixAdjustSalaryCollection(oql);
            if (oldColl != null) {
                String type = "";
                HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo> fixAdjustRecordMap = new HashMap<FixAdjustSalaryInfo, FixAdjustSalaryInfo>();
                type = "update";
                for (int i = 0; i < coll.size(); ++i) {
                    if (coll.get(i).getLeffectDay().getTime() == oldColl.get(i).getLeffectDay().getTime()) continue;
                    fixAdjustRecordMap.put(coll.get(i), oldColl.get(i));
                }
                FixAdjustSalaryRecordFacadeFactory.getLocalInstance(ctx).saveRecord(type, fixAdjustRecordMap);
            }
        }
    }

    @Override
    public void deleteRecords(Context ctx, String recordIds, boolean isDelete) throws BOSException, EASBizException {
        if (!recordIds.contains("'") && !recordIds.toLowerCase(Locale.ENGLISH).contains("select")) {
            recordIds = "'" + recordIds + "'";
        }
        String sql = " delete from T_HR_PersonBURelation where fid in (select FPersonBURelationID from T_HR_SAdjustEmpORelation where FPersonRecordID in (" + recordIds + "))";
        CmpSQLUtil.execute(ctx, sql);
        String fixAdjustSalaryRange = "select fas.fid from t_hr_sfixadjustsalary fas inner join T_HR_SAdjustPersonRecord rec on fas.FPERSONID = rec.FPERSONID  and fas.FADJHRORGUNITID = rec.FHRORGUNITID where rec.FID in (" + recordIds + ")";
        CmpSQLUtil.execute(ctx, "delete from T_HR_SFixAdjustPayHRRecord where FSourceId in (" + fixAdjustSalaryRange + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SFixAdjustSalary where fid in (" + fixAdjustSalaryRange + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SAdjustEmpORelation where FPersonRecordID in (" + recordIds + ")");
        CmpSQLUtil.execute(ctx, "delete from T_HR_SAdjustPersonRecord where fid in (" + recordIds + ")");
    }

    @Override
    public void addFixAdjustSalaryRecord(Context ctx, String recordIds) throws BOSException {
        if (StringUtils.isEmpty((String)recordIds)) {
            return;
        }
        if (!recordIds.contains("'") && !recordIds.toLowerCase(Locale.ENGLISH).contains("select")) {
            recordIds = "'" + recordIds + "'";
        }
        String fixAdjustSalaryRange = "select fas.fid from t_hr_sfixadjustsalary fas inner join T_HR_SAdjustPersonRecord rec on fas.FPERSONID = rec.FPERSONID  and fas.FADJHRORGUNITID = rec.FHRORGUNITID where rec.FID in (" + recordIds + ")";
        String oql = "where id in (" + fixAdjustSalaryRange + ")";
        FixAdjustSalaryCollection fixAdjustList = FixAdjustSalaryFactory.getLocalInstance(ctx).getFixAdjustSalaryCollection(oql);
        ArrayList<FixAdjustSalaryInfo> fixAdjustRecordList = new ArrayList<FixAdjustSalaryInfo>();
        for (int i = 0; i < fixAdjustList.size(); ++i) {
            fixAdjustRecordList.add(fixAdjustList.get(i));
        }
        try {
            FixAdjustSalaryRecordFacadeFactory.getLocalInstance(ctx).saveRecord(fixAdjustRecordList, "fileDelete");
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

