/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.factory.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.sql.record.AdjustRecordSQL;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.sql.record.RecordCommonSQL;
import com.kingdee.shr.compensation.sql.record.SocRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CmpBizPersonBuHisRelation {
    public static List<String> createPersonBuRelation(Context ctx, List<String> empList, String bizManageType, String hrOrgId) throws BOSException, EASBizException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<String> pbuList = new ArrayList<String>();
        for (int i = 0; i < empList.size(); ++i) {
            Object[] batchParam = new Object[2];
            String id = BOSUuid.create((String)"9F35F085").toString();
            batchParam[0] = id;
            batchParam[1] = empList.get(i);
            paramList.add(batchParam);
            pbuList.add(id);
        }
        String insertBuSql = RecordCommonSQL.getPersonBUInsertSql(bizManageType, hrOrgId);
        CmpSQLUtil.executeBatchAndReturn(ctx, insertBuSql, paramList);
        RecordUtil.updateDefaultBU(ctx, pbuList, bizManageType);
        return pbuList;
    }

    public static Map<String, Object> getEnableHisData(Context ctx, List<String> pbuList, String bizManageType) throws BOSException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ArrayList<RecordDataInfo> creRecordList = new ArrayList<RecordDataInfo>();
        ArrayList<RecordDataInfo> creEmpList = new ArrayList<RecordDataInfo>();
        ArrayList<RecordDataInfo> updateSPersonCmpList = new ArrayList<RecordDataInfo>();
        String enableDataSql = CmpRecordSQL.getEnableDataSql(CmpStrUtil.convertListToString(pbuList));
        if (bizManageType.equals("cEzQ1pHpEE+h9QzcFAj//2WJ1dE=")) {
            enableDataSql = AdjustRecordSQL.getEnableDataSql(CmpStrUtil.convertListToString(pbuList));
        }
        try {
            IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, enableDataSql);
            while (rowSet.next()) {
                String pbuId = rowSet.getString("FPersonBURelId");
                String recordId = rowSet.getString("recFid");
                String empOrgRelationID = rowSet.getString("cmpEmpORelationId");
                RecordDataInfo recordDataInfo = RecordUtil.getRecordDataInfo(rowSet);
                if (CmpStrUtil.isEmpty(recordId)) {
                    creRecordList.add(recordDataInfo);
                    continue;
                }
                if (!CmpStrUtil.isEmpty(empOrgRelationID)) continue;
                recordDataInfo.setRecordId(rowSet.getString("recFid"));
                recordDataInfo.setLeffdt(rowSet.getDate("empFLEffdt"));
                creEmpList.add(recordDataInfo);
                if (!rowSet.getDate("recFEffectDate").after(rowSet.getDate("empFEffdt"))) continue;
                RecordDataInfo info = new RecordDataInfo();
                info.setRecordId(recordId);
                info.setEffdt(rowSet.getDate("empFEffdt"));
                updateSPersonCmpList.add(info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        returnMap.put("createRecord", creRecordList);
        returnMap.put("createEmpRel", creEmpList);
        returnMap.put("updateEmpRel", updateSPersonCmpList);
        return returnMap;
    }

    public static Map<String, Object> getSocEnableData(Context ctx, List<String> pbuList) throws BOSException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashSet<String> hisSet = new HashSet<String>();
        HashSet<String> returnHisSet = new HashSet<String>();
        ArrayList<RecordDataInfo> creteList = new ArrayList<RecordDataInfo>();
        ArrayList<RecordDataInfo> updateList = new ArrayList<RecordDataInfo>();
        String personBURelationIds = CmpStrUtil.convertListToString(pbuList);
        String sql = SocRecordSQL.getRecordHisByPBUSQL(personBURelationIds);
        try {
            IRowSet r = CmpSQLUtil.executeQuery(ctx, sql);
            while (r.next()) {
                hisSet.add(r.getString(1));
            }
            r = CmpSQLUtil.executeQuery(ctx, SocRecordSQL.getEnableDataSQL(personBURelationIds));
            while (r.next()) {
                String recordId = r.getString("recFid");
                String pbuId = r.getString("FPersonBURelId");
                if (hisSet.contains(pbuId)) {
                    returnHisSet.add(pbuId);
                    continue;
                }
                RecordDataInfo recordDataInfo = RecordUtil.getRecordDataInfo(r);
                if (!CmpStrUtil.isNullOrEmpty(recordId)) {
                    recordDataInfo.setRecordId(recordId);
                    recordDataInfo.setOldPersonBURelId(r.getString("oldPBUId"));
                    updateList.add(recordDataInfo);
                    continue;
                }
                creteList.add(recordDataInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        returnMap.put("createRecord", creteList);
        returnMap.put("updateRecord", updateList);
        returnMap.put("hisSet", returnHisSet);
        return returnMap;
    }
}

