/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.record.RecordConstant;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import oadd.org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class NoticeHelper {
    public static String getMultiLan(Context ctx, String label) {
        return EASResource.getString((String)"com.kingdee.shr.compensation.app.v2.notice.CmpNoticeResource", (String)label, (Locale)ctx.getLocale());
    }

    public static void updateEntryTemplate(Context ctx, String templateIds) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)templateIds)) {
            return;
        }
        templateIds = StringEscapeUtils.escapeSql((String)templateIds);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update T_HR_SAdjustSalaryNoticeEntry  set FPdfAttachmentId='',FNoticeTitle=null,FHtmlContent=null,FSignatureAttachmentId=null ,FLastUpdateUserID=?,FLastUpdateTime=now()  where  FSendState in (0,-1,2)");
        updateSql.append(" and FTemplateId in (SELECT fid FROM T_HR_SAdjSalNoticeTemplateHIS where FHistoryRelateId in " + CmpStrUtil.buildInSql(templateIds) + ")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{currentUserInfo.getId().toString()});
    }

    public static String getNoticeEntryInfoSql(Context ctx, FixAdjustSalaryInfo info) throws BOSException, SQLException {
        Date leffectDate = RecordConstant.LEFFECT;
        String personId = info.getPerson().getId().toString();
        String cmpItemId = info.getCmpItem().getId().toString();
        String startDt = CmpDateUtil.toKSqlDate(info.getEffectDay());
        String endDt = info.getLeffectDay() == null ? CmpDateUtil.getMaxKsqlDate() : CmpDateUtil.toKSqlDate(info.getLeffectDay());
        String payHrOrgUnitId = info.getPayHrOrgUnit() != null ? info.getPayHrOrgUnit().getId().toString() : null;
        String noticeEntryTableSql = NoticeHelper.getNoticeEntryTableSql();
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, noticeEntryTableSql);
        StringBuilder sql = new StringBuilder();
        String billEntryTableName = null;
        String adjustSalaryRuleId = null;
        int index = 0;
        while (rs.next()) {
            billEntryTableName = rs.getString("FBillEntryTableName");
            adjustSalaryRuleId = rs.getString("FAdjustSalaryRule");
            Map item2FieldSn = AdjustSalaryUtils.getAdjItem2CmpItem((Context)ctx, (String)adjustSalaryRuleId);
            if (!item2FieldSn.containsKey(cmpItemId)) continue;
            if (index > 0) {
                sql.append(" union ");
            }
            sql.append("SELECT apply.fnumber as billNum FROM T_HR_SAdjustSalaryNoticeEntry nentry  inner join " + billEntryTableName + " adjEntry on nentry.FAdjEntryId=adjEntry.fid and (nentry.FIsremove <> 1 or nentry.FIsremove is null)  inner join T_HR_SAdjustSalaryApply apply on adjEntry.FBillID=apply.fid  where nentry.FConfirmState in (" + 5 + "," + 4 + ")  and nentry.FAdjEntryState<>" + 3);
            sql.append(" and adjEntry.FPersonID = '" + personId + "' ");
            if (info.getPayHrOrgUnit() == null) {
                sql.append("and (adjEntry.FHrOrgUnitId is null or adjEntry.FHrOrgUnitId = '') ");
            } else {
                sql.append("and adjEntry.FHrOrgUnitId = '" + payHrOrgUnitId + "' ");
            }
            if (info.getLeffectDay() != null && info.getLeffectDay().compareTo(leffectDate) < 0) {
                sql.append("and ((" + startDt + " < adjEntry.FEFFECTDATE and " + endDt + " >= adjEntry.FEFFECTDATE ) ");
            } else {
                sql.append("and ((1=0) ");
            }
            sql.append("or (" + startDt + " > adjEntry.FEFFECTDATE and adjEntry.FLEFFECTDATE < " + CmpDateUtil.getMaxKsqlDate() + " and adjEntry.FLEFFECTDATE >= " + startDt + ") ");
            sql.append("or (" + startDt + " = adjEntry.FEFFECTDATE))");
            ++index;
        }
        return sql.toString();
    }

    public static String getNoticeEntryTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct tableRel.FAdjustSalaryRule, tableRel.FBillEntryTableName FROM T_HR_SAdjustSalaryNoticeEntry nentry  inner join T_HR_SAdjustSalaryNoticeBill nbill on nentry.FNoticeBillId=nbill.fid and (nentry.FIsremove <> 1 or nentry.FIsremove is null) and (nbill.FIsremove <> 1 or nbill.FIsremove is null)  inner join T_HR_SAdjustSalaryApply apply on nbill.FAdjBillId=apply.fid  inner join T_HR_SAdjSalaryTableRelation tableRel on apply.FAdjustSalaryRuleID= tableRel.FAdjustSalaryRule  where nentry.FConfirmState in (5,4)  and nentry.FAdjEntryState<>3");
        return sql.toString();
    }

    public static String getNoticeEntryInfoNoHrOrg(Context ctx, FixAdjustSalaryInfo info) throws BOSException, SQLException {
        String personId = info.getPerson().getId().toString();
        String cmpItemId = info.getCmpItem().getId().toString();
        String noticeEntryTableSql = NoticeHelper.getNoticeEntryTableSql();
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, noticeEntryTableSql);
        StringBuilder sql = new StringBuilder();
        String billEntryTableName = null;
        String adjustSalaryRuleId = null;
        int index = 0;
        while (rs.next()) {
            billEntryTableName = rs.getString("FBillEntryTableName");
            adjustSalaryRuleId = rs.getString("FAdjustSalaryRule");
            Map item2FieldSn = AdjustSalaryUtils.getAdjItem2CmpItem((Context)ctx, (String)adjustSalaryRuleId);
            if (!item2FieldSn.containsKey(cmpItemId)) continue;
            if (index > 0) {
                sql.append(" union ");
            }
            sql.append("SELECT apply.fnumber as billNum FROM T_HR_SAdjustSalaryNoticeEntry nentry  inner join " + billEntryTableName + " adjEntry on nentry.FAdjEntryId=adjEntry.fid and (nentry.FIsremove <> 1 or nentry.FIsremove is null)  inner join T_HR_SAdjustSalaryApply apply on adjEntry.FBillID=apply.fid  where nentry.FConfirmState in (" + 5 + "," + 4 + ")  and nentry.FAdjEntryState<>" + 3);
            sql.append(" and adjEntry.FPersonID = '" + personId + "' ");
            if (info.getPayHrOrgUnit() == null) {
                sql.append("and (adjEntry.FHrOrgUnitId is not null) ");
            } else {
                sql.append("and (adjEntry.FHrOrgUnitId is null or adjEntry.FHrOrgUnitId = '') ");
            }
            ++index;
        }
        return sql.toString();
    }
}

