/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.validator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RecordValidatorUtils;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.sql.record.CmpRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpRecordValidator
extends RecordValidator {
    Logger logger = Logger.getLogger(CmpRecordValidator.class);
    private RecordValidatorUtils validatorUtils = new RecordValidatorUtils();

    @Override
    public RocordValidatorInfo deleteEmpRelation(Context ctx, String billId) throws BOSException, EASBizException {
        RocordValidatorInfo info = null;
        String sql = "select FPersonId from T_HR_SCmpCalTable where FCmpEmpORelationID = '" + billId + "'";
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        if (rowSet.size() > 0) {
            info = new RocordValidatorInfo();
            try {
                if (rowSet.next()) {
                    info.setCode(rowSet.getString("FPersonId"));
                    info.setMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label25", (Locale)ctx.getLocale()));
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
        return info;
    }

    @Override
    public List<RocordValidatorInfo> deleteEmpRelationReturnList(Context ctx, String billId) throws BOSException, EASBizException {
        RocordValidatorInfo info = null;
        JSONObject personInfo = null;
        ArrayList<RocordValidatorInfo> infoList = new ArrayList<RocordValidatorInfo>();
        try {
            personInfo = this.validatorUtils.getCmpCalTablePerson(ctx, billId, "RELATION");
            if (personInfo != null) {
                info = (RocordValidatorInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RocordValidatorInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getBatchSubmitBillPerson(ctx, billId, "RELATION")) != null) {
                info = (RocordValidatorInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RocordValidatorInfo.class);
                infoList.add(info);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("deleteRelationCmpError:" + e.getMessage()));
        }
        return infoList;
    }

    @Override
    public List<RecordDataInfo> deletePersonReturnList(Context ctx, String personIds) throws BOSException, EASBizException {
        RecordDataInfo info = null;
        JSONObject personInfo = null;
        ArrayList<RecordDataInfo> infoList = new ArrayList<RecordDataInfo>();
        try {
            personInfo = this.validatorUtils.getCmpCalTablePerson(ctx, personIds, "PERSON");
            if (personInfo != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getTaxUnitPerson(ctx, personIds)) != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
            if ((personInfo = this.validatorUtils.getBatchSubmitBillPerson(ctx, personIds, "PERSON")) != null) {
                info = (RecordDataInfo)JSON.parseObject((String)JSON.toJSONString((Object)personInfo), RecordDataInfo.class);
                infoList.add(info);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("deletePersonCmpError:" + e.getMessage()));
        }
        return infoList;
    }

    @Override
    public List<RocordValidatorInfo> loseRecord(Context ctx, String recordIds, Date leffdt) throws BOSException {
        String recFid;
        RocordValidatorInfo validator;
        recordIds = this.getInnerIds(recordIds);
        HashMap<String, RocordValidatorInfo> map = new HashMap<String, RocordValidatorInfo>();
        String calSql = CmpRecordSQL.getMaxCalDateByRecord(recordIds, leffdt, ctx);
        IRowSet r = CmpSQLUtil.executeQuery(ctx, calSql);
        try {
            while (r.next()) {
                validator = new RocordValidatorInfo();
                recFid = r.getString("recFid");
                validator.setCode(recFid);
                validator.setMsg(r.getString("perName") + ":" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label30", (Locale)ctx.getLocale()));
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String empSql = CmpRecordSQL.getMaxCmpEmpDateByRecord(recordIds, leffdt, ctx);
        IRowSet r1 = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (r1.next()) {
                recFid = r1.getString("recFid");
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label27", (Locale)ctx.getLocale()), ctx);
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.appendMsg(r1.getString("perName") + ":" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label27", (Locale)ctx.getLocale()), ctx);
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String sysSql = CmpRecordSQL.getMaxSystemPersonDateByRecord(recordIds, leffdt, ctx);
        IRowSet r2 = CmpSQLUtil.executeQuery(ctx, sysSql);
        try {
            while (r2.next()) {
                recFid = r2.getString("recFid");
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label28", (Locale)ctx.getLocale()), ctx);
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label17", (Locale)ctx.getLocale()) + ":" + r2.getString("perName") + ":" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label28", (Locale)ctx.getLocale()), ctx);
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        String costSql = CmpRecordSQL.getMaxCostDateByRecord(recordIds, leffdt, ctx);
        IRowSet r3 = CmpSQLUtil.executeQuery(ctx, costSql);
        try {
            while (r3.next()) {
                recFid = r3.getString("recFid");
                if (map.containsKey(recFid)) {
                    validator = (RocordValidatorInfo)map.get(recFid);
                    validator.appendMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label29", (Locale)ctx.getLocale()), ctx);
                    continue;
                }
                validator = new RocordValidatorInfo();
                validator.setCode(recFid);
                validator.appendMsg(r3.getString("perName") + ":" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label29", (Locale)ctx.getLocale()), ctx);
                map.put(recFid, validator);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        ArrayList<RocordValidatorInfo> list = new ArrayList<RocordValidatorInfo>();
        for (Map.Entry entry : map.entrySet()) {
            list.add((RocordValidatorInfo)entry.getValue());
        }
        return list;
    }
}

