/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.service.CalSecFixAdjustSalaryService;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalAdminSecFixAdjustSalaryService
extends CalSecFixAdjustSalaryService {
    private static final Logger logger = LoggerFactory.getLogger(CalAdminSecFixAdjustSalaryService.class);
    static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DATA_KEY_PREFIX = "GETADMINSECFIXADJUSTSALARY";

    public double getAdminSecFixAdjustSalary(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItem, String adminOrg, double needSubOrg, double totalDays, String attendanceItemName, String sectional) {
        if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return 0.0;
        }
        if (StringUtils.isEmpty((String)adminOrg)) {
            adminOrg = null;
        }
        boolean haveSubOrg = 1.0 == needSubOrg;
        String dataKey = "GETADMINSECFIXADJUSTSALARY_" + cmpItem + "_" + adminOrg + "_" + haveSubOrg + "_" + attendanceItemName;
        Map dataMap = new HashMap();
        if (tempMap.get(dataKey) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("calculate getAdminSecFixAdjustSalary func by params:" + cmpItem + "_" + adminOrg + "_" + haveSubOrg + "_" + attendanceItemName);
            }
            tempMap.put(dataKey, this.initPersonSecFixAdjustSalaryInfo(paramMap, calScheme, mainTableRowFilter, cmpItem, adminOrg, haveSubOrg, attendanceItemName, sectional));
        }
        dataMap = (Map)tempMap.get(dataKey);
        String key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        if (dataMap != null && dataMap.containsKey(key)) {
            BigDecimal totalSalary = (BigDecimal)dataMap.get(key);
            double salary = 0.0;
            if (totalDays != 0.0) {
                BigDecimal totalDaysBig = new BigDecimal(String.valueOf(totalDays));
                BigDecimal salaryBig = totalSalary.divide(totalDaysBig, 50, RoundingMode.HALF_EVEN);
                salary = salaryBig.doubleValue();
            }
            return salary;
        }
        return 0.0;
    }

    @Override
    protected Map<String, Object> getAttenceProjectDetailInfo(CalSchemeInfo calScheme, String calPersonId, String adminOrg, Boolean needSubOrg, String attendanceItemName) {
        Context ctx = Tools.getInstance().getCtx();
        String l = ctx.getLocale().getLanguage();
        String l1 = calScheme.getLanType().getValue();
        HashMap<String, Object> osfMap = new HashMap<String, Object>();
        StringBuilder str = new StringBuilder();
        str.append("select FPERSONID FROM T_HR_SCMPCALTABLE WHERE FCALSCHEMEID = '");
        str.append(calScheme.getId().toString());
        str.append("' AND FCALTIME = ").append(calScheme.getCalTime());
        str.append(" AND FPERIODYEAR = ").append(calScheme.getPeriodYear());
        str.append(" AND FPERIODMONTH = ").append(calScheme.getPeriodMonth());
        if ("test".equals(this.getType())) {
            str.append(" AND FPERSONID = '").append(calPersonId).append("'");
        }
        String companyLongNumber = "";
        if (!StringUtils.isEmpty((String)adminOrg)) {
            companyLongNumber = " select fLongNumber from T_ORG_ADMIN where fid in   (select FADMINORGID  from T_ORG_ADMINORGtreehis where fDisplayName_" + l + " = '" + adminOrg + "' or  fDisplayName_" + l1 + " = '" + adminOrg + "' ) ";
        }
        Date beginDate = calScheme.getBeginDate();
        Date endDate = calScheme.getEndDate();
        osfMap.put("personId", Base64Utils.encodeWithSalt(str.toString()));
        String beginDt = df.format(beginDate);
        String endDt = df.format(endDate);
        osfMap.put("beginDate", beginDt);
        osfMap.put("endDate", endDt);
        osfMap.put("projectName", attendanceItemName);
        osfMap.put("companyLongNumber", Base64Utils.encodeWithSalt(companyLongNumber));
        osfMap.put("haveSubOrg", needSubOrg);
        return (Map)OSFExecutor.executeOSF((Context)ctx, osfMap, (String)"getAttenceProjectDetailOrgInfo");
    }

    @Override
    public String getSegmentedSalarySQL(String itemName, CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calSchemeEndDate = CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calSchemeBeginDate = CmpDateUtil.toKSqlDate(calScheme.getBeginDate());
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable t where t.FcalSchemeID = '" + calschemeid + "' and t.FcalTime = " + calTime + " and t.FperiodYear = " + periodYear + " and t.FperiodMonth = " + periodMonth + " and calTable.fpersonid = t.FPERSONID ";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "t.fid").replace("t_hr_scmpcaltable.FCalState", "t.fcalState");
            personSql = personSql + " and " + replace;
        }
        StringBuilder sb = new StringBuilder();
        String l = calScheme.getLanType().getValue();
        sb.append(" SELECT distinct fix.FMoney as money,fix.FEffectDay effectDay,fix.fleffectday LEFFECTDAY,fix.FPersonId personId,item.FName_" + l + " itemName,fix.FCURRENCYID ,").append("\r\n");
        sb.append(" ( case when (fix.fpayhrorgunitid is null or fix.fpayhrorgunitid in ('')) then 0  when ( calTable.FHrOrgUnitID= fix.fpayhrorgunitid) then 1 else 2 end ) type").append("\r\n");
        sb.append(" FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fid=payHr.FSOURCEID  ").append("\r\n");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID  ").append("\r\n");
        sb.append(" where (calTable.FHrOrgUnitID= fix.fpayhrorgunitid  or fix.fpayhrorgunitid is null)");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and payHr.fleffdt >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and item.fname_" + l + "='").append(itemName).append("' ").append("\r\n");
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("'");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth).append("\r\n");
        sb.append(" and exists (").append(personSql).append(")").append("\r\n");
        sb.append(" order by fix.FPersonId ,item.FName_" + l + ",fix.FEffectDay ").append("\r\n");
        String salarySQL = sb.toString();
        return salarySQL;
    }
}

