/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpExchangeRuleEnum;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalSecFixAdjustSalaryService
extends SalaryCalFunction {
    private Logger logger = LoggerFactory.getLogger(CalSecFixAdjustSalaryService.class);
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public double getSecFixAdjustSalary(Map<String, Object> paramMap, Map<String, Object> tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItem, double totalDays, String attendanceItemName, String sectional) {
        if (StringUtils.isEmpty((String)cmpItem) || paramMap.get("T_HR_SCMPCALTABLE_FPERSONID") == null) {
            return 0.0;
        }
        String dataKey = "GETSECFIXADJUSTSALARY_" + cmpItem + "_" + attendanceItemName;
        Map dataMap = new HashMap();
        if (tempMap.get(dataKey) == null) {
            tempMap.put(dataKey, this.initPersonSecFixAdjustSalaryInfo(paramMap, calScheme, mainTableRowFilter, cmpItem, null, null, attendanceItemName, sectional));
        }
        dataMap = (Map)tempMap.get(dataKey);
        String key = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        if (dataMap != null && dataMap.containsKey(key)) {
            BigDecimal totalSalary = (BigDecimal)dataMap.get(key);
            double salary = 0.0;
            if (totalDays != 0.0) {
                BigDecimal totalDaysBig = new BigDecimal(String.valueOf(totalDays));
                BigDecimal salaryBig = totalSalary.divide(totalDaysBig, 50, 6);
                salary = salaryBig.doubleValue();
            }
            return salary;
        }
        return 0.0;
    }

    protected Map<String, BigDecimal> initPersonSecFixAdjustSalaryInfo(Map<String, Object> paramMap, CalSchemeInfo calScheme, String mainTableRowFilter, String cmpItem, String adminOrg, Boolean needSubOrg, String attendanceItemName, String sectional) {
        long start = System.currentTimeMillis();
        Context ctx = Tools.getInstance().getCtx();
        String calPersonId = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        Map<String, BigDecimal> salaryMap = new HashMap<String, BigDecimal>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = calScheme.getBeginDate();
        Date endDate = calScheme.getEndDate();
        BigDecimal rate = new BigDecimal(1);
        HashMap<String, Map<String, BigDecimal>> personMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Date> personAndLeffdtMap = new HashMap<String, Date>();
        String querySql = this.getSegmentedSalarySQL(cmpItem, calScheme, mainTableRowFilter);
        String beginDateKey = this.df.format(beginDate);
        IRowSet executeQuery = null;
        List<Object> dataList = new ArrayList();
        try {
            executeQuery = SqlUtil.executeQuery(ctx, querySql);
            dataList = this.getDataFromExecuteQuery(executeQuery);
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e1) {
            this.logger.error(e1.getMessage(), (Throwable)e1);
        }
        Map map = null;
        Iterator<Object> it = dataList.iterator();
        if (null != calScheme.getCurrency()) {
            String targetCurrencyId = calScheme.getCurrency().getId().toString();
            Date effdt = calScheme.getExchangeRule().equals((Object)CmpExchangeRuleEnum.PERIOD_BEGIN) ? calScheme.getBeginDate() : calScheme.getEndDate();
            String exchangeTableId = calScheme.getExchangeTable().getId().toString();
            try {
                int cursor = 0;
                Map<String, BigDecimal> currencyMap = CurrencyUtil.getTargetExchangeRateMap(ctx, exchangeTableId, targetCurrencyId, effdt);
                while (it.hasNext()) {
                    Map<String, BigDecimal> fixAdjSalMap;
                    map = (Map)it.next();
                    boolean isFixAdjFirstDay = false;
                    String personId = (String)map.get("personId");
                    BigDecimal money = (BigDecimal)map.get("money");
                    String currencyId = (String)map.get("FCURRENCYID");
                    rate = null != currencyId ? (null == currencyMap.get(currencyId) ? BigDecimal.ONE : currencyMap.get(currencyId)) : BigDecimal.ONE;
                    money = money.multiply(rate);
                    Date effectDay = (Date)map.get("effectDay");
                    String dateKey = this.df.format(effectDay);
                    Date leffectDay = (Date)map.get("LEFFECTDAY");
                    if (!beginDate.before(effectDay)) {
                        dateKey = beginDateKey;
                        isFixAdjFirstDay = true;
                    }
                    if (personMap.containsKey(personId)) {
                        fixAdjSalMap = (Map)personMap.get(personId);
                        fixAdjSalMap.put(dateKey, money);
                    } else {
                        fixAdjSalMap = new HashMap();
                        fixAdjSalMap.put(dateKey, money);
                        personMap.put(personId, fixAdjSalMap);
                    }
                    if (!isFixAdjFirstDay && cursor == 0) {
                        fixAdjSalMap = (Map)personMap.get(personId);
                        fixAdjSalMap.put(beginDateKey, BigDecimal.ZERO);
                    }
                    if (personAndLeffdtMap.containsKey(personId)) {
                        Date leffda = (Date)personAndLeffdtMap.get(personId);
                        if (leffectDay != null && leffda != null && leffectDay.compareTo(leffda) > 0) {
                            personAndLeffdtMap.put(personId, leffectDay);
                        }
                    } else {
                        personAndLeffdtMap.put(personId, leffectDay);
                    }
                    ++cursor;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                int cursor = 0;
                while (it.hasNext()) {
                    Map<String, BigDecimal> fixAdjSalMap;
                    map = (Map)it.next();
                    boolean isFixAdjFirstDay = false;
                    String personId = (String)map.get("personId");
                    BigDecimal money = (BigDecimal)map.get("money");
                    Date effectDay = (Date)map.get("effectDay");
                    String dateKey = this.df.format(effectDay);
                    Date leffectDay = (Date)map.get("LEFFECTDAY");
                    if (!beginDate.before(effectDay)) {
                        dateKey = beginDateKey;
                        isFixAdjFirstDay = true;
                    }
                    if (personMap.containsKey(personId)) {
                        fixAdjSalMap = (Map)personMap.get(personId);
                        fixAdjSalMap.put(dateKey, money);
                    } else {
                        fixAdjSalMap = new HashMap();
                        fixAdjSalMap.put(dateKey, money);
                        personMap.put(personId, fixAdjSalMap);
                    }
                    if (!isFixAdjFirstDay && cursor == 0) {
                        fixAdjSalMap = (Map)personMap.get(personId);
                        fixAdjSalMap.put(beginDateKey, BigDecimal.ZERO);
                    }
                    if (personAndLeffdtMap.containsKey(personId)) {
                        Date leffda = (Date)personAndLeffdtMap.get(personId);
                        if (leffectDay != null && leffda != null && leffectDay.compareTo(leffda) > 0) {
                            personAndLeffdtMap.put(personId, leffectDay);
                        }
                    } else {
                        personAndLeffdtMap.put(personId, leffectDay);
                    }
                    ++cursor;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long start1 = System.currentTimeMillis();
        this.logger.error("~~~~~~~~~~~~~time consuming \uff1a" + (start1 - start) + "ms");
        Map<String, Object> result = this.getAttenceProjectDetailInfo(calScheme, calPersonId, adminOrg, needSubOrg, attendanceItemName);
        long start2 = System.currentTimeMillis();
        this.logger.error("~~~~~~~~~~~~~time consuming\uff1a" + (start2 - start1) + "ms");
        if (result != null && result.size() > 0 && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sectional) || "1".equals(sectional))) {
            salaryMap = this.parseResultBySectional(personMap, result, attendanceItemName, beginDate, endDate, personAndLeffdtMap);
            long start3 = System.currentTimeMillis();
            this.logger.error("~~~~~~~~~~~~~time consuming \uff1a" + (start3 - start2) + "ms");
        }
        return salaryMap;
    }

    protected Map<String, Object> getAttenceProjectDetailInfo(CalSchemeInfo calScheme, String calPersonId, String adminOrg, Boolean needSubOrg, String attendanceItemName) {
        Context ctx = Tools.getInstance().getCtx();
        HashMap<String, String> osfMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        str.append("SELECT FPERSONID FROM T_HR_SCMPCALTABLE WHERE FCALSCHEMEID = '");
        str.append(calScheme.getId().toString());
        str.append("' AND FCALTIME = ").append(calScheme.getCalTime());
        str.append(" AND FPERIODYEAR = ").append(calScheme.getPeriodYear());
        str.append(" AND FPERIODMONTH = ").append(calScheme.getPeriodMonth());
        if ("test".equals(this.getType())) {
            str.append(" AND FPERSONID = '").append(calPersonId).append("'");
        }
        Date beginDate = calScheme.getBeginDate();
        Date endDate = calScheme.getEndDate();
        osfMap.put("personId", Base64Utils.encodeWithSalt(str.toString()));
        String beginDt = this.df.format(beginDate);
        String endDt = this.df.format(endDate);
        osfMap.put("beginDate", beginDt);
        osfMap.put("endDate", endDt);
        osfMap.put("projectName", attendanceItemName);
        long start1 = System.currentTimeMillis();
        Map result = (Map)OSFExecutor.executeOSF((Context)ctx, osfMap, (String)"getAttenceProjectDetailInfo");
        return result;
    }

    public List<Map<String, Object>> getDataFromExecuteQuery(IRowSet executeQuery) throws SQLException {
        HashMap<String, Object> map = null;
        ArrayList<Map<String, Object>> dataList = null;
        HashMap<String, HashSet> mapSet = null;
        HashMap<String, HashSet> mapSetOne = null;
        HashMap<String, HashSet> mapSetZero = null;
        HashSet set = null;
        HashSet oneSet = null;
        HashSet zeroSet = null;
        if (null != executeQuery) {
            String personId = null;
            dataList = new ArrayList<Map<String, Object>>();
            mapSet = new HashMap<String, HashSet>();
            mapSetOne = new HashMap<String, HashSet>();
            mapSetZero = new HashMap<String, HashSet>();
            while (executeQuery.next()) {
                map = new HashMap<String, Object>();
                personId = executeQuery.getString("personId");
                map.put("personId", executeQuery.getString("personId"));
                map.put("money", executeQuery.getBigDecimal("money") == null ? BigDecimal.ZERO : executeQuery.getBigDecimal("money"));
                map.put("FCURRENCYID", executeQuery.getString("FCURRENCYID"));
                map.put("itemName", executeQuery.getString("itemName"));
                map.put("effectDay", executeQuery.getDate("effectDay"));
                map.put("LEFFECTDAY", executeQuery.getDate("LEFFECTDAY"));
                int type = executeQuery.getInt("type");
                if (mapSet.containsKey(personId)) {
                    set = (HashSet)mapSet.get(personId);
                    set.add(map);
                } else {
                    set = new HashSet();
                    set.add(map);
                    mapSet.put(personId, set);
                }
                if (type == 1) {
                    if (mapSetOne.containsKey(personId)) {
                        oneSet = (HashSet)mapSetOne.get(personId);
                        oneSet.add(map);
                        continue;
                    }
                    oneSet = new HashSet();
                    oneSet.add(map);
                    mapSetOne.put(personId, oneSet);
                    continue;
                }
                if (type != 0) continue;
                if (mapSetZero.containsKey(personId)) {
                    zeroSet = (HashSet)mapSetZero.get(personId);
                    zeroSet.add(map);
                    continue;
                }
                zeroSet = new HashSet();
                zeroSet.add(map);
                mapSetZero.put(personId, zeroSet);
            }
            set = null;
            for (String str : mapSet.keySet()) {
                set = (HashSet)mapSet.get(str);
                if (mapSetOne.containsKey(str)) {
                    dataList.addAll((Collection)mapSetOne.get(str));
                    continue;
                }
                dataList.addAll((Collection)mapSetZero.get(str));
            }
        }
        if (null != dataList && !dataList.isEmpty()) {
            return dataList;
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    public String getSecFixAdjustSalarySQL(Map<String, Object> paramMap, String itemName, CalSchemeInfo calScheme) {
        String calPersonId = paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calSchemeEndDate = CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calSchemeBeginDate = CmpDateUtil.toKSqlDate(calScheme.getBeginDate());
        CmpPeriodTypeEnum periodType = calScheme.getCmpPeriodType();
        int month = -1;
        if (CmpPeriodTypeEnum.yeay.equals((Object)periodType)) {
            month = -12;
        } else if (CmpPeriodTypeEnum.half.equals((Object)periodType)) {
            month = -6;
        } else if (CmpPeriodTypeEnum.quarter.equals((Object)periodType)) {
            month = -3;
        }
        String l = calScheme.getLanType().getValue();
        String beginDateField = "dateAdd(month, " + month + ", calTable.FRealEndDate)";
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        StringBuilder str = new StringBuilder();
        str.append("SELECT FPERSONID FROM T_HR_SCMPCALTABLE WHERE FCALSCHEMEID = '");
        str.append(calScheme.getId().toString());
        str.append("' AND FCALTIME = ").append(calScheme.getCalTime());
        str.append(" AND FPERIODYEAR = ").append(calScheme.getPeriodYear());
        str.append(" AND FPERIODMONTH = ").append(calScheme.getPeriodMonth());
        if ("test".equals(this.getType())) {
            str.append(" AND FPERSONID = '").append(calPersonId).append("'");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT distinct fix.FMoney as money,fix.FEffectDay effectDay,fix.FPersonId personId,item.FName_" + l + " itemName, FIX.FCURRENCYID  ").append("\r\n");
        sb.append(" FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ").append("\r\n");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID  ").append("\r\n");
        sb.append(" where calTable.FRealEndDate >= payHr.FEFFDT and ").append(beginDateField).append(" <= payHr.FLEFFDT ").append("\r\n");
        sb.append(" and (calTable.FHrOrgUnitID=payHr.FHrOrgUnitID  or payHr.FHrOrgUnitID is null ) and fix.fid=payHr.fsourceid ");
        sb.append(" and ").append(beginDateField).append("<=fix.FEffectDay  and calTable.FRealEndDate>=fix.FEffectDay ").append("\r\n");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("'").append("\r\n");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth).append("\r\n");
        sb.append(" and calTable.fpersonid in(").append(str.toString()).append(")").append("\r\n");
        sb.append(" union ").append("\r\n");
        sb.append(" SELECT  b.money,a.EffectDay,a.FPersonId,b.itemName, b.FCURRENCYID from ").append("\r\n");
        sb.append(" ( ").append("\r\n");
        sb.append(" SELECT max(fix.FEffectDay) as EffectDay, calTable.fpersonId ").append("\r\n");
        sb.append("   FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append("   left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append("   left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ").append("\r\n");
        sb.append("   left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID ").append("\r\n");
        sb.append("  where ").append(beginDateField).append(" >= payHr.FEFFDT   ").append("\r\n");
        sb.append(" and (calTable.FHrOrgUnitID=payHr.FHrOrgUnitID  or payHr.FHrOrgUnitID is null ) and ").append(beginDateField).append(">=fix.FEffectDay  ").append("\r\n");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("' ").append("\r\n");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth).append("\r\n");
        sb.append(" and calTable.fpersonid in(").append(str.toString()).append(")").append("\r\n");
        sb.append(" group by calTable.fpersonid ").append("\r\n");
        sb.append(" ) a, ").append("\r\n");
        sb.append("(select distinct fix.FMoney AS money,fix.FEffectDay AS effectday,fix.FPersonId  AS personid,item.FName_" + l + "  AS itemName,FIX.FCURRENCYID ").append("\r\n");
        sb.append("   FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append("   left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append("   left join T_HR_SFixAdjustPayHrRecord payHr on fix.fpersonid=payHr.fpersonid and fix.FCmpItemID=payHr.FCmpItemID ").append("\r\n");
        sb.append("   left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID ").append("\r\n");
        sb.append("  where ").append(beginDateField).append(" >= payHr.FEFFDT and fix.fid=payHr.fsourceid  ").append("\r\n");
        sb.append("    and ( calTable.FHrOrgUnitID=payHr.FHrOrgUnitID or payHr.FHrOrgUnitID is null) and ").append(beginDateField).append(">=fix.FEffectDay  ").append("\r\n");
        sb.append("    and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append("    and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append("    and calTable.FHrOrgUnitID='").append(hrOrgId).append("' and item.fname_" + l + "='").append(itemName).append("' ").append("\r\n");
        sb.append("    and calTable.fpersonid in(").append(str.toString()).append(")").append("\r\n");
        sb.append(" ) b  ").append("\r\n");
        sb.append(" WHERE a.fpersonid = b.personid AND a.effectday = b.effectday  AND b.itemName='").append(itemName).append("' ").append("\r\n");
        sb.append("  ").append("\r\n");
        String salarySQL = sb.toString();
        return salarySQL;
    }

    private Map<String, BigDecimal> parseResultBySectional(Map<String, Map<String, BigDecimal>> map, Map<String, Object> result, String attendanceItemName, Date beginDate, Date endDate, Map<String, Date> personAndLeffdtMap) {
        HashMap<String, BigDecimal> salaryMap = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, Map<String, BigDecimal>> mapItem : map.entrySet()) {
            ArrayList effectDateList = new ArrayList();
            HashMap dateSalaryMap = new HashMap();
            LinkedList attenceDateList = new LinkedList();
            String key = mapItem.getKey();
            Map<String, BigDecimal> fixAdjSalMap = mapItem.getValue();
            List attenceDetailInfoList = (List)result.get(key);
            Date leffdt = personAndLeffdtMap.get(key);
            if (attenceDetailInfoList != null) {
                Map<String, BigDecimal> attenceMap = this.handleattenceDetail(attenceDetailInfoList, fixAdjSalMap, attendanceItemName, leffdt);
                BigDecimal fixAdjSalary = this.calculationFixAdjSalary(fixAdjSalMap, attenceMap);
                salaryMap.put(key, fixAdjSalary);
                continue;
            }
            salaryMap.put(key, BigDecimal.ZERO);
        }
        return salaryMap;
    }

    private BigDecimal calculationFixAdjSalary(Map<String, BigDecimal> fixAdjSalMap, Map<String, BigDecimal> attenceMap) {
        BigDecimal totalVal = BigDecimal.ZERO;
        Set<String> dateSet = fixAdjSalMap.keySet();
        for (String dateKey : dateSet) {
            BigDecimal money = fixAdjSalMap.get(dateKey);
            BigDecimal attenceVal = attenceMap.get(dateKey);
            totalVal = totalVal.add(money.multiply(attenceVal));
        }
        return totalVal;
    }

    private Map<String, BigDecimal> handleattenceDetail(List<Object> attenceDetailInfoList, Map<String, BigDecimal> fixAdjSalMap, String attendanceItemName, Date leffdt) {
        HashMap<String, BigDecimal> attenceMap = new HashMap<String, BigDecimal>();
        int cursor = 0;
        try {
            if (fixAdjSalMap != null) {
                Set<String> dateSet = fixAdjSalMap.keySet();
                ArrayList<Date> dateList = new ArrayList<Date>();
                for (String dateKey : dateSet) {
                    dateList.add(this.df.parse(dateKey));
                }
                Collections.sort(dateList, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        Date date1 = (Date)o1;
                        Date date2 = (Date)o2;
                        return date2.compareTo(date1);
                    }
                });
                for (Date date : dateList) {
                    BigDecimal val = BigDecimal.ZERO;
                    for (int i = attenceDetailInfoList.size() - 1; i >= 0; --i) {
                        Map attenceInfoMap = (Map)attenceDetailInfoList.get(i);
                        Date attenceDate = (Date)attenceInfoMap.get("attenceDate");
                        BigDecimal attenceVal = new BigDecimal(attenceInfoMap.get(attendanceItemName).toString());
                        if (attenceDate.compareTo(date) < 0) continue;
                        if (cursor == 0 && leffdt != null && attenceDate.compareTo(leffdt) <= 0) {
                            val = val.add(attenceVal);
                        }
                        if (cursor > 0) {
                            val = val.add(attenceVal);
                        }
                        attenceDetailInfoList.remove(i);
                    }
                    attenceMap.put(this.df.format(date), val);
                    ++cursor;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return attenceMap;
    }

    public String getSegmentedSalarySQL(String itemName, CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calSchemeEndDate = CmpDateUtil.toKSqlDate(calScheme.getEndDate());
        String calSchemeBeginDate = CmpDateUtil.toKSqlDate(calScheme.getBeginDate());
        String hrOrgId = calScheme.getHrOrgUnit().getId().toString();
        String personSql = "select FPersonID from T_HR_SCmpCalTable t where t.FcalSchemeID = '" + calschemeid + "' and t.FcalTime = " + calTime + " and t.FperiodYear = " + periodYear + " and t.FperiodMonth = " + periodMonth + " and calTable.fpersonid = t.FPERSONID ";
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "t.fid").replace("t_hr_scmpcaltable.FCalState", "t.fcalState");
            personSql = personSql + " and " + replace;
        }
        StringBuilder sb = new StringBuilder();
        String l = calScheme.getLanType().getValue();
        sb.append(" SELECT distinct fix.FMoney as money,fix.FEffectDay effectDay,fix.fleffectday LEFFECTDAY,fix.FPersonId personId,item.FName_" + l + " itemName,fix.FCURRENCYID ,").append("\r\n");
        sb.append(" ( case when (fix.fpayhrorgunitid is null or fix.fpayhrorgunitid in ('')) then 0  when ( calTable.FHrOrgUnitID= fix.fpayhrorgunitid) then 1 else 2 end ) type").append("\r\n");
        sb.append(" FROM t_hr_scmpcaltable calTable ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustSalary fix on calTable.fpersonid=fix.fpersonid  ").append("\r\n");
        sb.append(" left join T_HR_SFixAdjustPayHrRecord payHr on fix.fid=payHr.FSOURCEID  ").append("\r\n");
        sb.append(" left join T_HR_SCmpItem item on item.fid=fix.FCmpItemID  ").append("\r\n");
        sb.append(" where (calTable.FHrOrgUnitID= fix.fpayhrorgunitid  or fix.fpayhrorgunitid is null)");
        sb.append(" and fix.FEffectDay <= calTable.FRealEndDate ").append("\r\n");
        sb.append(" and fix.FEffectDay <=").append(calSchemeEndDate).append("\r\n");
        sb.append(" and fix.FLEFFECTDAY >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and payHr.fleffdt >=").append(calSchemeBeginDate).append("\r\n");
        sb.append(" and item.fname_" + l + "='").append(itemName).append("' ").append("\r\n");
        sb.append(" and calTable.FHrOrgUnitID='").append(hrOrgId).append("'");
        sb.append(" and calTable.FcalTime=").append(calTime).append(" and calTable.FperiodYear=");
        sb.append(periodYear).append(" and calTable.FperiodMonth=").append(periodMonth).append("\r\n");
        sb.append(" and exists (").append(personSql).append(")").append("\r\n");
        sb.append(" order by fix.FPersonId ,item.FName_" + l + ",fix.FEffectDay ").append("\r\n");
        String salarySQL = sb.toString();
        return salarySQL;
    }
}

