/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeRatioFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeRatioInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.budget.dto.BudgetSchemeRatioData;
import com.kingdee.shr.compensation.pojo.budget.BasicFormObj;
import com.kingdee.shr.compensation.service.budget.ICmpBudgetSchemeService;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CmpBudgetSchemeServiceImpl
implements ICmpBudgetSchemeService {
    @Override
    public void checkBudgetSchemeUnique(Context ctx, CoreBaseInfo model) throws BOSException {
        CmpBudgetSchemeCollection schemeCollection;
        CmpBudgetSchemeInfo budgetScheme = (CmpBudgetSchemeInfo)model;
        if (budgetScheme.getTemplate() == null) {
            return;
        }
        String templateId = budgetScheme.getTemplate().getId().toString();
        int budgetYear = budgetScheme.getBudgetYear();
        String oql = "where template.id = '" + templateId + "' and budgetYear = " + budgetYear;
        if (budgetScheme.getId() != null && !StringUtils.isEmpty((String)budgetScheme.getId().toString())) {
            oql = oql + " and id <> '" + budgetScheme.getId().toString() + "'";
        }
        if ((schemeCollection = CmpBudgetSchemeFactory.getLocalInstance((Context)ctx).getCmpBudgetSchemeCollection(oql)) != null && schemeCollection.size() > 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label9", (Locale)ctx.getLocale()));
        }
    }

    protected List<String> getIdList(String selectedIds) {
        ArrayList<String> idList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)selectedIds)) {
            String[] idArr = selectedIds.split(",");
            idList.addAll(Arrays.asList(idArr));
        }
        return idList;
    }

    @Override
    public void checkAssignBudgetScheme(Context ctx, String selectedIds) throws BOSException {
        List<String> idList = this.getIdList(selectedIds);
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String idInFile = cmpInSql.createInSqlBaseOnFId(ctx, idList);
        String sql = " SELECT FBUDGETPERIOD,FBUDGETYEAR,count(FId) as COUNTNUM  FROM T_HR_SCmpBudgetScheme  where FSubBudgetAssignType = 1  and  FID in " + idInFile + " group by FbudgetPeriod,FBudgetYear ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        cmpInSql.release(ctx);
        if (rowSet.size() > 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label8", (Locale)ctx.getLocale()));
        }
        if (rowSet.size() == 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label10", (Locale)ctx.getLocale()));
        }
        try {
            while (rowSet.next()) {
                int countnum = rowSet.getInt("COUNTNUM");
                if (countnum == idList.size()) continue;
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label7", (Locale)ctx.getLocale()));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<BudgetSchemeRatioData> getBudgetSchemeRatio(Context ctx, String selectedIds, int budgetPeriod) throws BOSException {
        ArrayList<BudgetSchemeRatioData> dataList = new ArrayList<BudgetSchemeRatioData>();
        List<String> idList = this.getIdList(selectedIds);
        if (idList == null || idList.isEmpty()) {
            BudgetSchemeRatioData newRatioData = new BudgetSchemeRatioData();
            if (1 == budgetPeriod) {
                newRatioData.setLastHalfYear(new BigDecimal("100"));
            } else if (2 == budgetPeriod) {
                newRatioData.setQuarter4(new BigDecimal("100"));
            } else if (3 == budgetPeriod) {
                newRatioData.setMonth12(new BigDecimal("100"));
            }
            dataList.add(newRatioData);
            return dataList;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String idInSql = cmpInSql.createInSqlBaseOnFId(ctx, idList);
        String ratioSelectSql = this.getBudgetSchemeRatioSelectSql(ctx, idInSql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)ratioSelectSql);
        try {
            while (rowSet.next()) {
                BudgetSchemeRatioData ratioData = new BudgetSchemeRatioData();
                String ratioId = rowSet.getString("FID");
                ratioData.setId(ratioId);
                ratioData.setCmpBudgetSchemeId(rowSet.getString("CMPBUDGETSCHEMEID"));
                ratioData.setCmpBudgetSchemeName(rowSet.getString("BUDGETSCHEMENAME"));
                ratioData.setBudgetYear(rowSet.getInt("FBUDGETPERIOD"));
                ratioData.setBudgetYear(rowSet.getInt("FBUDGETYEAR"));
                ratioData.setFirstHalfYear(rowSet.getBigDecimal("FIRSTHALFYEAR"));
                ratioData.setLastHalfYear(rowSet.getBigDecimal("FLASTHALFYEAR"));
                ratioData.setQuarter1(rowSet.getBigDecimal("FQUARTER1"));
                ratioData.setQuarter2(rowSet.getBigDecimal("FQUARTER2"));
                ratioData.setQuarter3(rowSet.getBigDecimal("FQUARTER3"));
                ratioData.setQuarter4(rowSet.getBigDecimal("FQUARTER4"));
                ratioData.setMonth1(rowSet.getBigDecimal("FMONTH1"));
                ratioData.setMonth2(rowSet.getBigDecimal("FMONTH2"));
                ratioData.setMonth3(rowSet.getBigDecimal("FMONTH3"));
                ratioData.setMonth4(rowSet.getBigDecimal("FMONTH4"));
                ratioData.setMonth5(rowSet.getBigDecimal("FMONTH5"));
                ratioData.setMonth6(rowSet.getBigDecimal("FMONTH6"));
                ratioData.setMonth7(rowSet.getBigDecimal("FMONTH7"));
                ratioData.setMonth8(rowSet.getBigDecimal("FMONTH8"));
                ratioData.setMonth9(rowSet.getBigDecimal("FMONTH9"));
                ratioData.setMonth10(rowSet.getBigDecimal("FMONTH10"));
                ratioData.setMonth11(rowSet.getBigDecimal("FMONTH11"));
                ratioData.setMonth12(rowSet.getBigDecimal("FMONTH12"));
                if (StringUtils.isEmpty((String)ratioId)) {
                    if (1 == budgetPeriod) {
                        ratioData.setLastHalfYear(new BigDecimal("100"));
                    } else if (2 == budgetPeriod) {
                        ratioData.setQuarter4(new BigDecimal("100"));
                    } else if (3 == budgetPeriod) {
                        ratioData.setMonth12(new BigDecimal("100"));
                    }
                }
                dataList.add(ratioData);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        cmpInSql.release(ctx);
        return dataList;
    }

    @Override
    public void saveBudgetRatioData(Context ctx, String jsonData) throws BOSException, EASBizException {
        List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonData, List.class);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> idList = new ArrayList<String>();
            for (Map rowData : list) {
                String budgetSchemeId = (String)rowData.get("cmpBudgetSchemeId");
                if (StringUtils.isEmpty((String)budgetSchemeId)) continue;
                idList.add(budgetSchemeId);
            }
            List<String> existDBSchemeIds = this.getExistDBSchemeIds(ctx, idList);
            this.insertRatioData(ctx, list, existDBSchemeIds);
            this.updateRatioData(ctx, list, existDBSchemeIds);
        }
    }

    protected BigDecimal cover2BigDecimal(Map<String, Object> rowData, String key) {
        Object keyVal = rowData.get(key);
        if (keyVal == null) {
            return BigDecimal.ZERO;
        }
        String valStr = keyVal.toString();
        if (StringUtils.isEmpty((String)valStr)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(valStr);
    }

    protected void insertRatioData(Context ctx, List<Map<String, Object>> list, List<String> existDBSchemeIds) throws BOSException, EASBizException {
        CoreBaseCollection ratioCollection = this.getRatioCollection(list, existDBSchemeIds, false);
        this.checkData100Percent(ctx, ratioCollection);
        if (ratioCollection.size() > 0) {
            BudgetSchemeRatioFactory.getLocalInstance((Context)ctx).saveBatchData(ratioCollection);
        }
    }

    protected void updateRatioData(Context ctx, List<Map<String, Object>> list, List<String> existDBSchemeIds) throws BOSException, EASBizException {
        CoreBaseCollection ratioCollection = this.getRatioCollection(list, existDBSchemeIds, true);
        this.checkData100Percent(ctx, ratioCollection);
        if (ratioCollection.size() > 0) {
            BudgetSchemeRatioFactory.getLocalInstance((Context)ctx).updateBatchData(ratioCollection);
        }
    }

    protected void checkData100Percent(Context ctx, CoreBaseCollection ratioCollection) throws BOSException {
        if (ratioCollection != null && !ratioCollection.isEmpty()) {
            String msgTemplate;
            Map<String, CmpBudgetSchemeInfo> budgetSchemeInfoMap = this.getBudgetSchemeInfoMap(ctx, ratioCollection);
            StringBuilder nameBuilder = new StringBuilder();
            StringBuilder less100Builder = new StringBuilder();
            BigDecimal hundred = new BigDecimal("100");
            for (int i = 0; i < ratioCollection.size(); ++i) {
                BudgetTemplateInfo template;
                BudgetPeriodEnum budgetPeriod;
                String budgetSchemeId;
                CmpBudgetSchemeInfo budgetSchemeInfo;
                BudgetSchemeRatioInfo ratioInfo = (BudgetSchemeRatioInfo)ratioCollection.get(i);
                if (ratioInfo == null || ratioInfo.getBudgetScheme() == null || ratioInfo.getBudgetScheme().getId() == null || (budgetSchemeInfo = budgetSchemeInfoMap.get(budgetSchemeId = ratioInfo.getBudgetScheme().getId().toString())) == null || budgetSchemeInfo.getTemplate() == null || (budgetPeriod = (template = budgetSchemeInfo.getTemplate()).getBudgetPeriod()) == null) continue;
                int budgetPeriodValue = budgetPeriod.getValue();
                BigDecimal sum = this.getPercentSum(ratioInfo, budgetPeriodValue);
                if (hundred.compareTo(sum) < 0) {
                    nameBuilder.append(",").append(budgetSchemeInfo.getName());
                }
                if (hundred.compareTo(sum) <= 0) continue;
                less100Builder.append(",").append(budgetSchemeInfo.getName());
            }
            String names = nameBuilder.toString();
            String less100Str = less100Builder.toString();
            String msg = "";
            if (!StringUtils.isEmpty((String)less100Str)) {
                msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label12", (Locale)ctx.getLocale());
                less100Str = less100Str.substring(1);
                msg = MessageFormat.format(msgTemplate, less100Str);
            }
            if (!StringUtils.isEmpty((String)names)) {
                msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label11", (Locale)ctx.getLocale());
                names = names.substring(1);
                String more100Msg = MessageFormat.format(msgTemplate, names);
                String string = msg = StringUtils.isEmpty((String)msg) ? more100Msg : msg + "<br/>" + more100Msg;
            }
            if (!StringUtils.isEmpty((String)msg)) {
                throw new BOSException(msg);
            }
        }
    }

    protected BigDecimal getPercentSum(BudgetSchemeRatioInfo ratioInfo, int budgetPeriodValue) {
        BigDecimal sum = BigDecimal.ZERO;
        if (1 == budgetPeriodValue) {
            BigDecimal firstHalfYear = ratioInfo.getFirstHalfYear() == null ? BigDecimal.ZERO : ratioInfo.getFirstHalfYear();
            BigDecimal lastHalfYear = ratioInfo.getLastHalfYear() == null ? BigDecimal.ZERO : ratioInfo.getLastHalfYear();
            sum = sum.add(firstHalfYear).add(lastHalfYear);
        } else if (2 == budgetPeriodValue) {
            BigDecimal quarter1 = ratioInfo.getQuarter1() == null ? BigDecimal.ZERO : ratioInfo.getQuarter1();
            BigDecimal quarter2 = ratioInfo.getQuarter2() == null ? BigDecimal.ZERO : ratioInfo.getQuarter2();
            BigDecimal quarter3 = ratioInfo.getQuarter3() == null ? BigDecimal.ZERO : ratioInfo.getQuarter3();
            BigDecimal quarter4 = ratioInfo.getQuarter4() == null ? BigDecimal.ZERO : ratioInfo.getQuarter4();
            sum = sum.add(quarter1).add(quarter2).add(quarter3).add(quarter4);
        } else if (3 == budgetPeriodValue) {
            BigDecimal month1 = ratioInfo.getMonth1() == null ? BigDecimal.ZERO : ratioInfo.getMonth1();
            BigDecimal month2 = ratioInfo.getMonth2() == null ? BigDecimal.ZERO : ratioInfo.getMonth2();
            BigDecimal month3 = ratioInfo.getMonth3() == null ? BigDecimal.ZERO : ratioInfo.getMonth3();
            BigDecimal month4 = ratioInfo.getMonth4() == null ? BigDecimal.ZERO : ratioInfo.getMonth4();
            BigDecimal month5 = ratioInfo.getMonth5() == null ? BigDecimal.ZERO : ratioInfo.getMonth5();
            BigDecimal month6 = ratioInfo.getMonth6() == null ? BigDecimal.ZERO : ratioInfo.getMonth6();
            BigDecimal month7 = ratioInfo.getMonth7() == null ? BigDecimal.ZERO : ratioInfo.getMonth7();
            BigDecimal month8 = ratioInfo.getMonth8() == null ? BigDecimal.ZERO : ratioInfo.getMonth8();
            BigDecimal month9 = ratioInfo.getMonth9() == null ? BigDecimal.ZERO : ratioInfo.getMonth9();
            BigDecimal month10 = ratioInfo.getMonth10() == null ? BigDecimal.ZERO : ratioInfo.getMonth10();
            BigDecimal month11 = ratioInfo.getMonth11() == null ? BigDecimal.ZERO : ratioInfo.getMonth11();
            BigDecimal month12 = ratioInfo.getMonth12() == null ? BigDecimal.ZERO : ratioInfo.getMonth12();
            sum = sum.add(month1).add(month2).add(month3).add(month4).add(month5).add(month6).add(month7).add(month8).add(month9).add(month10).add(month11).add(month12);
        }
        return sum;
    }

    protected Map<String, CmpBudgetSchemeInfo> getBudgetSchemeInfoMap(Context ctx, CoreBaseCollection ratioCollection) throws BOSException {
        HashSet<String> budgetSchemeIdSet = new HashSet<String>();
        for (int i = 0; i < ratioCollection.size(); ++i) {
            BudgetSchemeRatioInfo ratioInfo = (BudgetSchemeRatioInfo)ratioCollection.get(i);
            if (ratioInfo == null || ratioInfo.getBudgetScheme() == null || ratioInfo.getBudgetScheme().getId() == null) continue;
            CmpBudgetSchemeInfo budgetScheme = ratioInfo.getBudgetScheme();
            budgetSchemeIdSet.add(budgetScheme.getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String inSqlBaseOnFId = cmpInSql.createInSqlBaseOnFId(ctx, budgetSchemeIdSet);
        String oql = "select id,name,template.id,template.budgetPeriod where id in " + inSqlBaseOnFId;
        CmpBudgetSchemeCollection schemeCollection = CmpBudgetSchemeFactory.getLocalInstance((Context)ctx).getCmpBudgetSchemeCollection(oql);
        HashMap<String, CmpBudgetSchemeInfo> cmpBudgetSchemeInfoMap = new HashMap<String, CmpBudgetSchemeInfo>();
        for (int i = 0; i < schemeCollection.size(); ++i) {
            CmpBudgetSchemeInfo budgetSchemeInfo = schemeCollection.get(i);
            if (budgetSchemeInfo == null || budgetSchemeInfo.getId() == null) continue;
            cmpBudgetSchemeInfoMap.put(budgetSchemeInfo.getId().toString(), budgetSchemeInfo);
        }
        return cmpBudgetSchemeInfoMap;
    }

    protected CoreBaseCollection getRatioCollection(List<Map<String, Object>> list, List<String> existDBSchemeIds, boolean isUpdate) {
        CoreBaseCollection ratioCollection = new CoreBaseCollection();
        for (Map<String, Object> rowData : list) {
            String cmpBudgetSchemeId = (String)rowData.get("cmpBudgetSchemeId");
            BudgetSchemeRatioInfo ratioInfo = new BudgetSchemeRatioInfo();
            if (isUpdate && !existDBSchemeIds.contains(cmpBudgetSchemeId) || !isUpdate && existDBSchemeIds.contains(cmpBudgetSchemeId)) continue;
            if (isUpdate) {
                ratioInfo.setId(BOSUuid.read((String)((String)rowData.get("id"))));
            }
            CmpBudgetSchemeInfo budgetSchemeInfo = new CmpBudgetSchemeInfo();
            budgetSchemeInfo.setId(BOSUuid.read((String)cmpBudgetSchemeId));
            ratioInfo.setBudgetScheme(budgetSchemeInfo);
            ratioInfo.setFirstHalfYear(this.cover2BigDecimal(rowData, "firstHalfYear"));
            ratioInfo.setLastHalfYear(this.cover2BigDecimal(rowData, "lastHalfYear"));
            ratioInfo.setQuarter1(this.cover2BigDecimal(rowData, "quarter1"));
            ratioInfo.setQuarter2(this.cover2BigDecimal(rowData, "quarter2"));
            ratioInfo.setQuarter3(this.cover2BigDecimal(rowData, "quarter3"));
            ratioInfo.setQuarter4(this.cover2BigDecimal(rowData, "quarter4"));
            ratioInfo.setMonth1(this.cover2BigDecimal(rowData, "month1"));
            ratioInfo.setMonth2(this.cover2BigDecimal(rowData, "month2"));
            ratioInfo.setMonth3(this.cover2BigDecimal(rowData, "month3"));
            ratioInfo.setMonth4(this.cover2BigDecimal(rowData, "month4"));
            ratioInfo.setMonth5(this.cover2BigDecimal(rowData, "month5"));
            ratioInfo.setMonth6(this.cover2BigDecimal(rowData, "month6"));
            ratioInfo.setMonth7(this.cover2BigDecimal(rowData, "month7"));
            ratioInfo.setMonth8(this.cover2BigDecimal(rowData, "month8"));
            ratioInfo.setMonth9(this.cover2BigDecimal(rowData, "month9"));
            ratioInfo.setMonth10(this.cover2BigDecimal(rowData, "month10"));
            ratioInfo.setMonth11(this.cover2BigDecimal(rowData, "month11"));
            ratioInfo.setMonth12(this.cover2BigDecimal(rowData, "month12"));
            ratioCollection.add((CoreBaseInfo)ratioInfo);
        }
        return ratioCollection;
    }

    protected List<String> getExistDBSchemeIds(Context ctx, List<String> schemeIds) throws BOSException {
        ArrayList<String> dbIdList = new ArrayList<String>();
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String inSql = cmpInSql.createInSqlBaseOnFId(ctx, schemeIds);
        String sql = "SELECT FBUDGETSCHEMEID FROM T_HR_SBudgetSchemeRatio where FBudgetSchemeID in " + inSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                dbIdList.add(rowSet.getString("FBUDGETSCHEMEID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return dbIdList;
    }

    protected String getBudgetSchemeRatioSelectSql(Context ctx, String inSql) {
        String tbAlias = "ra";
        String ratioSqlField = tbAlias + ".FIRSTHALFYEAR," + tbAlias + ".FLASTHALFYEAR," + this.getDynamicFieldOfRatio(tbAlias, "FQUARTER", 4) + "," + this.getDynamicFieldOfRatio(tbAlias, "FMONTH", 12);
        String l = com.kingdee.shr.base.syssetting.util.LocaleUtils.getShortCode((Locale)ctx.getLocale());
        return " SELECT ra.FID,b.FID as CMPBUDGETSCHEMEID,b.Fname_" + l + " as BUDGETSCHEMENAME, b.FBudgetPeriod as FBUDGETPERIOD,b.FBUDGETYEAR," + ratioSqlField + " FROM T_HR_SCmpBudgetScheme b   left join T_HR_SBudgetSchemeRatio ra on ra.FBudgetSchemeID = b.FID  where b.FID in " + inSql;
    }

    protected String getDynamicFieldOfRatio(String tbAlias, String field, int colNum) {
        if (StringUtils.isEmpty((String)field)) {
            return "";
        }
        String templateField = tbAlias + "." + field;
        if (StringUtils.isEmpty((String)tbAlias)) {
            templateField = field;
        }
        StringBuilder fieldBuild = new StringBuilder();
        for (int i = 1; i <= colNum; ++i) {
            if (i > 1) {
                fieldBuild.append(",");
            }
            fieldBuild.append(templateField).append(i);
        }
        return fieldBuild.toString();
    }

    public CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws BOSException {
        CurrencyInfo currencyInfo = new CurrencyInfo();
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        String sql = "select FID,FNUMBER,Fname_l1 as NAME1,Fname_l2 as NAME2,Fname_l3 as NAME3 from T_BD_Currency where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currencyId});
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FID");
                String number = rowSet.getString("FNUMBER");
                String name1 = rowSet.getString("NAME1");
                String name2 = rowSet.getString("NAME2");
                String name3 = rowSet.getString("NAME3");
                currencyInfo.setId(BOSUuid.read((String)id));
                currencyInfo.setNumber(number);
                currencyInfo.setName(name1, LocaleUtils.locale_L1);
                currencyInfo.setName(name2, LocaleUtils.locale_L2);
                currencyInfo.setName(name3, LocaleUtils.locale_L3);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return currencyInfo;
    }

    @Override
    public void initNewFormData(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        CmpBudgetSchemeInfo budgetScheme = (CmpBudgetSchemeInfo)coreBaseInfo;
        String currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        CurrencyInfo RMBCurrencyInfo = this.getCurrencyInfo(ctx, currencyId);
        budgetScheme.setCurrency(RMBCurrencyInfo);
        Calendar effectCalendar = Calendar.getInstance();
        budgetScheme.setEffectDate(effectCalendar.getTime());
        int year = effectCalendar.get(1);
        effectCalendar.set(1, year + 1);
        effectCalendar.set(5, effectCalendar.get(5) - 1);
        budgetScheme.setExpiryDate(effectCalendar.getTime());
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        budgetScheme.setCreator(currentUserInfo);
    }

    @Override
    public BasicFormObj getTemplateName(Context ctx, String templateId) throws BOSException {
        BasicFormObj resObj = new BasicFormObj();
        String l = com.kingdee.shr.base.syssetting.util.LocaleUtils.getShortCode((Context)ctx);
        String sql = " SELECT FID,fNumber,Fname_" + l + " as langNAME, FNAME_L1 as NAME1,FNAME_L2 as NAME2,FNAME_l3 as NAME3 FROM T_HR_SBudgetTemplate where FID=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId});
        try {
            while (rowSet.next()) {
                resObj.setId(rowSet.getString("FID"));
                resObj.setNumber(rowSet.getString("fNumber"));
                resObj.setName(rowSet.getString("langNAME"));
                resObj.setL1(rowSet.getString("NAME1"));
                resObj.setL2(rowSet.getString("NAME2"));
                resObj.setL3(rowSet.getString("NAME3"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resObj;
    }

    protected String genSchemeName(BudgetTemplateInfo templateInfo, Locale locale, int budgetYear) {
        return templateInfo.getName(locale) + "_" + budgetYear;
    }

    @Override
    public void initDataForNextYear(Context ctx, String schemeId, CoreBaseInfo coreBaseInfo) throws BOSException {
        CmpBudgetSchemeCollection schemeCollection = CmpBudgetSchemeFactory.getLocalInstance((Context)ctx).getCmpBudgetSchemeCollection("select *,template.name,template.number where id = '" + schemeId + "'");
        if (schemeCollection.isEmpty()) {
            return;
        }
        CmpBudgetSchemeInfo existsSchemeInfo = schemeCollection.get(0);
        CmpBudgetSchemeInfo curSchemeInfo = (CmpBudgetSchemeInfo)coreBaseInfo;
        if (existsSchemeInfo != null) {
            BudgetTemplateInfo template = existsSchemeInfo.getTemplate();
            curSchemeInfo.setTemplate(template);
            curSchemeInfo.setBudgetPeriod(existsSchemeInfo.getBudgetPeriod());
            CurrencyInfo currencyInfo = this.getCurrencyInfo(ctx, existsSchemeInfo.getCurrency().getId().toString());
            curSchemeInfo.setCurrency(currencyInfo);
            int newYear = existsSchemeInfo.getBudgetYear() + 1;
            curSchemeInfo.setBudgetYear(newYear);
            curSchemeInfo.setBudgetPeriod(existsSchemeInfo.getBudgetPeriod());
            curSchemeInfo.setName(this.genSchemeName(template, LocaleUtils.locale_L1, newYear), LocaleUtils.locale_L1);
            curSchemeInfo.setName(this.genSchemeName(template, LocaleUtils.locale_L2, newYear), LocaleUtils.locale_L2);
            curSchemeInfo.setName(this.genSchemeName(template, LocaleUtils.locale_L3, newYear), LocaleUtils.locale_L3);
            curSchemeInfo.setNumber(template.getNumber() + "_" + newYear);
            curSchemeInfo.setDescription(null);
            Date expiryDate = existsSchemeInfo.getExpiryDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expiryDate);
            calendar.set(5, calendar.get(5) + 1);
            curSchemeInfo.setEffectDate(calendar.getTime());
            calendar.setTime(expiryDate);
            calendar.set(1, calendar.get(1) + 1);
            curSchemeInfo.setExpiryDate(calendar.getTime());
            curSchemeInfo.setState(StateEnum.DISABLE);
            curSchemeInfo.setEnableDate(null);
            curSchemeInfo.setDisableDate(null);
            curSchemeInfo.setSubBudgetAssignType(existsSchemeInfo.getSubBudgetAssignType());
            curSchemeInfo.setSubBalanceTypeEnum(existsSchemeInfo.getSubBalanceTypeEnum());
        }
    }
}

