/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql.wizard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.exception.CmpCalSQLException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class CmpCalSQL {
    public static String analysisSql(Context ctx, String tableNameA, String tableNameB, String joinFields, String linkStr, String sorter) throws BOSException {
        StringBuffer analysisSql = new StringBuffer();
        if (StringUtils.isEmpty((String)tableNameA) || StringUtils.isEmpty((String)tableNameB)) {
            throw new BOSException(new CmpCalSQLException(CmpCalSQLException.TABLENOTEMPTY).getMessage());
        }
        try {
            String[] split;
            String mainTableAlias = "A";
            if (" right join ".equals(linkStr)) {
                mainTableAlias = "B";
            }
            Map<String, Set<String>> tableCloumnSetMapA = SQLHandleUtil.getTableCloumnSetMap(ctx, tableNameA);
            Map<String, Set<String>> tableCloumnSetMapB = SQLHandleUtil.getTableCloumnSetMap(ctx, tableNameB);
            if (tableNameA.contains(" ")) {
                tableNameA = "(" + tableNameA + ")";
            }
            if (tableNameB.contains(" ")) {
                tableNameB = "(" + tableNameB + ")";
            }
            HashSet<String> joinSet = new HashSet<String>();
            HashSet numberSet = new HashSet();
            HashSet intSet = new HashSet();
            HashSet dateSet = new HashSet();
            HashSet strSet = new HashSet();
            HashSet nclobSet = new HashSet();
            HashSet uidSet = new HashSet();
            for (String str : split = joinFields.split(",")) {
                joinSet.add(str.toUpperCase(Locale.ENGLISH));
            }
            numberSet.addAll(tableCloumnSetMapA.get("numberSet"));
            numberSet.addAll(tableCloumnSetMapB.get("numberSet"));
            intSet.addAll(tableCloumnSetMapA.get("intSet"));
            intSet.addAll(tableCloumnSetMapB.get("intSet"));
            dateSet.addAll(tableCloumnSetMapA.get("dateSet"));
            dateSet.addAll(tableCloumnSetMapB.get("dateSet"));
            strSet.addAll(tableCloumnSetMapA.get("strSet"));
            strSet.addAll(tableCloumnSetMapB.get("strSet"));
            nclobSet.addAll(tableCloumnSetMapA.get("nclobSet"));
            nclobSet.addAll(tableCloumnSetMapB.get("nclobSet"));
            uidSet.addAll(tableCloumnSetMapA.get("uidSet"));
            uidSet.addAll(tableCloumnSetMapB.get("uidSet"));
            StringBuilder selectSql = new StringBuilder();
            for (String field : numberSet) {
                if (field.contains("CMP_CTB") || field.contains("cmp_ctb")) {
                    selectSql.append(",A.\"").append(field).append("\" AS \"A.").append(field).append("\",B.\"").append(field).append("\" AS \"B.").append(field).append("\",(isnull(A.\"").append(field).append("\",0)- isnull (B.\"").append(field).append("\",0)) AS \"").append(field).append("\"");
                    continue;
                }
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            for (String field : intSet) {
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            for (String field : dateSet) {
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            for (String field : uidSet) {
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            for (String field : strSet) {
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            for (String field : nclobSet) {
                selectSql.append(",").append(mainTableAlias).append(".\"").append(field).append("\" AS \"").append(field).append("\"");
            }
            if (StringUtils.isEmpty((String)selectSql.toString())) {
                return null;
            }
            analysisSql.append("SELECT ");
            analysisSql.append(selectSql.toString().replaceFirst(",", ""));
            analysisSql.append(" FROM ");
            analysisSql.append(tableNameA).append(" AS A");
            analysisSql.append(linkStr);
            analysisSql.append(tableNameB).append(" AS B");
            analysisSql.append(" ON ");
            boolean isFirst = true;
            for (String field : joinSet) {
                if (isFirst) {
                    analysisSql.append("A.\"").append(field).append("\" = B.\"").append(field).append("\" ");
                    isFirst = false;
                    continue;
                }
                analysisSql.append("and A.\"").append(field).append("\" = B.\"").append(field).append("\" ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!CmpStrUtil.isEmpty(sorter)) {
            analysisSql.append(" order by ");
            CmpCalSQL.addAnalysisSorter(analysisSql, sorter);
        }
        return analysisSql.toString();
    }

    private static void addAnalysisSorter(StringBuffer sb, String sorter) {
        if (CmpStrUtil.isEmpty(sorter)) {
            return;
        }
        String[] sorters = sorter.split(",");
        for (int i = 0; i < sorters.length; ++i) {
            sb.append("A").append(".").append(sorters[i]);
            sb.append(",");
            sb.append("B").append(".").append(sorters[i]);
            if (i == sorters.length - 1) continue;
            sb.append(",");
        }
    }

    public static String synchRealEndDateSql(CalSchemeInfo calSchemeInfo) {
        String cmpSchemeId = calSchemeInfo.getId().toString();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        return "update t_hr_scmpcaltable calTable    set frealenddate=(   select FLEFFECTDATE from T_HR_SCmpEmpORelation    where fid = calTable.fcmpemporelationid) where frealenddate>(  select FLEFFECTDATE from T_HR_SCmpEmpORelation   where fid = calTable.fcmpemporelationid) and FCalSchemeId='" + cmpSchemeId + "' and FPeriodYear=" + periodYear + "  and FPeriodMonth=" + periodMonth + " and FCalTime=" + calTime;
    }
}

