/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.shr.compensation.app.tax.TaxBaseCollection;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxPersonBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TaxCommonService {
    protected abstract TaxTypeEnum getTaxTypeEnum();

    public abstract String saveInfo(Context var1, String var2) throws Exception;

    public abstract String getInfo(Context var1, String var2) throws Exception;

    public abstract String getHisInfo(Context var1) throws Exception;

    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseInfo info) {
        return null;
    }

    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseCollection coll) {
        return null;
    }

    protected TaxBaseInfo setTaxBaseInfoForSave(Context ctx, TaxStateEnum state, double total) throws Exception {
        TaxBaseInfo baseInfo = new TaxBaseInfo();
        Calendar calendar = Calendar.getInstance();
        PersonInfo personInfo = TaxUtil.getPersonInfo(ctx);
        TaxPersonBaseInfo taxPersonBaseInfo = TaxUtil.getTaxPersonBaseByPersonId(ctx, personInfo.getId().toString());
        baseInfo.setSubmitDate(calendar.getTime());
        baseInfo.setSubmitter(personInfo);
        baseInfo.setPerson(personInfo);
        baseInfo.setTaxPerson(taxPersonBaseInfo);
        baseInfo.setState(state);
        baseInfo.setTotal(total);
        baseInfo.setDataState(true);
        baseInfo.setType(this.getTaxTypeEnum());
        baseInfo.setLeffdtYear(2199);
        baseInfo.setLeffdtMonth(12);
        return baseInfo;
    }

    protected String getTaxBaseInfoByState(Context ctx, int type, int state) throws Exception {
        StringBuilder str = new StringBuilder();
        String stateStr = null;
        String typeStr = "(" + type + ")";
        String personId = TaxUtil.getPersonId(ctx);
        stateStr = state == 20 ? "(10, 20)" : "(10)";
        if (10 == type || 20 == type) {
            typeStr = "(10,20)";
        }
        String ksql = " where person.id = '" + personId + "' and type in  " + typeStr + " and state in " + stateStr;
        TaxBaseCollection coll = TaxBaseFactory.getLocalInstance((Context)ctx).getTaxBaseCollection(ksql);
        if (null == coll || coll.size() < 1) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            str.append("'").append(coll.get(i).getId().toString()).append("',");
        }
        return str.substring(0, str.length() - 1);
    }

    public void setBillHeadMapForWeb(TaxBaseInfo billInfo, Map<String, Object> map) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("value", billInfo.getState().getValue());
        dataMap.put("text", billInfo.getState().getAlias());
        map.put("total", billInfo.getTotal());
        map.put("state", dataMap);
        map.put("effdt", billInfo.getEffdtYear() + "-" + (billInfo.getEffdtMonth() < 10 ? "0" + billInfo.getEffdtMonth() : Integer.valueOf(billInfo.getEffdtMonth())));
        map.put("leffdt", billInfo.getLeffdtYear() + "-" + (billInfo.getLeffdtMonth() < 10 ? "0" + billInfo.getLeffdtMonth() : Integer.valueOf(billInfo.getLeffdtMonth())));
    }

    public void saveAttactment(List<Map<String, Object>> attList, String boId) throws Exception {
        for (int i = 0; i < attList.size(); ++i) {
            Map<String, Object> attMap = attList.get(i);
            String fullname = attMap.get("name").toString();
            IAttachment attachment = AttachmentFactory.getRemoteInstance();
            String mainname = fullname.substring(0, fullname.lastIndexOf("."));
            String extname = fullname.substring(fullname.lastIndexOf(".") + 1, fullname.length());
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] decodeBuffer = decoder.decodeBuffer(attMap.get("context").toString());
            AttachmentInfo ai = new AttachmentInfo();
            ai.setName(mainname);
            ai.setSimpleName(extname);
            ai.setDescription(null);
            ai.setFile(decodeBuffer);
            ai.setIsShared(false);
            ai.setSharedDesc("no");
            ai.setAttachID("" + System.currentTimeMillis());
            ai.setType("picture");
            IObjectPK aiPk = attachment.addnew(ai);
            ai.setId(BOSUuid.read((String)aiPk.toString()));
            IBoAttchAsso attchAsso = BoAttchAssoFactory.getRemoteInstance();
            BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
            boAttchAssoInfo.setBoID(boId);
            boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boId, (boolean)true)));
            boAttchAssoInfo.setAssoType("Added Accessories");
            boAttchAssoInfo.setAttachment(ai);
            attchAsso.addnew(boAttchAssoInfo);
        }
    }
}

