/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.PrefectureInfo;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.app.tax.TenementFactory;
import com.kingdee.shr.compensation.app.tax.TenementInfo;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TeneAndHousingService;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class TenementSercive
extends TeneAndHousingService {
    @Override
    protected TaxTypeEnum getTaxTypeEnum() {
        return TaxTypeEnum.RENT;
    }

    @Override
    public String saveInfo(Context ctx, String jsonParam) throws Exception {
        List attList;
        TaxStateEnum state;
        String billIds;
        PrefectureInfo pInfo;
        String cityId;
        Map map = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonParam, Map.class);
        TaxBaseInfo bill = null;
        if (null == map.get("state")) {
            return TaxUtil.error(ctx, TaxExceptionEnum.STATE_NOT_NULL.getValue(), TaxExceptionEnum.STATE_NOT_NULL.getName());
        }
        Map objMap = (Map)map.get("rent");
        TenementInfo teneInfo = (TenementInfo)TaxUtil.convertMapToInfo(ctx, objMap, "com.kingdee.shr.compensation.app.tax.Tenement", TenementInfo.class);
        String provinceId = null == objMap.get("province") ? null : objMap.get("province").toString();
        String string = cityId = null == objMap.get("city") ? null : objMap.get("city").toString();
        if (null != provinceId) {
            pInfo = new PrefectureInfo();
            pInfo.setId(BOSUuid.read((String)provinceId));
            teneInfo.setProvince(pInfo);
        }
        if (null != cityId) {
            pInfo = new PrefectureInfo();
            pInfo.setId(BOSUuid.read((String)cityId));
            teneInfo.setCity(pInfo);
        }
        if (null != (billIds = this.getTaxBaseInfoByState(ctx, 20, (state = TaxStateEnum.getEnum((int)TaxUtil.getMapInt(map, "state"))).getValue()))) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SHousing where FBillId in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STenement where FBillId in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid in (" + billIds + ")"));
        }
        if (state.equals((Object)TaxStateEnum.SUBMIT)) {
            String personId = TaxUtil.getPersonId(ctx);
            StringBuilder str = new StringBuilder();
            str.append(" select fid, FEffdtYear effdtYear, FEffdtMonth effdtMonth ");
            str.append(" from T_HR_STaxBase where FPersonId = '").append(personId).append("' ");
            str.append(" and FType = 10 and FleffdtYear >= 2199 and FState = 30 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            if (rowSet.size() > 0) {
                String billId = null;
                int effdtYear = 0;
                int effdtMonth = 0;
                if (rowSet.next()) {
                    billId = rowSet.getString(1);
                    effdtYear = rowSet.getInt("effdtYear");
                    effdtMonth = rowSet.getInt("effdtMonth");
                }
                int month = TaxUtil.getEffdtMonth(ctx);
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, month);
                int leffdtYear = calendar.get(1);
                int leffdtMonth = calendar.get(2) + 1;
                if (leffdtYear < effdtYear || leffdtYear == effdtYear && leffdtMonth < effdtMonth) {
                    leffdtYear = effdtYear;
                    leffdtMonth = effdtMonth;
                }
                String sql = "update T_HR_STaxBase set FLeffdtYear = " + leffdtYear + ", FLeffdtMonth = " + leffdtMonth + ", FState = 40 where fid = '" + billId + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        bill = this.setTaxBaseInfoForSave(ctx, state, teneInfo.getMoney());
        IObjectPK pk = TaxBaseFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bill);
        bill.setId(BOSUuid.read((String)pk.toString()));
        teneInfo.setId(null);
        teneInfo.setBill(bill);
        IObjectPK tenePk = TenementFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)teneInfo);
        if (objMap.containsKey("attachment") && null != (attList = (List)objMap.get("attachment")) && attList.size() > 0) {
            this.saveAttactment(attList, tenePk.toString());
        }
        return TaxUtil.success(ctx, pk.toString());
    }
}

