/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.TbTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskResultInfo;
import com.kingdee.shr.compensation.app.taxCal.vo.TbData;
import com.kingdee.shr.compensation.app.taxCal.vo.WszmFile;
import com.kingdee.shr.compensation.app.taxCal.vo.WszmObject;
import com.kingdee.shr.compensation.app.taxCal.vo.WszmResponseData;
import com.kingdee.shr.compensation.app.taxCal.vo.WszmResponseVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpFileOperateUtils;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DownloadWszmService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(DownloadWszmService.class);

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        String message;
        TaxCalTaskStateEnum state;
        WszmResponseVO wszmResponseVO = (WszmResponseVO)JSON.parseObject((String)response, WszmResponseVO.class);
        WszmResponseData data = wszmResponseVO.getData();
        if (null == data) {
            state = TaxCalTaskStateEnum.FAIDED;
            message = "\u5b8c\u7a0e\u8bc1\u660e\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4f46\u662f\u6ca1\u6709\u6587\u4ef6";
            logger.error((Object)("no data for taskId[" + taskInfo.getId().toString() + "] after getting wszm successfully"));
        } else {
            state = TaxCalTaskStateEnum.FINISHED;
            message = "\u5b8c\u7a0e\u8bc1\u660e\u4e0b\u8f7d\u5b8c\u6210 ";
            TbData tbData = data.getData();
            try {
                WszmObject fjm;
                String errMsg2;
                WszmObject flsd;
                String errMsg1;
                WszmObject ykyj = tbData.getYkyj();
                String taskId = taskInfo.getId().toString();
                String errMsg = this.saveWszmFile(ykyj, taskId, TbTypeEnum.SB0701, ctx);
                if (null != errMsg) {
                    message = message + errMsg;
                }
                if (null != (errMsg1 = this.saveWszmFile(flsd = tbData.getFlsd(), taskId, TbTypeEnum.SB0702, ctx))) {
                    message = message + errMsg1;
                }
                if (null != (errMsg2 = this.saveWszmFile(fjm = tbData.getFjm(), taskId, TbTypeEnum.SB0703, ctx))) {
                    message = message + errMsg2;
                }
            }
            catch (Exception e) {
                logger.error((Object)"File resolve error: ", (Throwable)e);
                state = TaxCalTaskStateEnum.FINISHED;
                message = "\u5b8c\u7a0e\u8bc1\u660e\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4f46\u662f\u6587\u4ef6\u89e3\u6790\u548c\u4fdd\u5b58\u51fa\u9519";
            }
        }
        taskInfo.setMsg(message);
        taskInfo.setState(state);
        TaxServiceTaskResultInfo resultInfo = new TaxServiceTaskResultInfo();
        wszmResponseVO.setData(null);
        resultInfo.setResultContent(JSONObject.toJSONString((Object)wszmResponseVO));
        taskInfo.setRequestResult(resultInfo);
        try {
            TaxCalTaskFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)taskInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"Failed to save TaxCalTaskInfo, caused by: ", (Throwable)e);
        }
        this.sendMsg2Commander(ctx, taskInfo);
    }

    protected void sendMsg2Commander(Context ctx, TaxCalTaskInfo taskInfo) {
        try {
            String number = taskInfo.getNumber();
            TaxCalTaskStateEnum state = taskInfo.getState();
            String taxUnitName = taskInfo.getTaxUnit().getName();
            String period = taskInfo.getPeriod();
            String title = "\u5f00\u5177\u5b8c\u7a0e\u8bc1\u660e\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u5df2\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u7a0e\u6b3e\u7f34\u7eb3\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            title = MessageFormat.format(title, number);
            String msgTemplate = TaxCalTaskStateEnum.FINISHED.equals((Object)state) ? "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}]\u5b8c\u7a0e\u8bc1\u660e\u5f00\u5177\u5b8c\u6210\uff0c\u8bf7\u8fdb\u5165\u7a0e\u6b3e\u7f34\u7eb3\u5217\u8868\u8fdb\u884c\u4e0b\u8f7d" : "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}]\u5b8c\u7a0e\u8bc1\u660e\u5f00\u5177\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u539f\u56e0\u5e76\u91cd\u65b0\u53d1\u8d77\u4efb\u52a1";
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period);
            String sendUserID = CmpTaxUtil.getMessageReceivers(ctx, taskInfo.getTaxUnit().getId().toString());
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, title, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveWszmFile(WszmObject wszm, String taskId, TbTypeEnum tbType, Context ctx) throws Exception {
        String string;
        File zipFile;
        block19: {
            if (null == wszm) {
                return null;
            }
            Integer status = wszm.getStatus();
            if (null == status || status != 0) {
                return wszm.getMsg();
            }
            List files = wszm.getFiles();
            if (null == files || files.isEmpty()) {
                return null;
            }
            ArrayList<File> fileContents = new ArrayList<File>();
            zipFile = null;
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            try {
                byte[] bytes;
                String fullName = "";
                String parent = "/tmp/wszm/download/" + TaxCalcFileUtils.getUUID() + "/";
                String target = "/tmp/wszm/zip/" + TaxCalcFileUtils.getUUID() + "/";
                File dir = new File(parent);
                File targetDir = new File(target);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                HashMap<String, String> fileNameMapper = new HashMap<String, String>();
                for (WszmFile file : files) {
                    String fileName;
                    String errMsg = file.getErrinfo();
                    fullName = fileName = file.getFileNm();
                    String fileNameKey = TaxCalcFileUtils.getUUID() + ".png";
                    if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                        logger.error((Object)("Error message exists in task[" + taskId + "] and tbType[" + tbType.getValue() + "] for file[" + fileName + "]: " + errMsg));
                        continue;
                    }
                    String fileContent = file.getFile();
                    File wszmPNG = new File(parent + fileNameKey);
                    if (wszmPNG.exists()) {
                        FileUtils.deleteQuietly((File)wszmPNG);
                    }
                    fileContents.add(wszmPNG);
                    TaxCalcFileUtils.base64ToFile(fileContent, wszmPNG);
                    fileNameMapper.put(fileNameKey, fileName);
                }
                IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
                String mainName = fullName.substring(0, fullName.lastIndexOf(46));
                String extName = fullName.substring(fullName.lastIndexOf(46) + 1);
                AttachmentInfo attachment = new AttachmentInfo();
                attachment.setDescription("\u5b8c\u7a0e\u8bc1\u660e");
                attachment.setIsShared(false);
                attachment.setSharedDesc("\u5426");
                attachment.setName(mainName);
                if (fileContents.size() > 1) {
                    attachment.setSimpleName("zip");
                    CmpFileOperateUtils.compress(fileNameMapper, parent, target, mainName, true);
                    String zipFileName = target + mainName + ".zip";
                    zipFile = new File(zipFileName);
                    bytes = TaxCalcFileUtils.file2ByteArray(zipFile);
                } else {
                    attachment.setSimpleName(extName);
                    bytes = TaxCalcFileUtils.file2ByteArray((File)fileContents.get(0));
                }
                attachment.setFile(bytes);
                int size = bytes.length;
                if (size < 1024) {
                    attachment.setSize(size + "\u5b57\u8282");
                } else {
                    attachment.setSize(size / 1024 + "KB");
                }
                attachment.setSizeInByte(size);
                attachment.setAttachID(String.valueOf(System.currentTimeMillis()));
                attachment.setType("png\u56fe\u7247");
                String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
                IObjectPK id = iAttachment.addnew(attachment);
                Object[] param = new Object[]{id.toString(), userId, taskId, tbType.getValue()};
                updateParamList.add(param);
                DbUtil.executeBatch((Context)ctx, (String)("update T_HR_STaxPaymentService set FWszmFileId = ?,  FLastUpdateUserID= ?,  FLastUpdateTime = " + CmpDateUtil.toKSqlDate(new Date()) + " where FGetWszmTaskID = ? and FTbType = ?"), updateParamList);
                string = null;
                if (fileContents.isEmpty()) break block19;
            }
            catch (Throwable throwable) {
                if (!fileContents.isEmpty()) {
                    for (File file1 : fileContents) {
                        FileUtils.deleteQuietly((File)file1);
                    }
                }
                if (null != zipFile) {
                    FileUtils.deleteQuietly(zipFile);
                }
                throw throwable;
            }
            for (File file1 : fileContents) {
                FileUtils.deleteQuietly((File)file1);
            }
        }
        if (null != zipFile) {
            FileUtils.deleteQuietly((File)zipFile);
        }
        return string;
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set FSTATE = ? , FMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errMsg) ? "\u5b8c\u7a0e\u8bc1\u660e\u4e0b\u8f7d\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        this.sendMsg2Commander(ctx, taskInfo);
    }
}

