/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueEntryFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueEntryInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInviteEnum;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueItemEnum;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueResult;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueStatusEnum;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueTypeEnum;
import com.kingdee.shr.compensation.app.tax.YesOrNoEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueItem;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueResponse;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueResponseData;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueResponseVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IncomeIssueObtainService
implements ITaxTaskService {
    private static final Logger logger = Logger.getLogger(IncomeIssueObtainService.class);

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        IncomeTaxIssueResponseVO responseVO = (IncomeTaxIssueResponseVO)JSON.parseObject((String)response, IncomeTaxIssueResponseVO.class);
        String taskId = taskInfo.getId().toString();
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, responseVO.getMsg());
        IncomeTaxIssueResponseData responseData = responseVO.getData();
        if (null == response) {
            return;
        }
        List responses = responseData.getData();
        if (null == responses || responses.isEmpty()) {
            return;
        }
        CoreBaseCollection issues = new CoreBaseCollection();
        CoreBaseCollection issueEntries = new CoreBaseCollection();
        for (IncomeTaxIssueResponse response1 : responses) {
            long messageId = response1.getId();
            IncomeTaxIssueCollection issueCollection = IncomeTaxIssueFactory.getLocalInstance((Context)ctx).getIncomeTaxIssueCollection("where messageId = " + messageId);
            if (null != issueCollection && issueCollection.size() > 0) continue;
            if (StringUtils.isEmpty((String)response1.getSssxDm())) {
                logger.info((Object)("[sssxdm is empty]: " + response1));
                continue;
            }
            IncomeTaxIssueItemEnum itemEnum = IncomeTaxIssueItemEnum.getEnum((int)Integer.parseInt(response1.getSssxDm()));
            if (itemEnum == IncomeTaxIssueItemEnum.EMPLOY) {
                IncomeTaxIssueInfo issueInfo = this.initIncomeTaxIssue(ctx, taskInfo, response1, messageId, itemEnum);
                if (null == issueInfo) continue;
                issues.add((CoreBaseInfo)issueInfo);
                continue;
            }
            if (itemEnum != IncomeTaxIssueItemEnum.INCOME) continue;
            List items = response1.getSsmxlb();
            for (IncomeTaxIssueItem item : items) {
                IncomeTaxIssueInfo issueInfo = this.initIncomeTaxIssue(ctx, taskInfo, response1, messageId, itemEnum);
                if (null == issueInfo) continue;
                IncomeTaxIssueEntryInfo entryInfo = this.initIncomeTaxIssueEntry(item);
                issueInfo.setEntry(entryInfo);
                if (null == entryInfo.getIsExisted() || YesOrNoEnum.NO == entryInfo.getIsExisted()) {
                    issueInfo.setResult(IncomeTaxIssueResult.REAL);
                } else {
                    issueInfo.setResult(IncomeTaxIssueResult.NOT_REAL);
                }
                issues.add((CoreBaseInfo)issueInfo);
                issueEntries.add((CoreBaseInfo)entryInfo);
            }
        }
        try {
            if (issueEntries.size() > 0) {
                IncomeTaxIssueEntryFactory.getLocalInstance((Context)ctx).save(issueEntries);
            }
            if (issues.size() > 0) {
                IncomeTaxIssueFactory.getLocalInstance((Context)ctx).save(issues);
                String userIds = CmpTaxUtil.getMessageReceivers(ctx, taskInfo.getTaxUnit().getId().toString());
                this.sendMessage(ctx, taskInfo.getNumber(), taskInfo.getTaxUnit().getName(), userIds);
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to save IncomeTaxIssue, caused by: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void sendMessage(Context ctx, String acceptId, String taxUnitName, String receiverId) {
        String title = "\u4e89\u8bae\u7533\u8bc9\u7684\u4efb\u52a1\u7f16\u7801[" + acceptId + "]\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u4e89\u8bae\u7533\u8bc9\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
        String content = "\u7eb3\u7a0e\u5355\u4f4d[" + taxUnitName + "]\u5b58\u5728\u5f85\u5904\u7406\u7684\u4e89\u8bae\u7533\u8bc9\u4e8b\u9879\uff0c\u8bf7\u5728\u8fdb\u5165[\u4e2a\u7a0e\u670d\u52a1-\u4e89\u8bae\u7533\u8bc9]\u8fdb\u884c\u5c5e\u5b9e/\u4e0d\u5c5e\u5b9e\u5904\u7406\u3002";
        MessageUtil.setNeedSending(ctx);
        MessageUtil.sendMessage(ctx, receiverId, title, content, "\u85aa\u916c\u4e2a\u7a0e");
    }

    private IncomeTaxIssueEntryInfo initIncomeTaxIssueEntry(IncomeTaxIssueItem item) {
        IncomeTaxIssueEntryInfo entryInfo = new IncomeTaxIssueEntryInfo();
        try {
            entryInfo.setDeclareDate(CmpDateUtil.parseDate(item.getSbrq()));
        }
        catch (ParseException e) {
            logger.error((Object)("failed to parse date: " + item.getSbrq()), (Throwable)e);
        }
        entryInfo.setIncomeItem(item.getSdxmMc());
        entryInfo.setIndex(item.getSsmxxh());
        entryInfo.setYearMonth(item.getSkssqq());
        entryInfo.setSre(BigDecimal.valueOf(Double.parseDouble(item.getSre())));
        entryInfo.setYbtse(BigDecimal.valueOf(Double.parseDouble(item.getYjse())));
        if (StringUtils.isEmpty((String)item.getCzbz()) && "Y".equals(item.getCzbz())) {
            entryInfo.setIsExisted(YesOrNoEnum.YES);
        }
        BOSUuid id = BOSUuid.create((String)entryInfo.getBOSType().toString());
        entryInfo.setId(id);
        return entryInfo;
    }

    private IncomeTaxIssueInfo initIncomeTaxIssue(Context ctx, TaxCalTaskInfo task, IncomeTaxIssueResponse response1, long messageId, IncomeTaxIssueItemEnum itemEnum) throws BOSException {
        IncomeTaxIssueInfo issueInfo = new IncomeTaxIssueInfo();
        CardTypeEnum cardType = this.getCardTypeEnumByName(response1.getSsrSfzjlxMC());
        if (null == cardType) {
            logger.error((Object)("cannot find CardTypeEnum for: " + response1.getSsrSfzjlxMC()));
            return null;
        }
        String oql = "select bill.id where bill.cardType = '" + cardType.getValue() + "' and bill.cardNumber = '" + response1.getSsrSfzjhm() + "' and taxUnit.id = '" + task.getTaxUnit().getId() + "'";
        TaxPersonRecordEntryCollection personCollection = TaxPersonRecordEntryFactory.getLocalInstance((Context)ctx).getTaxPersonRecordEntryCollection(oql);
        if (null == personCollection || personCollection.size() == 0) {
            issueInfo.setName(response1.getSsrXM());
            issueInfo.setNumber(response1.getSsrSfzjhm());
        } else {
            issueInfo.setPerson(personCollection.get(0).getBill());
        }
        IncomeTaxIssueTypeEnum typeEnum = this.getIncomeTaxIssueTypeEnumByName(response1.getSslxMc());
        issueInfo.setIssueType(typeEnum);
        issueInfo.setStatus(IncomeTaxIssueStatusEnum.STANDBY);
        issueInfo.setMessageId(messageId);
        issueInfo.setMessageType(response1.getXxlx());
        issueInfo.setIssueItem(itemEnum);
        issueInfo.setIssueNo(response1.getZyssxh());
        issueInfo.setTaxUnit(task.getTaxUnit());
        issueInfo.setInviteStatus(IncomeTaxIssueInviteEnum.NOT_SEND);
        issueInfo.setIssueDate(response1.getSsrq());
        issueInfo.setEndDate(response1.getXqfkrq());
        issueInfo.setSupplementary(response1.getBcsm());
        return issueInfo;
    }

    private IncomeTaxIssueTypeEnum getIncomeTaxIssueTypeEnumByName(String name) {
        for (Object item : IncomeTaxIssueTypeEnum.getEnumList()) {
            IncomeTaxIssueTypeEnum typeEnum = (IncomeTaxIssueTypeEnum)item;
            if (!typeEnum.getAlias().equals(name)) continue;
            return typeEnum;
        }
        return null;
    }

    private CardTypeEnum getCardTypeEnumByName(String cardName) {
        for (Object item : CardTypeEnum.getEnumList()) {
            CardTypeEnum cardTypeEnum = (CardTypeEnum)((Object)item);
            if (!cardTypeEnum.getAlias().equals(cardName)) continue;
            return cardTypeEnum;
        }
        return null;
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errMsg) ? "\u3010\u83b7\u53d6\u7533\u8bc9\u4e89\u8bae\u3011\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        logger.error((Object)("\u3010\u83b7\u53d6\u7533\u8bc9\u4e89\u8bae\u3011\u5931\u8d25: " + errMsg));
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
    }
}

