/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionFactory;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonCollectService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(PersonCollectService.class);

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        String taskId = taskInfo.getId().toString();
        Map bodyMap = (Map)JSON.parseObject((String)response, Map.class);
        Map dataMap = (Map)bodyMap.get("data");
        List gjrylbList = dataMap.containsKey("gjrylb") ? (List)dataMap.get("gjrylb") : null;
        String msg = (String)bodyMap.get("msg");
        msg = StringUtils.isEmpty((String)msg) ? "\u4e0d\u6ee16\u4e07\u786e\u8ba4\u540d\u5355\u83b7\u53d6\u5b8c\u6210" : msg;
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, msg);
        taskInfo.setMsg(msg);
        taskInfo.setState(TaxCalTaskStateEnum.FINISHED);
        if (null == gjrylbList || gjrylbList.isEmpty()) {
            return;
        }
        TaxUnitInfo taxUnit = taskInfo.getTaxUnit();
        try {
            String period = taskInfo.getPeriod();
            int year = Integer.parseInt(period.substring(0, 4)) - 1;
            String taxUnitDeductionId = this.getTaxUnitDeduction(ctx, taxUnit, year);
            HashMap<String, Integer> personMap = new HashMap<String, Integer>();
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            for (Map stringObjectMap : gjrylbList) {
                personMap.put(stringObjectMap.get("zzhm").toString(), "\u662f".equals(stringObjectMap.get("sfkc")) ? 1 : 0);
            }
            String cardNumbers = CmpStrUtil.converMapToString(personMap);
            String sql = "SELECT e.fid, r.fCardNumber FROM t_hr_sTaxPersonRecordEntry e, t_hr_sTaxPersonRecord r WHERE e.fTaxUnitID = '" + taskInfo.getTaxUnit().getId().toString() + "'  and e.fBillId = r.fid  and r.fCardNumber IN (" + cardNumbers + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            Timestamp createTime = new Timestamp(System.currentTimeMillis());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            HashMap<String, Integer> personSet = new HashMap<String, Integer>();
            while (rowSet.next()) {
                Object[] param = new Object[10];
                String taxPersonRecordEntryId = rowSet.getString(1);
                param[0] = taxPersonRecordEntryId;
                Integer isDirect = (Integer)personMap.get(rowSet.getString(2));
                param[1] = isDirect;
                param[2] = taxUnitDeductionId;
                param[3] = userId;
                param[4] = createTime;
                param[5] = userId;
                param[6] = createTime;
                param[7] = BOSUuid.create((String)"F831C6DA").toString();
                param[8] = taskId;
                param[9] = 10;
                personSet.put(taxPersonRecordEntryId, isDirect);
                paramList.add(param);
            }
            String batchSql = "INSERT INTO T_HR_STAXDIRECTDEDUCTION( FTaxPersonRecordEntryId, FISDECDUT, FTAXUNITDEDUCTIONID, FCREATORID, FCREATETIME,  FLASTUPDATEUSERID, FLASTUPDATETIME, FID, FTaskId, fSate)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)batchSql, paramList);
            sql = "UPDATE t_hr_sTaxPersonRecordEntry SET fIsDirect = ? WHERE fid = ?";
            paramList = new ArrayList();
            for (Map.Entry entry : personSet.entrySet()) {
                Object[] param = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(param);
            }
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
            this.sendMsg2Commander(ctx, taskInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_saveStaffCollection error: ", (Throwable)e);
        }
    }

    private String getTaxUnitDeduction(Context ctx, TaxUnitInfo taxUnit, int year) throws BOSException {
        String oql = "select id where taxUnit.id = '" + taxUnit.getId().toString() + "' and year = " + year;
        TaxUnitDeductionCollection collection = TaxUnitDeductionFactory.getLocalInstance((Context)ctx).getTaxUnitDeductionCollection(oql);
        if (null != collection && !collection.isEmpty()) {
            return collection.get(0).getId().toString();
        }
        throw new BOSException("\u6ca1\u6709\u627e\u5230\u7eb3\u7a0e\u5355\u4f4d\u5f52\u96c6\u4fe1\u606f");
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String msg = StringUtils.isEmpty((String)errMsg) ? "\u4eba\u5458\u5f52\u96c6\u5931\u8d25" : errMsg;
        Object[] param = new Object[]{30, msg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        taskInfo.setMsg(msg);
        taskInfo.setState(TaxCalTaskStateEnum.FAIDED);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    protected void sendMsg2Commander(Context ctx, TaxCalTaskInfo taskInfo) {
        try {
            String number = taskInfo.getNumber();
            TaxCalTaskStateEnum state = taskInfo.getState();
            String taxUnitName = taskInfo.getTaxUnit().getName();
            String sendUserID = taskInfo.getCreator().getId().toString();
            String title = "\u83b7\u53d6\u4e0d\u6ee16\u4e07\u4eba\u5458\u540d\u5355\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u5b8c\u6210\uff0c\u8be6\u60c5\u67e5\u770b\u4eba\u5458\u786e\u8ba4\u540d\u5355\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            String msg = taskInfo.getMsg();
            if (state == TaxCalTaskStateEnum.FINISHED) {
                msg = "\u7eb3\u7a0e\u5355\u4f4d[{0}]\u5b58\u5728\u5f85\u786e\u8ba4\u7684\u4eba\u5458\u540d\u5355\uff0c\u8bf7\u8fdb\u5165\u3010\u4e2a\u7a0e\u670d\u52a1-\u4eba\u5458\u62a5\u7a0e\u4fe1\u606f-\u4eba\u5458\u786e\u8ba4\u540d\u5355\u3011\u8fdb\u884c\u786e\u8ba4\u5904\u7406\u3002";
                msg = MessageFormat.format(msg, taxUnitName);
            }
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"PersonCollectService sendMsg2Commander error: ", (Throwable)e);
        }
    }
}

