/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.BankCardStatusEnum;
import com.kingdee.shr.compensation.IdentityStatusEnume;
import com.kingdee.shr.compensation.PersonStatusEnum;
import com.kingdee.shr.compensation.SubmitStatusEnum;
import com.kingdee.shr.compensation.app.entity.Pair;
import com.kingdee.shr.compensation.app.entity.TaxPersonReBackEntity;
import com.kingdee.shr.compensation.app.incomeTax.ITaxPersonRecordEntry;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxUnitRegisterDetailFactory;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonReportService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(PersonReportService.class);
    private static final String PERSON_REPORT = "01";
    private static final String MULTI_REPORT = "0802";

    @Override
    public boolean isData4Resolving(String code) {
        return "0000".equals(code) || MULTI_REPORT.equals(code) || code.startsWith(PERSON_REPORT);
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        Gson gson = new Gson();
        JsonObject JO = null;
        JsonElement JE = (JsonElement)gson.fromJson(response, JsonElement.class);
        if (JE.isJsonObject()) {
            JO = JE.getAsJsonObject();
        }
        if (null == JO) {
            return;
        }
        String code = JO.get("code").getAsString();
        String msg = JO.get("msg").getAsString();
        String taskId = taskInfo.getId().toString();
        if ("0104".equals(code)) {
            this.onFailure(ctx, taskInfo, msg);
            return;
        }
        if (MULTI_REPORT.equals(code)) {
            TaxUnitRegisterDetailFactory.getLocalInstance((Context)ctx).resolveRegisterInfo(response, taskId);
            msg = "\u4efb\u52a1\u5931\u8d25\u3002\u5207\u6362\u6263\u7f34\u4e49\u52a1\u4eba\u5931\u8d25\u3002\u6263\u7f34\u5355\u4f4d\u5b58\u5728\u591a\u4e2a\u62a5\u9a8c\u6237\uff0c\u8bf7\u8fdb\u5165\u7eb3\u7a0e\u5355\u4f4d\u8868\u5355\u9009\u62e9\u767b\u8bb0\u5e8f\u53f7\u540e\u518d\u8fdb\u884c\u62a5\u9001";
            this.onFailure(ctx, taskInfo, msg);
            return;
        }
        ITaxCalTask iTaxCalTask = TaxCalTaskFactory.getLocalInstance((Context)ctx);
        int failSize = 0;
        JsonObject JD = JO.get("data").getAsJsonObject();
        String reString = JD.get("bsjg").toString();
        String acceptId = JD.get("accept_id").getAsString();
        List list = (List)gson.fromJson(reString, List.class);
        CoreBaseCollection entryBaseCollection = new CoreBaseCollection();
        CoreBaseCollection billBaseCollection = new CoreBaseCollection();
        Pair<Map<String, TaxPersonRecordEntryInfo>, Map<String, TaxPersonRecordInfo>> pairMap = this.getPairMap(ctx, taskId);
        for (Map map : list) {
            String json = gson.toJson((Object)map);
            TaxPersonReBackEntity taxPersonReBackEntity = (TaxPersonReBackEntity)gson.fromJson(json, TaxPersonReBackEntity.class);
            String zzhm = taxPersonReBackEntity.getZzhm();
            TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)((Map)pairMap.getFirst()).get(zzhm);
            if (taxPersonRecordEntryInfo != null) {
                SubmitStatusEnum submitStatus = SubmitStatusEnum.getEnum(String.valueOf(taxPersonReBackEntity.getSbzt()));
                if (submitStatus == SubmitStatusEnum.Submiting) {
                    submitStatus = SubmitStatusEnum.SubmitFail;
                }
                taxPersonRecordEntryInfo.setSubmitStatus(submitStatus);
                if (SubmitStatusEnum.HaveSubmit.equals((Object)SubmitStatusEnum.getEnum(String.valueOf(taxPersonReBackEntity.getSbzt())))) {
                    taxPersonRecordEntryInfo.setUpdateTime(new Timestamp(new Date().getTime()));
                } else {
                    ++failSize;
                }
                taxPersonRecordEntryInfo.setIdentityStatus(IdentityStatusEnume.getEnum(String.valueOf(taxPersonReBackEntity.getRzzt())));
                taxPersonRecordEntryInfo.setFailReason(taxPersonReBackEntity.getSbyy());
                taxPersonRecordEntryInfo.setAcceptId(acceptId);
                entryBaseCollection.add((CoreBaseInfo)taxPersonRecordEntryInfo);
            }
            TaxPersonRecordInfo taxPersonRecordInfo = (TaxPersonRecordInfo)((Map)pairMap.getSecond()).get(zzhm);
            if (null == taxPersonRecordEntryInfo) continue;
            taxPersonRecordInfo.setBankCardStatus(BankCardStatusEnum.getEnum(String.valueOf(taxPersonReBackEntity.getYhzhyzzt())));
            billBaseCollection.add((CoreBaseInfo)taxPersonRecordInfo);
        }
        if (failSize > 0) {
            iTaxCalTask.updateStateMsgById(taskId, TaxCalTaskStateEnum.FAIDED, msg);
        } else {
            iTaxCalTask.updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, msg);
        }
        List<Object[]> recordEntryParamsList = this.getParamsList(entryBaseCollection);
        String recordEntrySql = "update T_HR_STaxPersonRecordEntry set FSubmitStatus= ?, FIdentityStatus=?, FAcceptId=?, FailReason=?, FUpdateTime=?, FIsReported=? where fid =?";
        DbUtil.executeBatch((Context)ctx, (String)recordEntrySql, recordEntryParamsList);
        List<Object[]> recordParamsList = this.getParamsList(billBaseCollection);
        String recordSql = "update T_HR_STaxPersonRecord set FBankCardStatus=? where fid =?";
        DbUtil.executeBatch((Context)ctx, (String)recordSql, recordParamsList);
        this.sendMsg2TaskCreator(ctx, taskInfo);
        TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).executeNextTask(taskId);
    }

    private boolean isReported(String submitStatus, PersonStatusEnum personStatus) {
        return "2".equals(submitStatus) && personStatus == PersonStatusEnum.Normal;
    }

    protected void sendMsg2TaskCreator(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String number = taxCalTaskInfo.getNumber();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label115", (Locale)ctx.getLocale());
            title = MessageFormat.format(title, number);
            String msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d\u3010{0}\u3011\u3010{1}\u3011\u62a5\u9001\u5b8c\u6210\uff0c";
            String personMsgTemplate = "\u5458\u5de5{0}-\u3010{1}\u3011";
            String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label107", (Locale)ctx.getLocale());
            String oql = "select person.number,person.name,submitStatus,failReason where taxCalTaskId='" + taxCalTaskInfo.getId().toString() + "'";
            ITaxPersonRecordEntry iTaxPersonRecordEntry = TaxPersonRecordEntryFactory.getLocalInstance((Context)ctx);
            TaxPersonRecordEntryCollection taxRecordEntryCollection = iTaxPersonRecordEntry.getTaxPersonRecordEntryCollection(oql);
            HashSet<String> dupPersonNames = new HashSet<String>();
            ArrayList<String> noSubPersonNames = new ArrayList<String>();
            ArrayList<String> submittingPersonNames = new ArrayList<String>();
            ArrayList<String> sucPersonNames = new ArrayList<String>();
            ArrayList<String> failPersonNames = new ArrayList<String>();
            if (null != taxRecordEntryCollection && taxRecordEntryCollection.size() > 0) {
                PersonInfo personInfo;
                TaxPersonRecordEntryInfo taxPersonRecordEntryInfo;
                ArrayList<String> personNames = new ArrayList<String>();
                int size = taxRecordEntryCollection.size();
                for (int i = 0; i < size; ++i) {
                    taxPersonRecordEntryInfo = taxRecordEntryCollection.get(i);
                    personInfo = taxPersonRecordEntryInfo.getPerson();
                    String personName = personInfo.getName();
                    if (personNames.contains(personName)) {
                        dupPersonNames.add(personName);
                        continue;
                    }
                    personNames.add(personName);
                }
                int size2 = taxRecordEntryCollection.size();
                for (int i = 0; i < size2; ++i) {
                    String failReason;
                    taxPersonRecordEntryInfo = taxRecordEntryCollection.get(i);
                    personInfo = taxPersonRecordEntryInfo.getPerson();
                    String personName = personInfo.getName();
                    if (dupPersonNames.contains(personName)) {
                        String personNumber = personInfo.getNumber();
                        personName = personName + "\uff08" + personNumber + "\uff09";
                    }
                    SubmitStatusEnum submitStatus = taxPersonRecordEntryInfo.getSubmitStatus();
                    String string = failReason = null == taxPersonRecordEntryInfo.getFailReason() ? "" : "," + taxPersonRecordEntryInfo.getFailReason();
                    if ("2".equals(submitStatus.getValue())) {
                        sucPersonNames.add(personName);
                        continue;
                    }
                    if ("0".equals(submitStatus.getValue())) {
                        noSubPersonNames.add(MessageFormat.format(personMsgTemplate, personName, SubmitStatusEnum.NotSubmit.getAlias() + failReason));
                        continue;
                    }
                    if ("1".equals(submitStatus.getValue())) {
                        submittingPersonNames.add(MessageFormat.format(personMsgTemplate, personName, SubmitStatusEnum.Submiting.getAlias() + failReason));
                        continue;
                    }
                    failPersonNames.add(MessageFormat.format(personMsgTemplate, personName, SubmitStatusEnum.SubmitFail.getAlias() + failReason));
                }
            }
            StringBuilder msg = new StringBuilder();
            msg.append(MessageFormat.format(msgTemplate, taxUnitName, period));
            if (sucPersonNames.size() > 0) {
                msg.append(MessageFormat.format(personMsgTemplate, ((Object)sucPersonNames).toString().replace("[", "\u3010").replace("]", "\u3011"), SubmitStatusEnum.HaveSubmit.getAlias()));
            }
            if (noSubPersonNames.size() > 0) {
                msg.append(", ").append(((Object)noSubPersonNames).toString().replace("[", "").replace("]", ""));
            }
            if (submittingPersonNames.size() > 0) {
                msg.append(", ").append(((Object)submittingPersonNames).toString().replace("[", "").replace("]", ""));
            }
            if (failPersonNames.size() > 0) {
                msg.append(", ").append(((Object)failPersonNames).toString().replace("[", "").replace("]", ""));
            }
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, title, msg.toString(), category);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected List<Object[]> getParamsList(CoreBaseCollection coreBaseCollection) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String acceptId = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = null;
        for (int i = 0; i < coreBaseCollection.size(); ++i) {
            String id;
            Object[] object;
            CoreBaseInfo coreBaseInfo = coreBaseCollection.get(i);
            if (coreBaseInfo instanceof TaxPersonRecordEntryInfo) {
                object = new Object[7];
                TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)coreBaseInfo;
                String submitStatus = taxPersonRecordEntryInfo.getSubmitStatus().getValue();
                String identityStatus = taxPersonRecordEntryInfo.getIdentityStatus().getValue();
                if (!StringUtils.isEmpty((String)taxPersonRecordEntryInfo.getAcceptId())) {
                    acceptId = taxPersonRecordEntryInfo.getAcceptId();
                }
                String failReason = !StringUtils.isEmpty((String)taxPersonRecordEntryInfo.getFailReason()) ? taxPersonRecordEntryInfo.getFailReason() : null;
                Timestamp updateTime = taxPersonRecordEntryInfo.getUpdateTime();
                if (null != updateTime) {
                    time = sdf.format(updateTime);
                }
                id = taxPersonRecordEntryInfo.getId().toString();
                object[0] = submitStatus;
                object[1] = identityStatus;
                object[2] = acceptId;
                object[3] = failReason;
                object[4] = CmpDateUtil.toSqlDate(time);
                object[5] = this.isReported(submitStatus, taxPersonRecordEntryInfo.getPersonStatus());
                object[6] = id;
                paramsList.add(object);
            }
            if (!(coreBaseInfo instanceof TaxPersonRecordInfo)) continue;
            object = new Object[2];
            TaxPersonRecordInfo taxPersonRecordInfo = (TaxPersonRecordInfo)coreBaseInfo;
            String bankCardStatus = taxPersonRecordInfo.getBankCardStatus().getValue();
            id = taxPersonRecordInfo.getId().toString();
            object[0] = bankCardStatus;
            object[1] = id;
            paramsList.add(object);
        }
        return paramsList;
    }

    protected Pair<Map<String, TaxPersonRecordEntryInfo>, Map<String, TaxPersonRecordInfo>> getPairMap(Context ctx, String taskId) throws BOSException {
        String oql = "select *,bill.*,bill.person.*,bill.nationality.*,bill.position.*,bill.birthPlace.*,bill.eduLevel.*,taxUnit.id,taxUnit.taxNumber,taxUnit.areaCode,taxUnit.regNumber,taxUnit.declPassword,taxUnit.realPassword where taxCalTaskId='" + taskId + "'";
        ITaxPersonRecordEntry iTaxPersonRecordEntry = TaxPersonRecordEntryFactory.getLocalInstance((Context)ctx);
        TaxPersonRecordEntryCollection taxRecordEntryCollection = iTaxPersonRecordEntry.getTaxPersonRecordEntryCollection(oql);
        Pair pair = new Pair();
        HashMap<String, TaxPersonRecordEntryInfo> entryMap = new HashMap<String, TaxPersonRecordEntryInfo>();
        HashMap<String, TaxPersonRecordInfo> recordMap = new HashMap<String, TaxPersonRecordInfo>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (int i = 0; i < taxRecordEntryCollection.size(); ++i) {
            TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = taxRecordEntryCollection.get(i);
            TaxPersonRecordInfo bill = taxPersonRecordEntryInfo.getBill();
            String cardNumber = bill.getCardNumber();
            entryMap.put(cardNumber, taxPersonRecordEntryInfo);
            if (billIdSet.contains(bill.getId().toString())) continue;
            recordMap.put(cardNumber, bill);
            billIdSet.add(bill.getId().toString());
        }
        pair.setFirst(entryMap);
        pair.setSecond(recordMap);
        return pair;
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String taskId = taskInfo.getId().toString();
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FAIDED, errMsg);
        Pair<Map<String, TaxPersonRecordEntryInfo>, Map<String, TaxPersonRecordInfo>> pairMap = this.getPairMap(ctx, taskId);
        Map entryMap = (Map)pairMap.getFirst();
        this.updateFailSubmit(ctx, entryMap, errMsg);
        this.sendMsg2TaskCreator(ctx, taskInfo);
        TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).executeNextTask(taskId);
    }

    protected void updateFailSubmit(Context ctx, Map<String, TaxPersonRecordEntryInfo> entryMap, String errMsg) throws BOSException {
        CoreBaseCollection entryBaseCollection = new CoreBaseCollection();
        Set<Map.Entry<String, TaxPersonRecordEntryInfo>> entrySet = entryMap.entrySet();
        for (Map.Entry<String, TaxPersonRecordEntryInfo> entry : entrySet) {
            entryBaseCollection.add((CoreBaseInfo)entry.getValue());
        }
        List<Object[]> failParamsList = this.getFailParamsList(entryBaseCollection, errMsg);
        String recordEntrySql = "update T_HR_STaxPersonRecordEntry set FSubmitStatus= ?, FailReason = ? where fid =?";
        DbUtil.executeBatch((Context)ctx, (String)recordEntrySql, failParamsList);
        logger.info((Object)("--------->>>>>\u66f4\u65b0\u62a5\u9001\u72b6\u6001\u3001\u9a8c\u8bc1\u72b6\u6001\uff1arecordEntrySql:" + recordEntrySql + "------>>>>failParamsList:" + failParamsList));
    }

    protected List<Object[]> getFailParamsList(CoreBaseCollection coreBaseCollection, String errMsg) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String submitFail = SubmitStatusEnum.SubmitFail.getValue();
        for (int i = 0; i < coreBaseCollection.size(); ++i) {
            CoreBaseInfo coreBaseInfo = coreBaseCollection.get(i);
            Object[] object = new Object[3];
            TaxPersonRecordEntryInfo taxPersonRecordEntryInfo = (TaxPersonRecordEntryInfo)coreBaseInfo;
            String id = taxPersonRecordEntryInfo.getId().toString();
            object[0] = submitFail;
            object[1] = errMsg;
            object[2] = id;
            paramsList.add(object);
        }
        return paramsList;
    }
}

