/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.incomeTax.ReductionSummaryFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTaskDetail;
import com.kingdee.shr.compensation.app.taxCal.TaxCalForJSFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskDetailInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.ResponseVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.taxCal.analysis.CombineDataForResult;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TaxCalService
implements ITaxTaskService {
    private static final Logger logger = Logger.getLogger(TaxCalService.class);

    @Override
    public boolean isData4Resolving(String code) {
        return "0000".equals(code) || "0251".equals(code) || "0208".equals(code) || "0271".equals(code);
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        ResponseVO responseVO = (ResponseVO)JSON.parseObject((String)response, ResponseVO.class);
        String msg = responseVO.getMsg();
        String taskId = taskInfo.getId().toString();
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, TaxCalTaskStateEnum.FINISHED, StringUtils.isEmpty((String)msg) ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label155", (Locale)ctx.getLocale()) : msg);
        CombineDataForResult resultHandler = new CombineDataForResult();
        resultHandler.execute(ctx, taskId, response);
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSQL = "update T_HR_STaxCalTask set FState = ? , FMsg = ? where fid = ?";
        String taskId = taskInfo.getId().toString();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((String)errMsg) ? "\u7a0e\u6b3e\u8ba1\u7b97\u5931\u8d25" : errMsg, taskId};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramList);
        this.updateRelatedData(ctx, taskId);
        TaxCalForJSFacadeFactory.getLocalInstance((Context)ctx).executeNextTask(taskId);
        this.updateStatus(ctx, taskId);
        this.sendMsg2TaskCreator(ctx, taskInfo);
    }

    protected void updateRelatedData(Context ctx, String taskId) throws BOSException {
        TaxCalTaskInfo taskInfo;
        try {
            taskInfo = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaxCalTaskInfo("where id = '" + taskId + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        String str = " SELECT A01.FID  FROM T_HR_STAXCALINITDETAIL A01  WHERE EXISTS(SELECT 1 FROM T_HR_STAXCALTASKDETAIL A02 WHERE FCALTASKID = '" + taskId + "'  AND A01.fTaxUnitId = A02.fTaxUnitId AND A01.FPERSONID = A02.FPERSONID AND A01.FINCOMEITEMID = A02.FINCOMEITEMID  AND A01.FPERIODBEGIN = A02.FPERIODBEGIN)  AND A01.FTAXUNITID = '" + taskInfo.getTaxUnit().getId().toString() + "' AND A01.FSTATE = " + 30 + " AND NOT EXISTS(SELECT 1 FROM T_HR_STAXCALTASKDETAIL A03  WHERE A01.FCMPCALTABLEID = A03.FCMPCALTABLEID and A01.fIncomeItemId = A03.fIncomeItemId AND A03.FDataState = " + 10 + ")";
        String updateSql = "update T_HR_STaxCalInitDetail set FSTATE = 50 where FID in (" + str + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void updateStatus(Context ctx, String taskId) throws BOSException {
        Object[] param;
        String oql = "select cmpCalTable.id, person.id, taxUnit.id, incomeItem.id, periodBegin  where calTask.id = '" + taskId + "'";
        TaxCalTaskDetailCollection collection = TaxCalTaskDetailFactory.getLocalInstance((Context)ctx).getTaxCalTaskDetailCollection(oql);
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Timestamp updateTime = new Timestamp(System.currentTimeMillis());
        ArrayList<Object[]> initParams = new ArrayList<Object[]>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < collection.size(); ++i) {
            TaxCalTaskDetailInfo detail = collection.get(i);
            Object[] initParam = new Object[2];
            param = new Object[]{-1, updateTime, detail.getPerson().getId().toString(), detail.getTaxUnit().getId().toString(), detail.getPeriodBegin(), detail.getIncomeItem().getId().toString()};
            params.add(param);
            initParam[0] = detail.getCmpCalTable().getId().toString();
            initParam[1] = detail.getIncomeItem().getId().toString();
            initParams.add(initParam);
        }
        String updateSQL = "update T_HR_STaxCalInitDetail set fState = 50 where FCmpCalTableId = ? and fIncomeItemId = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, initParams);
        updateSQL = "update t_hr_sReductionItem set FStatus = ?, fLastUpdateTime = ? where FPersonId = ? and FTaxUnitId = ? and FPeriodDate = ? and FIncomeItemId = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
        updateSQL = "update t_hr_sCommInsuranceItem set FStatus = ?, fLastUpdateTime = ? where FPersonId = ? and FTaxUnitId = ? and FPeriodDate = ?";
        params = new ArrayList();
        for (int i = 0; i < collection.size(); ++i) {
            TaxCalTaskDetailInfo detail = collection.get(i);
            param = new Object[]{-1, updateTime, detail.getPerson().getId().toString(), detail.getTaxUnit().getId().toString(), detail.getPeriodBegin()};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
        updateSQL = "update t_hr_sTaxDelayInsuranceItem set FStatus = ?, fLastUpdateTime = ? where FPersonId = ? and FTaxUnitId = ? and FPeriodDate = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
        ReductionSummaryFacadeFactory.getLocalInstance((Context)ctx).updateStatusByTaskId(taskId);
    }

    public void sendMsg2TaskCreator(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String number = taxCalTaskInfo.getNumber();
            String state = taxCalTaskInfo.getState().getAlias();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            TaxCalTaskCatalogEnum catalog = taxCalTaskInfo.getCatalog();
            String title = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label113", (Locale)ctx.getLocale());
            String msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d\u3010{0}\u3011\u3010{1}\u3011\u4e2a\u7a0e\u8ba1\u7b97\u5b8c\u6210\uff0c\u5458\u5de5{2}-\u3010{3}\u3011";
            if (catalog == TaxCalTaskCatalogEnum.TaxCalDelete) {
                title = "\u521d\u7b97\u6570\u636e\u5df2\u5220\u9664\uff0c\u53ef\u8fdb\u5165[\u85aa\u916c\u6838\u7b97\u5411\u5bfc-\u6838\u7b97\u6570\u636e\u63d0\u4ea4]\u4e2d\uff0c\u91cd\u65b0\u63d0\u4ea4\u521d\u7b97\u660e\u7ec6\u6570\u636e";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d\u3010{0}\u3011\u3010{1}\u3011\u5220\u9664\u7b97\u7a0e\u5b8c\u6210\uff0c\u5458\u5de5{2}-\u3010{3}\u3011";
            }
            title = MessageFormat.format(title, number);
            String category = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label107", (Locale)ctx.getLocale());
            ITaxCalTaskDetail taxCalTaskDetail = TaxCalTaskDetailFactory.getLocalInstance((Context)ctx);
            String getDetailOQL = "select person.number,person.name,incomeItem.name where calTask = '" + taxCalTaskInfo.getId().toString() + "'";
            TaxCalTaskDetailCollection taxCalTaskDetailCollection = taxCalTaskDetail.getTaxCalTaskDetailCollection(getDetailOQL);
            HashSet<String> dupPersonNames = new HashSet<String>();
            ArrayList<String> personNames = new ArrayList<String>();
            int max = 5;
            if (null != taxCalTaskDetailCollection && taxCalTaskDetailCollection.size() > 0) {
                String personName;
                PersonInfo personInfo;
                TaxCalTaskDetailInfo taxCalTaskDetailInfo;
                int i;
                personNames = new ArrayList();
                int size = taxCalTaskDetailCollection.size();
                for (i = 0; i < size; ++i) {
                    taxCalTaskDetailInfo = taxCalTaskDetailCollection.get(i);
                    personInfo = taxCalTaskDetailInfo.getPerson();
                    personName = personInfo.getName();
                    if (personNames.contains(personName)) {
                        dupPersonNames.add(personName);
                        continue;
                    }
                    personNames.add(personName);
                }
                personNames = new ArrayList();
                size = taxCalTaskDetailCollection.size();
                for (i = 0; i < size; ++i) {
                    taxCalTaskDetailInfo = taxCalTaskDetailCollection.get(i);
                    if (i == max) break;
                    personInfo = taxCalTaskDetailInfo.getPerson();
                    personName = personInfo.getName();
                    if (dupPersonNames.contains(personName)) {
                        String personNumber = personInfo.getNumber();
                        personName = personName + "\uff08" + personNumber + "\uff09";
                    }
                    personNames.add(personName);
                }
            }
            String persons = ((Object)personNames).toString().replace("[", "\u3010").replace("]", "\u3011");
            if (null != taxCalTaskDetailCollection && taxCalTaskDetailCollection.size() > max) {
                persons = persons + "...";
            }
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, persons, state);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, title, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

