/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CmpCommonUtil {
    public static boolean isNullOrEmpty(Object ... objs) {
        boolean flag = false;
        if (null == objs || objs.length == 0) {
            return true;
        }
        for (Object o : objs) {
            if (null == o) {
                return true;
            }
            if (o instanceof String && ((String)o).trim().length() == 0) {
                return true;
            }
            if (o instanceof Integer && CmpCommonUtil.toInt(o) == 0) {
                return true;
            }
            if (o instanceof BigDecimal && new BigDecimal(0).equals(CmpCommonUtil.toBigDecimal(o))) {
                return true;
            }
            if (o instanceof Collection && ((Collection)o).size() == 0) {
                return true;
            }
            if (o instanceof Set && ((Set)o).size() == 0) {
                return true;
            }
            if (o instanceof List && ((List)o).size() == 0) {
                return true;
            }
            if (o instanceof IObjectCollection && ((IObjectCollection)o).size() == 0) {
                return true;
            }
            if (!(o instanceof Map) || ((Map)o).size() != 0) continue;
            return true;
        }
        return flag;
    }

    public static Object getEnumItem(String enumSource, String value) {
        try {
            return MetaDataUtil.findEnumByValue((String)enumSource, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Integer toInt(Object obj) {
        Integer res = 0;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str).intValue();
            }
            catch (Exception e5) {
                res = 0;
            }
        }
        return res;
    }

    public static Long toLong(Object obj) {
        Long res = 0L;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str).longValue();
            }
            catch (Exception e5) {
                res = 0L;
            }
        }
        return res;
    }

    public static String toSqlDate(Date date) {
        String res = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            res = "{ts'" + sdf.format(date) + "'}";
        }
        catch (Exception e5) {
            return null;
        }
        return res;
    }

    public static java.sql.Date toSqlDate4UtilDate(Date date) {
        if (null == date) {
            return null;
        }
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        return sqlDate;
    }

    public static String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Date || obj instanceof java.sql.Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(obj);
            }
            return String.valueOf(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Timestamp toTimestamp(Object obj) {
        Object res = null;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS", Locale.ENGLISH);
                dateFormat.setLenient(false);
                Date timeDate = dateFormat.parse(str);
                Timestamp dateTime = new Timestamp(timeDate.getTime());
                return dateTime;
            }
            catch (Exception e5) {
                res = null;
            }
        }
        return res;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal res = new BigDecimal(0);
        if (obj == null) {
            return null;
        }
        String str = String.valueOf(obj);
        if ("0E-10".equalsIgnoreCase(str)) {
            return res;
        }
        if (!StringUtils.isEmpty((String)str)) {
            try {
                res = new BigDecimal(str);
            }
            catch (Exception e) {
                res = new BigDecimal(0);
            }
        }
        return res;
    }

    public static Boolean toBoolean(Object obj) {
        boolean res = false;
        if (obj == null) {
            return res;
        }
        String str = String.valueOf(obj);
        if (!StringUtils.isEmpty((String)str)) {
            if ("null".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "0".equalsIgnoreCase(str) || "-1".equalsIgnoreCase(str) || "undefind".equalsIgnoreCase(str) || "[]".equalsIgnoreCase(str) || "[[]]".equalsIgnoreCase(str) || "{}".equalsIgnoreCase(str) || "".equalsIgnoreCase(str)) {
                return res;
            }
            return true;
        }
        return res;
    }

    public Double toDouble(Object obj) {
        Double res = CmpCommonUtil.toBigDecimal(obj).doubleValue();
        return res;
    }

    public static String toDoubleString(Object obj) {
        if (null == obj) {
            return null;
        }
        String res = "0";
        String str = String.valueOf(obj);
        if (str.equalsIgnoreCase("0E-10") || str.equalsIgnoreCase("0")) {
            return res;
        }
        Double d = CmpCommonUtil.toBigDecimal(str).doubleValue();
        res = String.valueOf(d);
        if (res.endsWith(".0")) {
            res = res.substring(0, res.length() - 2);
        } else if (res.endsWith(".00")) {
            res = res.substring(0, res.length() - 3);
        }
        return res;
    }

    @Deprecated
    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
}

