/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.PayerTypeEnum;
import com.kingdee.shr.compensation.util.EncryptProcessor;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CmpExcelUtil {
    private static Logger logger = Logger.getLogger(CmpExcelUtil.class);

    public static Object getCellValue(Cell cell) {
        Object value = "";
        if (cell == null) {
            return value;
        }
        switch (cell.getCellType()) {
            case BLANK: {
                value = "";
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                value = "";
                break;
            }
            case FORMULA: {
                Workbook wb = cell.getSheet().getWorkbook();
                CreationHelper createHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = createHelper.createFormulaEvaluator();
                value = CmpExcelUtil.getCellValue(evaluator.evaluateInCell(cell));
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().getString() == null ? "" : cell.getRichStringCellValue().getString().trim();
                if (!(value instanceof String) || !value.toString().matches("^\\d{8}\\-{2}$")) break;
                value = value.toString().substring(0, 4) + "-" + value.toString().substring(4, 6) + "-" + value.toString().substring(6, 8);
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    public static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        DataFormat textFormat = wb.createDataFormat();
        short textFt = textFormat.getFormat("text");
        DataFormat dateFormat = wb.createDataFormat();
        short dateFt = dateFormat.getFormat("yyyy-mm-dd");
        DataFormat percentFormat = wb.createDataFormat();
        short percentFt = percentFormat.getFormat("0.00%");
        CellStyle head = wb.createCellStyle();
        head.setAlignment(HorizontalAlignment.CENTER);
        head.setVerticalAlignment(VerticalAlignment.CENTER);
        head.setFillForegroundColor(IndexedColors.WHITE.index);
        Font font = wb.createFont();
        font.setBold(true);
        head.setFont(font);
        styles.put("head", head);
        CellStyle red = wb.createCellStyle();
        red.setFont(redFont);
        styles.put("red", red);
        CellStyle bodyText = wb.createCellStyle();
        bodyText.setDataFormat(textFt);
        styles.put("bodyText", bodyText);
        CellStyle bodyDate = wb.createCellStyle();
        bodyDate.setDataFormat(dateFt);
        styles.put("bodyDate", bodyDate);
        CellStyle bodyPercent = wb.createCellStyle();
        bodyPercent.setDataFormat(percentFt);
        styles.put("bodyPercent", bodyPercent);
        CellStyle bgGreen = wb.createCellStyle();
        bgGreen.setBorderRight(BorderStyle.THIN);
        bgGreen.setBorderBottom(BorderStyle.THIN);
        bgGreen.setBorderLeft(BorderStyle.THIN);
        bgGreen.setFillForegroundColor(IndexedColors.GREEN.getIndex());
        bgGreen.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styles.put("bgGreen", bgGreen);
        CellStyle bgRed = wb.createCellStyle();
        bgRed.setBorderRight(BorderStyle.THIN);
        bgRed.setBorderBottom(BorderStyle.THIN);
        bgRed.setBorderLeft(BorderStyle.THIN);
        bgRed.setFillForegroundColor(IndexedColors.RED.getIndex());
        bgRed.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styles.put("bgRed", bgRed);
        CellStyle vCenter = wb.createCellStyle();
        vCenter.setVerticalAlignment(VerticalAlignment.CENTER);
        styles.put("vCenter", vCenter);
        CellStyle mustInputHead = wb.createCellStyle();
        mustInputHead.setAlignment(HorizontalAlignment.CENTER);
        mustInputHead.setVerticalAlignment(VerticalAlignment.CENTER);
        mustInputHead.setFillForegroundColor(IndexedColors.WHITE.index);
        mustInputHead.setFillForegroundColor(IndexedColors.WHITE.index);
        Font font2 = wb.createFont();
        font2.setBold(true);
        font2.setColor(IndexedColors.BROWN.index);
        mustInputHead.setFont(font2);
        styles.put("mustInputHead", mustInputHead);
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeData2Template(List<List<Object>> rowList, String template, int startRow, String fileName, Map<String, String> params) {
        XSSFWorkbook innerWorkbook = null;
        OutputStream os = null;
        FileInputStream in = null;
        File outFile = new File(fileName);
        File tempFile = new File(template);
        try {
            outFile.createNewFile();
            in = new FileInputStream(tempFile);
            innerWorkbook = new XSSFWorkbook((InputStream)in);
            XSSFSheet sheet = innerWorkbook.getSheetAt(0);
            XSSFDataFormat format = innerWorkbook.createDataFormat();
            XSSFCellStyle textStyle = innerWorkbook.createCellStyle();
            textStyle.setDataFormat(format.getFormat("@"));
            XSSFCellStyle cellStyle = innerWorkbook.createCellStyle();
            XSSFCellStyle cellStyle1 = innerWorkbook.createCellStyle();
            CmpExcelUtil.setContentStyle(innerWorkbook, (CellStyle)cellStyle);
            CmpExcelUtil.setTitleStyle(innerWorkbook, (CellStyle)cellStyle1);
            Row row2 = sheet.getRow(1);
            Cell cell21 = row2.getCell(0);
            String content1 = cell21.getStringCellValue();
            String val1 = String.format(content1, params.get("startAndEnd"));
            cell21.setCellValue(val1);
            cell21.setCellStyle((CellStyle)cellStyle1);
            Row row3 = sheet.getRow(2);
            Cell cell31 = row3.getCell(0);
            String content2 = cell31.getStringCellValue();
            String val2 = String.format(content2, params.get("taxUnitName"));
            cell31.setCellValue(val2);
            cell31.setCellStyle((CellStyle)cellStyle1);
            Row row4 = sheet.getRow(3);
            Cell cell41 = row4.getCell(0);
            String content3 = cell41.getStringCellValue();
            String val3 = String.format(content3, params.get("taxUnitNumber"));
            cell41.setCellValue(val3);
            cell41.setCellStyle((CellStyle)cellStyle1);
            for (List<Object> data : rowList) {
                Row row = sheet.createRow(startRow);
                for (int i = 0; i < data.size(); ++i) {
                    Object val = data.get(i);
                    Cell cell = row.createCell(i);
                    cell.setCellStyle((CellStyle)cellStyle);
                    if (i == 5) {
                        val = CmpExcelUtil.convert(val);
                    }
                    if (i == 2) {
                        val = CmpExcelUtil.convertCardType(val);
                    }
                    if (null == val) continue;
                    if (val instanceof String) {
                        cell.setCellValue(val.toString());
                        cell.setCellStyle((CellStyle)textStyle);
                        continue;
                    }
                    if (val instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)val;
                        cell.setCellValue(bigDecimal.doubleValue());
                        continue;
                    }
                    if (val instanceof Integer) {
                        Integer integer = (Integer)val;
                        cell.setCellValue((double)integer.intValue());
                        continue;
                    }
                    cell.setCellStyle((CellStyle)textStyle);
                    cell.setCellValue(String.valueOf(val));
                }
                ++startRow;
            }
            os = new FileOutputStream(outFile);
            String psw = params.get("psw");
            if (StringUtils.isEmpty((String)psw)) {
                innerWorkbook.write(os);
            } else {
                EncryptProcessor.encryptExcel((Workbook)innerWorkbook, psw, os);
            }
        }
        catch (Exception e) {
            logger.error((Object)"writeData2Template error: ", (Throwable)e);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error((Object)"writeData2Template error: ", (Throwable)e);
                }
            }
            if (null != innerWorkbook) {
                try {
                    innerWorkbook.close();
                }
                catch (IOException e) {
                    logger.error((Object)"writeData2Template error: ", (Throwable)e);
                }
            }
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)"writeData2Template error: ", (Throwable)e);
                }
            }
        }
    }

    private static Object convertCardType(Object val) {
        if (null == val) {
            return "";
        }
        String value = (String)val;
        CardTypeEnum cardTypeEnum = CardTypeEnum.getEnum(value);
        return null == cardTypeEnum ? "" : cardTypeEnum.getAlias();
    }

    private static void setContentStyle(XSSFWorkbook innerWorkbook, CellStyle cellStyle) {
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = innerWorkbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)8);
        font.setBold(false);
        cellStyle.setFont((Font)font);
    }

    private static void setTitleStyle(XSSFWorkbook innerWorkbook, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFFont font = innerWorkbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)7);
        font.setBold(false);
        cellStyle.setFont((Font)font);
    }

    private static String convert(Object val) {
        if (null == val) {
            return "";
        }
        String value = (String)val;
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getEnum(value);
        return null == payerTypeEnum ? "" : payerTypeEnum.getAlias();
    }
}

