/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.columnModel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CmpColumnModelWrapper {
    private Context ctx;
    private Map<String, Object> gridMap = new HashMap<String, Object>();
    private WidgetType widgetType;

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    private WidgetType getWidgetType() {
        return this.widgetType;
    }

    private void setWidgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
    }

    public void putGridMap(String key, Object value) {
        this.gridMap.put(key, value);
    }

    public static CmpColumnModelWrapper createEmptyColModel() {
        return new CmpColumnModelWrapper();
    }

    public static CmpColumnModelWrapper createCommonColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = new CmpColumnModelWrapper();
        wraper.putGridMap("name", name);
        wraper.putGridMap("label", label);
        wraper.putGridMap("frozen", false);
        wraper.putGridMap("width", width == null ? 90 : width);
        wraper.putGridMap("align", "left");
        wraper.putGridMap("key", false);
        wraper.putGridMap("hidden", false);
        wraper.putGridMap("editable", true);
        wraper.putGridMap("sortable", false);
        return wraper;
    }

    public static CmpColumnModelWrapper createDecimalColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.DECIMAL);
        wraper.putGridMap("sorttype", "bigdecimal");
        wraper.putGridMap("edittype", "numberfield");
        wraper.putGridMap("formatter", "numberfield");
        return wraper;
    }

    public static CmpColumnModelWrapper createTextColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.TEXT);
        wraper.putGridMap("sorttype", "string");
        wraper.putGridMap("edittype", "shrtext");
        return wraper;
    }

    public static CmpColumnModelWrapper createDateColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.DATE);
        wraper.putGridMap("sorttype", "date");
        wraper.putGridMap("formatter", "shrDateTimePicker");
        wraper.putGridMap("edittype", "shrDateTimePicker");
        return wraper;
    }

    public static CmpColumnModelWrapper createBooleanColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.BOOLEAN);
        wraper.putGridMap("sorttype", "boolean");
        wraper.putGridMap("formatter", "wafcheckbox");
        return wraper;
    }

    public static CmpColumnModelWrapper createMultiLanColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.MULTILAN);
        wraper.putGridMap("formatter", "shrMultiLangBox");
        wraper.putGridMap("edittype", "shrMultiLangBox");
        return wraper;
    }

    public static CmpColumnModelWrapper createF7ColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.F7);
        wraper.putGridMap("edittype", "promptBox");
        wraper.putGridMap("sorttype", "objectvalue");
        wraper.putGridMap("formatter", "promptBox");
        return wraper;
    }

    public static CmpColumnModelWrapper createSelectColModel(String name, String label, Integer width) {
        CmpColumnModelWrapper wraper = CmpColumnModelWrapper.createCommonColModel(name, label, width);
        wraper.setWidgetType(WidgetType.SELECT);
        wraper.putGridMap("edittype", "shrselect");
        wraper.putGridMap("sorttype", "enum");
        wraper.putGridMap("formatter", "shrselect");
        wraper.putGridMap("autoFillSelect", false);
        return wraper;
    }

    public CmpColumnModelWrapper assembleDecimalInputEditOptions(boolean isRequired, int dataDot, int dataLength) {
        if (WidgetType.DECIMAL != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        JSONObject editoptions = JSON.parseObject((String)"{ \"inputJson\": { \"id\": \"txt_money\", \"name\": \"money\", \"formatType\": \"number\" }, \"validateJson\": {}}");
        editoptions.put("validateJson", (Object)JSON.parseObject((String)("{ \"errMsg\": \"\", \"rules\": \"required:" + (isRequired ? "true" : "false") + "\", \"validatetrigger\": \"focus keyup datachange\" }")));
        JSONObject inputJson = editoptions.getJSONObject("inputJson");
        inputJson.put("decimalPrecision", (Object)dataDot);
        inputJson.put("maxlength", (Object)dataLength);
        this.gridMap.put("editoptions", editoptions);
        return this;
    }

    public CmpColumnModelWrapper assembleDateEditoptions(boolean isRequired, boolean isRemoveDay) {
        if (WidgetType.DATE != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        String editOptionsBuilder = "{\"datepickerjson\":{\"id\":\"dp_autoSize\",\"name\":\"dp_autoSize\",\"minuteStep\":\"\",\"showTimeZoneForCtrl\":false,\"isAutoTimeZoneTrans\":false,\"isShowUTC\":false,\"isReadonlyUTC\":true,\"isRemoveSeconds\":true,\"isRemoveDay\":" + (isRemoveDay ? "true" : "false") + ",\"ctrlType\":\"Date\"},\"validateJson\":{\"errMsg\":\"\",\"rules\":\"required: " + (isRequired ? "true" : "false") + "\",\"validatetrigger\":\"focus keyup datachange\"}}";
        this.gridMap.put("editoptions", JSON.parseObject((String)editOptionsBuilder));
        return this;
    }

    public CmpColumnModelWrapper assembleSelectEditOptions(String name, String enumSource, boolean isRequired) {
        if (WidgetType.SELECT != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        String editoptions = "{ selectJson: {\tid: \"" + name + "\",\tenumSource: \"" + enumSource + "\"},validateJson : {\tvalidatetrigger: \"focus keyup datachange\", \terrMsg: \"\", \trules: \"required: " + (isRequired ? "true" : " false") + "\"},enumSource: {},urlSource: \"/shr/selectEnum.do?method=getSelectEnumData&enumSource=" + enumSource + "\"}";
        this.gridMap.put("editoptions", JSON.parseObject((String)editoptions));
        return this;
    }

    public CmpColumnModelWrapper assembleTextInputEditOptions(boolean isRequired, int dataLength) {
        if (WidgetType.TEXT != this.getWidgetType() && WidgetType.MULTILAN != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        JSONObject editoptions = JSON.parseObject((String)"{ \"inputJson\": {  } }");
        editoptions.put("validateJson", (Object)JSON.parseObject((String)("{ \"errMsg\": \"\", \"rules\": \"required:" + (isRequired ? "true" : "false") + "\", \"validatetrigger\": \"focus keyup datachange\" }")));
        JSONObject inputJson = editoptions.getJSONObject("inputJson");
        inputJson.put("maxlength", (Object)dataLength);
        this.gridMap.put("editoptions", editoptions);
        return this;
    }

    public CmpColumnModelWrapper assembleF7Editoptions(String title, String uipk, boolean isRequired, boolean isBisicItem) {
        return this.assembleF7Editoptions(title, uipk, isRequired, "", isBisicItem);
    }

    public CmpColumnModelWrapper assembleF7Editoptions(String title, String uipk, boolean isRequired, String f7Filter, boolean isBasicItem) {
        if (WidgetType.F7 != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        HashMap editoptionsMap = Maps.newHashMap();
        HashMap f7JsonMap = Maps.newHashMap();
        f7JsonMap.put("subWidgetName", isBasicItem ? "specialPromptGrid" : "shrPromptGrid");
        f7JsonMap.put("searchFields", "");
        f7JsonMap.put("isHROrg", false);
        f7JsonMap.put("isAdminOrg", false);
        f7JsonMap.put("searchLikePattern", "any");
        HashMap uipkMap = Maps.newHashMap();
        uipkMap.put("title", title);
        uipkMap.put("uipk", uipk);
        uipkMap.put("query", "");
        uipkMap.put("filter", f7Filter);
        uipkMap.put("multiselect", false);
        uipkMap.put("isTree", false);
        uipkMap.put("treeUrl", "");
        uipkMap.put("isContainLowerOrg", false);
        uipkMap.put("isAdminOrg", false);
        uipkMap.put("isEnableExpFilter", true);
        if (isBasicItem) {
            uipkMap.put("isHRBaseItem", true);
            uipkMap.put("f7ReKeyValue", "BaseInfo.id:BaseInfo.name");
            ArrayList filterConfig = Lists.newArrayList();
            HashMap fil = Maps.newHashMap();
            fil.put("name", "isComUse");
            fil.put("value", true);
            String alias = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"isComUse", (Locale)this.ctx.getLocale());
            fil.put("alias", alias);
            fil.put("widgetType", "checkbox");
            filterConfig.add(fil);
            uipkMap.put("filterConfig", filterConfig);
            uipkMap.put("bizFilterFields", "hrOrgUnit");
        }
        f7JsonMap.put("subWidgetOptions", uipkMap);
        HashMap validateJsonMap = Maps.newHashMap();
        validateJsonMap.put("errMsg", "");
        if (isRequired) {
            validateJsonMap.put("rules", "required:true");
        }
        validateJsonMap.put("validatetrigger", "focus keyup datachange");
        editoptionsMap.put("f7Json", f7JsonMap);
        editoptionsMap.put("validateJson", validateJsonMap);
        this.gridMap.put("editoptions", editoptionsMap);
        return this;
    }

    public CmpColumnModelWrapper assembleF7Editoptions(String title, String uipk, boolean isRequired, String f7Filter, boolean isBasicItem, Map<String, Object> otherParamsMap) {
        if (WidgetType.F7 != this.getWidgetType()) {
            return this;
        }
        if (isRequired) {
            this.required();
        }
        HashMap editoptionsMap = Maps.newHashMap();
        HashMap f7JsonMap = Maps.newHashMap();
        f7JsonMap.put("subWidgetName", isBasicItem ? "specialPromptGrid" : "shrPromptGrid");
        f7JsonMap.put("searchFields", "");
        f7JsonMap.put("isHROrg", false);
        f7JsonMap.put("isAdminOrg", false);
        f7JsonMap.put("searchLikePattern", "any");
        HashMap uipkMap = Maps.newHashMap();
        uipkMap.put("title", title);
        uipkMap.put("uipk", uipk);
        uipkMap.put("query", "");
        uipkMap.put("filter", f7Filter);
        uipkMap.put("multiselect", false);
        uipkMap.put("isTree", false);
        uipkMap.put("treeUrl", "");
        uipkMap.put("isContainLowerOrg", false);
        uipkMap.put("isAdminOrg", false);
        uipkMap.put("isEnableExpFilter", true);
        if (isBasicItem) {
            uipkMap.put("isHRBaseItem", true);
            uipkMap.put("f7ReKeyValue", "BaseInfo.id:BaseInfo.name");
            ArrayList filterConfig = Lists.newArrayList();
            HashMap fil = Maps.newHashMap();
            fil.put("name", "isComUse");
            fil.put("value", true);
            fil.put("alias", "Display Unfavorited Data");
            fil.put("widgetType", "checkbox");
            filterConfig.add(fil);
            uipkMap.put("filterConfig", filterConfig);
            uipkMap.put("bizFilterFields", "hrOrgUnit");
        }
        if (otherParamsMap != null && !otherParamsMap.isEmpty()) {
            uipkMap.put("otherParams", otherParamsMap);
        }
        f7JsonMap.put("subWidgetOptions", uipkMap);
        HashMap validateJsonMap = Maps.newHashMap();
        validateJsonMap.put("errMsg", "");
        if (isRequired) {
            validateJsonMap.put("rules", "required:true");
        }
        validateJsonMap.put("validatetrigger", "focus keyup datachange");
        editoptionsMap.put("f7Json", f7JsonMap);
        editoptionsMap.put("validateJson", validateJsonMap);
        this.gridMap.put("editoptions", editoptionsMap);
        return this;
    }

    public CmpColumnModelWrapper disable() {
        this.gridMap.put("editable", false);
        this.gridMap.put("classes", "disabled");
        return this;
    }

    public CmpColumnModelWrapper requiredAndDisable() {
        this.gridMap.put("classes", "required disabled");
        return this;
    }

    public CmpColumnModelWrapper hidden() {
        this.hidden(Boolean.TRUE);
        return this;
    }

    public CmpColumnModelWrapper hidden(Boolean isHidden) {
        if (isHidden == null) {
            isHidden = Boolean.FALSE;
        }
        this.gridMap.put("hidden", isHidden);
        return this;
    }

    public CmpColumnModelWrapper required() {
        this.required(Boolean.TRUE);
        return this;
    }

    public CmpColumnModelWrapper required(Boolean isRequired) {
        if (isRequired == null) {
            isRequired = Boolean.FALSE;
        }
        if (isRequired.booleanValue()) {
            this.gridMap.put("classes", "required");
        }
        return this;
    }

    public CmpColumnModelWrapper key() {
        this.gridMap.put("key", true);
        return this;
    }

    public CmpColumnModelWrapper frozen() {
        this.frozen(Boolean.TRUE);
        return this;
    }

    public CmpColumnModelWrapper frozen(Boolean isFrozen) {
        if (isFrozen == null) {
            isFrozen = Boolean.FALSE;
        }
        this.gridMap.put("frozen", isFrozen);
        return this;
    }

    public CmpColumnModelWrapper sortable() {
        this.gridMap.put("sortable", true);
        return this;
    }

    public CmpColumnModelWrapper removeWidth() {
        this.gridMap.remove("width");
        return this;
    }

    public Map<String, Object> get() {
        return this.gridMap;
    }

    protected static enum WidgetType {
        TEXT,
        DECIMAL,
        DATE,
        SELECT,
        BOOLEAN,
        MULTILAN,
        F7;

    }
}

